/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.guirecordingwindow.listeners;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import se.claremont.taf.core.gui.Gui;
import se.claremont.taf.core.gui.guistyle.TafFrame;
import se.claremont.taf.core.gui.guistyle.TafHtmlTextPane;
import se.claremont.taf.core.gui.teststructure.TestStep;
import se.claremont.taf.javasupport.gui.guirecordingwindow.JavaGuiElementDeclarationManager;
import se.claremont.taf.javasupport.gui.teststeps.JavaClictTestStep;
import se.claremont.taf.javasupport.objectstructure.JavaGuiElement;

public class RecordingMouseListener
implements MouseListener {
    String returnText = null;
    TafHtmlTextPane scriptArea;

    public RecordingMouseListener(TafHtmlTextPane scriptArea) {
        this.scriptArea = scriptArea;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getComponent() == null) {
            return;
        }
        Component actualComponent = e.getComponent();
        if (actualComponent == null) {
            return;
        }
        String alternativeText = JavaGuiElementDeclarationManager.javaGuiElementAsCodeHtml(JavaGuiElementDeclarationManager.createJavaGuiElement(e.getComponent()));
        String text = "<pre>java.click(new JavaGuiElement(By.byName(\"" + actualComponent.getName() + "\")));</pre><br>" + System.lineSeparator();
        this.scriptArea.append(text);
        this.scriptArea.revalidate();
        this.scriptArea.repaint();
        Gui.addTestStepToListOfAvailableTestSteps((TestStep)new JavaClictTestStep(new JavaGuiElement(actualComponent)));
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static boolean isApplied(Component component) {
        for (MouseListener mouseListener : component.getMouseListeners()) {
            if (!mouseListener.getClass().equals(RecordingMouseListener.class)) continue;
            return true;
        }
        return false;
    }

    public String getReturnText() {
        return this.returnText;
    }

    private Component identifyComponent(Component w) {
        Component c;
        while (!w.getClass().getName().equals(TafFrame.class.getName())) {
            w = w.getParent();
        }
        Point mousePosition = MouseInfo.getPointerInfo().getLocation();
        int x = w.getLocationOnScreen().x;
        int y = w.getLocationOnScreen().y;
        Component returnElement = c = w.getComponentAt(mousePosition.x - x, mousePosition.y - y);
        while (c != null) {
            try {
                if ((c = c.getComponentAt(mousePosition.x - c.getLocationOnScreen().x, mousePosition.y - c.getLocationOnScreen().y)) == null) continue;
                if (c.equals(returnElement)) {
                    c = null;
                    continue;
                }
                returnElement = c;
            }
            catch (IllegalStateException e) {
                c = null;
            }
        }
        System.out.println(returnElement.toString());
        return returnElement;
    }
}

