/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.interaction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.testcase.TestCase;

public class MethodInvoker {
    TestCase testCase = null;

    public MethodInvoker(TestCase testCase) {
        this.testCase = testCase;
    }

    public MethodInvoker() {
        this.testCase = null;
    }

    public Object invokeTheFirstEncounteredMethod(Object component, List<String> methodNames) {
        return this.invokeTheFirstEncounteredMethod(component, methodNames, (Object[])null);
    }

    public static Object invokeTheFirstEncounteredMethod(TestCase testCase, Object component, String[] methodNames) {
        MethodInvoker m = new MethodInvoker(testCase);
        return m.invokeTheFirstEncounteredMethod(component, methodNames);
    }

    public static List<String> getAvailableMethods(Object object) {
        MethodInvoker m = new MethodInvoker();
        return m.getAvalableMethods(object);
    }

    public static Object invokeTheFirstEncounteredMethod(TestCase testCase, Object component, String[] methodNames, Object ... args) {
        MethodInvoker m = new MethodInvoker(testCase);
        return m.invokeTheFirstEncounteredMethod(component, methodNames, args);
    }

    public static Object invokeTheFirstEncounteredMethodFromListOfMethodNames(Object component, String[] methodNames) {
        MethodInvoker m = new MethodInvoker(null);
        ArrayList<String> methods = new ArrayList<String>();
        Collections.addAll(methods, methodNames);
        return m.invokeTheFirstEncounteredMethod(component, methods, (Object[])null);
    }

    public Object invokeTheFirstEncounteredMethod(Object component, String[] methodNames) {
        ArrayList<String> methods = new ArrayList<String>();
        Collections.addAll(methods, methodNames);
        return this.invokeTheFirstEncounteredMethod(component, methods, (Object[])null);
    }

    public Object invokeTheFirstEncounteredMethod(Object component, String[] methodNames, Object ... args) {
        ArrayList<String> methods = new ArrayList<String>();
        Collections.addAll(methods, methodNames);
        return this.invokeTheFirstEncounteredMethod(component, methods, args);
    }

    public static Object invokeTheFirstEncounteredMethodFromListOfMethodNames(Object component, String[] methodNames, Object ... args) {
        MethodInvoker m = new MethodInvoker(null);
        return m.invokeTheFirstEncounteredMethod(component, methodNames, args);
    }

    public Object invokeTheFirstEncounteredMethod(Object component, List<String> methodNames, Object ... args) {
        if (component == null || methodNames == null || methodNames.size() == 0) {
            this.log(LogLevel.DEBUG, "Could not invoke any of the methods ('" + String.join((CharSequence)"', '", methodNames) + "') since the object to invoke them on was null.");
            return null;
        }
        for (String methodName : methodNames) {
            if (!this.objectHasMethod(component, methodName)) continue;
            if (args == null) {
                return this.tryInvokeMethod(component, methodName);
            }
            Class<?> c = component.getClass();
            for (Method m : c.getMethods()) {
                if (!m.toString().contains(methodName)) continue;
                String returnstring = "Invoking method '" + m.toString() + "' with arguments '" + Arrays.toString(args) + "'";
                try {
                    String returnString = ".";
                    Object returnObject = m.invoke(component, args);
                    if (returnObject != null) {
                        returnString = " and retrieved the object '" + returnObject.toString() + "'";
                    }
                    this.log(LogLevel.DEBUG, returnString + ".");
                    return returnObject;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.log(LogLevel.DEBUG, "Error while trying to invoke method '" + m.toString() + "'. Error: " + e.toString());
                    return null;
                }
            }
        }
        this.log(LogLevel.FRAMEWORK_ERROR, "None of the suggested methods ('" + String.join((CharSequence)"', '", methodNames) + "') were found to be suitable for element of class '" + this.getClassName(component) + "'. The methods available for this object are:" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), this.getAvalableMethods(component)));
        return null;
    }

    public static Object invokeMethod(TestCase testCase, Object component, String methodName, Object ... args) {
        MethodInvoker m = new MethodInvoker(testCase);
        return m.invokeMethod(component, methodName, args);
    }

    public Object invokeMethod(Object component, String methodName, Object ... args) {
        if (args == null) {
            return this.invokeMethod(component, methodName);
        }
        if (component == null || methodName == null || methodName.equals("")) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not invoke method '" + methodName + "' on null element.");
            return null;
        }
        Class<?> c = component.getClass();
        for (Method m : c.getMethods()) {
            if (!m.toString().contains("." + methodName)) continue;
            try {
                Object returnObject = m.invoke(component, args);
                String returnString = ".";
                if (returnObject != null) {
                    returnString = " and retrieved the object '" + returnObject.toString() + "'.";
                }
                this.log(LogLevel.EXECUTED, "Invoked method '" + methodName + "' on component of class '" + this.getClassName(component) + "'" + returnString);
                return returnObject;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.log(LogLevel.EXECUTION_PROBLEM, "Could not invoke method '" + methodName + "' on component of class '" + this.getClassName(component) + "'. Error: " + e.getMessage());
                return null;
            }
        }
        this.log(LogLevel.EXECUTION_PROBLEM, "Tried invoking method '" + methodName + "' on component, but that method could not be found for this component." + System.lineSeparator() + "Class is '" + this.getClassName(component) + "' and available methods are:" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), this.getAvalableMethods(component)) + System.lineSeparator() + "Remember to cast any return object upon usage.");
        return null;
    }

    public Object invokeMethod(Object component, String methodName) {
        if (component == null || methodName == null || methodName.equals("")) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not invoke method '" + methodName + "' on null element.");
            return null;
        }
        Class<?> c = component.getClass();
        for (Method m : c.getMethods()) {
            if (!m.toString().contains("." + methodName)) continue;
            try {
                Object returnObject = m.invoke(component, new Object[0]);
                String returnString = ".";
                if (returnObject != null) {
                    returnString = " and retrieved the object '" + returnObject.toString() + "'.";
                }
                this.log(LogLevel.EXECUTED, "Invoked method '" + methodName + "' on component of class '" + this.getClassName(component) + "'" + returnString);
                return returnObject;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.log(LogLevel.EXECUTION_PROBLEM, "Could not invoke method '" + methodName + "' on component of class '" + this.getClassName(component) + "'. Error: " + e.getMessage());
                return null;
            }
        }
        this.log(LogLevel.EXECUTION_PROBLEM, "Tried invoking method '" + methodName + "' on component, but that method could not be found for this component." + System.lineSeparator() + "Class is '" + this.getClassName(component) + "' and available methods are:" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), this.getAvalableMethods(component)) + System.lineSeparator() + "Remember to cast any return object upon usage.");
        return null;
    }

    private Object tryInvokeMethod(Object component, String methodName) {
        if (component == null || methodName == null || methodName.equals("")) {
            this.log(LogLevel.DEBUG, "Cannot invoke method '" + methodName + "' on object since either of them are null and both are needed.");
            return null;
        }
        Class<?> c = component.getClass();
        for (Method method : c.getMethods()) {
            if (!method.toString().endsWith("." + methodName)) continue;
            try {
                String logString = "Invoking method '" + method.toString() + "' on object of class '" + this.getClassName(component) + "'";
                Object returnObject = method.invoke(component, new Object[0]);
                if (returnObject != null) {
                    logString = logString + " and received '" + returnObject.toString() + "' in response";
                }
                this.log(LogLevel.DEBUG, logString + ".");
                return returnObject;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.log(LogLevel.DEBUG, "Encountered problems when invoking method '" + method.toString() + "' on element of class '" + this.getClassName(component) + "'. Error: " + e.toString());
            }
        }
        return null;
    }

    public ArrayList<String> getAvalableMethods(Object component) {
        Class<?> c = component.getClass();
        ArrayList<String> methods = new ArrayList<String>();
        for (Method m : c.getMethods()) {
            methods.add(m.toString());
        }
        return methods;
    }

    public boolean objectHasMethod(Object component, String methodName) {
        if (component == null) {
            return false;
        }
        Class<?> c = component.getClass();
        for (Method m : c.getMethods()) {
            if (!m.toString().contains(methodName)) continue;
            return true;
        }
        return false;
    }

    public boolean objectHasAnyOfTheMethods(Object component, String[] methodNames) {
        for (String methodName : methodNames) {
            if (!this.objectHasMethod(component, methodName)) continue;
            return true;
        }
        return false;
    }

    private Object tryInvokeMethod(Object object, Method method) {
        if (object == null || method == null) {
            this.log(LogLevel.DEBUG, "Cannot invoke method since method or object is null and both are needed.");
            return null;
        }
        try {
            String logString = "Invoking method '" + method.toString() + "' on object of class '" + this.getClassName(object) + "'";
            Object returnObject = method.invoke(object, new Object[0]);
            if (returnObject != null) {
                logString = logString + " and received '" + returnObject.toString() + "' in response";
            }
            this.log(LogLevel.DEBUG, logString + ".");
            return returnObject;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.log(LogLevel.DEBUG, "Encountered problems when invoking method '" + method.toString() + "' on element of class '" + this.getClassName(object) + "'. Error: " + e.toString());
            return null;
        }
    }

    private void log(LogLevel logLevel, String message) {
        if (this.testCase == null) {
            return;
        }
        this.testCase.log(logLevel, message);
    }

    private String getClassName(Object object) {
        if (object == null) {
            return "[null]";
        }
        String className = object.getClass().toString();
        String[] nameParts = className.split(" ");
        if (nameParts.length > 1) {
            className = nameParts[nameParts.length - 1];
        }
        return className;
    }
}

