/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.interaction;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import se.claremont.taf.core.guidriverpluginstructure.PositionBasedIdentification.PositionBasedGuiElement;
import se.claremont.taf.core.guidriverpluginstructure.PositionBasedIdentification.PositionBasedIdentificator;
import se.claremont.taf.core.support.StringManagement;
import se.claremont.taf.core.support.SupportMethods;
import se.claremont.taf.javasupport.interaction.GenericInteractionMethods;
import se.claremont.taf.javasupport.interaction.MethodDeclarations;
import se.claremont.taf.javasupport.interaction.MethodInvoker;
import se.claremont.taf.javasupport.objectstructure.JavaGuiElement;
import se.claremont.taf.javasupport.objectstructure.JavaWindow;

public class WindowMapper {
    List<Component> unidentifiedComponents = new ArrayList<Component>();
    List<Component> identifiedComponents = new ArrayList<Component>();
    StringBuilder sb = new StringBuilder();
    GenericInteractionMethods gim = new GenericInteractionMethods(null);
    JavaWindow javaWindow;

    public static void Map(JavaWindow javaWindow, String outputFilePath) {
        WindowMapper windowMapper = new WindowMapper();
        windowMapper.createElementDefinitions(javaWindow, outputFilePath);
    }

    private void createElementDefinitions(JavaWindow javaWindow, String outputFilePath) {
        this.javaWindow = javaWindow;
        this.unidentifiedComponents = javaWindow.getComponents();
        this.addClassHeader();
        this.addWindowDeclaration();
        this.addElementsIdentifiedByName();
        this.addElementsIdentifiedByUniqueClass();
        this.addElementsIdentifiedByUniqueText();
        this.addElementsToTheRightOfIdentifiedElement();
        this.addUnidentifiedElements();
        this.sb.append(System.lineSeparator()).append("}").append(System.lineSeparator());
        SupportMethods.saveToFile((String)this.sb.toString(), (String)outputFilePath);
    }

    private void addElementsToTheRightOfIdentifiedElement() {
        Integer numberOfUnidentifiedComponents = null;
        while (numberOfUnidentifiedComponents == null || numberOfUnidentifiedComponents.intValue() != this.unidentifiedComponents.size()) {
            numberOfUnidentifiedComponents = this.unidentifiedComponents.size();
            ArrayList<JavaGuiElement> javaGuiElements = new ArrayList<JavaGuiElement>();
            for (Component c : this.unidentifiedComponents) {
                javaGuiElements.add(new JavaGuiElement(c));
            }
            for (Component potentialRightComponent : this.unidentifiedComponents) {
                for (Component potentialLeftElement : this.identifiedComponents) {
                    Component candidateRightComponent = (Component)PositionBasedIdentificator.fromAllThePositionBasedElements(javaGuiElements).elementImmediatelyToTheRightOf((PositionBasedGuiElement)new JavaGuiElement(potentialLeftElement));
                    if (candidateRightComponent == null || !candidateRightComponent.toString().equals(potentialRightComponent.toString())) continue;
                    System.out.println("Element '" + candidateRightComponent.toString() + "' is immediately to the right of element '" + potentialLeftElement + "'.");
                    this.sb.append("   public static JavaGuiElement = new JavaGuiElement((Component)(Component)PositionBasedIdentificator.fromAllThePositionBasedElements(javaGuiElements).elementImmediatelyToTheRightOf(new JavaGuiElement(potentialLeftElement)));").append(System.lineSeparator());
                }
            }
        }
    }

    private void addWindowDeclaration() {
        String title = this.javaWindow.getTitle();
        this.sb.append("   public static JavaWindow window = new JavaWindow(\"" + title + "\");").append(System.lineSeparator()).append(System.lineSeparator());
    }

    private void addUnidentifiedElements() {
        this.sb.append(System.lineSeparator());
        this.sb.append("// Unidentified elements").append(System.lineSeparator());
        this.sb.append("// =======================").append(System.lineSeparator()).append(System.lineSeparator());
        for (Component o : this.unidentifiedComponents) {
            this.sb.append("// ").append(((Object)o).toString()).append(System.lineSeparator()).append(System.lineSeparator());
        }
    }

    private void addElementsIdentifiedByUniqueText() {
        ArrayList<Component> elementsToRemove = new ArrayList<Component>();
        for (int i = 0; i < this.unidentifiedComponents.size(); ++i) {
            Component o = this.unidentifiedComponents.get(i);
            String text = this.gim.getText(o);
            if (text == null || text.length() == 0) continue;
            if (i == this.unidentifiedComponents.size()) {
                this.addElementDefinition(o, "         .byExactText(\"" + text + "\")");
                elementsToRemove.add(o);
                continue;
            }
            boolean duplicateFound = false;
            for (int j = i + 1; j < this.unidentifiedComponents.size(); ++j) {
                String elementText = this.gim.getText(this.unidentifiedComponents.get(j));
                if (elementText == null || !elementText.equals(text)) continue;
                duplicateFound = true;
                break;
            }
            if (duplicateFound) continue;
            this.addElementDefinition(o, "         .byExactText(\"" + text + "\")");
            elementsToRemove.add(o);
        }
        this.unidentifiedComponents.removeAll(elementsToRemove);
    }

    private void addElementsIdentifiedByName() {
        ArrayList<Component> elementsToRemove = new ArrayList<Component>();
        for (int i = 0; i < this.unidentifiedComponents.size(); ++i) {
            Component o = this.unidentifiedComponents.get(i);
            String name = this.gim.getName(o);
            if (name == null || name.length() == 0) continue;
            if (i == this.unidentifiedComponents.size()) {
                this.addElementDefinition(o, "         .byName(\"" + name + "\")");
                elementsToRemove.add(o);
                continue;
            }
            boolean duplicateFound = false;
            for (int j = i + 1; j < this.unidentifiedComponents.size(); ++j) {
                String elementName = this.gim.getName(this.unidentifiedComponents.get(j));
                if (elementName == null || !elementName.equals(name)) continue;
                duplicateFound = true;
                break;
            }
            if (duplicateFound) continue;
            this.addElementDefinition(o, "         .byName(\"" + name + "\")");
            elementsToRemove.add(o);
        }
        this.unidentifiedComponents.removeAll(elementsToRemove);
    }

    private void addElementsIdentifiedByUniqueClass() {
        ArrayList<Component> elementsToRemove = new ArrayList<Component>();
        for (int i = 0; i < this.unidentifiedComponents.size(); ++i) {
            Component o = this.unidentifiedComponents.get(i);
            String className = o.getClass().getSimpleName();
            if (className == null || className.length() == 0) continue;
            if (i == this.unidentifiedComponents.size()) {
                this.addElementDefinition(o, "         .byClass(\"" + className + "\")");
                elementsToRemove.add(o);
                continue;
            }
            boolean duplicateFound = false;
            for (int j = i + 1; j < this.unidentifiedComponents.size(); ++j) {
                String elementClassName = this.gim.getName(this.unidentifiedComponents.get(j));
                if (elementClassName == null || !elementClassName.equals(className)) continue;
                duplicateFound = true;
                break;
            }
            if (duplicateFound) continue;
            this.addElementDefinition(o, "         .byClass(\"" + className + "\")");
            elementsToRemove.add(o);
        }
        this.unidentifiedComponents.removeAll(elementsToRemove);
    }

    private void addElementDefinition(Component o, String byStatement) {
        this.identifiedComponents.add(o);
        String elementName = this.identifyElementName(o);
        this.sb.append("   public static JavaGuiElement " + elementName + "(){").append(System.lineSeparator());
        this.sb.append("        return new JavaGuiElement(window, By").append(System.lineSeparator()).append("   ").append(byStatement).append(",").append(System.lineSeparator() + "            \"" + elementName + "\");").append(System.lineSeparator());
        this.sb.append("   }").append(System.lineSeparator());
        this.sb.append(System.lineSeparator());
    }

    private String identifyElementName(Object o) {
        String className;
        String objectName = (String)MethodInvoker.invokeTheFirstEncounteredMethod(null, o, MethodDeclarations.componentNameGetterMethodsInAttemptOrder);
        if (objectName == null || objectName.length() == 0) {
            objectName = (String)MethodInvoker.invokeTheFirstEncounteredMethod(null, o, MethodDeclarations.textGettingMethodsInAttemptOrder);
        }
        if (objectName == null || objectName.length() == 0) {
            objectName = "NoNamedObject";
        }
        if (!(objectName = StringManagement.safeVariableName((String)objectName)).endsWith(className = o.getClass().getSimpleName()) || !objectName.startsWith(className)) {
            objectName = objectName + o.getClass().getSimpleName().replace(".", "_").replace(" ", "");
        }
        return objectName;
    }

    private void addClassHeader() {
        String title = this.javaWindow.getTitle();
        this.sb.append("import se.claremont.autotest.javasupport.interaction.elementidentification.By;").append(System.lineSeparator());
        this.sb.append("import se.claremont.autotest.javasupport.objectstructure.JavaGuiElement;").append(System.lineSeparator());
        this.sb.append("import se.claremont.autotest.javasupport.objectstructure.JavaWindow;").append(System.lineSeparator());
        this.sb.append(System.lineSeparator());
        String windowName = StringManagement.safeClassName((String)title) + "Window";
        this.sb.append("public class ").append(windowName).append(" {").append(System.lineSeparator());
        this.sb.append(System.lineSeparator());
    }
}

