/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.guirecordingwindow;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.JFrame;
import se.claremont.taf.core.gui.guistyle.TafHtmlTextPane;
import se.claremont.taf.javasupport.applicationundertest.ApplicationUnderTest;
import se.claremont.taf.javasupport.gui.JavaSupportTab;
import se.claremont.taf.javasupport.gui.guirecordingwindow.RecordingOptionsWindow;
import se.claremont.taf.javasupport.gui.guirecordingwindow.listeners.NewWindowsListener;
import se.claremont.taf.javasupport.gui.guirecordingwindow.listeners.RecordingFocusListener;
import se.claremont.taf.javasupport.gui.guirecordingwindow.listeners.RecordingKeyBoardListener;
import se.claremont.taf.javasupport.gui.guirecordingwindow.listeners.RecordingMouseListener;
import se.claremont.taf.javasupport.objectstructure.JavaWindow;

public class RecordingListenersManager {
    private static TafHtmlTextPane scriptOutputArea;
    private static final NewWindowsListener newWindowsListener;
    private static JFrame keyBoardEventCatcher;

    static void setScriptArea(TafHtmlTextPane scriptArea) {
        scriptOutputArea = scriptArea;
    }

    public static void startRecording() {
        Toolkit.getDefaultToolkit().addAWTEventListener(newWindowsListener, 64L);
        Collection<Window> windows = RecordingOptionsWindow.recordTafWindows ? ApplicationUnderTest.getWindows() : JavaSupportTab.applicationUnderTest.getWindowsForSUT();
        for (Window window : windows) {
            RecordingListenersManager.makeSureAllComponentsHasRegisteredListeners(window);
        }
        if (RecordingOptionsWindow.recordKeyStrokesOutsideOfWindows) {
            keyBoardEventCatcher = new JFrame();
            keyBoardEventCatcher.setSize(Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height);
            keyBoardEventCatcher.setUndecorated(true);
            keyBoardEventCatcher.setOpacity(0.0f);
            keyBoardEventCatcher.setVisible(true);
            keyBoardEventCatcher.getRootPane().setOpaque(false);
            keyBoardEventCatcher.addKeyListener(new RecordingKeyBoardListener(scriptOutputArea));
        }
    }

    public static void stopRecording() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(newWindowsListener);
        Collection<Window> windows = RecordingOptionsWindow.recordTafWindows ? ApplicationUnderTest.getWindows() : JavaSupportTab.applicationUnderTest.getWindowsForSUT();
        for (Window window : windows) {
            RecordingListenersManager.removeAllTafRecordingListenersFromWindow(window);
        }
        if (keyBoardEventCatcher != null) {
            keyBoardEventCatcher.dispose();
        }
    }

    public static void removeAllTafRecordingListenersFromWindow(Window window) {
        JavaWindow javaWindow = new JavaWindow(window);
        Iterator<Component> iterator = javaWindow.getComponents().iterator();
        while (iterator.hasNext()) {
            Component object;
            Component c = object = iterator.next();
            for (MouseListener mouseListener : c.getMouseListeners()) {
                if (!mouseListener.getClass().equals(RecordingMouseListener.class)) continue;
                c.removeMouseListener(mouseListener);
            }
            for (EventListener eventListener : c.getFocusListeners()) {
                if (!eventListener.getClass().equals(RecordingFocusListener.class)) continue;
                c.removeFocusListener((FocusListener)eventListener);
            }
            for (EventListener eventListener : c.getKeyListeners()) {
                if (!eventListener.getClass().equals(RecordingKeyBoardListener.class)) continue;
                c.removeKeyListener((KeyListener)eventListener);
            }
        }
    }

    public static void makeSureAllComponentsHasRegisteredListeners(Window window) {
        JavaWindow javaWindow = new JavaWindow(window);
        for (Component object : javaWindow.getComponents()) {
            Component c = object;
            if (!RecordingMouseListener.isApplied(c)) {
                c.addMouseListener(new RecordingMouseListener(scriptOutputArea));
            }
            if (!RecordingFocusListener.isApplied(c)) {
                c.addFocusListener(new RecordingFocusListener(scriptOutputArea));
            }
            if (RecordingOptionsWindow.recordKeyStrokesOutsideOfWindows || RecordingKeyBoardListener.isApplied(c)) continue;
            c.addKeyListener(new RecordingKeyBoardListener(scriptOutputArea));
        }
    }

    static {
        newWindowsListener = new NewWindowsListener();
    }
}

