/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.teststeps;

import java.io.Serializable;
import se.claremont.taf.core.gui.teststructure.TestCaseManager;
import se.claremont.taf.core.gui.teststructure.TestStep;
import se.claremont.taf.core.gui.teststructure.TestStepResult;
import se.claremont.taf.core.testcase.TestCaseResult;
import se.claremont.taf.javasupport.gui.teststeps.JavaTestStep;
import se.claremont.taf.javasupport.interaction.GenericInteractionMethods;
import se.claremont.taf.javasupport.objectstructure.JavaGuiElement;

public class JavaWriteTestStep
extends JavaTestStep
implements Serializable {
    JavaGuiElement javaGuiElement;

    public JavaWriteTestStep(String name, String description) {
        super(name, description);
    }

    public JavaWriteTestStep(JavaGuiElement javaGuiElement, String keysPressedUponComponent) {
        this.javaGuiElement = javaGuiElement;
        this.setName("Write '" + keysPressedUponComponent + "' to element '" + javaGuiElement.getName() + "'");
        this.setDescription("Write '" + keysPressedUponComponent + "' to element '" + javaGuiElement.getName() + "'");
        this.setActionName("Write");
        this.setElementName(javaGuiElement.getName());
        this.setAssociatedData(keysPressedUponComponent);
    }

    @Override
    public JavaWriteTestStep clone() {
        JavaWriteTestStep clonedStep = new JavaWriteTestStep(this.getName(), this.getDescription());
        clonedStep.setActionName(this.actionName);
        clonedStep.setElementName(this.elementName);
        clonedStep.setAssociatedData(this.data);
        clonedStep.javaGuiElement = this.javaGuiElement;
        return clonedStep;
    }

    @Override
    public String asCode() {
        TestCaseManager.testSetCode.makeSureRequiredImportIsAdded("import se.claremont.autotest.javasupport.interaction.*;");
        TestCaseManager.testSetCode.makeSureClassVariableIsDeclared("GenericInteractionMethods java;");
        TestCaseManager.testSetCode.makeSureBeginTestSectionDeclarationExist("java = new GenericInteractionMethods(currentTestCase());");
        return "java.write(" + this.data + ", " + this.javaGuiElement.getName() + ");";
    }

    @Override
    public TestStepResult execute() {
        TestCaseManager.startTestStep();
        GenericInteractionMethods java = new GenericInteractionMethods(TestCaseManager.getTestCase());
        java.write(this.javaGuiElement, (String)this.data);
        if (java.testCase.testCaseResult.resultStatus.equals((Object)TestCaseResult.ResultStatus.PASSED)) {
            TestCaseManager.wrapUpTestCase();
            return new TestStepResult((TestStep)this, TestStepResult.Result.PASS);
        }
        TestCaseManager.wrapUpTestCase();
        return new TestStepResult((TestStep)this, TestStepResult.Result.FAIL);
    }
}

