/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.objectstructure;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import se.claremont.taf.core.support.StringManagement;
import se.claremont.taf.core.support.SupportMethods;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.applicationundertest.ApplicationUnderTest;
import se.claremont.taf.javasupport.interaction.GenericInteractionMethods;
import se.claremont.taf.javasupport.interaction.MethodDeclarations;
import se.claremont.taf.javasupport.interaction.MethodInvoker;
import se.claremont.taf.javasupport.interaction.WindowMapper;
import se.claremont.taf.javasupport.objectstructure.JavaGuiElement;

public class JavaWindow
implements Serializable {
    MethodInvoker methodInvoker = new MethodInvoker();
    String titleAsRegularExpression;
    String name;
    ArrayList<Window> nonShownWindows = new ArrayList();
    boolean renderingCompleted = false;

    public JavaWindow(String titleAsRegularExpression) {
        this.titleAsRegularExpression = titleAsRegularExpression;
        this.name = titleAsRegularExpression;
    }

    public JavaWindow(String titleAsRegularExpression, String name) {
        this.name = name;
        this.titleAsRegularExpression = titleAsRegularExpression;
    }

    public JavaWindow(Window window) {
        if (window != null) {
            this.name = this.titleAsRegularExpression = (String)this.methodInvoker.invokeTheFirstEncounteredMethod((Object)window, MethodDeclarations.titleGetterMethodsInAttemptOrder);
        }
    }

    public JavaWindow(Window window, String name) {
        if (window != null) {
            this.titleAsRegularExpression = (String)this.methodInvoker.invokeTheFirstEncounteredMethod((Object)window, MethodDeclarations.titleGetterMethodsInAttemptOrder);
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Object waitForWindowToAppear(int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            Object o = this.getWindow();
            if (this.getWindow() != null) {
                return o;
            }
            this.wait(100);
        }
        return null;
    }

    public String getTitle() {
        return (String)this.methodInvoker.invokeTheFirstEncounteredMethod(this.getWindow(), MethodDeclarations.titleGetterMethodsInAttemptOrder);
    }

    private void setDefaultCloseOperationToDisposeIfExitOnClose(Window w) {
        Integer defaultCloseOperation = (Integer)MethodInvoker.invokeMethod(null, w, "getDefaultCloseOperation()", new Object[0]);
        if (defaultCloseOperation != null && defaultCloseOperation == 3) {
            MethodInvoker.invokeMethod(new TestCase(), w, "setDefaultCloseOperation(int)", 2);
        }
    }

    public boolean isRenderingCompleted() {
        return this.renderingCompleted;
    }

    private void makeSureListenerForFullyRenderedWindowExist(Window w) {
        for (WindowListener windowListener : w.getWindowListeners()) {
            if (!windowListener.getClass().equals(TafWindowRenderingCompletedListener.class)) continue;
            return;
        }
        w.addWindowListener(new TafWindowRenderingCompletedListener());
    }

    public Object getWindow() {
        Window subWindow;
        String title;
        Set<Window> windows = ApplicationUnderTest.getWindows();
        this.nonShownWindows.clear();
        if (windows.size() == 0) {
            return null;
        }
        for (Window w : windows) {
            this.setDefaultCloseOperationToDisposeIfExitOnClose(w);
            title = (String)this.methodInvoker.invokeTheFirstEncounteredMethod((Object)w, MethodDeclarations.titleGetterMethodsInAttemptOrder);
            if (SupportMethods.isRegexMatch((String)title, (String)this.titleAsRegularExpression)) {
                if (w.isVisible() && w.isShowing()) {
                    if (JFrame.class.isAssignableFrom(w.getClass())) {
                        if (((JFrame)w).isVisible()) {
                            this.makeSureListenerForFullyRenderedWindowExist(w);
                            return w;
                        }
                    } else {
                        this.makeSureListenerForFullyRenderedWindowExist(w);
                        return w;
                    }
                }
                this.nonShownWindows.add(w);
                continue;
            }
            subWindow = this.checkSubWindowsRecursive(w, true);
            if (subWindow != null && subWindow.isShowing() && subWindow.isVisible()) {
                this.makeSureListenerForFullyRenderedWindowExist(subWindow);
                return subWindow;
            }
            if (subWindow == null) continue;
            this.nonShownWindows.add(subWindow);
        }
        for (Window window : this.nonShownWindows) {
            title = (String)this.methodInvoker.invokeTheFirstEncounteredMethod((Object)window, MethodDeclarations.titleGetterMethodsInAttemptOrder);
            if (SupportMethods.isRegexMatch((String)title, (String)this.titleAsRegularExpression)) {
                this.makeSureListenerForFullyRenderedWindowExist(window);
                return window;
            }
            subWindow = this.checkSubWindowsRecursive(window, false);
            if (subWindow == null) continue;
            this.makeSureListenerForFullyRenderedWindowExist(subWindow);
            return subWindow;
        }
        return null;
    }

    private Window checkSubWindowsRecursive(Window parent, boolean saveSupressedWindows) {
        if (parent == null) {
            return null;
        }
        for (Window w : parent.getOwnedWindows()) {
            String title = (String)this.methodInvoker.invokeTheFirstEncounteredMethod((Object)w, MethodDeclarations.titleGetterMethodsInAttemptOrder);
            if (SupportMethods.isRegexMatch((String)title, (String)this.titleAsRegularExpression)) {
                if (w.isShowing()) {
                    return w;
                }
                if (!saveSupressedWindows) continue;
                this.nonShownWindows.add(w);
                continue;
            }
            return this.checkSubWindowsRecursive(w, saveSupressedWindows);
        }
        return null;
    }

    public ArrayList<JavaGuiElement> getComponentsAsJavaGuiElements() {
        ArrayList<JavaGuiElement> javaGuiElements = new ArrayList<JavaGuiElement>();
        for (Component o : this.getComponents()) {
            javaGuiElements.add(new JavaGuiElement(o));
        }
        return javaGuiElements;
    }

    public static List<Component> getAllComponents(Container c) {
        if (c == null) {
            return new ArrayList<Component>();
        }
        Component[] comps = c.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        for (Component comp : comps) {
            compList.add(comp);
            if (!(comp instanceof Container)) continue;
            compList.addAll(JavaWindow.getAllComponents((Container)comp));
        }
        return compList;
    }

    public List<Component> getComponents() {
        Container container = (Container)this.getWindow();
        return JavaWindow.getAllComponents(container);
    }

    public void printIdentifiedComponents() {
        for (Component c : this.getComponents()) {
            System.out.println(((Object)c).toString());
        }
    }

    public List<String> textsInComponents() {
        ArrayList<String> returnTexts = new ArrayList<String>();
        GenericInteractionMethods jim = new GenericInteractionMethods(null);
        for (Component c : this.getComponents()) {
            returnTexts.add(jim.getText(c));
        }
        return returnTexts;
    }

    public void mapWindowToDescriptionClass(String outputFile) {
        System.out.println("Attempting to map window " + this.getName() + ".");
        Object w = this.waitForWindowToAppear(15);
        System.out.println("Found window " + w.toString() + ". Mapping...");
        WindowMapper.Map(this, outputFile);
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        try {
            Desktop.getDesktop().open(new File(outputFile));
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    private void createElementDefinitions(Object window, String path) {
        Window theWindow = (Window)window;
        StringBuilder sb = new StringBuilder();
        GenericInteractionMethods i = new GenericInteractionMethods(null);
        JavaWindow javaWindow = new JavaWindow(theWindow);
        String title = javaWindow.getTitle();
        sb.append("public class ").append(StringManagement.methodNameWithOnlySafeCharacters((String)title)).append(" {").append(System.lineSeparator());
        sb.append(System.lineSeparator());
        List<Component> objects = this.getComponents();
        for (Component o : objects) {
            String name = i.getName(o);
            String text = i.getText(o);
            String className = o.getClass().toString();
            className = className.substring(className.lastIndexOf("."));
            if (name != null) {
                sb.append("   public static JavaGuiElement ").append(StringManagement.methodNameWithOnlySafeCharacters((String)(name + "_" + className))).append("() {").append(System.lineSeparator());
                sb.append("      return new JavaGuiElement(\"").append(StringManagement.methodNameWithOnlySafeCharacters((String)(name + className.replace("(", "").replace(")", "")))).append("\", \"").append(name).append("\", JavaGuiElement.IdType.ELEMENT_NAME);").append(System.lineSeparator());
                sb.append("   }").append(System.lineSeparator()).append(System.lineSeparator());
                continue;
            }
            if (text != null) {
                sb.append("   public static JavaGuiElement ").append(StringManagement.methodNameWithOnlySafeCharacters((String)(text + "_" + className))).append("() {").append(System.lineSeparator());
                sb.append("      return new JavaGuiElement(\"").append(StringManagement.methodNameWithOnlySafeCharacters((String)(text + className.replace("(", "").replace(")", "")))).append("\", \"").append(text).append("\", JavaGuiElement.IdType.ELEMENT_TEXT);").append(System.lineSeparator());
                sb.append("   }").append(System.lineSeparator()).append(System.lineSeparator());
                continue;
            }
            sb.append("/*").append(System.lineSeparator());
            sb.append("   Cannot create proper code for element of class '").append(o.getClass().toString()).append("'.").append(System.lineSeparator());
            sb.append("   An object toString() method call returns:").append(System.lineSeparator());
            sb.append("   ").append(((Object)o).toString()).append(System.lineSeparator());
            sb.append("*/").append(System.lineSeparator()).append(System.lineSeparator());
        }
        sb.append("}").append(System.lineSeparator());
        SupportMethods.saveToFile((String)sb.toString(), (String)path);
    }

    private List<Object> addSubComponents(Object component) {
        Component[] componentCollection;
        ArrayList<Object> componentList = new ArrayList<Object>();
        if (this.methodInvoker.objectHasAnyOfTheMethods(component, MethodDeclarations.subAllComponentsGettersMethodsInAttemptOrder) && (componentCollection = (Component[])this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.subAllComponentsGettersMethodsInAttemptOrder)) != null && componentCollection.length > 0) {
            for (Component c : componentCollection) {
                componentList.add(c);
                componentList.addAll(this.addSubComponents(c));
            }
            return componentList;
        }
        if (!this.methodInvoker.objectHasAnyOfTheMethods(component, MethodDeclarations.subComponentCountMethodsInAttemptOrder) || !this.methodInvoker.objectHasAnyOfTheMethods(component, MethodDeclarations.subComponentGetterMethodsInAttemptOrder)) {
            return componentList;
        }
        Integer numberOfSubItems = null;
        try {
            numberOfSubItems = (int)((Integer)this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.subComponentCountMethodsInAttemptOrder));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (numberOfSubItems != null) {
            for (int i = 0; i < numberOfSubItems; ++i) {
                Object o = this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.subComponentGetterMethodsInAttemptOrder, i);
                componentList.add(o);
                componentList.addAll(this.addSubComponents(o));
            }
        }
        return componentList;
    }

    private void wait(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            System.out.println("Could not wait " + milliseconds + " milliseconds. Error: " + e.toString());
        }
    }

    public int getElementMatchCount(JavaGuiElement javaGuiElement) {
        int matchesCount = 0;
        for (Component subElement : this.getComponents()) {
            if (!javaGuiElement.by.isMatch(subElement)) continue;
            ++matchesCount;
        }
        return matchesCount;
    }

    public List<Object> getMatchingComponents(JavaGuiElement javaGuiElement) {
        ArrayList<Object> matches = new ArrayList<Object>();
        for (Component subElement : this.getComponents()) {
            if (!javaGuiElement.by.isMatch(subElement)) continue;
            matches.add(subElement);
        }
        return matches;
    }

    public boolean isShown() {
        Object w = this.getWindow();
        if (w == null) {
            return false;
        }
        return ((Window)w).isShowing();
    }

    class TafWindowRenderingCompletedListener
    implements WindowListener {
        TafWindowRenderingCompletedListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            JavaWindow.this.renderingCompleted = true;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            JavaWindow.this.renderingCompleted = false;
        }

        @Override
        public void windowClosed(WindowEvent e) {
            JavaWindow.this.renderingCompleted = true;
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

