/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest.applicationcontext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.testcase.TestCase;

public class EnvironmentVariableManager
implements Serializable {
    @JsonIgnore
    private transient TestCase testCase;
    @JsonProperty
    public List<String> appliedVariableChanges = new ArrayList<String>();

    private EnvironmentVariableManager() {
        this.testCase = new TestCase();
    }

    public EnvironmentVariableManager(TestCase testCase) {
        this.testCase = testCase;
    }

    @JsonIgnore
    public void setEnvironmentVariables(Map<String, String> variables) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        Map<String, String> env = pb.environment();
        for (String key : variables.keySet()) {
            env.put(key, variables.get(key));
        }
        boolean success = this.setEnv(env);
        if (success) {
            StringBuilder sb = new StringBuilder();
            sb.append("The following environment variables were given the following values:").append(System.lineSeparator());
            for (String key : variables.keySet()) {
                sb.append("   * '").append(key).append("' = '").append(variables.get(key)).append("'").append(System.lineSeparator());
            }
            this.log(LogLevel.EXECUTED, sb.toString());
        }
    }

    @JsonIgnore
    public void setEnvironmentVariable(String variableName, String variableValue) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        Map<String, String> env = pb.environment();
        env.put(variableName, variableValue);
        boolean success = this.setEnv(env);
        if (success) {
            this.log(LogLevel.EXECUTED, "Environment variable '" + variableName + "' set to '" + variableValue + "'.");
        }
        this.appliedVariableChanges.add(variableName + "=" + variableValue);
    }

    @JsonIgnore
    public List<String> currentEnvironmentVariables() {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        ArrayList<String> variables = new ArrayList<String>();
        Map<String, String> env = pb.environment();
        for (String key : env.keySet()) {
            variables.add("Environment variable: '" + key + "' = '" + env.get(key) + "'.");
        }
        return variables;
    }

    @JsonIgnore
    protected boolean setEnv(Map<String, String> newenv) {
        boolean success = false;
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newenv);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newenv);
            success = true;
        }
        catch (NoSuchFieldException e) {
            try {
                Class<?>[] classes = Collections.class.getDeclaredClasses();
                Map<String, String> env = System.getenv();
                for (Class<?> cl : classes) {
                    if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                    Field field = cl.getDeclaredField("m");
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    Map map = (Map)obj;
                    map.clear();
                    map.putAll(newenv);
                }
                success = true;
            }
            catch (Exception e2) {
                this.log(LogLevel.EXECUTION_PROBLEM, "Could not set environment variable. Error: " + e2.toString());
            }
        }
        catch (Exception e1) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not set environment variable. Error: " + e1.toString());
        }
        return success;
    }

    @JsonIgnore
    private void log(LogLevel logLevel, String message) {
        if (this.testCase == null) {
            System.out.println(logLevel.toString() + ": " + message);
        } else {
            this.testCase.log(logLevel, message);
        }
    }
}

