/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest.applicationstarters;

import java.awt.Window;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.jar.Attributes;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.applicationundertest.applicationstarters.ApplicationStartMechanism;
import se.claremont.taf.javasupport.applicationundertest.applicationstarters.MethodInvoker;

public class ApplicationStarter
extends ApplicationStartMechanism {
    URL url;

    public ApplicationStarter(TestCase testCase) {
        super(testCase);
    }

    public void startJar(String filePath) {
        String[] parts;
        filePath = filePath.replace("\\", "/");
        ArrayList<String> usableParts = new ArrayList<String>();
        for (String part : parts = filePath.split(" ")) {
            if (part.trim().length() <= 0) continue;
            usableParts.add(part.trim());
        }
        if (usableParts.size() == 0) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot start application without any file path.");
            return;
        }
        URL fileUrl = null;
        if (usableParts.size() > 0) {
            try {
                String url = (String)usableParts.get(0);
                if (!(url.startsWith("file:///") || url.startsWith("http://") || url.startsWith("https://"))) {
                    url = "file:///" + url;
                }
                fileUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if (usableParts.size() == 1) {
            this.startJar(fileUrl);
        } else {
            String[] args = new String[usableParts.size() - 1];
            for (int i = 1; i < usableParts.size(); ++i) {
                args[i - 1] = (String)usableParts.get(i);
            }
            this.startJar(fileUrl, args);
        }
    }

    public void startJar(URL url) {
        this.log(LogLevel.DEBUG, "Starting jar file '" + url.toString() + "' from jar main class.");
        this.classLoader = new JarClassLoader(url);
        this.url = url;
        this.startUrlOrPathToJarFile = url.toString();
        this.mainClass = this.getMainClassName();
        this.invokeMainMethodOfMainClassWithArguments();
    }

    public void startJar(URL url, String[] args) {
        this.log(LogLevel.DEBUG, "Starting jar file '" + url.toString() + "' from jar main class.");
        this.classLoader = new JarClassLoader(url);
        this.url = url;
        this.startUrlOrPathToJarFile = url.toString();
        this.mainClass = this.getMainClassName();
        this.arguments = new ArrayList();
        for (String arg : args) {
            this.arguments.add(arg);
        }
        this.invokeMainMethodOfMainClassWithArguments();
    }

    public void startJar(URL url, String mainClass) {
        this.log(LogLevel.DEBUG, "Starting jar file '" + url.toString() + "' from jar with main class '" + mainClass + "'.");
        this.classLoader = new JarClassLoader(url);
        this.url = url;
        this.startUrlOrPathToJarFile = url.toString();
        this.mainClass = mainClass;
        this.invokeMainMethodOfMainClassWithArguments();
    }

    public void startJar(URL url, String mainClass, String[] args) throws SecurityException {
        this.log(LogLevel.DEBUG, "Starting jar file '" + url.toString() + "' from jar with main class '" + mainClass + "'.");
        this.classLoader = new JarClassLoader(url);
        this.url = url;
        this.startUrlOrPathToJarFile = url.toString();
        this.mainClass = mainClass;
        this.arguments = new ArrayList();
        for (String arg : args) {
            this.arguments.add(arg);
        }
        MethodInvoker.invokeMethodOfClass(this.classLoader, this.testCase, mainClass, "main", args);
    }

    public String getMainClassName() {
        URL u = null;
        try {
            u = new URL("jar", "", this.url + "!/");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        JarURLConnection uc = null;
        Attributes attr = null;
        try {
            uc = (JarURLConnection)u.openConnection();
            attr = uc.getMainAttributes();
        }
        catch (IOException e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Problem opening jar file:" + e.toString());
        }
        String returnString = attr != null ? attr.getValue(Attributes.Name.MAIN_CLASS) : null;
        this.log(LogLevel.DEBUG, "Found main class '" + returnString + "'.");
        return returnString;
    }

    public void invokeMainMethodOfMainClassWithArguments() {
        MethodInvoker.invokeMethodOfClass(this.classLoader, this.testCase, this.mainClass, "main", (String[])this.arguments.toArray());
    }

    public static Window[] getWindows() {
        return Window.getOwnerlessWindows();
    }

    public Window getWindow() {
        Window[] windows = ApplicationStarter.getWindows();
        if (windows.length == 0) {
            return null;
        }
        return windows[0];
    }

    private void log(LogLevel logLevel, String message) {
        if (this.testCase == null) {
            System.out.println(message);
        } else {
            this.testCase.log(logLevel, message);
        }
    }

    class JarClassLoader
    extends URLClassLoader {
        URL url;

        public JarClassLoader(URL url) {
            super(new URL[]{url});
            this.url = url;
        }
    }
}

