/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.applicationdeclarationwindow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.claremont.taf.core.gui.guistyle.TafButton;
import se.claremont.taf.core.gui.guistyle.TafCloseButton;
import se.claremont.taf.core.gui.guistyle.TafDialog;
import se.claremont.taf.core.gui.guistyle.TafHeadline;
import se.claremont.taf.core.gui.guistyle.TafLabel;
import se.claremont.taf.core.gui.guistyle.TafPanel;
import se.claremont.taf.core.gui.guistyle.TafTextField;

public class AddSystemPropertyWindow {
    TafDialog frame;
    TafTextField textComponentToUpdate;
    TafTextField propertyNameText = new TafTextField(" < property name > ");
    TafTextField propertyValueText = new TafTextField(" < property value > ");
    TafButton saveButton = new TafButton("Save");

    public AddSystemPropertyWindow(TafTextField component, JFrame parentWindow) {
        this.frame = new TafDialog(parentWindow, "TAF - Add system property", true);
        this.textComponentToUpdate = component;
        this.frame.getContentPane().setLayout(new BorderLayout());
        TafHeadline headline = new TafHeadline("Add system property");
        TafLabel warningText = new TafLabel("Warning: System properties are global. Once applied it affects all java applications in JVM - including TAF.");
        TafPanel propertiesPanel = new TafPanel("PropertiesPanel");
        propertiesPanel.setLayout((LayoutManager)new GridLayout(3, 2));
        TafLabel propertyNameLabel = new TafLabel("Property name");
        propertyNameLabel.setLabelFor((Component)this.propertyNameText);
        this.propertyNameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddSystemPropertyWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddSystemPropertyWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddSystemPropertyWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }
        });
        propertiesPanel.add((Component)propertyNameLabel);
        propertiesPanel.add((Component)this.propertyNameText);
        TafLabel propertyValueLabel = new TafLabel("Property value");
        this.propertyValueText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddSystemPropertyWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddSystemPropertyWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddSystemPropertyWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }
        });
        propertyValueLabel.setLabelFor((Component)this.propertyValueText);
        propertiesPanel.add((Component)propertyValueLabel);
        propertiesPanel.add((Component)this.propertyValueText);
        TafCloseButton cancelButton = new TafCloseButton((JDialog)this.frame);
        cancelButton.setText("Cancel");
        propertiesPanel.add((Component)cancelButton);
        this.saveButton.setEnabled(false);
        propertiesPanel.add((Component)this.saveButton);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AddSystemPropertyWindow.this.textComponentToUpdate.isChangedFromDefault()) {
                    AddSystemPropertyWindow.this.textComponentToUpdate.setText(AddSystemPropertyWindow.this.propertyNameText.getText() + "=" + AddSystemPropertyWindow.this.propertyValueText.getText());
                } else {
                    AddSystemPropertyWindow.this.textComponentToUpdate.setText(AddSystemPropertyWindow.this.textComponentToUpdate.getText() + ", " + AddSystemPropertyWindow.this.propertyNameText.getText() + "=" + AddSystemPropertyWindow.this.propertyValueText.getText());
                }
                AddSystemPropertyWindow.this.textComponentToUpdate.revalidate();
                AddSystemPropertyWindow.this.textComponentToUpdate.repaint();
                AddSystemPropertyWindow.this.frame.dispose();
            }
        });
        this.frame.getContentPane().add((Component)headline, "First");
        this.frame.getContentPane().add((Component)warningText, "Center");
        this.frame.getContentPane().add((Component)propertiesPanel, "Last");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void enableSaveButtonIfBothNameAndValueIsChanged() {
        if (this.propertyNameText.isChangedFromDefault() && this.propertyValueText.isChangedFromDefault()) {
            this.saveButton.setEnabled(true);
        } else {
            this.saveButton.setEnabled(false);
        }
    }
}

