/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class ParentLastURLClassLoader
extends ClassLoader {
    private ChildURLClassLoader childClassLoader;

    public ParentLastURLClassLoader(List<URL> classpath) {
        super(Thread.currentThread().getContextClassLoader());
        URL[] urls = classpath.toArray(new URL[classpath.size()]);
        this.childClassLoader = new ChildURLClassLoader(urls, new FindClassClassLoader(this.getParent()));
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.childClassLoader.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    private static class ChildURLClassLoader
    extends URLClassLoader {
        private FindClassClassLoader realParent;

        public ChildURLClassLoader(URL[] urls, FindClassClassLoader realParent) {
            super(urls, (ClassLoader)null);
            this.realParent = realParent;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> loaded = super.findLoadedClass(name);
            if (loaded != null) {
                return loaded;
            }
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.realParent.loadClass(name);
            }
        }
    }

    private static class FindClassClassLoader
    extends ClassLoader {
        public FindClassClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }
    }
}

