/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest.applicationstarters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.applicationundertest.applicationstarters.ApplicationStarter;

public class ApplicationStartMechanism
implements Serializable {
    @JsonProperty
    public String startUrlOrPathToJarFile;
    @JsonProperty
    public String mainClass;
    @JsonIgnore
    transient TestCase testCase;
    @JsonProperty
    public List<String> arguments = new ArrayList<String>();
    @JsonIgnore
    ClassLoader classLoader;

    private ApplicationStartMechanism() {
    }

    public ApplicationStartMechanism(TestCase testCase) {
        this.testCase = testCase;
    }

    public void run() {
        ApplicationStarter as = new ApplicationStarter(this.testCase);
        try {
            as.startJar(new URL(this.startUrlOrPathToJarFile), this.mainClass, this.arguments.toArray(new String[0]));
        }
        catch (MalformedURLException e) {
            System.out.println("Could not start program '" + this.startUrlOrPathToJarFile + "', with start class '" + this.mainClass + "' and arguments '" + String.join((CharSequence)"', '", this.arguments) + "'. Error:" + e.toString());
        }
        catch (SecurityException e) {
            System.out.println("SUT application exited.");
        }
    }

    public String saveToJsonFile(String filePath) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writeValue(new File(filePath), (Object)this);
        }
        catch (IOException e) {
            return e.toString();
        }
        return "ok";
    }

    public static ApplicationStartMechanism readFromJsonFile(String filePath) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (ApplicationStartMechanism)mapper.readValue(new File(filePath), ApplicationStartMechanism.class);
        }
        catch (IOException e) {
            System.out.println(e.toString());
            return new ApplicationStartMechanism(new TestCase());
        }
    }

    String toClassFile() {
        StringBuilder sb = new StringBuilder();
        sb.append("");
        return sb.toString();
    }
}

