/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest.applicationstarters.javawebstart;

import java.util.ArrayList;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.applicationundertest.applicationstarters.javawebstart.JnlpFile;
import se.claremont.taf.javasupport.applicationundertest.applicationstarters.javawebstart.SslFileDownloader;

public class JarDownloaderFromJnlp {
    TestCase testCase;
    String baseFilePath = System.getProperty("java.io.tmpdir") + "TAF_JNLP_temp";
    String baseUrl;

    public JarDownloaderFromJnlp(TestCase testCase, String baseUrl) {
        this.testCase = testCase;
        this.baseUrl = baseUrl;
    }

    private void log(LogLevel logLevel, String message) {
        if (this.testCase == null) {
            System.out.println(logLevel.toString() + ":" + message);
        } else {
            this.testCase.log(logLevel, message);
        }
    }

    public void downloadResources() {
        JnlpFile jnlpFile = new JnlpFile(this.testCase);
        jnlpFile.getJnlpContent(this.baseUrl + "jnlp?app=calypsox.apps.startup.StartMainEntrySSL&config=default", "C:\\temp\\jnlp.jnlp");
        this.downloadAndSaveJarFiles(this.baseUrl, jnlpFile.jarFiles);
    }

    private void downloadAndSaveJarFiles(String baseUrl, ArrayList<String> jarFiles) {
        long startTime = System.currentTimeMillis();
        for (String jarFile : jarFiles) {
            this.downloadAndSaveJarFile(baseUrl, jarFile);
        }
        this.log(LogLevel.DEBUG, "It took " + String.valueOf((System.currentTimeMillis() - startTime) / 1000L) + " seconds to download all jar files.");
    }

    private void downloadAndSaveJarFile(String baseUrl, String jarFile) {
        long startTime = System.currentTimeMillis();
        SslFileDownloader sslFileDownloader = new SslFileDownloader(this.testCase);
        sslFileDownloader.downloadFileOverSSLAndPotentiallyBadCertificate(baseUrl + jarFile, this.baseFilePath + jarFile);
        long millis = System.currentTimeMillis() - startTime;
        this.log(LogLevel.DEBUG, "It took " + String.valueOf(millis) + " milliseconds to download '" + baseUrl + jarFile + "' to '" + this.baseFilePath + jarFile + "'.");
    }
}

