/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.applicationdeclarationwindow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.claremont.taf.core.gui.guistyle.TafButton;
import se.claremont.taf.core.gui.guistyle.TafCloseButton;
import se.claremont.taf.core.gui.guistyle.TafDialog;
import se.claremont.taf.core.gui.guistyle.TafHeadline;
import se.claremont.taf.core.gui.guistyle.TafLabel;
import se.claremont.taf.core.gui.guistyle.TafPanel;
import se.claremont.taf.core.gui.guistyle.TafTextField;

public class AddEnvironmentVariableWindow {
    TafDialog frame;
    TafTextField textComponentToUpdate;
    TafTextField variableNameText = new TafTextField(" < environment variable name > ");
    TafTextField variableValueText = new TafTextField(" < environment variable value > ");
    TafButton saveButton = new TafButton("Save");

    public AddEnvironmentVariableWindow(TafTextField component, JFrame parentWindow) {
        this.frame = new TafDialog(parentWindow, "AddEnvironmentVariableFrame", true);
        this.textComponentToUpdate = component;
        this.frame.getContentPane().setLayout(new BorderLayout());
        TafHeadline headline = new TafHeadline("Add or update environment variable");
        TafLabel warningText = new TafLabel("Warning: Environment variables are global to the JVM process - including TAF.");
        TafPanel variablesPanel = new TafPanel("VariablesPanel");
        variablesPanel.setLayout((LayoutManager)new GridLayout(3, 2));
        TafLabel variableNameLabel = new TafLabel("Environment variable name");
        variableNameLabel.setLabelFor((Component)this.variableNameText);
        this.variableNameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddEnvironmentVariableWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddEnvironmentVariableWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddEnvironmentVariableWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }
        });
        variablesPanel.add((Component)variableNameLabel);
        variablesPanel.add((Component)this.variableNameText);
        TafLabel variableValueLabel = new TafLabel("Variable value");
        this.variableValueText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddEnvironmentVariableWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddEnvironmentVariableWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddEnvironmentVariableWindow.this.enableSaveButtonIfBothNameAndValueIsChanged();
            }
        });
        variableValueLabel.setLabelFor((Component)this.variableValueText);
        variablesPanel.add((Component)variableValueLabel);
        variablesPanel.add((Component)this.variableValueText);
        TafCloseButton cancelButton = new TafCloseButton((JDialog)this.frame);
        cancelButton.setText("Cancel");
        variablesPanel.add((Component)cancelButton);
        this.saveButton.setEnabled(false);
        variablesPanel.add((Component)this.saveButton);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AddEnvironmentVariableWindow.this.textComponentToUpdate.isChangedFromDefault()) {
                    AddEnvironmentVariableWindow.this.textComponentToUpdate.setText(AddEnvironmentVariableWindow.this.variableNameText.getText() + "=" + AddEnvironmentVariableWindow.this.variableValueText.getText());
                } else {
                    AddEnvironmentVariableWindow.this.textComponentToUpdate.setText(AddEnvironmentVariableWindow.this.textComponentToUpdate.getText() + ", " + AddEnvironmentVariableWindow.this.variableNameText.getText() + "=" + AddEnvironmentVariableWindow.this.variableValueText.getText());
                }
                AddEnvironmentVariableWindow.this.textComponentToUpdate.revalidate();
                AddEnvironmentVariableWindow.this.textComponentToUpdate.repaint();
                AddEnvironmentVariableWindow.this.frame.dispose();
            }
        });
        this.frame.getContentPane().add((Component)headline, "First");
        this.frame.getContentPane().add((Component)warningText, "Center");
        this.frame.getContentPane().add((Component)variablesPanel, "Last");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void enableSaveButtonIfBothNameAndValueIsChanged() {
        if (this.variableNameText.isChangedFromDefault() && this.variableValueText.isChangedFromDefault()) {
            this.saveButton.setEnabled(true);
        } else {
            this.saveButton.setEnabled(false);
        }
    }
}

