/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.applicationdeclarationwindow;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.claremont.taf.core.gui.Gui;
import se.claremont.taf.core.gui.guistyle.AppFont;
import se.claremont.taf.core.gui.guistyle.TafButton;
import se.claremont.taf.core.gui.guistyle.TafCheckbox;
import se.claremont.taf.core.gui.guistyle.TafFrame;
import se.claremont.taf.core.gui.guistyle.TafGuiColor;
import se.claremont.taf.core.gui.guistyle.TafLabel;
import se.claremont.taf.core.gui.guistyle.TafPanel;
import se.claremont.taf.core.gui.guistyle.TafTextField;
import se.claremont.taf.core.gui.runtab.TestClassPickerDialogue;
import se.claremont.taf.core.gui.teststructure.TestStep;
import se.claremont.taf.javasupport.applicationundertest.ApplicationUnderTest;
import se.claremont.taf.javasupport.gui.JavaSupportTab;
import se.claremont.taf.javasupport.gui.applicationdeclarationwindow.AddEnvironmentVariableWindow;
import se.claremont.taf.javasupport.gui.applicationdeclarationwindow.AddJVMSettingWindow;
import se.claremont.taf.javasupport.gui.applicationdeclarationwindow.AddSystemPropertyWindow;
import se.claremont.taf.javasupport.gui.teststeps.JavaStartApplicationTestStep;

public class DeclareApplicationDialog {
    TafFrame dialog = new TafFrame("TAF - Declare application");
    TafLabel headline = new TafLabel("Application declaration for testing");
    TafLabel blankSpace = new TafLabel(" ");
    TafPanel parametersPanel = new TafPanel("ParametersPanel");
    TafPanel startApplicationPanel = new TafPanel("StartApplicationPanel");
    TafLabel startApplicationLabel = new TafLabel("Application start parameters");
    TafLabel applicationFriendlyNameLabel = new TafLabel("Friendly name*");
    TafTextField applicationFriendlyNameText = new TafTextField(" < Friendly name > ");
    TafLabel pathToJarFileLabel = new TafLabel("Path to jar:");
    LocalTextField pathToJarFileTextField = new LocalTextField(" <Path to jar> ");
    TafButton selectJarFileButton = new TafButton("Select");
    TafLabel workingFolderLabel = new TafLabel("Working folder:");
    LocalTextField workingFolderTextField = new LocalTextField("<Working folder>");
    TafLabel mainClassLabel = new TafLabel("Main class:");
    JComboBox mainClassComboBox;
    DefaultComboBoxModel model;
    String comboBoxDefaultText = "<Main class>";
    LocalTextField mainClassTextField = new LocalTextField("<Main class>");
    TafLabel runtimeArgumentsLabel = new TafLabel("Runtime arguments:");
    LocalTextField runtimeArgumentsTextField = new LocalTextField("<Runtime arguments>");
    TafCheckbox showAdvancedCheckbox = new TafCheckbox("Show advanced options");
    TafPanel advancedParametersPanel = new TafPanel("AdvancedParametersPanel");
    TafLabel advancedParameterLabel = new TafLabel("Advanced");
    TafLabel loadedLibrariesLabel = new TafLabel("Loaded extra libraries");
    TafTextField loadedLibrariesTextField = new TafTextField(" < Loaded external libraries > ");
    TafButton loadedLibrariesAddButton = new TafButton("Add");
    TafLabel environmentVariablesLabel = new TafLabel("Environment variables");
    TafTextField environmentVariablesText = new TafTextField(" < modified environment variables > ");
    TafButton environmentVariablesAddButton = new TafButton("Add");
    TafLabel systemParametersLabel = new TafLabel("Modified system parameters");
    TafTextField systemParametersTextField = new TafTextField(" < System parameters > ");
    TafButton systemParametersAddButton = new TafButton("Add");
    TafLabel jvmArgumentLabel = new TafLabel("JVM arguments");
    TafTextField jvmArgumentTextField = new TafTextField(" < JVM arguments > ");
    TafButton jvmArgumentAddButton = new TafButton("Add");
    TafLabel cliLabel = new TafLabel("Corresponding CLI command:");
    JTextArea cliCommand = new JTextArea();
    TafButton saveButton = new TafButton("Save");
    TafButton cancelButton = new TafButton("Cancel");
    TafButton tryButton = new TafButton("Try");
    TafButton saveSutToFile = new TafButton("Save to file");
    TafButton loadSutFromFile = new TafButton("Load from file");
    GridBagLayout gridBagLayout = new GridBagLayout();
    GridBagConstraints constraints = new GridBagConstraints();

    public DeclareApplicationDialog() {
        final ApplicationUnderTest unmodifiedAut = new ApplicationUnderTest(JavaSupportTab.applicationUnderTest);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setMaximumSize(new Dimension(Toolkit.getDefaultToolkit().getScreenSize()));
        this.headline.setFont(new Font(AppFont.getInstance().getName(), AppFont.getInstance().getStyle(), AppFont.getInstance().getSize() * 3 / 2));
        this.saveButton.setEnabled(false);
        this.applicationFriendlyNameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (DeclareApplicationDialog.this.applicationFriendlyNameText.isChangedFromDefault() && DeclareApplicationDialog.this.applicationFriendlyNameText.getText().length() > 0) {
                    DeclareApplicationDialog.this.saveButton.setEnabled(true);
                } else {
                    DeclareApplicationDialog.this.saveButton.setEnabled(false);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (DeclareApplicationDialog.this.applicationFriendlyNameText.isChangedFromDefault() && DeclareApplicationDialog.this.applicationFriendlyNameText.getText().length() > 0) {
                    DeclareApplicationDialog.this.saveButton.setEnabled(true);
                } else {
                    DeclareApplicationDialog.this.saveButton.setEnabled(false);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (DeclareApplicationDialog.this.applicationFriendlyNameText.isChangedFromDefault() && DeclareApplicationDialog.this.applicationFriendlyNameText.getText().length() > 0) {
                    DeclareApplicationDialog.this.saveButton.setEnabled(true);
                } else {
                    DeclareApplicationDialog.this.saveButton.setEnabled(false);
                }
            }
        });
        this.selectJarFileButton.setMnemonic('e');
        this.selectJarFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setName("FilePickerWindow");
                fileChooser.setDialogTitle("TAF - File picker");
                fileChooser.setFont(AppFont.getInstance());
                try {
                    fileChooser.setCurrentDirectory(new File(TestClassPickerDialogue.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()));
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
                int returnVal = fileChooser.showOpenDialog((Component)DeclareApplicationDialog.this.dialog);
                if (returnVal == 0) {
                    File file = fileChooser.getSelectedFile();
                    DeclareApplicationDialog.this.pathToJarFileTextField.setText(file.getAbsolutePath());
                    if (!file.isDirectory() && DeclareApplicationDialog.this.workingFolderTextField.getText().equals(DeclareApplicationDialog.this.workingFolderTextField.disregardedDefaultRunNameString)) {
                        DeclareApplicationDialog.this.workingFolderTextField.setText(file.getParent());
                    }
                }
                DeclareApplicationDialog.this.updateMainClassComboboxModel();
            }
        });
        this.applicationFriendlyNameLabel.setLabelFor((Component)this.applicationFriendlyNameText);
        this.applicationFriendlyNameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (DeclareApplicationDialog.this.applicationFriendlyNameText.isChangedFromDefault()) {
                    JavaSupportTab.applicationUnderTest.setName(DeclareApplicationDialog.this.applicationFriendlyNameText.getText());
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (DeclareApplicationDialog.this.applicationFriendlyNameText.isChangedFromDefault()) {
                    JavaSupportTab.applicationUnderTest.setName(DeclareApplicationDialog.this.applicationFriendlyNameText.getText());
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (DeclareApplicationDialog.this.applicationFriendlyNameText.isChangedFromDefault()) {
                    JavaSupportTab.applicationUnderTest.setName(DeclareApplicationDialog.this.applicationFriendlyNameText.getText());
                }
            }
        });
        this.model = new DefaultComboBoxModel<String>(new String[]{this.comboBoxDefaultText});
        this.mainClassComboBox = new JComboBox(this.model);
        this.mainClassComboBox.setEditable(true);
        this.mainClassComboBox.getEditor().getEditorComponent().setForeground(TafGuiColor.disabledColor);
        this.mainClassComboBox.setFont(new Font(AppFont.getInstance().getFontName(), 2, AppFont.getInstance().getSize()));
        this.mainClassComboBox.addActionListener(new ActionListener(){
            private int selectedIndex = -1;

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = DeclareApplicationDialog.this.mainClassComboBox.getSelectedIndex();
                if (index >= 0) {
                    this.selectedIndex = index;
                } else if ("comboBoxEdited".equals(e.getActionCommand())) {
                    Object newValue = DeclareApplicationDialog.this.model.getSelectedItem();
                    DeclareApplicationDialog.this.model.removeElementAt(this.selectedIndex);
                    DeclareApplicationDialog.this.model.addElement(newValue);
                    DeclareApplicationDialog.this.mainClassComboBox.setSelectedItem(newValue);
                    this.selectedIndex = DeclareApplicationDialog.this.model.getIndexOf(newValue);
                }
                if (DeclareApplicationDialog.this.mainClassComboBox.getItemAt(this.selectedIndex) != null && !DeclareApplicationDialog.this.mainClassComboBox.getItemAt(this.selectedIndex).equals(DeclareApplicationDialog.this.comboBoxDefaultText)) {
                    DeclareApplicationDialog.this.updateCliSuggestionAndSaveToFileButtonStatus();
                    DeclareApplicationDialog.this.mainClassComboBox.getEditor().getEditorComponent().setForeground(TafGuiColor.textColor);
                    DeclareApplicationDialog.this.mainClassComboBox.setFont(AppFont.getInstance());
                } else {
                    DeclareApplicationDialog.this.mainClassComboBox.getEditor().getEditorComponent().setForeground(TafGuiColor.disabledColor);
                    DeclareApplicationDialog.this.mainClassComboBox.setFont(new Font(AppFont.getInstance().getFontName(), 2, AppFont.getInstance().getSize()));
                }
            }
        });
        this.mainClassComboBox.setSelectedIndex(0);
        if (JavaSupportTab.applicationUnderTest.startMechanism.startUrlOrPathToJarFile != null && JavaSupportTab.applicationUnderTest.startMechanism.startUrlOrPathToJarFile.length() > 0) {
            this.pathToJarFileTextField.setText(JavaSupportTab.applicationUnderTest.startMechanism.startUrlOrPathToJarFile);
        }
        if (JavaSupportTab.applicationUnderTest.startMechanism.mainClass != null && JavaSupportTab.applicationUnderTest.startMechanism.mainClass.length() > 0) {
            this.mainClassTextField.setText(JavaSupportTab.applicationUnderTest.startMechanism.mainClass);
        }
        if (JavaSupportTab.applicationUnderTest.startMechanism.arguments != null && JavaSupportTab.applicationUnderTest.startMechanism.arguments.size() > 0) {
            this.runtimeArgumentsTextField.setText(String.join((CharSequence)" ", JavaSupportTab.applicationUnderTest.startMechanism.arguments));
        }
        this.showAdvancedCheckbox.setSelected(false);
        this.showAdvancedCheckbox.setMnemonic('h');
        this.showAdvancedCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (DeclareApplicationDialog.this.showAdvancedCheckbox.isSelected()) {
                    DeclareApplicationDialog.this.advancedParametersPanel.setVisible(true);
                    DeclareApplicationDialog.this.dialog.pack();
                    DeclareApplicationDialog.this.dialog.revalidate();
                    DeclareApplicationDialog.this.dialog.repaint();
                } else {
                    DeclareApplicationDialog.this.advancedParametersPanel.setVisible(false);
                    DeclareApplicationDialog.this.dialog.pack();
                    DeclareApplicationDialog.this.dialog.revalidate();
                    DeclareApplicationDialog.this.dialog.repaint();
                }
            }
        });
        this.advancedParametersPanel.setVisible(false);
        this.loadedLibrariesTextField.setEditable(false);
        this.loadedLibrariesAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser window = new JFileChooser();
                window.setName("FilePickerWindow");
                window.setDialogTitle("TAF - File picker");
                window.setFont(AppFont.getInstance());
                try {
                    window.setCurrentDirectory(new File(TestClassPickerDialogue.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()));
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
                int returnVal = window.showOpenDialog((Component)DeclareApplicationDialog.this.dialog);
                if (returnVal == 0) {
                    File file = window.getSelectedFile();
                    if (file.isDirectory()) {
                        JavaSupportTab.applicationUnderTest.loadAllLibrariesInFolder(file.getPath());
                        ArrayList<String> subFiles = new ArrayList<String>();
                        for (File subFile : file.listFiles()) {
                            if (subFile.isDirectory()) continue;
                            subFiles.add(subFile.getAbsolutePath());
                        }
                        if (DeclareApplicationDialog.this.loadedLibrariesTextField.getText().equals(DeclareApplicationDialog.this.loadedLibrariesTextField.disregardedDefaultRunNameString)) {
                            DeclareApplicationDialog.this.loadedLibrariesTextField.setText(String.join((CharSequence)", ", subFiles));
                        } else {
                            DeclareApplicationDialog.this.loadedLibrariesTextField.setText(DeclareApplicationDialog.this.loadedLibrariesTextField.getText() + ", " + String.join((CharSequence)", ", subFiles));
                        }
                    } else {
                        JavaSupportTab.applicationUnderTest.loadLibrary(file.getPath());
                        if (DeclareApplicationDialog.this.loadedLibrariesTextField.getText().equals(DeclareApplicationDialog.this.loadedLibrariesTextField.disregardedDefaultRunNameString)) {
                            DeclareApplicationDialog.this.loadedLibrariesTextField.setText(String.join((CharSequence)", ", DeclareApplicationDialog.this.loadedLibrariesTextField.getText().split(", ")) + file.getAbsolutePath());
                        } else {
                            DeclareApplicationDialog.this.loadedLibrariesTextField.setText(DeclareApplicationDialog.this.loadedLibrariesTextField.getText() + ", " + file.getAbsolutePath());
                        }
                    }
                    DeclareApplicationDialog.this.updateCliSuggestionAndSaveToFileButtonStatus();
                }
            }
        });
        this.systemParametersTextField.setEditable(false);
        this.systemParametersAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddSystemPropertyWindow propertyAddingWindow = new AddSystemPropertyWindow(DeclareApplicationDialog.this.systemParametersTextField, (JFrame)DeclareApplicationDialog.this.dialog);
                DeclareApplicationDialog.this.updateCliSuggestionAndSaveToFileButtonStatus();
            }
        });
        this.environmentVariablesText.setEditable(false);
        this.environmentVariablesAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddEnvironmentVariableWindow addEnvironmentVariableWindow = new AddEnvironmentVariableWindow(DeclareApplicationDialog.this.environmentVariablesText, (JFrame)DeclareApplicationDialog.this.dialog);
                DeclareApplicationDialog.this.updateCliSuggestionAndSaveToFileButtonStatus();
            }
        });
        this.jvmArgumentTextField.setEditable(false);
        this.jvmArgumentAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddJVMSettingWindow addJVMSettingWindow = new AddJVMSettingWindow(DeclareApplicationDialog.this.jvmArgumentTextField, (JFrame)DeclareApplicationDialog.this.dialog);
                if (DeclareApplicationDialog.this.jvmArgumentTextField.isChangedFromDefault() && DeclareApplicationDialog.this.jvmArgumentTextField.getText().contains(", ")) {
                    for (String pair : DeclareApplicationDialog.this.jvmArgumentTextField.getText().split(", ")) {
                        if (!pair.contains("=")) continue;
                        JavaSupportTab.applicationUnderTest.context.jvmSettings.setVMOption(pair.split("=")[0], pair.substring(pair.indexOf("=")));
                    }
                }
                DeclareApplicationDialog.this.updateCliSuggestionAndSaveToFileButtonStatus();
            }
        });
        this.loadSutFromFile.setMnemonic('L');
        this.loadSutFromFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser window = new JFileChooser();
                window.setName("FilePickerWindow");
                window.setDialogTitle("TAF - File picker");
                window.setFont(AppFont.getInstance());
                try {
                    window.setCurrentDirectory(new File(TestClassPickerDialogue.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()));
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
                int returnVal = window.showOpenDialog((Component)DeclareApplicationDialog.this.dialog);
                if (returnVal == 0) {
                    File file = window.getSelectedFile();
                    JavaSupportTab.applicationUnderTest = new ApplicationUnderTest(ApplicationUnderTest.readFromJsonFile(file.getPath()));
                    DeclareApplicationDialog.this.pathToJarFileTextField.setText(JavaSupportTab.applicationUnderTest.startMechanism.startUrlOrPathToJarFile.substring(7));
                    DeclareApplicationDialog.this.mainClassComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{JavaSupportTab.applicationUnderTest.startMechanism.mainClass}));
                    DeclareApplicationDialog.this.runtimeArgumentsTextField.setText(String.join((CharSequence)", ", JavaSupportTab.applicationUnderTest.startMechanism.arguments));
                    if (JavaSupportTab.applicationUnderTest.context.jvmSettings.appliedSetting.size() > 0) {
                        DeclareApplicationDialog.this.jvmArgumentTextField.setText(String.join((CharSequence)", ", JavaSupportTab.applicationUnderTest.context.jvmSettings.appliedSetting));
                    }
                    DeclareApplicationDialog.this.environmentVariablesText.setText(String.join((CharSequence)" ", JavaSupportTab.applicationUnderTest.context.environmentVariables.appliedVariableChanges));
                    if (JavaSupportTab.applicationUnderTest.context.properties.appliedProperties.size() > 0) {
                        DeclareApplicationDialog.this.systemParametersTextField.setText(String.join((CharSequence)", ", JavaSupportTab.applicationUnderTest.context.properties.appliedProperties));
                    }
                    DeclareApplicationDialog.this.loadedLibrariesTextField.setText(String.join((CharSequence)", ", JavaSupportTab.applicationUnderTest.context.loadedLibraries.appliedFiles));
                    DeclareApplicationDialog.this.updateCliSuggestionAndSaveToFileButtonStatus();
                }
            }
        });
        this.saveSutToFile.setEnabled(false);
        this.saveSutToFile.setMnemonic('f');
        this.saveSutToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser window = new JFileChooser();
                window.setName("FileSaveWindow");
                window.setDialogTitle("TAF - File save dialog");
                window.setFont(AppFont.getInstance());
                try {
                    window.setCurrentDirectory(new File(TestClassPickerDialogue.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()));
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
                int returnVal = window.showSaveDialog((Component)DeclareApplicationDialog.this.dialog);
                if (returnVal == 0) {
                    File file = window.getSelectedFile();
                    JavaSupportTab.applicationUnderTest.saveToJsonFile(file.getPath());
                }
            }
        });
        this.cancelButton.setMnemonic('c');
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaSupportTab.applicationUnderTest = new ApplicationUnderTest(unmodifiedAut);
                DeclareApplicationDialog.this.dialog.setVisible(false);
                DeclareApplicationDialog.this.dialog.dispose();
            }
        });
        this.saveButton.setMnemonic('S');
        this.saveButton.setToolTipText("Needs a set friendly name for saving.");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.addTestStepToListOfAvailableTestSteps((TestStep)new JavaStartApplicationTestStep(JavaSupportTab.applicationUnderTest));
                DeclareApplicationDialog.this.dialog.setVisible(false);
                DeclareApplicationDialog.this.dialog.dispose();
            }
        });
        this.tryButton.setMnemonic('T');
        this.tryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaSupportTab.applicationUnderTest.start();
            }
        });
        this.cliCommand.setForeground(TafGuiColor.disabledColor);
        this.cliCommand.setFont(new Font(AppFont.getInstance().getFontName(), 2, AppFont.getInstance().getSize()));
        this.cliCommand.setEnabled(false);
        this.cliCommand.setLineWrap(true);
        this.cliCommand.setBackground(TafGuiColor.backgroundColor);
        this.updateCliSuggestionAndSaveToFileButtonStatus();
        this.setParameterPanelLayout();
        this.setWindowLayout();
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private void setParameterPanelLayout() {
        this.startApplicationPanel.setLayout((LayoutManager)this.gridBagLayout);
        this.constraints.ipadx = AppFont.getInstance().getSize();
        this.startApplicationLabel.setFont(new Font(AppFont.getInstance().getName(), 1, AppFont.getInstance().getSize()));
        this.startApplicationPanel.setBorder(BorderFactory.createLineBorder(TafGuiColor.textColor));
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 0.0;
        this.constraints.fill = 2;
        this.constraints.anchor = 21;
        this.startApplicationPanel.add((Component)this.startApplicationLabel, (Object)this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 0.0;
        this.constraints.fill = 2;
        this.constraints.anchor = 21;
        this.startApplicationPanel.add((Component)this.pathToJarFileLabel, (Object)this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.constraints.weightx = 0.5;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.startApplicationPanel.add((Component)((Object)this.pathToJarFileTextField), (Object)this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridy = 1;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 22;
        this.startApplicationPanel.add((Component)this.selectJarFileButton, (Object)this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 21;
        this.constraints.fill = 2;
        this.startApplicationPanel.add((Component)this.mainClassLabel, (Object)this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 2;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 2;
        this.constraints.fill = 2;
        this.constraints.anchor = 22;
        this.startApplicationPanel.add((Component)this.mainClassComboBox, (Object)this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 21;
        this.constraints.fill = 2;
        this.startApplicationPanel.add((Component)this.runtimeArgumentsLabel, (Object)this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 3;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 2;
        this.constraints.fill = 2;
        this.constraints.anchor = 22;
        this.startApplicationPanel.add((Component)((Object)this.runtimeArgumentsTextField), (Object)this.constraints);
        this.advancedParametersPanel.setLayout((LayoutManager)new GridBagLayout());
        this.advancedParametersPanel.setBorder(BorderFactory.createLineBorder(TafGuiColor.textColor));
        this.advancedParameterLabel.setFont(new Font(AppFont.getInstance().getName(), 1, AppFont.getInstance().getSize()));
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 3;
        this.constraints.fill = 2;
        this.constraints.anchor = 21;
        this.advancedParametersPanel.add((Component)this.advancedParameterLabel, (Object)this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 21;
        this.advancedParametersPanel.add((Component)this.workingFolderLabel, (Object)this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 2;
        this.constraints.fill = 2;
        this.constraints.anchor = 22;
        this.advancedParametersPanel.add((Component)((Object)this.workingFolderTextField), (Object)this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 21;
        this.constraints.fill = 2;
        this.advancedParametersPanel.add((Component)this.loadedLibrariesLabel, (Object)this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 2;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.advancedParametersPanel.add((Component)this.loadedLibrariesTextField, (Object)this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridy = 2;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 22;
        this.advancedParametersPanel.add((Component)this.loadedLibrariesAddButton, (Object)this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 21;
        this.constraints.fill = 2;
        this.advancedParametersPanel.add((Component)this.systemParametersLabel, (Object)this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 3;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.advancedParametersPanel.add((Component)this.systemParametersTextField, (Object)this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridy = 3;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 22;
        this.advancedParametersPanel.add((Component)this.systemParametersAddButton, (Object)this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 4;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 21;
        this.constraints.fill = 2;
        this.advancedParametersPanel.add((Component)this.environmentVariablesLabel, (Object)this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 4;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.advancedParametersPanel.add((Component)this.environmentVariablesText, (Object)this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridy = 4;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 22;
        this.advancedParametersPanel.add((Component)this.environmentVariablesAddButton, (Object)this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 5;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 21;
        this.constraints.fill = 2;
        this.advancedParametersPanel.add((Component)this.jvmArgumentLabel, (Object)this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 5;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.advancedParametersPanel.add((Component)this.jvmArgumentTextField, (Object)this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridy = 5;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 22;
        this.advancedParametersPanel.add((Component)this.jvmArgumentAddButton, (Object)this.constraints);
    }

    private void setWindowLayout() {
        TafPanel contentPanelSubstitute = new TafPanel("DeclareSutMainPanel");
        GroupLayout groupLayout = new GroupLayout((Container)contentPanelSubstitute);
        contentPanelSubstitute.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent((Component)this.headline).addComponent((Component)this.blankSpace).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.applicationFriendlyNameLabel).addComponent((Component)this.applicationFriendlyNameText)).addComponent((Component)this.startApplicationPanel).addComponent((Component)this.showAdvancedCheckbox).addComponent((Component)this.advancedParametersPanel).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.loadSutFromFile).addComponent((Component)this.saveSutToFile)).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.cliLabel).addComponent(this.cliCommand)).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.tryButton).addComponent((Component)this.cancelButton).addComponent((Component)this.saveButton))));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent((Component)this.headline).addComponent((Component)this.blankSpace).addGroup(groupLayout.createParallelGroup().addComponent((Component)this.applicationFriendlyNameLabel).addComponent((Component)this.applicationFriendlyNameText)).addComponent((Component)this.startApplicationPanel).addComponent((Component)this.showAdvancedCheckbox).addComponent((Component)this.advancedParametersPanel).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.loadSutFromFile).addComponent((Component)this.saveSutToFile)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.cliLabel, -1, -1, Short.MAX_VALUE).addComponent(this.cliCommand)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.tryButton).addComponent((Component)this.cancelButton).addComponent((Component)this.saveButton)));
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        this.dialog.getContentPane().add((Component)contentPanelSubstitute);
    }

    private void updateMainClassComboboxModel() {
        this.model.removeAllElements();
        try {
            ZipInputStream zip = new ZipInputStream(new FileInputStream(this.pathToJarFileTextField.getText()));
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                    try {
                        String className = entry.getName().replace("/", ".").replace("\\", ".");
                        className = className.substring(0, className.length() - ".class".length());
                        Class<?> klass = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                        if (Modifier.isPublic(klass.getModifiers())) {
                            for (Method method : klass.getDeclaredMethods()) {
                                if (!method.getName().equals("main")) continue;
                                method.setAccessible(true);
                                if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
                                this.model.addElement(klass.getName());
                            }
                        }
                    }
                    catch (NoClassDefFoundError ignored) {
                        System.out.println(ignored.toString());
                    }
                    catch (Exception ignored) {
                        System.out.println(ignored.toString());
                    }
                }
                entry = zip.getNextEntry();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        if (this.model.getSize() == 0) {
            this.model.addElement(this.comboBoxDefaultText);
        }
        this.mainClassComboBox.setModel(this.model);
        this.mainClassComboBox.setSelectedIndex(0);
    }

    private void updateCliSuggestionAndSaveToFileButtonStatus() {
        String comboboxChoice;
        String cli = "";
        String pathToJar = this.pathToJarFileTextField.getText();
        if (this.pathToJarFileTextField.isChangedFromDefault() || this.mainClassTextField.isChangedFromDefault() || this.runtimeArgumentsTextField.isChangedFromDefault() || this.systemParametersTextField.isChangedFromDefault() || this.environmentVariablesText.isChangedFromDefault() || this.jvmArgumentTextField.isChangedFromDefault() || this.loadedLibrariesTextField.isChangedFromDefault()) {
            cli = "java ";
        }
        if (this.jvmArgumentTextField.isChangedFromDefault()) {
            if (this.jvmArgumentTextField.getText().contains(", ")) {
                for (String pair : this.jvmArgumentTextField.getText().split(", ")) {
                    cli = cli + "-X" + pair;
                }
            } else {
                cli = cli + "-X" + this.jvmArgumentTextField.getText();
            }
        }
        if (this.pathToJarFileTextField.isChangedFromDefault()) {
            JavaSupportTab.applicationUnderTest.startMechanism.startUrlOrPathToJarFile = "file://" + this.pathToJarFileTextField.getText();
            cli = cli + "-jar " + pathToJar + " ";
        }
        if (JavaSupportTab.applicationUnderTest.context.properties.appliedProperties.size() > 0) {
            cli = cli + "-D" + String.join((CharSequence)" -D", JavaSupportTab.applicationUnderTest.context.properties.appliedProperties) + " ";
        }
        if (this.mainClassComboBox.getItemAt(this.mainClassComboBox.getSelectedIndex()) != null && !(comboboxChoice = this.mainClassComboBox.getItemAt(this.mainClassComboBox.getSelectedIndex()).toString()).equals(this.mainClassTextField.disregardedDefaultRunNameString) && comboboxChoice.length() != 0) {
            JavaSupportTab.applicationUnderTest.startMechanism.mainClass = comboboxChoice;
            cli = cli + " " + comboboxChoice;
        }
        if (this.environmentVariablesText.isChangedFromDefault()) {
            if (this.environmentVariablesText.getText().contains(", ")) {
                for (String pair : this.environmentVariablesText.getText().split(", ")) {
                    if (!pair.contains("=")) continue;
                    JavaSupportTab.applicationUnderTest.context.environmentVariables.setEnvironmentVariable(pair.split("=")[0], pair.substring(pair.indexOf("=")));
                }
            } else if (this.environmentVariablesText.getText().contains("=")) {
                JavaSupportTab.applicationUnderTest.context.environmentVariables.setEnvironmentVariable(this.environmentVariablesText.getText().split("=")[0], this.environmentVariablesText.getText().substring(this.environmentVariablesText.getText().indexOf("=")));
            }
        }
        if (this.systemParametersTextField.isChangedFromDefault()) {
            if (this.systemParametersTextField.getText().contains(", ")) {
                cli = cli + " -D" + String.join((CharSequence)(" -D" + this.systemParametersTextField.getText().split(", ")), new CharSequence[0]);
                for (String pair : this.systemParametersTextField.getText().split(", ")) {
                    if (!pair.contains("=")) continue;
                    JavaSupportTab.applicationUnderTest.context.properties.setProperty(pair.split("=")[0], pair.substring(pair.indexOf("=")));
                }
            } else {
                cli = cli + " -D" + this.systemParametersTextField.getText();
                if (this.systemParametersTextField.getText().contains("=")) {
                    JavaSupportTab.applicationUnderTest.context.properties.setProperty(this.systemParametersTextField.getText().split("=")[0], this.systemParametersTextField.getText().substring(this.systemParametersTextField.getText().indexOf("=")));
                }
            }
        }
        if (!this.workingFolderTextField.getText().equals(this.workingFolderTextField.disregardedDefaultRunNameString) && this.workingFolderTextField.getText().length() != 0) {
            cli = cli + " -cp " + this.workingFolderTextField.getText() + File.pathSeparator + "*";
            if (!this.loadedLibrariesTextField.getText().equals(this.loadedLibrariesTextField.disregardedDefaultRunNameString)) {
                cli = cli + "/" + this.loadedLibrariesTextField.getText().replace(", ", "/");
            }
        }
        if (!this.runtimeArgumentsTextField.getText().equals(this.runtimeArgumentsTextField.disregardedDefaultRunNameString) && this.runtimeArgumentsTextField.getText().length() != 0) {
            JavaSupportTab.applicationUnderTest.startMechanism.arguments.clear();
            for (String arg : this.runtimeArgumentsTextField.getText().split(" ")) {
                JavaSupportTab.applicationUnderTest.startMechanism.arguments.add(arg);
            }
            cli = cli + " " + this.runtimeArgumentsTextField.getText();
        }
        if (this.pathToJarFileTextField.getText() != null && this.pathToJarFileTextField.getText().length() > 0 && this.mainClassComboBox.getItemAt(this.mainClassComboBox.getSelectedIndex()).toString().length() > 0 && !this.mainClassComboBox.getItemAt(this.mainClassComboBox.getSelectedIndex()).toString().equals(this.comboBoxDefaultText)) {
            this.saveSutToFile.setEnabled(true);
        }
        this.cliCommand.setText(cli);
        this.dialog.pack();
        this.dialog.revalidate();
        this.dialog.repaint();
    }

    private class LocalTextField
    extends TafTextField {
        public LocalTextField(String initialText) {
            super(initialText);
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    DeclareApplicationDialog.this.updateCliSuggestionAndSaveToFileButtonStatus();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    DeclareApplicationDialog.this.updateCliSuggestionAndSaveToFileButtonStatus();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    DeclareApplicationDialog.this.updateCliSuggestionAndSaveToFileButtonStatus();
                }
            });
        }
    }
}

