/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.guispywindow;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import se.claremont.taf.core.gui.guistyle.AppFont;
import se.claremont.taf.core.gui.guistyle.TafLabel;
import se.claremont.taf.core.gui.guistyle.TafTextField;
import se.claremont.taf.javasupport.gui.guispywindow.GuiSpyingWindow;
import se.claremont.taf.javasupport.interaction.MethodDeclarations;
import se.claremont.taf.javasupport.interaction.MethodInvoker;

public class GuiSpyMouseListener
implements MouseListener {
    private final JTextComponent textComponent;
    private final JPanel elementPropertiesPanel;
    static Component currentComponent;
    GridBagConstraints constraints = new GridBagConstraints();
    private int propertiesPanelRowCount = 0;

    GuiSpyMouseListener(JTextComponent updateComponent, JPanel elementPropertiesPanel) {
        this.textComponent = updateComponent;
        this.elementPropertiesPanel = elementPropertiesPanel;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (GuiSpyingWindow.executionIsPaused) {
            return;
        }
        currentComponent = e.getComponent();
        this.textComponent.setText(this.componentDeclarationString(currentComponent));
        this.textComponent.revalidate();
        this.textComponent.repaint();
        this.updatePropertiesPanel(currentComponent);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (GuiSpyingWindow.executionIsPaused) {
            return;
        }
        currentComponent = null;
        this.textComponent.setText("");
    }

    static boolean guiSpyMouseListenerIsAdded(Component component) {
        for (MouseListener mouseListener : component.getMouseListeners()) {
            if (!mouseListener.getClass().equals(GuiSpyMouseListener.class)) continue;
            return true;
        }
        return false;
    }

    private void updatePropertiesPanel(Component c) {
        int propertiesCount = 4;
        StringBuilder parameterTextForClipbard = new StringBuilder();
        GridBagLayout gridBag = new GridBagLayout();
        this.elementPropertiesPanel.setLayout(gridBag);
        this.constraints.fill = 2;
        this.elementPropertiesPanel.removeAll();
        this.addPropertyName("Class");
        parameterTextForClipbard.append("Class=").append(c.getClass().getName()).append(System.lineSeparator());
        this.addPropertyValueAsLabel(c.getClass().getName());
        ++this.propertiesPanelRowCount;
        String text = null;
        MethodInvoker m = new MethodInvoker();
        try {
            text = (String)m.invokeTheFirstEncounteredMethod((Object)c, MethodDeclarations.textGettingMethodsInAttemptOrder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addPropertyName("Text");
        TafTextField textProperty = new TafTextField(" < No text identified > ");
        if (text != null) {
            textProperty.setText(text);
        }
        this.setGridBagConstraintsForPropertyValue();
        parameterTextForClipbard.append("Text=").append(text).append(System.lineSeparator());
        this.elementPropertiesPanel.add((Component)textProperty, this.constraints);
        ++this.propertiesPanelRowCount;
        this.addPropertyName("Enabled");
        this.addPropertyValueAsLabel(String.valueOf(c.isEnabled()));
        parameterTextForClipbard.append("Enabled=").append(String.valueOf(c.isEnabled())).append(System.lineSeparator());
        ++this.propertiesPanelRowCount;
        TafTextField name = new TafTextField(" < No element name set > ");
        if (c.getName() != null && c.getName().length() > 0) {
            name.setText(c.getName());
        }
        this.addPropertyName("Name");
        this.setGridBagConstraintsForPropertyValue();
        parameterTextForClipbard.append("Name=").append(c.getName()).append(System.lineSeparator());
        this.elementPropertiesPanel.add((Component)name, this.constraints);
        ++this.propertiesPanelRowCount;
        GuiSpyingWindow.currentElementParametersForClipboard = parameterTextForClipbard.toString();
        this.elementPropertiesPanel.revalidate();
        this.elementPropertiesPanel.repaint();
    }

    private void setGridBagConstraintsForPropertyValue() {
        this.constraints.gridx = 1;
        this.constraints.gridy = this.propertiesPanelRowCount;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 22;
        this.constraints.fill = 2;
    }

    private void addPropertyName(String name) {
        this.constraints.gridx = 0;
        this.constraints.gridy = this.propertiesPanelRowCount;
        this.constraints.weightx = 0.0;
        this.constraints.ipadx = 50;
        this.constraints.anchor = 21;
        this.constraints.fill = 2;
        this.elementPropertiesPanel.add((Component)new TafLabel(name), this.constraints);
    }

    private void addPropertyValueAsLabel(String value) {
        this.constraints.gridx = 1;
        this.constraints.gridy = this.propertiesPanelRowCount;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 22;
        this.constraints.fill = 2;
        this.elementPropertiesPanel.add((Component)new TafLabel(value), this.constraints);
    }

    private String componentDeclarationString(Component c) {
        if (c == null) {
            return null;
        }
        String elementName = "Noname";
        StringBuilder htmlDescriptionForGui = new StringBuilder();
        htmlDescriptionForGui.append("      ").append(".byClassName(\"").append(c.getClass().getSimpleName()).append("\")<br>");
        if (c.getName() != null && c.getName().length() > 0) {
            htmlDescriptionForGui.append("      .andByName(\"").append(c.getName()).append("\")<br>");
            elementName = c.getName();
        }
        String text = null;
        try {
            text = (String)MethodInvoker.invokeMethod(null, c, "getText", new Object(){});
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (text != null && text.length() > 0) {
            htmlDescriptionForGui.append("      .andByExactText(\"").append(text).append("\")<br>");
        }
        GuiSpyingWindow.elementProgramaticDescriptionFormattedForClipboard = "   public static JavaGuiElement " + elementName + " = new JavaGuiElement(By" + System.lineSeparator() + htmlDescriptionForGui.toString().replace("<br>", System.lineSeparator()) + "   );" + System.lineSeparator();
        return ("<html><body><div style=\"white-space: pre; font-size: " + AppFont.getInstance().getSize() * 2 / 3 + "; color:darkgrey; \">   public static JavaGuiElement " + elementName + " = new JavaGuiElement(By<br>" + htmlDescriptionForGui.toString() + "   );</div></body></html>").replace(" ", "&nbsp;");
    }
}

