/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.interaction.elementidentification;

import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import se.claremont.taf.core.guidriverpluginstructure.PositionBasedIdentification.ElementsList;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.interaction.GenericInteractionMethods;
import se.claremont.taf.javasupport.interaction.MethodDeclarations;
import se.claremont.taf.javasupport.interaction.MethodInvoker;
import se.claremont.taf.javasupport.interaction.elementidentification.SearchCondition;
import se.claremont.taf.javasupport.interaction.elementidentification.SearchConditionType;
import se.claremont.taf.javasupport.objectstructure.JavaGuiElement;
import se.claremont.taf.javasupport.objectstructure.JavaWindow;

public class By {
    public List<SearchCondition> searchConditions = new ArrayList<SearchCondition>();

    public static By byClass(String className) {
        By by = new By();
        by.searchConditions.add(new SearchCondition(SearchConditionType.CLASS, className));
        return by;
    }

    public static By byOrdinalNumber(int ordinalNumber) {
        By by = new By();
        by.searchConditions.add(new SearchCondition(SearchConditionType.ORDINAL_NUMBER, ordinalNumber));
        return by;
    }

    public static By byRelativePosition(ElementsList staticPositionBasedIdentificatorReferenceToElementList) {
        By by = new By();
        by.searchConditions.add(new SearchCondition(SearchConditionType.POSITION_BASED, staticPositionBasedIdentificatorReferenceToElementList));
        return by;
    }

    public static By byName(String elementName) {
        By by = new By();
        by.searchConditions.add(new SearchCondition(SearchConditionType.NAME, elementName));
        return by;
    }

    public static By byExactText(Object ... alternativesForElementText) {
        By by = new By();
        by.searchConditions.add(new SearchCondition(SearchConditionType.EXACT_TEXT, alternativesForElementText));
        return by;
    }

    public static By byTextContaining(Object ... alternativesForElementText) {
        By by = new By();
        by.searchConditions.add(new SearchCondition(SearchConditionType.TEXT_CONTAINS, alternativesForElementText));
        return by;
    }

    public static By byTextRegexMatch(Object ... alternativesForElementTextRegexPatterns) {
        By by = new By();
        by.searchConditions.add(new SearchCondition(SearchConditionType.TEXT_REGEX_MATCH, alternativesForElementTextRegexPatterns));
        return by;
    }

    public static By byBeingDescendantOf(JavaGuiElement ancestorElement) {
        By by = new By();
        by.searchConditions.add(new SearchCondition(SearchConditionType.BEING_DESCENDANT_OF, ancestorElement));
        return by;
    }

    public By andByClass(String className) {
        this.searchConditions.add(new SearchCondition(SearchConditionType.CLASS, className));
        return this;
    }

    public By andByName(String elementName) {
        this.searchConditions.add(new SearchCondition(SearchConditionType.NAME, elementName));
        return this;
    }

    public By andByExactText(Object ... alterativesForElementText) {
        this.searchConditions.add(new SearchCondition(SearchConditionType.EXACT_TEXT, alterativesForElementText));
        return this;
    }

    public By andByTextContains(Object ... alterativesForElementText) {
        this.searchConditions.add(new SearchCondition(SearchConditionType.TEXT_CONTAINS, alterativesForElementText));
        return this;
    }

    public By andByTextRegexMatch(Object ... alterativesForElementTextRegexPatterns) {
        this.searchConditions.add(new SearchCondition(SearchConditionType.TEXT_REGEX_MATCH, alterativesForElementTextRegexPatterns));
        return this;
    }

    public By andByBeingDescendantOf(JavaGuiElement ancestorElement) {
        this.searchConditions.add(new SearchCondition(SearchConditionType.BEING_DESCENDANT_OF, ancestorElement));
        return this;
    }

    public By andByOrdinalNumber(int ordinalNumber) {
        this.searchConditions.add(new SearchCondition(SearchConditionType.ORDINAL_NUMBER, ordinalNumber));
        return this;
    }

    public String asCode() {
        if (this.searchConditions == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("By").append(System.lineSeparator());
        for (SearchCondition searchCondition : this.searchConditions) {
            String objectString = null;
            switch (searchCondition.searchConditionType) {
                case BEING_DESCENDANT_OF: {
                    objectString = ((JavaGuiElement)searchCondition.objects[0]).getName();
                    break;
                }
                default: {
                    objectString = "\"" + searchCondition.objects[0].toString() + "\"";
                }
            }
            sb.append("      ").append(".").append(searchCondition.searchConditionType.getMethodName()).append("(").append(objectString).append(")").append(System.lineSeparator());
        }
        return sb.toString();
    }

    public boolean isMatch(Object object) {
        boolean match = false;
        Integer ordinalNumber = null;
        for (SearchCondition searchCondition : this.searchConditions) {
            switch (searchCondition.searchConditionType) {
                case NAME: {
                    match = false;
                    String name = (String)MethodInvoker.invokeTheFirstEncounteredMethodFromListOfMethodNames(object, MethodDeclarations.componentNameGetterMethodsInAttemptOrder);
                    if (name == null || name.length() == 0) {
                        return false;
                    }
                    for (Object nameAlternative : searchCondition.objects) {
                        if (!((String)nameAlternative).equals(name)) continue;
                        match = true;
                        break;
                    }
                    if (match) break;
                    return false;
                }
                case CLASS: {
                    match = false;
                    for (Object className : searchCondition.objects) {
                        if (object.getClass().getSimpleName().equals((String)className)) {
                            match = true;
                            break;
                        }
                        if (match || !object.getClass().getName().equals((String)className)) continue;
                        match = true;
                        break;
                    }
                    if (match) break;
                    return false;
                }
                case EXACT_TEXT: {
                    match = false;
                    String text = (String)MethodInvoker.invokeTheFirstEncounteredMethodFromListOfMethodNames(object, MethodDeclarations.textGettingMethodsInAttemptOrder);
                    if (text == null) {
                        return false;
                    }
                    for (Object textAlternative : searchCondition.objects) {
                        if (!text.equals((String)textAlternative)) continue;
                        match = true;
                        break;
                    }
                    if (match) break;
                    return false;
                }
                case TEXT_CONTAINS: {
                    match = false;
                    String text1 = (String)MethodInvoker.invokeTheFirstEncounteredMethodFromListOfMethodNames(object, MethodDeclarations.textGettingMethodsInAttemptOrder);
                    if (text1 == null) {
                        return false;
                    }
                    for (Object textAlternative : searchCondition.objects) {
                        if (!text1.contains((String)textAlternative)) continue;
                        match = true;
                        break;
                    }
                    if (match) break;
                    return false;
                }
                case TEXT_REGEX_MATCH: {
                    match = false;
                    String elementText = (String)MethodInvoker.invokeTheFirstEncounteredMethodFromListOfMethodNames(object, MethodDeclarations.textGettingMethodsInAttemptOrder);
                    if (elementText == null) {
                        return false;
                    }
                    for (Object textAlternative : searchCondition.objects) {
                        if (!elementText.matches((String)textAlternative)) continue;
                        match = true;
                        break;
                    }
                    if (match) break;
                    return false;
                }
                case BEING_DESCENDANT_OF: {
                    match = false;
                    GenericInteractionMethods java = new GenericInteractionMethods(new TestCase());
                    block15: for (Object potentialParent : searchCondition.objects) {
                        JavaGuiElement javaGuiElement = new JavaGuiElement(potentialParent);
                        for (JavaGuiElement subElement : javaGuiElement.getSubElements()) {
                            if (!this.isMatch(subElement)) continue;
                            match = true;
                            continue block15;
                        }
                    }
                    if (match) break;
                    return false;
                }
                case ORDINAL_NUMBER: {
                    ordinalNumber = (Integer)searchCondition.objects[0];
                }
            }
        }
        if (ordinalNumber != null) {
            match = false;
            JavaWindow window = new JavaWindow((Window)new JavaGuiElement(object).getWindow());
            ArrayList<Component> relevantSubComponents = new ArrayList<Component>();
            for (Component subComponenet : window.getComponents()) {
                if (!this.isMatch(subComponenet)) continue;
                relevantSubComponents.add(subComponenet);
            }
            if (relevantSubComponents.size() > 0 && relevantSubComponents.size() <= ordinalNumber) {
                match = true;
            }
        }
        return match;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[By:").append(System.lineSeparator());
        for (SearchCondition sc : this.searchConditions) {
            sb.append("   ").append(sc.toString()).append(System.lineSeparator());
        }
        sb.append("]");
        return sb.toString();
    }
}

