/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.eyeautomatesupport.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import se.claremont.taf.core.gui.guistyle.AppFont;
import se.claremont.taf.core.gui.guistyle.TafGuiColor;
import se.claremont.taf.core.gui.guistyle.TafHeadline;
import se.claremont.taf.core.gui.guistyle.TafLabel;
import se.claremont.taf.core.gui.guistyle.TafPanel;
import se.claremont.taf.core.gui.plugins.IGuiTab;

public class SmartImageRecognitionSupportTabPanel
implements IGuiTab {
    TafPanel panel = null;
    TafHeadline headline = new TafHeadline("Smart image recognition support");
    TafLabel textParagraph1 = new TafLabel("Smart image recognition utilizes the libraries from EyeAutomate to identify and interact with GUI elements based on their appearance.");
    TafLabel textParagraph2 = new TafLabel("The algorithms compensate for resolution, color depth and normal font deviations.");
    TafLabel textParagraph3 = new TafLabel("Smart image recognition is supported through code, or from EyeAutomate capturemanagers, for now.");

    public SmartImageRecognitionSupportTabPanel() {
        this.panel = new TafPanel("SmartImageRecognitionSupportTabPanel");
        GroupLayout groupLayout = new GroupLayout((Container)this.panel);
        this.panel.setLayout((LayoutManager)groupLayout);
        JTextPane textPane = new JTextPane();
        textPane.setName("AboutTextPane");
        textPane.setContentType("text/html");
        textPane.setForeground(TafGuiColor.textColor);
        textPane.setBackground(TafGuiColor.backgroundColor);
        textPane.setFont(AppFont.getInstance());
        textPane.setEditable(false);
        textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (URISyntaxException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        textPane.setText(this.getBriefText());
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent((Component)this.headline).addComponent((Component)this.textParagraph1).addComponent((Component)this.textParagraph2).addComponent((Component)this.textParagraph3).addComponent(textPane)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent((Component)this.headline).addComponent((Component)this.textParagraph1).addComponent((Component)this.textParagraph2).addComponent((Component)this.textParagraph3).addComponent(textPane));
    }

    private String getBriefText() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<body style=\"color: grey; font-size: " + AppFont.getInstance().getSize() + "; \">");
        sb.append("<p>More info about EyeAutomate tool can be found at the product site for <a href=\"http://eyeautomate.com/");
        sb.append("\" target=\"_blank\">EyeAutomate</a>.</p>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            return new SmartImageRecognitionSupportTabPanel().panel;
        }
        return this.panel;
    }

    public String getName() {
        return "Smart image recognition";
    }
}

