/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.gui.recorder;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import se.claremont.taf.core.gui.Gui;
import se.claremont.taf.core.gui.teststructure.TestStep;
import se.claremont.taf.websupport.gui.recorder.captureinfrastructure.Javascripts;
import se.claremont.taf.websupport.gui.recorder.captureinfrastructure.restserver.HttpServer;
import se.claremont.taf.websupport.gui.recorder.captureinfrastructure.restserver.Settings;
import se.claremont.taf.websupport.gui.recorder.capturemanagers.CaptureInfrastructureManager;
import se.claremont.taf.websupport.gui.recorder.capturemanagers.ClickCaptureManager;
import se.claremont.taf.websupport.gui.recorder.capturemanagers.DomChangeCaptureManager;
import se.claremont.taf.websupport.gui.recorder.capturemanagers.InputCaptureManager;
import se.claremont.taf.websupport.gui.teststeps.WebNavigationTestStep;

public class WebRecorder {
    WebDriver driver;
    HttpServer recorderRESTServer;

    public WebRecorder(WebDriver driver) throws NullWebDriverException {
        if (driver == null) {
            throw new NullWebDriverException();
        }
        this.driver = driver;
    }

    public void start() throws WebDriverIsNotJavaScriptExecutorException {
        if (!(this.driver instanceof JavascriptExecutor)) {
            throw new WebDriverIsNotJavaScriptExecutorException();
        }
        this.recorderRESTServer = new HttpServer();
        this.recorderRESTServer.start();
        try {
            this.driver.get("http://" + HttpServer.getIPAddressesOfLocalMachine() + ":" + Settings.port + "/tafwebrecorder/instructions");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.invokeJavascriptBasedListeners();
        new Thread(new UrlNavigationListener(this.driver)).start();
    }

    public void stop() {
        if (this.recorderRESTServer != null) {
            try {
                this.recorderRESTServer.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.driver != null) {
            this.driver.quit();
        }
    }

    public Object executeJavascript(String script) {
        Object returnObject = null;
        try {
            JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.driver;
            returnObject = javascriptExecutor.executeScript(script, new Object[0]);
            String returnObjectAsString = null;
            if (returnObject != null) {
                try {
                    returnObjectAsString = returnObject.toString();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return returnObject;
    }

    public void invokeJavascriptBasedListeners() {
        this.executeJavascript(new CaptureInfrastructureManager().script + Javascripts.textChangedOrCheckboxClickedElementListener + new DomChangeCaptureManager().script + new InputCaptureManager().script + new ClickCaptureManager().script + Javascripts.addListenersToAllDomElements);
    }

    class UrlNavigationListener
    implements Runnable {
        int checkIntervalInMilliseconds;
        WebDriver driver;
        String lastUrl;

        UrlNavigationListener(WebDriver driver) {
            this.driver = driver;
            this.lastUrl = driver.getCurrentUrl();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    if (!this.driver.getCurrentUrl().equals(this.lastUrl)) {
                        System.out.println("New url detected: '" + this.driver.getCurrentUrl());
                        this.lastUrl = this.driver.getCurrentUrl();
                        Gui.addTestStepToListOfAvailableTestSteps((TestStep)new WebNavigationTestStep(this.lastUrl));
                        WebRecorder.this.invokeJavascriptBasedListeners();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(this.checkIntervalInMilliseconds);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public class WebDriverIsNotJavaScriptExecutorException
    extends Exception {
    }

    public class NullWebDriverException
    extends Exception {
    }
}

