/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.webdrivergluecode;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;
import se.claremont.taf.core.StringComparisonType;
import se.claremont.taf.core.guidriverpluginstructure.GuiElement;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.support.tableverification.CellMatchingType;
import se.claremont.taf.core.support.tableverification.TableData;
import se.claremont.taf.websupport.DomElement;
import se.claremont.taf.websupport.webdrivergluecode.BrowserVerificationMethods;
import se.claremont.taf.websupport.webdrivergluecode.WebInteractionMethods;

public class ElementVerificationMethods
extends BrowserVerificationMethods {
    DomElement domElement;
    WebInteractionMethods web;

    public ElementVerificationMethods(GuiElement domElement, WebInteractionMethods web) {
        super(web);
        this.domElement = (DomElement)domElement;
        this.web = web;
        this.wasSuccess = null;
        this.noFailsInBuilderChain = true;
    }

    ElementVerificationMethods(GuiElement guiElement, WebInteractionMethods web, boolean onlySuccessesSoFar) {
        super(web);
        this.domElement = (DomElement)guiElement;
        this.web = web;
        this.wasSuccess = null;
        if (!onlySuccessesSoFar) {
            this.noFailsInBuilderChain = false;
        }
    }

    public ElementVerificationMethods textEquals(String expectedString) {
        return this.text(expectedString, StringComparisonType.Exact);
    }

    public ElementVerificationMethods textEqualsIgnoreCase(String expectedString) {
        return this.text(expectedString, StringComparisonType.ExactIgnoreCase);
    }

    public ElementVerificationMethods textContains(String expectedString) {
        return this.text(expectedString, StringComparisonType.Contains);
    }

    public ElementVerificationMethods textContainsIgnoreCase(String expectedString) {
        return this.text(expectedString, StringComparisonType.ContainsIgnoreCase);
    }

    public ElementVerificationMethods textMatchesRegex(String pattern) {
        return this.text(pattern, StringComparisonType.Regex);
    }

    private String getText() {
        WebElement element = this.web.getRuntimeElementWithoutLogging(this.domElement);
        if (element == null) {
            return null;
        }
        String text = element.getText();
        if (text == null) {
            text = element.getAttribute("value");
        }
        if (text == null) {
            text = element.getAttribute("data");
        }
        if (text == null) {
            text = element.getAttribute("option");
        }
        if (text == null) {
            text = element.getAttribute("text");
        }
        return text;
    }

    private ElementVerificationMethods text(String expectedPattern, StringComparisonType stringComparisonType) {
        boolean isMatch = stringComparisonType.match(this.getText(), expectedPattern);
        long startTime = System.currentTimeMillis();
        while (!isMatch && System.currentTimeMillis() - startTime < (long)(this.web.getStandardTimeout() * 1000)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            isMatch = stringComparisonType.match(this.getText(), expectedPattern);
        }
        if (isMatch) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Text for element '" + this.domElement.LogIdentification() + "' matched '" + expectedPattern + "'.");
            this.wasSuccess = true;
        } else {
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            if (this.web.exists(this.domElement)) {
                this.testCase.log(LogLevel.VERIFICATION_FAILED, "Text for element '" + this.domElement.LogIdentification() + "' was '" + this.web.getText(this.domElement) + "' which did not match the expected pattern '" + expectedPattern + "'.");
            } else {
                this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Could not match text of element '" + this.domElement.LogIdentification() + "' since it could not be identified.");
            }
            this.web.saveScreenshot(null);
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
        return this;
    }

    public ElementVerificationMethods isEnabled() {
        boolean success = this.enabled();
        long startTime = System.currentTimeMillis();
        while (!success && System.currentTimeMillis() - startTime < (long)(this.web.getStandardTimeout() * 1000)) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            success = this.enabled();
        }
        if (success) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Element '" + this.domElement.LogIdentification() + "' was enabled, as expected.");
            this.wasSuccess = true;
        } else {
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Element '" + this.domElement.LogIdentification() + "' was expected to be enabled but never became enabled within the timeout.");
            this.web.saveScreenshot(this.web.getRuntimeElementWithoutLogging(this.domElement));
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
        }
        return this;
    }

    private boolean enabled() {
        WebElement element = this.web.getRuntimeElementWithLogging(this.domElement);
        return element != null && element.isEnabled();
    }

    public ElementVerificationMethods exists() {
        boolean success = this.web.getRuntimeElementWithoutLogging(this.domElement) != null;
        long startTime = System.currentTimeMillis();
        while (!success && System.currentTimeMillis() - startTime < (long)(this.web.getStandardTimeout() * 1000)) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            success = this.web.getRuntimeElementWithoutLogging(this.domElement) != null;
        }
        if (success) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Element '" + this.domElement.LogIdentification() + "' existed, as expected.");
            this.wasSuccess = true;
        } else {
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Element '" + this.domElement.LogIdentification() + "' did not exist, but was expected to exist.");
            this.web.saveScreenshot(null);
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
        return this;
    }

    public ElementVerificationMethods doesNotExist() {
        boolean success = this.web.getRuntimeElementWithoutLogging(this.domElement) == null;
        long startTime = System.currentTimeMillis();
        while (!success && System.currentTimeMillis() - startTime < (long)(this.web.getStandardTimeout() * 1000)) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            success = this.web.getRuntimeElementWithoutLogging(this.domElement) == null;
        }
        if (success) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Element '" + this.domElement.LogIdentification() + "' did not exist, as expected.");
            this.wasSuccess = true;
        } else {
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Element '" + this.domElement.LogIdentification() + "' existed, but was expected not to.");
            this.web.saveScreenshot(this.web.getRuntimeElementWithoutLogging(this.domElement));
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
        return this;
    }

    public ElementVerificationMethods isDisabled() {
        boolean success = !this.enabled();
        long startTime = System.currentTimeMillis();
        while (!success && System.currentTimeMillis() - startTime < (long)(this.web.getStandardTimeout() * 1000)) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            success = !this.enabled();
        }
        if (success) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Element '" + this.domElement.LogIdentification() + "' was disabled, as expected.");
            this.wasSuccess = true;
        } else {
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Element '" + this.domElement.LogIdentification() + "' was expected to be disabled but never became disabled within the timeout.");
            this.web.saveScreenshot(this.web.getRuntimeElementWithoutLogging(this.domElement));
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
        return this;
    }

    public ElementVerificationMethods isDisplayed() {
        boolean success = this.displayed();
        long startTime = System.currentTimeMillis();
        while (!success && System.currentTimeMillis() - startTime < (long)(this.web.getStandardTimeout() * 1000)) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            success = this.displayed();
        }
        if (success) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Element '" + this.domElement.LogIdentification() + "' was displayed, as expected.");
            this.wasSuccess = true;
        } else {
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Element '" + this.domElement.LogIdentification() + "' was not displayed, but was expected to be.");
            this.web.saveScreenshot(this.web.getRuntimeElementWithoutLogging(this.domElement));
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
        return this;
    }

    public ElementVerificationMethods isNotDisplayed() {
        boolean success = !this.displayed();
        long startTime = System.currentTimeMillis();
        while (!success && System.currentTimeMillis() - startTime < (long)(this.web.getStandardTimeout() * 1000)) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            success = !this.displayed();
        }
        if (success) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Element '" + this.domElement.LogIdentification() + "' was displayed, as expected.");
            this.wasSuccess = true;
        } else {
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Element '" + this.domElement.LogIdentification() + "' was not displayed, but was expected to be.");
            this.web.saveScreenshot(this.web.getRuntimeElementWithoutLogging(this.domElement));
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
        return this;
    }

    private boolean displayed() {
        WebElement element = this.web.getRuntimeElementWithoutLogging(this.domElement);
        if (element == null) {
            return false;
        }
        return element.isDisplayed();
    }

    public ElementVerificationMethods tableRow(String headlineColonValueSemicolonSeparatedString, CellMatchingType cellMatchingType) {
        return this.tableRows(new String[]{headlineColonValueSemicolonSeparatedString}, cellMatchingType);
    }

    public ElementVerificationMethods tableRows(String[] headlineColonValueSemicolonSeparatedString, CellMatchingType cellMatchingType) {
        TableData tableData;
        boolean doneOk = false;
        long startTime = System.currentTimeMillis();
        while (!doneOk && System.currentTimeMillis() - startTime <= (long)(this.web.getStandardTimeout() * 1000)) {
            tableData = this.web.tableDataFromGuiElement(this.domElement, false);
            if (tableData == null) {
                DomElement table = this.domElement;
                this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Table data for " + table.LogIdentification() + " is null.");
                this.web.saveScreenshot(this.web.getRuntimeElementWithoutLogging(table));
                this.web.saveDesktopScreenshot();
                this.web.saveHtmlContentOfCurrentPage();
                this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
                this.wasSuccess = false;
                this.noFailsInBuilderChain = false;
                return this;
            }
            boolean nonErroneous = true;
            for (String searchPattern : headlineColonValueSemicolonSeparatedString) {
                if (tableData.rowExist(searchPattern, cellMatchingType)) continue;
                nonErroneous = false;
            }
            if (!nonErroneous) continue;
            doneOk = true;
        }
        tableData = this.web.tableDataFromGuiElement(this.domElement, true);
        if (tableData == null) {
            return this;
        }
        this.wasSuccess = tableData.verifyRows(headlineColonValueSemicolonSeparatedString, cellMatchingType);
        if (!this.wasSuccess.booleanValue()) {
            this.noFailsInBuilderChain = false;
        }
        return this;
    }

    private String getAttributeValue(String attributeName) {
        WebElement element = this.web.getRuntimeElementWithoutLogging(this.domElement);
        if (element == null) {
            return null;
        }
        return element.getAttribute(attributeName);
    }

    public ElementVerificationMethods attributeValue(String attributeName, String attributeValuePattern, StringComparisonType stringComparisonType) {
        boolean success = stringComparisonType.match(this.getAttributeValue(attributeName), attributeValuePattern);
        long startTime = System.currentTimeMillis();
        while (!success && System.currentTimeMillis() - startTime < (long)(this.web.getStandardTimeout() * 1000)) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            success = stringComparisonType.match(this.getAttributeValue(attributeName), attributeValuePattern);
        }
        if (success) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Value for attribute '" + attributeName + "' for element '" + this.domElement.LogIdentification() + "' was '" + this.getAttributeValue(attributeName) + ", successfully matching '" + attributeValuePattern + "'.");
            this.wasSuccess = true;
        } else {
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            if (this.web.exists(this.domElement)) {
                if (this.getAttributeValue(attributeName) == null) {
                    this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Could not find any value for attribute '" + attributeName + "' for element '" + this.domElement.LogIdentification() + "'.");
                } else {
                    this.testCase.log(LogLevel.VERIFICATION_FAILED, "Value for attribute '" + attributeName + "' was expected to match '" + attributeValuePattern + "', but it was '" + this.getAttributeValue(attributeName) + "' for element '" + this.domElement.LogIdentification() + "'.");
                }
            } else {
                this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Tried to verify attribute value '" + attributeName + "' for element '" + this.domElement.LogIdentification() + "', but the element was never identified.");
            }
            this.web.saveScreenshot(this.web.getRuntimeElementWithoutLogging(this.domElement));
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
        return this;
    }

    public ElementVerificationMethods tableHeadline(String expectedHeadline) {
        ArrayList<String> headlines = new ArrayList<String>();
        headlines.add(expectedHeadline);
        return this.tableHeadlines(headlines);
    }

    public ElementVerificationMethods tableHeadlines(List<String> expectedHeadlines) {
        boolean found = this.web.waitForElementToAppear((GuiElement)this.domElement).wasSuccess;
        if (!found) {
            this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Could not find " + this.domElement.LogIdentification() + " to verify headlines '" + String.join((CharSequence)"', '", expectedHeadlines) + "' in.");
            return this;
        }
        TableData tableData = this.web.tableDataFromGuiElement(this.domElement, false);
        if (tableData == null) {
            this.testCase.log(LogLevel.FRAMEWORK_ERROR, "Could not construct TableData for HTML table " + this.domElement.LogIdentification() + " when trying to verify headlines '" + String.join((CharSequence)"', '", expectedHeadlines) + "'.");
            this.web.saveScreenshot(this.web.getRuntimeElementWithoutLogging(this.domElement));
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            return this;
        }
        if (!tableData.verifyHeadingsExist(expectedHeadlines)) {
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            this.web.saveScreenshot(this.web.getRuntimeElementWithoutLogging(this.domElement));
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
        } else {
            this.wasSuccess = true;
        }
        return this;
    }

    public ElementVerificationMethods isAnimated() {
        boolean animationHasStarted;
        boolean elementHasFinishedRendering;
        long startTime = System.currentTimeMillis();
        this.web.waitForElementToAppear(this.domElement, this.web.getStandardTimeout());
        BufferedImage bufferedImage1 = this.web.grabElementImage(this.domElement);
        BufferedImage bufferedImage2 = this.web.grabElementImage(this.domElement);
        boolean bl = elementHasFinishedRendering = !this.web.bufferedImagesAreEqual(bufferedImage1, bufferedImage2);
        while (!elementHasFinishedRendering && System.currentTimeMillis() - startTime < (long)(this.web.getStandardTimeout() * 1000)) {
            this.web.wait(50);
            bufferedImage2 = this.web.grabElementImage(this.domElement);
            elementHasFinishedRendering = !this.web.bufferedImagesAreEqual(bufferedImage1, bufferedImage2);
        }
        this.web.wait(50);
        bufferedImage1 = this.web.grabElementImage(this.domElement);
        boolean bl2 = animationHasStarted = !this.web.bufferedImagesAreEqual(bufferedImage1, bufferedImage2);
        while (!animationHasStarted && System.currentTimeMillis() - startTime < (long)(this.web.getStandardTimeout() * 1000)) {
            this.web.wait(50);
            bufferedImage1 = this.web.grabElementImage(this.domElement);
            animationHasStarted = !this.web.bufferedImagesAreEqual(bufferedImage1, bufferedImage2);
        }
        if (animationHasStarted) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Element " + this.domElement.LogIdentification() + " is detected to be animated.");
            this.wasSuccess = true;
        } else {
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Element " + this.domElement.LogIdentification() + " could not be detected to be animated within the timeout of " + this.web.getStandardTimeout() + " seconds.");
            this.web.saveScreenshot(this.web.getRuntimeElementWithoutLogging(this.domElement));
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
        }
        return this;
    }
}

