/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.webdrivergluecode;

import io.github.bonigarcia.wdm.ChromeDriverManager;
import io.github.bonigarcia.wdm.EdgeDriverManager;
import io.github.bonigarcia.wdm.InternetExplorerDriverManager;
import io.github.bonigarcia.wdm.OperaDriverManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.opera.OperaDriver;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.support.SupportMethods;
import se.claremont.taf.core.support.Utils;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.core.testrun.Settings;
import se.claremont.taf.core.testrun.TestRun;
import se.claremont.taf.filetestingsupport.FileTester;

public class WebDriverManager {
    private TestCase testCase;

    public WebDriverManager(TestCase testCase) {
        this.testCase = testCase;
    }

    public WebDriver initializeWebDriver(WebBrowserType webBrowserType) {
        this.testCase.log(LogLevel.DEBUG, "Attempting to initializeIfNotInitialized WebDriver for web browser type '" + webBrowserType.toString() + "'.");
        WebDriver driver = null;
        if (this.testCase == null) {
            this.testCase = new TestCase(null, "dummy");
        }
        switch (webBrowserType) {
            case CHROME: {
                driver = new ChromeBrowser(this.testCase).setup();
                break;
            }
            case INTERNET_EXPLORER: {
                driver = new InternetExplorerBrowser(this.testCase).setup();
                break;
            }
            case OPERA: {
                driver = new OperaBrowser(this.testCase).setup();
                break;
            }
            case EDGE: {
                driver = new EdgeBrowser(this.testCase).setup();
                break;
            }
            case FIREFOX: {
                driver = new FirefoxBrowser(this.testCase).setup();
                break;
            }
            case REMOTE_CHROME: {
                this.testCase.log(LogLevel.INFO, "Initializing remote Chrome driver - not yet implemented.");
                break;
            }
            case PHANTOMJS: {
                driver = new PhantomJsBrowser(this.testCase).setup();
                break;
            }
            default: {
                this.testCase.log(LogLevel.INFO, "Initializing Firefox driver (default driver) '" + System.getProperty("webdriver.firefox.bin") + "'.");
                driver = new FirefoxDriver();
            }
        }
        if (driver == null) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not initializeIfNotInitialized driver for browser '" + webBrowserType.toString() + "'.");
            this.logIdentifiedLocalBrowsersFromFileScan();
        } else {
            this.testCase.log(LogLevel.INFO, "Driver for browser '" + webBrowserType.toString() + "' achieved.");
        }
        return driver;
    }

    private void logIdentifiedLocalBrowsersFromFileScan() {
        ArrayList<String> fileNamesToFind = new ArrayList<String>();
        fileNamesToFind.add("firefox.exe");
        fileNamesToFind.add("iexplore.exe");
        fileNamesToFind.add("chrome.exe");
        fileNamesToFind.add("phantomjs.exe");
        this.testCase.log(LogLevel.EXECUTED, "Scanning machine hard drive for browsers named '" + String.join((CharSequence)"', '", fileNamesToFind) + "'.");
        List<File> browsers = WebDriverManager.scanComputerForBrowsersAndRegisterTheirLocations(fileNamesToFind);
        ArrayList<String> browserPaths = new ArrayList<String>();
        for (File browser : browsers) {
            browserPaths.add(browser.getAbsolutePath());
        }
        this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.INFO, "Identified local browsers on execution machine:" + SupportMethods.LF + "'" + String.join((CharSequence)("'" + SupportMethods.LF + "'"), browserPaths) + "'", "Identified local browsers on execution machine:<br>" + SupportMethods.LF + "'" + String.join((CharSequence)("'<br>" + SupportMethods.LF + "'"), browserPaths) + "'<br>");
    }

    private static List<File> scanComputerForBrowsersAndRegisterTheirLocations(List<String> fileNames) {
        List matchingFiles = null;
        if (Utils.getInstance().amIWindowsOS()) {
            matchingFiles = FileTester.searchForSpecificFiles((File)new File("C:\\"), fileNames);
        } else if (Utils.getInstance().amIMacOS() || Utils.getInstance().amILinuxOS()) {
            matchingFiles = FileTester.searchForSpecificFiles((File)new File("/"), fileNames);
        }
        return matchingFiles;
    }

    class PhantomJsBrowser
    extends Browser {
        PhantomJsBrowser(TestCase testCase) {
            super(testCase);
        }
    }

    class OperaBrowser
    extends Browser {
        OperaBrowser(TestCase testCase) {
            super(testCase);
        }

        @Override
        public WebDriver setup() {
            OperaDriver driver = null;
            this.testCase.log(LogLevel.DEBUG, "Attempting to get hold of drivers for Internet Explorer.");
            try {
                long startTime = System.currentTimeMillis();
                OperaDriverManager.getInstance(OperaDriver.class).setup();
                driver = new OperaDriver();
                this.testCase.log(LogLevel.EXECUTED, "Creating an Opera session took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
            }
            catch (Exception e) {
                this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not start Opera driver. Error message: " + e.getMessage());
            }
            return driver;
        }
    }

    class EdgeBrowser
    extends Browser {
        EdgeBrowser(TestCase testCase) {
            super(testCase);
        }

        @Override
        public WebDriver setup() {
            EdgeDriver driver = null;
            this.testCase.log(LogLevel.DEBUG, "Attempting to get hold of drivers for the Edge browser.");
            try {
                long startTime = System.currentTimeMillis();
                EdgeDriverManager.getInstance(EdgeDriver.class).setup();
                driver = new EdgeDriver();
                this.testCase.log(LogLevel.EXECUTED, "Creating an Edge browser session took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
            }
            catch (Exception e) {
                this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not start Edge browser driver. Error message: " + e.getMessage());
            }
            return driver;
        }
    }

    class InternetExplorerBrowser
    extends Browser {
        InternetExplorerBrowser(TestCase testCase) {
            super(testCase);
        }

        @Override
        public WebDriver setup() {
            InternetExplorerDriver driver = null;
            this.testCase.log(LogLevel.DEBUG, "Attempting to get hold of drivers for Internet Explorer.");
            try {
                long startTime = System.currentTimeMillis();
                InternetExplorerDriverManager.getInstance(InternetExplorerDriver.class).setup();
                driver = new InternetExplorerDriver();
                this.testCase.log(LogLevel.EXECUTED, "Creating an Internet Explorer session took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
            }
            catch (Exception e) {
                this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not start Internet Explorer driver. Error message: " + e.getMessage());
            }
            return driver;
        }
    }

    class FirefoxBrowser
    extends Browser {
        FirefoxBrowser(TestCase testCase) {
            super(testCase);
        }

        @Override
        public WebDriver setup() {
            FirefoxDriver driver = null;
            this.testCase.log(LogLevel.INFO, "Initializing Firefox driver '" + System.getProperty("webdriver.firefox.bin") + "'.");
            try {
                driver = new FirefoxDriver();
            }
            catch (Exception e) {
                this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not initializeIfNotInitialized Firefox driver. Expected to find Firefox driver at '" + TestRun.getSettingsValue((Settings.SettingParameters)Settings.SettingParameters.FIREFOX_PATH_TO_BROWSER_EXE) + "' as stated by the 'firefoxPathToBrowserExe' parameter in settings.");
                WebDriverManager.this.logIdentifiedLocalBrowsersFromFileScan();
            }
            return driver;
        }
    }

    class ChromeBrowser
    extends Browser {
        ChromeBrowser(TestCase testCase) {
            super(testCase);
        }

        @Override
        public WebDriver setup() {
            ChromeDriver driver = null;
            this.testCase.log(LogLevel.DEBUG, "Attempting to initializeIfNotInitialized Chrome driver.");
            try {
                long startTime = System.currentTimeMillis();
                ChromeDriverManager.getInstance(ChromeDriver.class).setup();
                driver = new ChromeDriver();
                this.testCase.log(LogLevel.EXECUTED, "Creating a Chrome session took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
            }
            catch (Exception e) {
                this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not initializeIfNotInitialized Chrome driver. Error message: " + e.getMessage());
            }
            return driver;
        }
    }

    abstract class Browser {
        final TestCase testCase;

        Browser(TestCase testCase) {
            this.testCase = testCase;
        }

        public WebDriver setup() {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Browser is an abstract class and the setup of this is not intended.");
            return null;
        }
    }

    public static enum WebBrowserType {
        CHROME,
        FIREFOX,
        INTERNET_EXPLORER,
        REMOTE_CHROME,
        REMOTE_FIREFOX,
        PHANTOMJS,
        MARIONETTE,
        EDGE,
        OPERA,
        NONE,
        REMOTE_INTERNET_EXPLORER;

    }
}

