/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.webdrivergluecode;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.openqa.selenium.logging.LogEntry;
import se.claremont.taf.core.StringComparisonType;
import se.claremont.taf.core.VerificationMethods;
import se.claremont.taf.core.guidriverpluginstructure.GuiElement;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.websupport.W3CHtmlValidatorService;
import se.claremont.taf.websupport.brokenlinkcheck.BrokenLinkReporter;
import se.claremont.taf.websupport.webdrivergluecode.ElementVerificationMethods;
import se.claremont.taf.websupport.webdrivergluecode.WebInteractionMethods;

public class BrowserVerificationMethods
extends VerificationMethods {
    private WebInteractionMethods web;

    public BrowserVerificationMethods(WebInteractionMethods web) {
        super(web.getTestCase());
        this.web = web;
    }

    public BrowserVerificationMethods noBrokenLinksOnCurrentPage() {
        BrokenLinkReporter brokenLinkReporter = new BrokenLinkReporter(this.testCase, this.web.driver);
        this.wasSuccess = brokenLinkReporter.reportBrokenLinks(true);
        if (!this.wasSuccess.booleanValue()) {
            this.noFailsInBuilderChain = false;
        }
        return this;
    }

    public BrowserVerificationMethods noBrokenLinksOnCurrentPage_IncludeNonDisplayedLinks() {
        BrokenLinkReporter brokenLinkReporter = new BrokenLinkReporter(this.testCase, this.web.driver);
        this.wasSuccess = brokenLinkReporter.reportBrokenLinks(false);
        if (!this.wasSuccess.booleanValue()) {
            this.noFailsInBuilderChain = false;
        }
        return this;
    }

    public ElementVerificationMethods verifyElement(GuiElement guiElement) {
        return new ElementVerificationMethods(guiElement, this.web, this.noFailsInBuilderChain);
    }

    public BrowserVerificationMethods title(String expectedTitlePattern, StringComparisonType stringComparisonType) {
        boolean isMatch = stringComparisonType.match(this.web.driver.getTitle(), expectedTitlePattern);
        long timer = System.currentTimeMillis();
        while (!isMatch && System.currentTimeMillis() - timer < (long)(this.web.getStandardTimeout() * 1000)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            isMatch = stringComparisonType.match(this.web.driver.getTitle(), expectedTitlePattern);
        }
        if (isMatch) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Current title matched '" + expectedTitlePattern + "' as expected.");
            this.wasSuccess = true;
        } else {
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Expected title to match '" + expectedTitlePattern + "', but it was '" + this.web.driver.getTitle() + "'.");
            this.web.saveScreenshot(null);
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
        return this;
    }

    public BrowserVerificationMethods textOnPage(String pattern, StringComparisonType stringComparisonType) {
        boolean success = stringComparisonType.match(this.web.driver.getPageSource(), pattern);
        long startTime = System.currentTimeMillis();
        while (!success && System.currentTimeMillis() - startTime < (long)(this.web.getStandardTimeout() * 1000)) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            success = stringComparisonType.match(this.web.driver.getPageSource(), pattern);
        }
        if (success) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Pattern '" + pattern + "' successfully matched in page source.");
            this.wasSuccess = true;
        } else {
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Could not match pattern '" + pattern + "' in page source.");
            this.web.saveScreenshot(null);
            this.web.saveDesktopScreenshot();
            this.web.saveHtmlContentOfCurrentPage();
            this.web.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
        return this;
    }

    public BrowserVerificationMethods currentPageSourceWithW3validator(boolean verbose) {
        if (this.web.driver == null) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.web.haltFurtherExecution();
        }
        W3CHtmlValidatorService w3CHtmlValidatorService = new W3CHtmlValidatorService(this.testCase, this.web.driver.getPageSource(), verbose);
        w3CHtmlValidatorService.verifyPageSourceWithW3validator();
        if (w3CHtmlValidatorService.failed()) {
            this.web.saveHtmlContentOfCurrentPage();
            this.noFailsInBuilderChain = false;
            this.wasSuccess = false;
        } else {
            this.wasSuccess = true;
        }
        return this;
    }

    public void browserConsoleHasNoErrors_AlsoClearsBrowserConsole() {
        List<LogEntry> logEntries = this.web.getLogEntriesFromBrowser(Level.SEVERE);
        ArrayList<String> logEntriesAsStrings = new ArrayList<String>();
        for (LogEntry logEntry : logEntries) {
            logEntriesAsStrings.add(logEntry.toString());
        }
        if (logEntries.size() > 0) {
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Browser has the following log posts of at least log level 'severe' in console:" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), logEntriesAsStrings));
            this.wasSuccess = false;
            this.noFailsInBuilderChain = false;
        } else {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Browser had no severe log posts in console.");
            this.wasSuccess = true;
        }
    }
}

