/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.webdrivergluecode;

import java.awt.AWTException;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.support.ui.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.claremont.taf.core.guidriverpluginstructure.GuiElement;
import se.claremont.taf.core.logging.LogFolder;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.support.StringManagement;
import se.claremont.taf.core.support.SupportMethods;
import se.claremont.taf.core.support.tableverification.CellMatchingType;
import se.claremont.taf.core.support.tableverification.TableData;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.core.testrun.TestRun;
import se.claremont.taf.javasupport.interaction.GenericInteractionMethods;
import se.claremont.taf.javasupport.interaction.MethodInvoker;
import se.claremont.taf.websupport.ActionResult;
import se.claremont.taf.websupport.DomElement;
import se.claremont.taf.websupport.W3CHtmlValidatorService;
import se.claremont.taf.websupport.brokenlinkcheck.BrokenLinkReporter;
import se.claremont.taf.websupport.brokenlinkcheck.LinkCheck;
import se.claremont.taf.websupport.elementidentification.WebElementIdentifier;
import se.claremont.taf.websupport.webdrivergluecode.BrowserVerificationMethods;
import se.claremont.taf.websupport.webdrivergluecode.ElementVerificationMethods;
import se.claremont.taf.websupport.webdrivergluecode.WebDriverManager;
import se.claremont.taf.websupport.webdrivergluecode.WebPageCodeConstructor;
import se.claremont.taf.websupport.webdrivergluecode.WebPageCodeConstructorWithBy;

public class WebInteractionMethods {
    private static final Logger logger = LoggerFactory.getLogger(WebInteractionMethods.class);
    public WebDriver driver;
    private final TestCase testCase;
    private int standardTimeoutInSeconds = 30;

    public int getStandardTimeout() {
        return this.standardTimeoutInSeconds;
    }

    public WebInteractionMethods(TestCase testCase) {
        WebDriverManager.WebBrowserType webBrowser = WebDriverManager.WebBrowserType.CHROME;
        this.testCase = testCase;
        try {
            WebDriverManager webDriverManager = new WebDriverManager(testCase);
            this.driver = webDriverManager.initializeWebDriver(webBrowser);
            this.driver.manage().window().maximize();
            if (this.driver.getWindowHandles() == null || this.driver.getWindowHandles().size() == 0) {
                this.log(LogLevel.EXECUTION_PROBLEM, "Could not initializeIfNotInitialized driver.");
                this.saveScreenshot(null);
                this.saveDesktopScreenshot();
                this.writeRunningProcessListDeviationsSinceTestCaseStart();
                this.haltFurtherExecution();
            }
        }
        catch (Exception e) {
            this.log(LogLevel.FRAMEWORK_ERROR, "Could not initializeIfNotInitialized driver. Error: " + e.getMessage());
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            this.haltFurtherExecution();
        }
    }

    public WebInteractionMethods(TestCase testCase, WebDriverManager.WebBrowserType browserType) {
        this.testCase = testCase;
        if (browserType == WebDriverManager.WebBrowserType.NONE) {
            this.driver = null;
            return;
        }
        try {
            WebDriverManager webDriverManager = new WebDriverManager(testCase);
            this.driver = webDriverManager.initializeWebDriver(browserType);
            this.driver.manage().window().maximize();
            if (this.driver.getWindowHandles() == null || this.driver.getWindowHandles().size() == 0) {
                this.log(LogLevel.EXECUTION_PROBLEM, "Could not initializeIfNotInitialized driver.");
                this.saveScreenshot(null);
                this.saveDesktopScreenshot();
                this.writeRunningProcessListDeviationsSinceTestCaseStart();
                this.haltFurtherExecution();
            }
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not initialize if not driver is initialized. Error: " + e.toString());
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            this.haltFurtherExecution();
        }
    }

    public WebInteractionMethods(TestCase testCase, WebDriver driver) {
        this.testCase = testCase;
        try {
            this.driver = driver;
            driver.manage().window().maximize();
            if (driver.getWindowHandles() == null || driver.getWindowHandles().size() == 0) {
                this.log(LogLevel.FRAMEWORK_ERROR, "Could not initializeIfNotInitialized driver.");
                this.saveScreenshot(null);
                this.saveDesktopScreenshot();
                this.writeRunningProcessListDeviationsSinceTestCaseStart();
                this.haltFurtherExecution();
            }
        }
        catch (Exception e) {
            this.log(LogLevel.FRAMEWORK_ERROR, "Could not initializeIfNotInitialized driver. Error: " + e.getMessage());
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            this.haltFurtherExecution();
        }
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public synchronized void wait(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
            this.log(LogLevel.DEBUG, "Waiting for " + milliseconds + " milliseconds.");
        }
        catch (InterruptedException e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not wait the expected " + milliseconds + " milliseconds.");
        }
    }

    public ActionResult goBack() {
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        try {
            this.driver.navigate().back();
            this.log(LogLevel.EXECUTED, "Navigating back in browser.");
            return new ActionResult(true, null, this);
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not navigate back in browser." + e.toString());
            return new ActionResult(false, null, this);
        }
    }

    public BrowserVerificationMethods verify() {
        return new BrowserVerificationMethods(this);
    }

    public void log(LogLevel logLevel, String message) {
        this.testCase.log(logLevel, message);
    }

    public ActionResult navigate(String url) {
        try {
            this.goToUrl(url);
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTED, "Navigation performed to url '" + url + "'.", "Navigation performed to url '<a href=\"" + url + "\" target=\"_blank\">" + url + "</a>'.");
            return new ActionResult(true, null, this);
        }
        catch (NavigationError e) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTION_PROBLEM, "Could not navigate to url '" + url + "'.", "Could not navigate to url '<a href=\"" + url + "\" target=\"_blank\">" + url + "</a>'.");
            return new ActionResult(false, null, this);
        }
    }

    public ActionResult mapCurrentPageWithBy(String outputFilePath, boolean quickAndSloppyMode) {
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        WebPageCodeConstructorWithBy constructor = new WebPageCodeConstructorWithBy(this);
        constructor.createPageObjectFromCurrentPage(outputFilePath, quickAndSloppyMode);
        return new ActionResult(true, null, this);
    }

    public ActionResult mapCurrentPage(String outputFilePath) {
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        Date startTime = new Date();
        this.log(LogLevel.DEBUG, "Starting mapping elements of the current page (" + this.driver.getCurrentUrl() + ").");
        WebPageCodeConstructor.ConstructWebPageCode(this.driver, outputFilePath);
        this.log(LogLevel.EXECUTED, "Mapped the element of the current page ('" + this.driver.getCurrentUrl() + "') and saved it to the file '" + outputFilePath + "'. Mapping took " + StringManagement.timeDurationAsString((Date)startTime, (Date)new Date()) + ".");
        return new ActionResult(true, null, this);
    }

    @Deprecated
    public ActionResult mapCurrentPageThorough(String outputFilePath) {
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        Date startTime = new Date();
        this.log(LogLevel.DEBUG, "Starting mapping elements of the current page (" + this.driver.getCurrentUrl() + ").");
        WebPageCodeConstructor.ConstructWebPageCodeThorough(this.driver, outputFilePath);
        this.log(LogLevel.EXECUTED, "Mapped the element of the current page ('" + this.driver.getCurrentUrl() + "') and saved it to the file '" + outputFilePath + "'. Mapping took " + StringManagement.timeDurationAsString((Date)startTime, (Date)new Date()) + ".");
        return new ActionResult(true, null, this);
    }

    public ActionResult reportBrokenLinksOnCurrentPage() {
        BrokenLinkReporter brokenLinkReporter = new BrokenLinkReporter(this.testCase, this.driver);
        brokenLinkReporter.reportBrokenLinks(true);
        return new ActionResult(true, null, this);
    }

    public ActionResult reportBrokenLinksOnCurrentPage_IncludeAllLinksAlsoNonDisplayedLinks() {
        BrokenLinkReporter brokenLinkReporter = new BrokenLinkReporter(this.testCase, this.driver);
        brokenLinkReporter.reportBrokenLinks(false);
        return new ActionResult(true, null, this);
    }

    public ActionResult waitForElementToAppear(GuiElement guiElement) {
        return new ActionResult(this.waitForElementToAppear((GuiElement)guiElement, (int)this.standardTimeoutInSeconds).wasSuccess, guiElement, this);
    }

    public ActionResult waitForElementToAppear(GuiElement guiElement, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        DomElement domElement = (DomElement)guiElement;
        boolean elementHasAppeared = false;
        while (!elementHasAppeared && System.currentTimeMillis() - startTime <= (long)(timeoutInSeconds * 1000)) {
            WebElement element = this.getRuntimeElementWithoutLogging(domElement);
            if (element != null && element.isDisplayed()) {
                elementHasAppeared = true;
                continue;
            }
            this.wait(50);
        }
        this.log(LogLevel.DEBUG, "Waited " + (System.currentTimeMillis() - startTime) + " for element " + domElement.LogIdentification() + " to appear. It " + Boolean.toString(elementHasAppeared).toLowerCase().replace("true", "did.").replace("false", "never did."));
        return new ActionResult(elementHasAppeared, guiElement, this);
    }

    public WebElement waitForElementToBeEnabled(GuiElement guiElement, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        DomElement domElement = (DomElement)guiElement;
        WebElement element = null;
        boolean elementIsEnabled = false;
        while (System.currentTimeMillis() - startTime <= (long)(timeoutInSeconds * 1000)) {
            element = this.getRuntimeElementWithoutLogging(domElement);
            try {
                if (element != null && element.isEnabled()) {
                    elementIsEnabled = true;
                    if (element.isDisplayed()) {
                        this.log(LogLevel.DEBUG, "Waited " + (System.currentTimeMillis() - startTime) + " milliseconds for element " + domElement.LogIdentification() + " to become displayed and enabled.");
                    } else {
                        this.log(LogLevel.DEBUG, "Waited " + (System.currentTimeMillis() - startTime) + " milliseconds for element " + domElement.LogIdentification() + " to become enabled. Element is not visible.");
                    }
                    return element;
                }
                this.wait(50);
            }
            catch (Exception exception) {}
        }
        if (element == null) {
            this.log(LogLevel.DEBUG, "Could not identify element " + domElement.LogIdentification() + ". Tried for " + (System.currentTimeMillis() - startTime) + " milliseconds.");
        } else {
            this.log(LogLevel.DEBUG, "Waited " + (System.currentTimeMillis() - startTime) + " milliseconds for element " + domElement.LogIdentification() + " to become displayed and enabled. It " + Boolean.toString(elementIsEnabled).toLowerCase().replace("true", "did").replace("false", "never did") + " become enabled.");
        }
        return null;
    }

    public ActionResult waitForElementToDisappear(GuiElement guiElement) {
        return new ActionResult(this.waitForElementToDisappear((GuiElement)guiElement, (int)this.standardTimeoutInSeconds).wasSuccess, guiElement, this);
    }

    public ActionResult waitForElementToDisappear(GuiElement guiElement, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        DomElement domElement = (DomElement)guiElement;
        boolean elementIsDisplayed = true;
        while (elementIsDisplayed && System.currentTimeMillis() - startTime <= (long)(timeoutInSeconds * 1000)) {
            WebElement element = this.getRuntimeElementWithoutLogging(domElement);
            try {
                if (element == null || !element.isDisplayed()) {
                    elementIsDisplayed = false;
                    continue;
                }
                this.wait(50);
            }
            catch (Exception ignored) {
                elementIsDisplayed = false;
            }
        }
        this.log(LogLevel.DEBUG, "Waited " + (System.currentTimeMillis() - startTime) + " for element " + domElement.LogIdentification() + " to disappear. It " + Boolean.toString(elementIsDisplayed).toLowerCase().replace("true", "never did.").replace("false", "did."));
        return new ActionResult(!this.waitForElementToDisappear((GuiElement)guiElement, (int)this.standardTimeoutInSeconds).wasSuccess, guiElement, this);
    }

    public ActionResult reportBrokenLinksRecursive() {
        String currentDomain = this.currentDomain();
        List links = this.driver.findElements(By.xpath((String)"//a"));
        ArrayList<Thread> linkCheckingThreads = new ArrayList<Thread>();
        for (WebElement link : links) {
            String href = link.getAttribute("href");
            if (!SupportMethods.isRegexMatch((String)href, (String)("http.*" + currentDomain + ".*")) && !SupportMethods.isRegexMatch((String)href, (String)"./.*")) continue;
            Thread linkCheck = new Thread(new LinkCheck(this.testCase, link.getAttribute("href")));
            linkCheckingThreads.add(linkCheck);
            linkCheck.start();
        }
        for (int i = 0; i < linkCheckingThreads.size(); ++i) {
            try {
                ((Thread)linkCheckingThreads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                this.log(LogLevel.FRAMEWORK_ERROR, e.getMessage());
            }
        }
        return new ActionResult(true, null, this);
    }

    private String currentDomain() {
        String domain = this.driver.getCurrentUrl();
        int startPosition = domain.indexOf("://") + 3;
        if ((domain = domain.substring(startPosition)).contains("/")) {
            domain = domain.substring(0, domain.indexOf("/"));
        }
        return domain;
    }

    public String getText(GuiElement guiElement) {
        long startTime = System.currentTimeMillis();
        DomElement domElement = (DomElement)guiElement;
        String text = null;
        WebElement element = null;
        boolean elementIdentified = false;
        while (text == null && System.currentTimeMillis() - startTime <= (long)(this.standardTimeoutInSeconds * 1000)) {
            element = this.getRuntimeElementWithoutLogging(domElement);
            if (element != null) {
                elementIdentified = true;
                try {
                    text = element.getText();
                    if (text == null || text.length() == 0) {
                        text = element.getAttribute("value");
                    }
                }
                catch (Exception ignored) {
                    text = (String)MethodInvoker.invokeTheFirstEncounteredMethod((TestCase)this.testCase, (Object)element, (String[])new String[]{"getValue()", "getOptions()", "value()", "option()", "text()", "getLabel()", "label()"});
                }
            }
            this.wait(50);
        }
        if (text == null && !elementIdentified) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not retrieve text from element " + domElement.LogIdentification() + " since it could not be identified at runtime.");
            this.saveScreenshot(element);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        } else if (text == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "The element " + domElement.LogIdentification() + " could be identified, but the text of the element could not be read.");
            this.saveScreenshot(element);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        } else {
            this.log(LogLevel.DEBUG, "Identified the text '" + text + "' from element " + domElement.LogIdentification() + ".");
        }
        return text;
    }

    public String getTextWithoutLogging(GuiElement guiElement) {
        long startTime = System.currentTimeMillis();
        DomElement domElement = (DomElement)guiElement;
        String text = null;
        while (text == null && System.currentTimeMillis() - startTime <= (long)(this.standardTimeoutInSeconds * 1000)) {
            WebElement element = this.getRuntimeElementWithoutLogging(domElement);
            if (element != null) {
                try {
                    text = element.getText();
                }
                catch (Exception exception) {}
                continue;
            }
            this.wait(50);
        }
        return text;
    }

    public boolean exists(GuiElement element) {
        DomElement domElement = (DomElement)element;
        return this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds) != null;
    }

    public ActionResult acceptAlert() {
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        try {
            Alert alert = this.driver.switchTo().alert();
            alert.accept();
            this.log(LogLevel.EXECUTED, "Accepted alert dialogue.");
            return new ActionResult(true, null, this);
        }
        catch (Exception ignored) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not accept alert dialogue.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return new ActionResult(false, null, this);
        }
    }

    public ActionResult setBrowserWindowSize(int width, int height) {
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        this.log(LogLevel.DEBUG, "Re-sizing the browser window from (width/height) " + this.driver.manage().window().getSize().width + "/" + this.driver.manage().window().getSize().height + " pixels to " + width + "/" + height + " pixels.");
        try {
            this.driver.manage().window().setSize(new Dimension(width, height));
            this.log(LogLevel.EXECUTED, "Re-sized browser window to width " + width + " pixels and height " + height + " pixels.");
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not re-size browser window to height " + height + " and width " + width + " pixels");
            return new ActionResult(false, null, this);
        }
        return new ActionResult(true, null, this);
    }

    public boolean verifyPDFContent(String strURL, String reqTextInPDF) {
        Object pdfStripper = null;
        PDDocument pdDoc = null;
        Object cosDoc = null;
        String parsedText = null;
        try {
            String script = "window.file_contents = null; var xhr = new XMLHttpRequest(); xhr.responseType = 'blob'; xhr.onload = function() {    var reader = new FileReader();    reader.onloadend = function() {       window.file_contents = reader.result;   };   reader.readAsDataURL(xhr.response);};xhr.open('GET', '" + strURL + "');xhr.send();";
            this.executeJavascript(script);
            String theFile = null;
            long startTime = System.currentTimeMillis();
            while (theFile == null && System.currentTimeMillis() - startTime < 10000L) {
                theFile = (String)this.executeJavascript("return (window.file_contents !== null ? window.file_contents.split(',')[1] : null);");
            }
            pdDoc = PDDocument.load((byte[])Base64.getDecoder().decode(theFile));
            String pdfText = new PDFTextStripper().getText(pdDoc);
            pdDoc.close();
            if (!reqTextInPDF.contains(pdfText.replaceAll(" ", ""))) {
                this.log(LogLevel.VERIFICATION_FAILED, "The total salary value is not present in the pdf document expected total Salary = " + reqTextInPDF);
            } else {
                this.log(LogLevel.VERIFICATION_PASSED, "Total salary in pdf document is correct");
            }
        }
        catch (IOException e) {
            System.err.println("Unable to open PDF Parser. " + e.getMessage());
            try {
                if (cosDoc != null) {
                    cosDoc.close();
                }
                if (pdDoc != null) {
                    pdDoc.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return SupportMethods.isRegexMatch(parsedText, (String)reqTextInPDF);
    }

    @Deprecated
    public ActionResult verifyElementAttribute(GuiElement linkElement, String attributeName, String expectedAttributeValue) {
        DomElement domElement = (DomElement)linkElement;
        try {
            WebElement element = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds);
            if (element.getAttribute("href").equals(expectedAttributeValue)) {
                this.log(LogLevel.VERIFICATION_PASSED, "Element " + domElement.LogIdentification() + " was found to have the expected attribute value of '" + expectedAttributeValue + "' for attribute '" + attributeName + "'.");
                return new ActionResult(true, linkElement, this);
            }
            this.log(LogLevel.VERIFICATION_FAILED, "Element " + domElement.LogIdentification() + " was expected to have the value '" + expectedAttributeValue + "' for attribute '" + attributeName + "' but actually had the value of '" + element.getAttribute(attributeName) + "'.");
            return new ActionResult(false, linkElement, this);
        }
        catch (Exception e) {
            this.log(LogLevel.VERIFICATION_PROBLEM, "Could not check the attribute '" + attributeName + "' of element " + domElement.LogIdentification() + " (was expected to have the value '" + expectedAttributeValue + "'." + SupportMethods.LF + e.toString());
            return new ActionResult(false, linkElement, this);
        }
    }

    @Deprecated
    public ActionResult verifyElementAttributeRegex(GuiElement linkElement, String attributeName, String expectedAttributevalueAsRegex) {
        DomElement domElement = (DomElement)linkElement;
        try {
            WebElement element = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds);
            if (SupportMethods.isRegexMatch((String)element.getAttribute("href"), (String)expectedAttributevalueAsRegex)) {
                this.log(LogLevel.VERIFICATION_PASSED, "Element " + domElement.LogIdentification() + " was found to have the expected attribute value of '" + expectedAttributevalueAsRegex + "' for attribute '" + attributeName + "'.");
                return new ActionResult(true, linkElement, this);
            }
            this.log(LogLevel.VERIFICATION_FAILED, "Element " + domElement.LogIdentification() + " was expected to have the value '" + expectedAttributevalueAsRegex + "' for attribute '" + attributeName + "' but actually had the value of '" + element.getAttribute(attributeName) + "'.");
            return new ActionResult(false, linkElement, this);
        }
        catch (Exception e) {
            this.log(LogLevel.VERIFICATION_PROBLEM, "Could not check the attribute '" + attributeName + "' of element " + domElement.LogIdentification() + " (was expected to have the value '" + expectedAttributevalueAsRegex + "'." + SupportMethods.LF + e.toString());
            return new ActionResult(false, linkElement, this);
        }
    }

    public ActionResult writeRunningProcessListDeviationsSinceTestCaseStart() {
        this.testCase.writeProcessListDeviationsFromSystemStartToLog();
        return new ActionResult(true, null, this);
    }

    public ActionResult write(GuiElement guiElement, String textToWrite) {
        DomElement domElement = (DomElement)guiElement;
        long startTime = System.currentTimeMillis();
        WebElement element = null;
        boolean success = false;
        while (!success && System.currentTimeMillis() - startTime < (long)(this.standardTimeoutInSeconds * 1000)) {
            element = this.getRuntimeElementWithoutLogging(domElement);
            if (element == null) {
                this.wait(50);
                continue;
            }
            try {
                this.enterText(element, textToWrite, false);
                success = true;
            }
            catch (Exception exception) {}
        }
        if (success) {
            this.log(LogLevel.EXECUTED, "Wrote '" + textToWrite + "' to " + domElement.LogIdentification() + ".");
            return new ActionResult(true, guiElement, this);
        }
        String text = null;
        String errorMessage = null;
        boolean exist = false;
        try {
            element = this.getRuntimeElementWithoutLogging(domElement);
            if (element != null) {
                exist = true;
                text = element.getText();
            }
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        this.log(LogLevel.EXECUTION_PROBLEM, "Could not enter the text '" + textToWrite + "' to element " + domElement.LogIdentification() + ". Element " + Boolean.toString(exist).toLowerCase().replace("false", "could not be identified").replace("true", "was identified") + ".");
        if (text != null) {
            this.log(LogLevel.DEVIATION_EXTRA_INFO, "Current text of " + domElement.LogIdentification() + " = '" + text + "'.");
        } else if (exist) {
            this.log(LogLevel.DEVIATION_EXTRA_INFO, "Could not retrieve the current text of the element " + domElement.LogIdentification() + ". Are you sure it is the correct element?");
        }
        if (errorMessage != null) {
            this.log(LogLevel.DEVIATION_EXTRA_INFO, "Error message: " + errorMessage);
        }
        this.saveScreenshot(element);
        this.saveDesktopScreenshot();
        this.saveHtmlContentOfCurrentPage();
        this.writeRunningProcessListDeviationsSinceTestCaseStart();
        this.haltFurtherExecution();
        return new ActionResult(false, guiElement, this);
    }

    public ActionResult writeAfterClear(GuiElement guiElement, String textToWrite) {
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds);
        try {
            this.enterText(webElement, textToWrite, true);
            return new ActionResult(true, guiElement, this);
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not enter the text '" + textToWrite + "' to element " + domElement.LogIdentification() + ". ");
            this.saveScreenshot(webElement);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return new ActionResult(false, guiElement, this);
        }
    }

    public ActionResult submitText(GuiElement guiElement, String text) {
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = null;
        try {
            webElement = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds);
            this.enterText(webElement, text, false);
            try {
                webElement.submit();
                this.log(LogLevel.EXECUTED, "Submitted text '" + text + "' to " + domElement.LogIdentification() + ".");
                return new ActionResult(true, guiElement, this);
            }
            catch (Exception e) {
                this.log(LogLevel.EXECUTION_PROBLEM, "Could not submit the text entered to " + domElement.LogIdentification() + ".");
                this.saveScreenshot(webElement);
                this.saveDesktopScreenshot();
                this.saveHtmlContentOfCurrentPage();
                this.writeRunningProcessListDeviationsSinceTestCaseStart();
            }
        }
        catch (TextEnteringError textEnteringError) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not enter '" + text + "' in " + domElement.LogIdentification() + ".");
            this.saveScreenshot(webElement);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
        return new ActionResult(false, guiElement, this);
    }

    public ActionResult saveScreenshot(WebElement relevantWebElementToMarkWithBorder) {
        byte[] fileImage;
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        JavascriptExecutor js = null;
        try {
            js = (JavascriptExecutor)this.driver;
            if (relevantWebElementToMarkWithBorder != null && this.driver instanceof JavascriptExecutor) {
                js.executeScript("arguments[0].setAttribute('style', arguments[1]);", new Object[]{relevantWebElementToMarkWithBorder, "border: 5px solid yellow;"});
            }
        }
        catch (Exception e) {
            this.log(LogLevel.DEBUG, "Could not highlight any element before screenshot. Error: " + e.getMessage());
        }
        String fileName = this.testCase.testName + TestRun.getFileCounter() + ".png";
        String filePath = LogFolder.testRunLogFolder + fileName;
        logger.debug("Saving screenshot of web browser content to '" + filePath + "'.");
        TestRun.increaseFileCounter();
        try {
            fileImage = (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES);
        }
        catch (Exception e) {
            this.log(LogLevel.FRAMEWORK_ERROR, "Could not take screenshot. Is driver ok? " + e.toString());
            try {
                if (relevantWebElementToMarkWithBorder != null && this.driver instanceof JavascriptExecutor && js != null) {
                    js.executeScript("arguments[0].setAttribute('style', arguments[1]);", new Object[]{relevantWebElementToMarkWithBorder, ""});
                }
            }
            catch (Exception jsProblem) {
                this.log(LogLevel.DEBUG, "Could not reset element highlight frame. Error: " + jsProblem.getMessage());
            }
            return new ActionResult(false, null, this);
        }
        if (fileImage == null) {
            this.log(LogLevel.DEBUG, "Could not save screenshot to '" + filePath + "' since the image data was empty.");
            return new ActionResult(false, null, this);
        }
        SupportMethods.saveToFile((byte[])fileImage, (String)filePath);
        String htmlFilePath = fileName;
        this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.INFO, "Saved browser screenshot as '" + filePath + "'.", "Saved browser screenshot as " + System.lineSeparator() + "   <a href=\"" + htmlFilePath + "\" target=\"_blank\">" + System.lineSeparator() + "      <span class=\"screenshotfile\">" + filePath + "</span>" + System.lineSeparator() + "   </a>" + System.lineSeparator() + "   <br>" + System.lineSeparator() + "   <a href=\"" + htmlFilePath + "\" target=\"_blank\">" + System.lineSeparator() + "      <img src=\"" + htmlFilePath + "\" alt=\"browser screenshot\" class=\"screenshot\">" + System.lineSeparator() + "   </a>");
        return new ActionResult(true, null, this);
    }

    public ActionResult saveDesktopScreenshot() {
        try {
            GenericInteractionMethods robotSwingInteractionMethods = new GenericInteractionMethods(this.testCase);
            robotSwingInteractionMethods.takeScreenshot();
            return new ActionResult(true, null, this);
        }
        catch (Exception e) {
            this.testCase.log(LogLevel.DEBUG, "Could not take desktop screenshot: " + e.toString());
            return new ActionResult(false, null, this);
        }
    }

    public ActionResult saveDomElementScreenshot(DomElement domElement, String filePath) {
        BufferedImage img;
        WebElement webElement;
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        if ((webElement = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds)) == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not identify " + domElement.LogIdentification() + " when trying to capture an image of it.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return new ActionResult(false, domElement, this);
        }
        File screen = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
        int ImageWidth = webElement.getSize().getWidth();
        int ImageHeight = webElement.getSize().getHeight();
        Point point = webElement.getLocation();
        int xCoordinate = point.getX();
        int yCoordinate = point.getY();
        try {
            img = ImageIO.read(screen);
        }
        catch (IOException e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not read screenshot of full screenshot when trying to capture an image of " + domElement.LogIdentification() + ".");
            return new ActionResult(false, domElement, this);
        }
        BufferedImage destination = img.getSubimage(xCoordinate, yCoordinate, ImageWidth, ImageHeight);
        try {
            ImageIO.write((RenderedImage)destination, "png", new File(filePath));
        }
        catch (IOException e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not write image of " + domElement.LogIdentification() + " to file '" + filePath + "'.");
            return new ActionResult(false, domElement, this);
        }
        return new ActionResult(true, domElement, this);
    }

    public boolean existsWithTimeout(GuiElement guiElement, int timeOutInSeconds) {
        DomElement domElement = (DomElement)guiElement;
        return this.getRuntimeElementWithTimeout(domElement, timeOutInSeconds) != null;
    }

    public boolean exists(DomElement domElement) {
        return this.getRuntimeElementWithoutLogging(domElement) != null;
    }

    public ActionResult setStandardTimeout(int standardTimeoutInSeconds) {
        this.log(LogLevel.DEBUG, "Resetting standard timeout from " + this.standardTimeoutInSeconds + " seconds to " + standardTimeoutInSeconds + " seconds.");
        this.standardTimeoutInSeconds = standardTimeoutInSeconds;
        return new ActionResult(true, null, this);
    }

    public ActionResult clickOnElementWithTheVisibleText(String visibleText) {
        List potentialClickObjects;
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        if ((potentialClickObjects = this.driver.findElements(By.xpath((String)("//*[.='" + visibleText + "']")))).size() == 0) {
            this.log(LogLevel.DEBUG, "No exact match for string '" + visibleText + "' found. Trying to find elements containing the text instead.");
            potentialClickObjects = this.driver.findElements(By.xpath((String)("//*[contains(text(), '" + visibleText + "')]")));
        }
        if (potentialClickObjects.size() == 1) {
            if (!((WebElement)potentialClickObjects.get(0)).isDisplayed()) {
                this.errorManagementProcedures("Attempting to click the element with the visible text '" + visibleText + "'. It exists but it is hidden from view.", (WebElement)potentialClickObjects.get(0));
            }
            if (!((WebElement)potentialClickObjects.get(0)).isEnabled()) {
                this.errorManagementProcedures("Attempting to click the element with the visible text '" + visibleText + "'. It exists but it is disabled.", (WebElement)potentialClickObjects.get(0));
            }
            try {
                ((WebElement)potentialClickObjects.get(0)).click();
                this.log(LogLevel.EXECUTED, "Clicked the element with visible text '" + visibleText + "'.");
                return new ActionResult(true, new DomElement((WebElement)potentialClickObjects.get(0)), this);
            }
            catch (Exception e) {
                this.log(LogLevel.EXECUTION_PROBLEM, "Could not click the element with the visible text '" + visibleText + "'. Error message: " + e.getMessage());
                return new ActionResult(false, new DomElement((WebElement)potentialClickObjects.get(0)), this);
            }
        }
        ArrayList<WebElement> trulyClickableElements = new ArrayList<WebElement>();
        for (WebElement potentialClickObject : potentialClickObjects) {
            if (!potentialClickObject.isEnabled()) continue;
            trulyClickableElements.add(potentialClickObject);
        }
        this.log(LogLevel.DEBUG, "Found " + potentialClickObjects.size() + " elements with the text '" + visibleText + "'. Out of those " + trulyClickableElements.size() + " was enabled and not hidden.");
        if (trulyClickableElements.size() == 1) {
            try {
                ((WebElement)trulyClickableElements.get(0)).click();
                this.log(LogLevel.EXECUTED, "Clicked the element with the visible text '" + visibleText + "'.");
                return new ActionResult(true, new DomElement((WebElement)trulyClickableElements.get(0)), this);
            }
            catch (Exception e) {
                this.errorManagementProcedures("Could not click element with visible text '" + visibleText + "'. Error message: " + e.getMessage(), (WebElement)trulyClickableElements.get(0));
                return new ActionResult(false, new DomElement((WebElement)trulyClickableElements.get(0)), this);
            }
        }
        boolean clicked = false;
        for (WebElement webElement : trulyClickableElements) {
            if (!webElement.isDisplayed()) continue;
            clicked = true;
            webElement.click();
            this.log(LogLevel.EXECUTED, "Clicked the element with the visible text '" + visibleText + "'.");
            return new ActionResult(true, new DomElement(webElement), this);
        }
        if (!clicked) {
            this.errorManagementProcedures("Attempted to click element with visible text '" + visibleText + "', but several elements was found with that text.", null);
        }
        return new ActionResult(false, null, this);
    }

    public ActionResult clickEvenIfDisabled(GuiElement guiElement, int timeoutInSeconds) {
        this.waitForElementToAppear(guiElement);
        WebElement webElement = this.getRuntimeElementWithLogging((DomElement)guiElement);
        if (webElement == null) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not identify element " + ((DomElement)guiElement).LogIdentification() + " to click blindly at.");
            return new ActionResult(false, guiElement, this);
        }
        Point topLeft = webElement.getLocation();
        Point clickPoint = new Point(topLeft.getX() + webElement.getSize().width / 2, topLeft.getY() + webElement.getSize().height / 2);
        try {
            Robot r = new Robot();
            r.mouseMove(clickPoint.getX(), clickPoint.getY());
            r.mousePress(16);
            r.mouseRelease(16);
            this.testCase.log(LogLevel.EXECUTED, "Clicked blindly at element position for element " + ((DomElement)guiElement).LogIdentification() + " (at point '" + clickPoint.x + "x" + clickPoint.y + "').");
            return new ActionResult(true, guiElement, this);
        }
        catch (AWTException e) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not click blindly at element " + ((DomElement)guiElement).LogIdentification() + " at point '" + clickPoint.x + "x" + clickPoint.y + "'. Error: " + e.toString());
            return new ActionResult(false, guiElement, this);
        }
    }

    public ActionResult click(GuiElement guiElement) {
        return new ActionResult(this.click((GuiElement)guiElement, (int)this.standardTimeoutInSeconds).wasSuccess, guiElement, this);
    }

    public ActionResult click(GuiElement guiElement, int timeoutInSeconds) {
        HashSet<String> errorMessages = new HashSet<String>();
        DomElement element = (DomElement)guiElement;
        long startTime = System.currentTimeMillis();
        boolean hasBeenEnabled = false;
        boolean hasBeenDisplayed = false;
        boolean hasBeenIdentified = false;
        boolean clicked = false;
        WebElement webElement = null;
        this.log(LogLevel.DEBUG, "Attempting to click on " + element.LogIdentification() + ".");
        while (!clicked && System.currentTimeMillis() - startTime <= (long)(timeoutInSeconds * 1000)) {
            webElement = this.getRuntimeElementWithoutLogging(element);
            if (webElement == null || !webElement.isEnabled() || !webElement.isDisplayed()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            webElement = this.getRuntimeElementWithLogging(element);
            if (webElement == null) break;
            if (webElement.isEnabled()) {
                hasBeenEnabled = true;
            }
            if (webElement.isDisplayed()) {
                hasBeenDisplayed = true;
            }
            try {
                webElement.click();
                clicked = true;
            }
            catch (Exception e) {
                errorMessages.add(e.getMessage());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    errorMessages.add(e2.getMessage());
                }
            }
        }
        if (clicked) {
            this.log(LogLevel.EXECUTED, "Clicked the " + element.LogIdentification() + " element after " + String.valueOf(System.currentTimeMillis() - startTime) + " milliseconds.");
            return new ActionResult(true, guiElement, this);
        }
        if (errorMessages.size() > 0) {
            for (String errorMessage : errorMessages) {
                if (!errorMessages.contains("Other element would receive the click")) continue;
                this.log(LogLevel.EXECUTION_PROBLEM, "It seems something is blocking the possibility to click on " + element.LogIdentification() + ". It could for example be a popup overlaying the element?");
                this.errorManagementProcedures("Could not click element " + element.LogIdentification() + ".", webElement);
                return new ActionResult(false, guiElement, this);
            }
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.FRAMEWORK_ERROR, "Could not click on element " + element.LogIdentification() + ". Error(s):" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), errorMessages), "Could not click och element " + element.LogIdentification() + ".<br>Error:<br><br>" + String.join((CharSequence)"<br> * ", errorMessages));
            this.errorManagementProcedures("Could not click element " + element.LogIdentification() + ".", webElement);
        } else {
            if (webElement == null) {
                this.errorManagementProcedures("Could not identify element " + element.LogIdentification() + " in the GUI.", null);
            }
            if (!hasBeenEnabled || !hasBeenDisplayed) {
                this.errorManagementProcedures("Element " + element.LogIdentification() + " was identified. It is" + String.valueOf(hasBeenEnabled).toLowerCase().replace("true", "").replace("false", " not") + " enabled. It is" + String.valueOf(hasBeenDisplayed).toLowerCase().replace("true", "").replace("false", " not") + " displayed. Seems unnatural to click it. If you still want this element to be clicked the clickEvenIfDisabled() method instead.", webElement);
            }
            this.errorManagementProcedures("Could not successfully click on the " + element.LogIdentification() + " element.", webElement);
        }
        return new ActionResult(false, guiElement, this);
    }

    private boolean elementBecomeDisplayedWithinTimeout(WebElement webelement) {
        if (!webelement.isDisplayed()) {
            Waiter wait = new Waiter(this.testCase, LogLevel.DEBUG);
            while (!webelement.isDisplayed() && wait.totalTimeSpentSoFar() < this.standardTimeoutInSeconds * 1000) {
                wait.wait(50);
            }
            wait.report();
        }
        return webelement.isDisplayed();
    }

    private boolean elementBecomeEnabledWithinTimeout(WebElement webelement) {
        if (!webelement.isEnabled()) {
            Waiter wait = new Waiter(this.testCase, LogLevel.DEBUG);
            while (!webelement.isEnabled() && wait.totalTimeSpentSoFar() < this.standardTimeoutInSeconds * 1000) {
                wait.wait(50);
            }
            wait.report();
        }
        return webelement.isEnabled();
    }

    public ActionResult closeBrowser() {
        try {
            this.closeBrowserDriver();
            this.log(LogLevel.INFO, "Closing browser.");
            return new ActionResult(true, null, this);
        }
        catch (BrowserClosingError browserClosingError) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not close the browser.");
            return new ActionResult(false, null, this);
        }
    }

    public ActionResult makeSureDriverIsClosed() {
        try {
            this.closeBrowserDriver();
            return new ActionResult(true, null, this);
        }
        catch (Exception e) {
            this.log(LogLevel.DEBUG, "Could not close browser. Was probably already closed.");
            return new ActionResult(false, null, this);
        }
    }

    @Deprecated
    public void verifyElementExistence(GuiElement guiElement) {
        DomElement domElement = (DomElement)guiElement;
        if (this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds) == null) {
            this.log(LogLevel.VERIFICATION_FAILED, "Object " + domElement.LogIdentification() + " was expected to be present but could not be identified.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        } else {
            this.log(LogLevel.VERIFICATION_PASSED, "Existence of object " + domElement.LogIdentification() + " verified.");
        }
    }

    @Deprecated
    public void verifyObjectExistence(GuiElement guiElement) {
        this.verifyElementExistence(guiElement);
    }

    @Deprecated
    public void verifyObjectIsNotDisplayed(GuiElement guiElement) {
        this.verifyElementIsNotDisplayed(guiElement);
    }

    @Deprecated
    public void verifyElementIsNotDisplayed(GuiElement guiElement) {
        boolean disappeared;
        DomElement domElement = (DomElement)guiElement;
        long startTime = System.currentTimeMillis();
        WebElement webElement = this.getRuntimeElementWithoutLogging(domElement);
        boolean bl = disappeared = webElement == null;
        while (!disappeared && System.currentTimeMillis() - startTime < (long)(this.standardTimeoutInSeconds * 1000)) {
            this.wait(100);
            webElement = this.getRuntimeElementWithoutLogging(domElement);
            disappeared = webElement == null || !webElement.isDisplayed();
        }
        if (webElement == null) {
            this.log(LogLevel.DEBUG, "Object " + domElement.LogIdentification() + " could not be identified in the html.");
            this.log(LogLevel.VERIFICATION_PASSED, "Object " + domElement.LogIdentification() + " verified to not be present.");
        } else if (!webElement.isDisplayed()) {
            this.log(LogLevel.DEBUG, "Object " + domElement.LogIdentification() + " could be identified in the html, but it is suppressed from being displayed in the GUI.");
            this.log(LogLevel.VERIFICATION_PASSED, "Object " + domElement.LogIdentification() + " verified to not displayed.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "Object " + domElement.LogIdentification() + " was identified as displayed although expected to not be displayed.");
            this.saveScreenshot(webElement);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    @Deprecated
    public void verifyObjectIsNotDisplayedWithTimeout(GuiElement guiElement, int timeoutInSeconds) {
        this.verifyElementIsNotDisplayedWithTimeout(guiElement, timeoutInSeconds);
    }

    @Deprecated
    public void verifyElementIsNotDisplayedWithTimeout(GuiElement guiElement, int timeoutInSeconds) {
        boolean disappeared;
        DomElement domElement = (DomElement)guiElement;
        long startTime = System.currentTimeMillis();
        WebElement webElement = this.getRuntimeElementWithoutLogging(domElement);
        boolean bl = disappeared = webElement == null;
        while (!disappeared && System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            this.wait(100);
            webElement = this.getRuntimeElementWithoutLogging(domElement);
            disappeared = webElement == null || !webElement.isDisplayed();
        }
        if (webElement == null) {
            this.log(LogLevel.DEBUG, "Object " + domElement.LogIdentification() + " could not be identified in the html.");
            this.log(LogLevel.VERIFICATION_PASSED, "Object " + domElement.LogIdentification() + " verified to not be present.");
        } else if (!webElement.isDisplayed()) {
            this.log(LogLevel.DEBUG, "Object " + domElement.LogIdentification() + " could be identified in the html, but it is suppressed from being displayed in the GUI.");
            this.log(LogLevel.VERIFICATION_PASSED, "Object " + domElement.LogIdentification() + " verified to not displayed.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "Object " + domElement.LogIdentification() + " was identified as displayed although expected to not be displayed.");
            this.saveScreenshot(webElement);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    public boolean isDisplayed(GuiElement guiElement) {
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds);
        boolean displayed = webElement == null || !webElement.isDisplayed();
        this.log(LogLevel.DEBUG, "Checking if " + domElement.LogIdentification() + " is displayed. Returning " + displayed + ".");
        return displayed;
    }

    public boolean isNotDisplayed(GuiElement guiElement) {
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds);
        boolean notDisplayed = webElement == null || !webElement.isDisplayed();
        this.log(LogLevel.DEBUG, "Checking if " + domElement.LogIdentification() + " is not displayed. Returning " + notDisplayed + ".");
        return notDisplayed;
    }

    public boolean isNotDisplayedExactlyNow(GuiElement guiElement) {
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = this.getRuntimeElementWithoutLogging(domElement);
        boolean notDisplayed = webElement == null || !webElement.isDisplayed();
        this.log(LogLevel.DEBUG, "Checking if " + domElement.LogIdentification() + " is not displayed. Returning " + notDisplayed + ".");
        return notDisplayed;
    }

    public boolean isNotDisplayedWithinTimeout(GuiElement guiElement, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = this.getRuntimeElementWithoutLogging(domElement);
        if (webElement == null) {
            return true;
        }
        while (webElement != null && webElement.isDisplayed() && System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            webElement = this.getRuntimeElementWithoutLogging(domElement);
        }
        return webElement == null || !webElement.isDisplayed();
    }

    @Deprecated
    public void verifyObjectIsDisplayed(GuiElement guiElement) {
        this.verifyElementIsDisplayed(guiElement);
    }

    @Deprecated
    public void verifyElementIsDisplayed(GuiElement guiElement) {
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds);
        if (webElement == null) {
            this.log(LogLevel.VERIFICATION_FAILED, "Object " + domElement.LogIdentification() + " was expected to be displayed but could not be identified at all.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        } else if (!webElement.isDisplayed()) {
            this.log(LogLevel.VERIFICATION_FAILED, "Object " + domElement.LogIdentification() + " is present, but the display of the object is suppressed.");
            this.saveScreenshot(webElement);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        } else {
            this.log(LogLevel.VERIFICATION_PASSED, "Existence of object " + domElement.LogIdentification() + " verified.");
        }
    }

    @Deprecated
    public void verifyObjectDoesNotExist(GuiElement guiElement) {
        this.verifyElementDoesNotExist(guiElement);
    }

    @Deprecated
    public void verifyElementDoesNotExist(GuiElement guiElement) {
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds);
        if (webElement != null) {
            this.log(LogLevel.VERIFICATION_FAILED, "Object " + domElement.LogIdentification() + " was expected to not be present but was able to be identified.");
            this.saveScreenshot(webElement);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        } else {
            this.log(LogLevel.VERIFICATION_PASSED, "Verified that the object " + domElement.LogIdentification() + " was not present.");
        }
    }

    @Deprecated
    public void verifyObjectDoesNotExistWithTimeout(GuiElement guiElement, int timeoutInSeconds) {
        this.verifyElementDoesNotExistWithTimeout(guiElement, timeoutInSeconds);
    }

    @Deprecated
    public void verifyElementDoesNotExistWithTimeout(GuiElement guiElement, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = this.getRuntimeElementWithTimeout(domElement, timeoutInSeconds);
        if (webElement != null) {
            this.log(LogLevel.VERIFICATION_FAILED, "Object " + domElement.LogIdentification() + " was expected to not be present but was able to be identified.");
            this.saveScreenshot(webElement);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        } else {
            this.log(LogLevel.VERIFICATION_PASSED, "Verified that the object " + domElement.LogIdentification() + " was not present.");
        }
    }

    @Deprecated
    public void verifyObjectExistenceWithTimeout(GuiElement guiElement, int timeoutInSeconds) {
        this.verifyElementExistenceWithTimeout(guiElement, timeoutInSeconds);
    }

    @Deprecated
    public void verifyElementExistenceWithTimeout(GuiElement guiElement, int timeoutInSeconds) {
        DomElement domElement = (DomElement)guiElement;
        if (this.getRuntimeElementWithTimeout(domElement, timeoutInSeconds) == null) {
            this.log(LogLevel.VERIFICATION_PROBLEM, "Object " + domElement.LogIdentification() + " was expected to be present but was not identified.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        } else {
            this.log(LogLevel.VERIFICATION_PASSED, "Existence of object " + domElement.LogIdentification() + " verified.");
        }
    }

    public boolean isDisplayedWithoutTimeout(GuiElement guiElement) {
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = this.getRuntimeElementWithoutLogging(domElement);
        return webElement != null && webElement.isDisplayed();
    }

    @Deprecated
    public void verifyTextExistOnCurrentPage(String text) {
        DomElement domElement = new DomElement("//*[contains(text(),'" + text + "')]", DomElement.IdentificationType.BY_X_PATH);
        WebElement webElement = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds);
        if (webElement != null) {
            this.log(LogLevel.VERIFICATION_PASSED, "The text '" + text + "' could be found on the current page.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "The text '" + text + "' could not be found on the current page.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    @Deprecated
    public boolean textExistInPageSourceOfCurrentPageWithinTimeout(String text, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime <= (long)(timeoutInSeconds * 1000)) {
            if (this.driver.getPageSource().contains(text)) {
                this.log(LogLevel.DEBUG, "Checked for text '" + text + "' to exist in current page source within " + timeoutInSeconds + " seconds, and it was identified after " + (System.currentTimeMillis() - startTime) + " milliseconds.");
                return true;
            }
            this.wait(50);
        }
        this.log(LogLevel.DEBUG, "Checked for text '" + text + "' to exist in page source within " + timeoutInSeconds + " seconds. It could not be identified.");
        return false;
    }

    public boolean textExistOnCurrentPageWithinTimeout(String text, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        DomElement domElement = new DomElement("//*[contains(text(),'" + text + "')]", DomElement.IdentificationType.BY_X_PATH);
        while (System.currentTimeMillis() - startTime <= (long)(timeoutInSeconds * 1000)) {
            WebElement webElement = this.getRuntimeElementWithoutLogging(domElement);
            if (webElement != null) {
                this.log(LogLevel.DEBUG, "Checked for text '" + text + "' to exist on current page within " + timeoutInSeconds + " seconds, and it was identified after " + (System.currentTimeMillis() - startTime) + " milliseconds. No check for if the element is displayed. There are other methods for that.");
                return true;
            }
            this.wait(50);
        }
        this.log(LogLevel.DEBUG, "Checked for text '" + text + "' to exist on page within " + timeoutInSeconds + " seconds. It could not be identified.");
        return false;
    }

    public boolean textIsDisplayedOnCurrentPageWithinTimeout(String text, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        DomElement domElement = new DomElement("//*[contains(text(),'" + text + "')]", DomElement.IdentificationType.BY_X_PATH);
        while (System.currentTimeMillis() - startTime <= (long)(timeoutInSeconds * 1000)) {
            WebElement webElement = this.getRuntimeElementWithoutLogging(domElement);
            if (webElement != null && webElement.isDisplayed()) {
                this.log(LogLevel.DEBUG, "Checked for text '" + text + "' to become displayed on current page within " + timeoutInSeconds + " seconds, and it was identified after " + (System.currentTimeMillis() - startTime) + " milliseconds.");
                return true;
            }
            this.wait(50);
        }
        this.log(LogLevel.DEBUG, "Checked for text '" + text + "' to become displayed on page within " + timeoutInSeconds + " seconds. It could not be identified.");
        return false;
    }

    @Deprecated
    public void verifyTextAsRegexPatternExistInPageSource(String textAsRegexPattern) {
        String pageSource;
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        if (SupportMethods.isRegexMatch((String)(pageSource = this.driver.getPageSource()), (String)textAsRegexPattern)) {
            this.log(LogLevel.VERIFICATION_PASSED, "The regular expression pattern '" + textAsRegexPattern + "' could be found on the current page.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "The regular expression pattern '" + textAsRegexPattern + "' could not be found on the current page.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    @Deprecated
    public void verifyPageTitleAsRegex(String expectedTitleAsRegexPattern) {
        String currentTitle;
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        if (SupportMethods.isRegexMatch((String)(currentTitle = this.driver.getTitle()), (String)expectedTitleAsRegexPattern)) {
            this.log(LogLevel.VERIFICATION_PASSED, "The current page title was '" + currentTitle + "', and that title matches the given regex pattern '" + expectedTitleAsRegexPattern + "'.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "The current page title was expected to match the regex pattern '" + expectedTitleAsRegexPattern + "' but was '" + currentTitle + "'.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    @Deprecated
    public void verifyPageTitle(String expectedTitle) {
        String currentTitle;
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        if ((currentTitle = this.driver.getTitle()).equals(expectedTitle)) {
            this.log(LogLevel.VERIFICATION_PASSED, "The current page title was '" + expectedTitle + "' as expected.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "The current page title was expected to be '" + expectedTitle + "' but was '" + currentTitle + "'.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    @Deprecated
    public void verifyPageTitleAsRegexWithTimeout(String expectedTitleAsRegexPattern, int timeoutInSeconds) {
        double startTime = System.currentTimeMillis();
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        String currentTitle = this.driver.getTitle();
        long retryPeriodInMS = 50L;
        while (!SupportMethods.isRegexMatch((String)currentTitle, (String)expectedTitleAsRegexPattern) && (double)System.currentTimeMillis() - startTime < (double)(timeoutInSeconds * 1000)) {
            try {
                Thread.sleep(retryPeriodInMS);
            }
            catch (InterruptedException e) {
                this.log(LogLevel.FRAMEWORK_ERROR, "Could not put thread to sleep.");
                e.printStackTrace();
            }
            currentTitle = this.driver.getTitle();
        }
        if (SupportMethods.isRegexMatch((String)currentTitle, (String)expectedTitleAsRegexPattern)) {
            this.log(LogLevel.VERIFICATION_PASSED, "The current page title was '" + currentTitle + "' and that title is found to be a match for given regular expression pattern '" + expectedTitleAsRegexPattern + "' (found after " + ((double)System.currentTimeMillis() - startTime) + " milliseconds).");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "The current page title was expected to match the regular expression pattern '" + expectedTitleAsRegexPattern + "' but was '" + currentTitle + "' even after " + timeoutInSeconds + " milliseconds.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    @Deprecated
    public void verifyPageTitleWithTimeout(String expectedTitle, int timeoutInSeconds) {
        double startTime = System.currentTimeMillis();
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        String currentTitle = this.driver.getTitle();
        long retryPeriodInMS = 50L;
        while (!currentTitle.equals(expectedTitle) && (double)System.currentTimeMillis() - startTime < (double)(timeoutInSeconds * 1000)) {
            try {
                Thread.sleep(retryPeriodInMS);
            }
            catch (InterruptedException e) {
                this.log(LogLevel.FRAMEWORK_ERROR, "Could not put thread to sleep.");
                e.printStackTrace();
            }
            currentTitle = this.driver.getTitle();
        }
        if (currentTitle.equals(expectedTitle)) {
            this.log(LogLevel.VERIFICATION_PASSED, "The current page title was '" + expectedTitle + "' as expected (found after " + ((double)System.currentTimeMillis() - startTime) + " milliseconds).");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "The current page title was expected to be '" + expectedTitle + "' but was '" + currentTitle + "' even after " + ((double)System.currentTimeMillis() - startTime) + " milliseconds.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    @Deprecated
    public void verifyElementText(GuiElement guiElement, String expectedText) {
        boolean verifiedOk = false;
        String currentText = "";
        long startTime = System.currentTimeMillis();
        while (!verifiedOk && System.currentTimeMillis() - startTime <= (long)(this.standardTimeoutInSeconds * 1000)) {
            currentText = this.getTextWithoutLogging(guiElement);
            if (currentText == null || !currentText.equals(expectedText)) continue;
            verifiedOk = true;
        }
        if (verifiedOk) {
            this.log(LogLevel.VERIFICATION_PASSED, "Element " + ((DomElement)guiElement).LogIdentification() + " found to have the text '" + expectedText + "' as expected.");
        } else {
            if (this.exists(guiElement)) {
                this.log(LogLevel.VERIFICATION_FAILED, "Element " + ((DomElement)guiElement).LogIdentification() + " was expected to have the text '" + expectedText + "', but it actually was '" + currentText + "'.");
            } else {
                DomElement domElement = (DomElement)guiElement;
                this.log(LogLevel.VERIFICATION_PROBLEM, "Could not find element " + domElement.LogIdentification() + " when attempting to verify the text '" + expectedText + "'.");
            }
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    @Deprecated
    public void verifyElementTextContainsText(GuiElement guiElement, String expectedText) {
        boolean verifiedOk = false;
        String currentText = "";
        long startTime = System.currentTimeMillis();
        while (!verifiedOk && System.currentTimeMillis() - startTime <= (long)(this.standardTimeoutInSeconds * 1000)) {
            currentText = this.getTextWithoutLogging(guiElement);
            if (currentText == null || !currentText.contains(expectedText)) continue;
            verifiedOk = true;
        }
        if (verifiedOk) {
            this.log(LogLevel.VERIFICATION_PASSED, "Element " + ((DomElement)guiElement).LogIdentification() + " found to have the text '" + expectedText + "' as expected.");
        } else {
            if (this.exists(guiElement)) {
                this.log(LogLevel.VERIFICATION_FAILED, "Element " + ((DomElement)guiElement).LogIdentification() + " was expected to have the text '" + expectedText + "', but it actually was '" + currentText + "'.");
            } else {
                DomElement domElement = (DomElement)guiElement;
                this.log(LogLevel.VERIFICATION_PROBLEM, "Could not find element " + domElement.LogIdentification() + " when attempting to verify the text '" + expectedText + "'.");
            }
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    @Deprecated
    public void verifyElementTextWithRegexPattern(GuiElement guiElement, String expectedTextAsRegexPattern) {
        String currentText = "";
        long startTime = System.currentTimeMillis();
        boolean verifiedOk = false;
        while (!verifiedOk && System.currentTimeMillis() - startTime <= (long)(this.standardTimeoutInSeconds * 1000)) {
            currentText = this.getTextWithoutLogging(guiElement);
            if (!SupportMethods.isRegexMatch((String)currentText, (String)expectedTextAsRegexPattern)) continue;
            verifiedOk = true;
        }
        if (SupportMethods.isRegexMatch((String)currentText, (String)expectedTextAsRegexPattern)) {
            this.log(LogLevel.VERIFICATION_PASSED, "Element " + ((DomElement)guiElement).LogIdentification() + " found to be '" + currentText + ". It is a match with the regular expression pattern '" + expectedTextAsRegexPattern + "'.");
        } else {
            if (this.exists(guiElement)) {
                this.log(LogLevel.VERIFICATION_FAILED, "Element " + ((DomElement)guiElement).LogIdentification() + " was expected to have match the regular expression pattern '" + expectedTextAsRegexPattern + "', but it actually was '" + currentText + "'. Not a match.");
            } else {
                DomElement domElement = (DomElement)guiElement;
                this.log(LogLevel.VERIFICATION_PROBLEM, "Could not find element " + domElement.LogIdentification() + " when attempting to verify the text from regular expression pattern '" + expectedTextAsRegexPattern + "'.");
            }
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    public ActionResult pickTableRow(GuiElement guiTableElement, String[] textsToFindOnRow) {
        boolean doneOk = false;
        long startTime = System.currentTimeMillis();
        DomElement domElement = (DomElement)guiTableElement;
        WebElement webElement = null;
        try {
            while (!doneOk && System.currentTimeMillis() - startTime <= (long)(this.standardTimeoutInSeconds * 1000)) {
                webElement = this.getRuntimeElementWithoutLogging(domElement);
                ArrayList<String> partialMatches = new ArrayList<String>();
                boolean allValuesFoundInRow = false;
                List rows = webElement.findElements(By.xpath((String)".//tr"));
                for (WebElement row : rows) {
                    ArrayList<String> rowStrings = new ArrayList<String>();
                    boolean someValueFoundInRow = false;
                    boolean valueMissingOnRow = false;
                    List cells = row.findElements(By.xpath((String)"(.//td | .//th)"));
                    for (String textToFindOnRow : textsToFindOnRow) {
                        boolean thisValueFoundOnRow = false;
                        for (WebElement cell : cells) {
                            rowStrings.add(cell.getText());
                            if (!cell.getText().contains(textToFindOnRow)) continue;
                            thisValueFoundOnRow = true;
                            someValueFoundInRow = true;
                        }
                        if (thisValueFoundOnRow) continue;
                        valueMissingOnRow = true;
                        break;
                    }
                    if (!valueMissingOnRow) {
                        allValuesFoundInRow = true;
                        row.click();
                        break;
                    }
                    if (!someValueFoundInRow) continue;
                    partialMatches.add("'" + String.join((CharSequence)"', '", rowStrings) + "'");
                }
                if (!allValuesFoundInRow) {
                    this.log(LogLevel.EXECUTION_PROBLEM, "Could not find row matching '" + String.join((CharSequence)"', '", textsToFindOnRow) + "' in " + domElement.LogIdentification() + ".");
                    this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.DEVIATION_EXTRA_INFO, "Rows with partial matches for '" + String.join((CharSequence)"', '", textsToFindOnRow) + "':" + System.lineSeparator() + "[" + String.join((CharSequence)("]" + System.lineSeparator() + "["), partialMatches) + "]", "Rows with partial matches for '" + String.join((CharSequence)"', '", textsToFindOnRow) + "':<br><table><tr><td>" + String.join((CharSequence)"</td></tr><tr><td>", partialMatches) + "</td></tr></table>");
                    this.saveScreenshot(webElement);
                    this.saveDesktopScreenshot();
                    this.saveHtmlContentOfCurrentPage();
                    this.haltFurtherExecution();
                    continue;
                }
                doneOk = true;
                this.log(LogLevel.EXECUTED, "Clicked the row with values '" + String.join((CharSequence)"', '", textsToFindOnRow) + "' in table " + domElement.LogIdentification() + ".");
            }
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not pick table row. Error: " + e.toString());
            this.saveScreenshot(webElement);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.haltFurtherExecution();
        }
        return new ActionResult(true, guiTableElement, this);
    }

    public Object executeJavascript(String script) {
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        Object returnObject = null;
        if (this.driver instanceof JavascriptExecutor) {
            try {
                JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.driver;
                returnObject = javascriptExecutor.executeScript(script, new Object[0]);
                String returnObjectAsString = null;
                if (returnObject != null) {
                    try {
                        returnObjectAsString = returnObject.toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String logMessageText = "Executed the javascript '" + script + "'.";
                String logMessageHtml = "Executed the javascript:" + StringManagement.htmlContentToDisplayableHtmlCode((String)script);
                if (returnObjectAsString != null) {
                    logMessageText = logMessageText + " Returned '" + returnObjectAsString + "'.";
                    logMessageHtml = logMessageHtml + "<br>Returned:<br>" + StringManagement.htmlContentToDisplayableHtmlCode((String)returnObjectAsString);
                }
                this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTED, logMessageText, logMessageHtml);
            }
            catch (Exception e) {
                this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTION_PROBLEM, "Errors while trying to run the javascript:" + SupportMethods.LF + script + SupportMethods.LF + "Error:" + SupportMethods.LF + e.toString(), "Errors while trying to run the javascript:" + SupportMethods.LF + StringManagement.htmlContentToDisplayableHtmlCode((String)script) + SupportMethods.LF + "Error:" + SupportMethods.LF + e.toString());
                this.saveHtmlContentOfCurrentPage();
            }
        } else {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTION_PROBLEM, "Attempted executing javascript, but browser type driver does not seem to be compatible. Javascript that did not run below:" + SupportMethods.LF + script, "Attempted executing javascript, but browser type driver does not seem to be compatible. Javascript that did not run below:" + SupportMethods.LF + StringManagement.htmlContentToDisplayableHtmlCode((String)script));
            this.saveHtmlContentOfCurrentPage();
        }
        return returnObject;
    }

    @Deprecated
    public ActionResult verifyCurrentPageSourceWithW3validator(boolean verbose) {
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        W3CHtmlValidatorService w3CHtmlValidatorService = new W3CHtmlValidatorService(this.testCase, this.driver.getPageSource(), verbose);
        w3CHtmlValidatorService.verifyPageSourceWithW3validator();
        if (w3CHtmlValidatorService.failed()) {
            this.saveHtmlContentOfCurrentPage();
        }
        return new ActionResult(!w3CHtmlValidatorService.failed(), null, this);
    }

    @Deprecated
    public void verifyIsEnabled(GuiElement guiElement) {
        if (this.isEnabled(guiElement)) {
            this.log(LogLevel.VERIFICATION_PASSED, "Element " + ((DomElement)guiElement).LogIdentification() + " found to be enabled as expected.");
        } else {
            long startTime = System.currentTimeMillis();
            DomElement domElement = (DomElement)guiElement;
            boolean enabled = false;
            WebElement webElement = null;
            while (!enabled && System.currentTimeMillis() - startTime < (long)(this.standardTimeoutInSeconds * 1000)) {
                webElement = this.getRuntimeElementWithoutLogging(domElement);
                if (!webElement.isEnabled()) continue;
                enabled = true;
            }
            if (webElement == null) {
                this.log(LogLevel.VERIFICATION_FAILED, "Element " + ((DomElement)guiElement).LogIdentification() + " was expected to be enabled, but could not be identified.");
                this.saveScreenshot(null);
                this.saveDesktopScreenshot();
                this.saveHtmlContentOfCurrentPage();
                this.writeRunningProcessListDeviationsSinceTestCaseStart();
                return;
            }
            if (!webElement.isDisplayed() && !enabled) {
                this.log(LogLevel.VERIFICATION_FAILED, "Element " + ((DomElement)guiElement).LogIdentification() + " was expected to be enabled, but it's neither displayed, nor enabled.");
            } else if (!enabled) {
                this.log(LogLevel.VERIFICATION_FAILED, "Element " + ((DomElement)guiElement).LogIdentification() + " was expected to be enabled. It seem to be enabled, but not displayed.");
            } else {
                this.log(LogLevel.VERIFICATION_FAILED, "Element " + ((DomElement)guiElement).LogIdentification() + " was expected to be enabled. It's enabled, but not displayed and cannot be used for interaction.");
            }
            this.saveScreenshot(webElement);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    public ActionResult switchBrowserTabWithTabNameGivenAsRegexPattern(String tabNameAsRegexForTabToSwitchTo) {
        String currentTabId;
        String initialTitle;
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        try {
            initialTitle = this.driver.getTitle();
            currentTabId = this.driver.getWindowHandle();
            this.log(LogLevel.DEBUG, "Switching browser tabs, trying to switch to a tab with title matching the regular expression pattern '" + tabNameAsRegexForTabToSwitchTo + "'. Initial browser tab title = '" + initialTitle + "' (tab id='" + currentTabId + "').");
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not switch browser tab. Browser seem to be closed.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return new ActionResult(false, null, this);
        }
        for (String tabId : this.driver.getWindowHandles()) {
            if (currentTabId.equals(tabId)) continue;
            this.driver.switchTo().window(tabId);
            String tabName = this.driver.getTitle();
            this.log(LogLevel.DEBUG, "Identified browser tab with tab title = '" + tabName + " (id='" + tabId + "').");
            if (!SupportMethods.isRegexMatch((String)this.driver.getTitle(), (String)tabNameAsRegexForTabToSwitchTo)) continue;
            return new ActionResult(true, null, this);
        }
        this.log(LogLevel.EXECUTED, "Switched browser tab from tab '" + initialTitle + "' to tab with title '" + this.driver.getTitle() + "'. Matched with regular expression pattern '" + tabNameAsRegexForTabToSwitchTo + "'.");
        return new ActionResult(true, null, this);
    }

    public ActionResult switchBrowserTab(String tabNameForTabToSwitchTo) {
        String currentTabId;
        String initialTitle;
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        try {
            initialTitle = this.driver.getTitle();
            currentTabId = this.driver.getWindowHandle();
            this.log(LogLevel.DEBUG, "Switching browser tabs, trying to switch to tab with title '" + tabNameForTabToSwitchTo + "'. Initial browser tab title = '" + initialTitle + "' (tab id='" + currentTabId + "').");
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not switch browser tab. Browser seem to be closed.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return new ActionResult(false, null, this);
        }
        ArrayList<String> actualTabs = new ArrayList<String>();
        actualTabs.add(initialTitle);
        for (String tabId : this.driver.getWindowHandles()) {
            if (currentTabId.equals(tabId)) continue;
            this.driver.switchTo().window(tabId);
            String tabName = this.driver.getTitle();
            this.log(LogLevel.DEBUG, "Identified browser tab with tab title = '" + tabName + " (id='" + tabId + "').");
            String currentTitle = this.driver.getTitle();
            actualTabs.add(currentTitle);
            if (currentTitle == null || !currentTitle.equals(tabNameForTabToSwitchTo)) continue;
            this.log(LogLevel.EXECUTED, "Switched browser tab from tab '" + initialTitle + "' to tab with title '" + this.driver.getTitle() + "'.");
            return new ActionResult(true, null, this);
        }
        this.log(LogLevel.EXECUTION_PROBLEM, "Could not switch browser tab from tab '" + initialTitle + "' to tab with title '" + tabNameForTabToSwitchTo + "'. Existing titles: '" + String.join((CharSequence)"', '", actualTabs) + "'.");
        return new ActionResult(false, null, this);
    }

    public ActionResult closeCurrentBrowserTab() {
        this.log(LogLevel.FRAMEWORK_ERROR, "Close current browser tab is not yet implemented.");
        return new ActionResult(false, null, this);
    }

    public ActionResult hover(GuiElement guiElement) {
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        String javaScript = "var evObj = document.createEvent('MouseEvents');evObj.initMouseEvent(\"mouseover\",true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);arguments[0].dispatchEvent(evObj);";
        try {
            ((JavascriptExecutor)this.driver).executeScript(javaScript, new Object[]{this.getRuntimeElementWithTimeout((DomElement)guiElement, this.standardTimeoutInSeconds)});
            this.log(LogLevel.EXECUTED, "Hover over " + ((DomElement)guiElement).LogIdentification() + ".");
            return new ActionResult(true, guiElement, this);
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not hover over " + ((DomElement)guiElement).LogIdentification() + ".");
            this.saveScreenshot(this.getRuntimeElementWithoutLogging((DomElement)guiElement));
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return new ActionResult(false, guiElement, this);
        }
    }

    public ElementVerificationMethods verifiyElement(DomElement domElement) {
        return new ElementVerificationMethods(domElement, this);
    }

    public boolean isEnabled(GuiElement guiElement) {
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds);
        if (webElement == null) {
            return false;
        }
        boolean interactionable = webElement.isEnabled() && webElement.isDisplayed();
        this.log(LogLevel.DEBUG, "Checking if " + ((DomElement)guiElement).LogIdentification() + " is interactionable and " + String.valueOf(interactionable).toLowerCase().replace("true", "it seems to be both displayed and enabled.").replace("false", " it is not."));
        return interactionable;
    }

    public ActionResult selectInMultipleChoiceDropdown(GuiElement dropdownElement, ArrayList<String> selectedOptions) {
        return new ActionResult(this.selectInDropdownManager((GuiElement)dropdownElement, selectedOptions).wasSuccess, dropdownElement, this);
    }

    public ActionResult selectInDropdown(GuiElement guiElement, String selection) {
        ArrayList<String> selectionsList = new ArrayList<String>();
        selectionsList.add(selection);
        return new ActionResult(this.selectInDropdownManager((GuiElement)guiElement, selectionsList).wasSuccess, guiElement, this);
    }

    public ActionResult chooseRadioButton(GuiElement radioButtonContainer, String text) {
        DomElement domElement = (DomElement)radioButtonContainer;
        if (text == null) {
            this.log(LogLevel.DEBUG, "Did not choose anything in " + domElement.LogIdentification() + " since there was no input to select.");
            return new ActionResult(false, radioButtonContainer, this);
        }
        WebElement webElement = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds);
        if (webElement == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not identify radio button element " + domElement.LogIdentification() + " where '" + text + "' was supposed to be selected. Continuing test case execution nevertheless.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return new ActionResult(false, domElement, this);
        }
        if (!webElement.getTagName().toLowerCase().equals("form")) {
            if (webElement.getTagName().toLowerCase().equals("input") && (webElement.getText().contains(text) || webElement.getAttribute("value").contains(text))) {
                webElement.click();
                this.log(LogLevel.EXECUTED, "Clicked the '" + webElement.getAttribute("value") + "' radiobutton element.");
                return new ActionResult(true, domElement, this);
            }
            this.log(LogLevel.EXECUTION_PROBLEM, "Trying to select '" + text + "' in radio button set " + domElement.LogIdentification() + ". However the tag of the element is not 'form', but '" + webElement.getTagName() + "'.");
            this.saveScreenshot(webElement);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return new ActionResult(false, domElement, this);
        }
        ArrayList<String> optionStrings = new ArrayList<String>();
        try {
            List optionButtons = webElement.findElements(By.xpath((String)"//*[@type='radio']"));
            this.log(LogLevel.DEBUG, "Found " + optionButtons.size() + " options for radiobutton.");
            if (optionButtons.size() == 0) {
                this.log(LogLevel.FRAMEWORK_ERROR, "Could not identify any radiobuttons within " + domElement.LogIdentification() + ". Does it contain elements of type 'radio'?");
                this.saveScreenshot(webElement);
                this.saveDesktopScreenshot();
                this.saveHtmlContentOfCurrentPage();
                this.writeRunningProcessListDeviationsSinceTestCaseStart();
                return new ActionResult(false, domElement, this);
            }
            for (WebElement optionButton : optionButtons) {
                if (optionButton.isSelected()) {
                    this.log(LogLevel.DEBUG, "Initial selected value in " + domElement.LogIdentification() + " was '" + optionButton.getText() + "'.");
                    if (optionButton.getText().equals(text)) {
                        this.log(LogLevel.EXECUTED, "Made sure the radiobutton " + domElement.LogIdentification() + " had the value '" + text + "' checked, and it already did.");
                        return new ActionResult(true, domElement, this);
                    }
                }
                if (optionButton.isDisplayed()) {
                    optionStrings.add(optionButton.getText() + " (value='" + optionButton.getAttribute("value") + "')" + String.valueOf(optionButton.isEnabled()).toLowerCase().replace("false", " (not enabled)").replace("true", ""));
                    continue;
                }
                optionStrings.add(optionButton.getText() + " (hidden field)" + String.valueOf(optionButton.isEnabled()).toLowerCase().replace("false", " (not enabled)").replace("true", ""));
            }
            for (WebElement optionButton : optionButtons) {
                if (!optionButton.getText().equals(text)) continue;
                optionButton.click();
                this.log(LogLevel.EXECUTED, "Clicked the '" + text + "' radiobutton of " + domElement.LogIdentification() + ".");
                return new ActionResult(true, domElement, this);
            }
            for (WebElement optionButton : optionButtons) {
                if (!optionButton.getAttribute("value").equals(text)) continue;
                optionButton.click();
                this.log(LogLevel.EXECUTED, "Clicked the '" + text + "' radiobutton of " + domElement.LogIdentification() + ".");
                return new ActionResult(true, domElement, this);
            }
            this.errorManagementProcedures("Could not click the '" + text + "' radiobutton of " + domElement.LogIdentification() + ". Available options are '" + String.join((CharSequence)"', '", optionStrings) + "'.", webElement);
        }
        catch (Exception e) {
            this.log(LogLevel.FRAMEWORK_ERROR, "Method 'chooseRadioButton()' crashed with error." + e.getMessage());
            this.saveScreenshot(webElement);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            this.haltFurtherExecution();
        }
        return new ActionResult(false, domElement, this);
    }

    public ActionResult manageCheckbox(GuiElement checkboxElement, Boolean expectedToBeTicked) {
        long startTime = System.currentTimeMillis();
        DomElement domElement = (DomElement)checkboxElement;
        if (expectedToBeTicked == null) {
            this.log(LogLevel.DEBUG, "Leaving checkbox " + domElement.LogIdentification() + " without interaction since input was null.");
            return new ActionResult(true, checkboxElement, this);
        }
        WebElement webElement = null;
        boolean success = false;
        while (!success && System.currentTimeMillis() - startTime <= (long)(this.standardTimeoutInSeconds * 1000)) {
            webElement = this.getRuntimeElementWithoutLogging(domElement);
            if (webElement == null) {
                this.wait(50);
                continue;
            }
            if (!webElement.getTagName().toLowerCase().equals("input") || !webElement.getAttribute("type").toLowerCase().equals("checkbox")) {
                List subElements = webElement.findElements(By.xpath((String)"//input"));
                if (subElements.size() == 1) {
                    if (!((WebElement)subElements.get(0)).isSelected() == expectedToBeTicked) {
                        ((WebElement)subElements.get(0)).click();
                        this.log(LogLevel.EXECUTED, "Clicked the " + domElement.LogIdentification() + " to make it " + String.valueOf(expectedToBeTicked).toLowerCase().replace("true", "ticked").replace("false", "unticked") + ".");
                        success = true;
                        continue;
                    }
                    this.log(LogLevel.EXECUTED, "Made sure that " + domElement.LogIdentification() + " was " + String.valueOf(expectedToBeTicked).toLowerCase().replace("true", "ticked").replace("false", "un-ticked") + ". And it already was.");
                    success = true;
                    continue;
                }
                this.log(LogLevel.EXECUTION_PROBLEM, "Element " + domElement.LogIdentification() + " was expected to be a 'input' tag with the type 'checkbox', but it seem to be a '" + webElement.getTagName() + "' tag with type '" + webElement.getAttribute("type") + "'.");
                webElement = null;
                this.saveScreenshot(null);
                this.saveDesktopScreenshot();
                this.saveHtmlContentOfCurrentPage();
                this.writeRunningProcessListDeviationsSinceTestCaseStart();
                this.haltFurtherExecution();
                continue;
            }
            try {
                if (webElement.isSelected() == expectedToBeTicked.booleanValue()) {
                    this.log(LogLevel.EXECUTED, "Made sure the " + domElement.LogIdentification() + " was " + String.valueOf(expectedToBeTicked).toLowerCase().replace("true", "ticked").replace("false", "unticked") + ", and it already was.");
                    success = true;
                } else {
                    webElement.click();
                    this.log(LogLevel.EXECUTED, "Clicked on the " + domElement.LogIdentification() + " checkbox since it was expected to be " + String.valueOf(expectedToBeTicked).toLowerCase().replace("true", "ticked").replace("false", "unticked") + " but it was not.");
                    success = true;
                }
                return new ActionResult(true, checkboxElement, this);
            }
            catch (Exception e) {
                this.log(LogLevel.FRAMEWORK_ERROR, "Something went wrong while interacting with the " + domElement.LogIdentification() + " checkbox. " + e.getMessage());
                this.errorManagementProcedures("This should not happen.", webElement);
            }
        }
        if (webElement == null) {
            this.errorManagementProcedures("Could not identify the checkbox " + domElement.LogIdentification() + ". Was supposed to " + String.valueOf(expectedToBeTicked).toLowerCase().replace("true", "tick").replace("false", "untick") + " it.", null);
        }
        return new ActionResult(false, checkboxElement, this);
    }

    public String getSelectedValueFromDropdown(GuiElement guiElement) {
        Select dropdown;
        ArrayList<String> selectedStrings = new ArrayList<String>();
        DomElement domElement = (DomElement)guiElement;
        WebElement webElement = this.waitForElementToBeEnabled(guiElement, this.standardTimeoutInSeconds);
        if (webElement == null) {
            this.log(LogLevel.DEBUG, "Could not identify the element " + domElement.LogIdentification() + " to get current selection from.");
            return null;
        }
        try {
            dropdown = new Select(webElement);
        }
        catch (Exception e) {
            this.log(LogLevel.DEBUG, "Could not cast WebElement to type Select (=DropDown). " + e.getMessage());
            return null;
        }
        List selections = dropdown.getAllSelectedOptions();
        for (WebElement selection : selections) {
            try {
                selectedStrings.add(selection.getText());
            }
            catch (Exception e) {
                this.log(LogLevel.DEBUG, "Could not get text value for selected element when attempting to get selections for " + domElement.LogIdentification() + ". " + e.getMessage());
            }
        }
        return "['" + String.join((CharSequence)"','", selectedStrings) + "']";
    }

    @Deprecated
    public void verifyImage(GuiElement guiElement, String pathToOracleImage) {
        this.log(LogLevel.FRAMEWORK_ERROR, "Method 'verifyImage()' is not yet implemented.");
        this.saveScreenshot(this.getRuntimeElementWithoutLogging((DomElement)guiElement));
        this.saveDesktopScreenshot();
        this.saveHtmlContentOfCurrentPage();
        this.writeRunningProcessListDeviationsSinceTestCaseStart();
    }

    private ActionResult selectInDropdownManager(GuiElement dropdownElement, List<String> selections) {
        DomElement domElement = (DomElement)dropdownElement;
        if (selections == null || selections.size() == 0) {
            this.log(LogLevel.DEBUG, "Did not choose anything in " + domElement.LogIdentification() + " since there was no input to select.");
            return new ActionResult(true, dropdownElement, this);
        }
        WebElement webElement = this.waitForElementToBeEnabled(domElement, this.standardTimeoutInSeconds);
        if (webElement == null) {
            this.errorManagementProcedures("Could not identify element " + domElement.LogIdentification() + " where '" + String.join((CharSequence)"', '", selections) + "' was supposed to be selected. Continuing test case execution nevertheless.", null);
            return new ActionResult(false, dropdownElement, this);
        }
        if (!webElement.getTagName().toLowerCase().equals("select")) {
            this.errorManagementProcedures("Trying to select '" + String.join((CharSequence)"', '", selections) + "' in dropdown " + domElement.LogIdentification() + ". However the tag of the element is not 'select', but '" + webElement.getTagName() + "'.", webElement);
        }
        boolean allSelectionsOkSoFar = true;
        ArrayList<String> nonSelectedStrings = new ArrayList<String>();
        ArrayList<String> optionStrings = new ArrayList<String>();
        try {
            Select select = new Select(webElement);
            ArrayList<String> selectedOptions = new ArrayList<String>();
            for (WebElement selectedOption : select.getAllSelectedOptions()) {
                selectedOptions.add(selectedOption.getText());
            }
            this.log(LogLevel.DEBUG, "Initial selected value(s) in " + domElement.LogIdentification() + ": '" + String.join((CharSequence)"', '", selectedOptions) + "'.");
            List options = select.getOptions();
            for (WebElement option : options) {
                if (option.isDisplayed()) {
                    optionStrings.add(option.getText() + String.valueOf(option.isEnabled()).toLowerCase().replace("false", " (not enabled)").replace("true", ""));
                    continue;
                }
                optionStrings.add(option.getText() + " (hidden field)" + String.valueOf(option.isEnabled()).toLowerCase().replace("false", " (not enabled)").replace("true", ""));
            }
            if (select.isMultiple()) {
                select.deselectAll();
            }
            for (String selection : selections) {
                boolean thisSelectionPerformed = false;
                for (WebElement option : options) {
                    if (!option.isDisplayed() || !option.isEnabled() || !option.getText().equals(selection)) continue;
                    select.selectByVisibleText(selection);
                    thisSelectionPerformed = true;
                    break;
                }
                if (thisSelectionPerformed) continue;
                nonSelectedStrings.add(selection);
                allSelectionsOkSoFar = false;
            }
        }
        catch (Exception e) {
            this.log(LogLevel.FRAMEWORK_ERROR, "Something went terribly bad while trying to select '" + String.join((CharSequence)"', '", selections) + "' in " + domElement.LogIdentification() + ". " + e.getMessage());
            this.errorManagementProcedures("This should not happen.", webElement);
        }
        if (allSelectionsOkSoFar) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.DEBUG, "Found available options in " + domElement.LogIdentification() + ": '" + String.join((CharSequence)"', '", optionStrings) + "'.", "Found available options in " + domElement.LogIdentification() + ": '" + String.join((CharSequence)"', '", optionStrings) + "'.");
            this.log(LogLevel.EXECUTED, "Selected '" + String.join((CharSequence)"', '", selections) + "' in dropdown " + domElement.LogIdentification());
            return new ActionResult(true, domElement, this);
        }
        this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTION_PROBLEM, "Could not select '" + String.join((CharSequence)"', '", nonSelectedStrings) + "' in element " + domElement.LogIdentification() + " when attempting to select '" + String.join((CharSequence)"', '", selections) + "'. Available options are :'" + String.join((CharSequence)"', '", optionStrings) + "'.", "Could not select:<ul><li>'" + String.join((CharSequence)"'</li><li>'", nonSelectedStrings) + "'</li></ul> in element " + domElement.LogIdentification() + " when attempting to select: <ul><li>'" + String.join((CharSequence)"'</li><li>'", selections) + "'</li></ul>. Available options are:<ul><li>'" + String.join((CharSequence)"'</li><li>'", optionStrings) + "'</li></ul>.");
        this.saveScreenshot(webElement);
        this.saveDesktopScreenshot();
        this.saveHtmlContentOfCurrentPage();
        this.writeRunningProcessListDeviationsSinceTestCaseStart();
        this.haltFurtherExecution();
        return new ActionResult(false, domElement, this);
    }

    @Deprecated
    public void verifyTableRows(GuiElement guiElement, String[] headlineColonValueSemicolonSeparatedString, CellMatchingType cellMatchingType) {
        TableData tableData;
        boolean doneOk = false;
        long startTime = System.currentTimeMillis();
        while (!doneOk && System.currentTimeMillis() - startTime <= (long)(this.standardTimeoutInSeconds * 1000)) {
            tableData = this.tableDataFromGuiElement(guiElement, false);
            if (tableData == null) {
                DomElement table = (DomElement)guiElement;
                this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Table data for " + table.LogIdentification() + " is null.");
                this.saveScreenshot(this.getRuntimeElementWithoutLogging(table));
                this.saveDesktopScreenshot();
                this.saveHtmlContentOfCurrentPage();
                this.writeRunningProcessListDeviationsSinceTestCaseStart();
                return;
            }
            boolean nonErroneous = true;
            for (String searchPattern : headlineColonValueSemicolonSeparatedString) {
                if (tableData.rowExist(searchPattern, cellMatchingType)) continue;
                nonErroneous = false;
            }
            if (!nonErroneous) continue;
            doneOk = true;
        }
        tableData = this.tableDataFromGuiElement(guiElement, true);
        if (tableData == null) {
            return;
        }
        tableData.verifyRows(headlineColonValueSemicolonSeparatedString, cellMatchingType);
    }

    @Deprecated
    public void verifyTableRow(GuiElement tableElement, String headlineColonValueSemicolonSeparatedString, CellMatchingType cellMatchingType) {
        TableData tableData;
        DomElement domElement = (DomElement)tableElement;
        long startTime = System.currentTimeMillis();
        boolean found = this.waitForElementToAppear((GuiElement)tableElement).wasSuccess;
        if (!found) {
            this.log(LogLevel.VERIFICATION_PROBLEM, "Could not identify " + domElement.LogIdentification() + " within timeout. Could not verify row data '" + headlineColonValueSemicolonSeparatedString + "'.");
            return;
        }
        boolean doneOk = false;
        while (!doneOk && System.currentTimeMillis() - startTime <= (long)(this.standardTimeoutInSeconds * 1000)) {
            try {
                tableData = this.tableDataFromGuiElement(tableElement, false);
            }
            catch (Exception ignored) {
                tableData = null;
            }
            if (tableData == null) {
                this.wait(50);
                continue;
            }
            doneOk = tableData.rowExist(headlineColonValueSemicolonSeparatedString, cellMatchingType);
        }
        tableData = this.tableDataFromGuiElement(tableElement, true);
        if (tableData == null) {
            this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Could not retrieve data from " + domElement.LogIdentification() + ".");
            this.saveScreenshot(this.getRuntimeElementWithoutLogging(domElement));
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return;
        }
        if (!tableData.verifyRowExist(headlineColonValueSemicolonSeparatedString, cellMatchingType)) {
            this.saveScreenshot(this.getRuntimeElementWithoutLogging(domElement));
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    public ActionResult reloadPage() {
        try {
            this.driver.navigate().refresh();
            return new ActionResult(true, null, this);
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not reload page. Error: " + e);
            return new ActionResult(false, null, this);
        }
    }

    @Deprecated
    public void verifyTableHeadline(GuiElement tableElement, String expectedHeadline) {
        TableData tableData = this.tableDataFromGuiElement(tableElement, true);
        if (tableData == null) {
            return;
        }
        if (!tableData.verifyHeadingExist(expectedHeadline)) {
            this.saveScreenshot(this.getRuntimeElementWithoutLogging((DomElement)tableElement));
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    public TableData tableDataFromGuiElement(GuiElement guiElement, boolean logErrors) {
        List rows;
        DomElement domElement = (DomElement)guiElement;
        boolean found = this.waitForElementToAppear((GuiElement)guiElement).wasSuccess;
        if (!found) {
            this.testCase.log(LogLevel.DEBUG, "Could not find " + domElement.LogIdentification() + " within timeout.");
            return null;
        }
        StringBuilder tableContent = new StringBuilder();
        WebElement tableElement = this.getRuntimeElementWithoutLogging(domElement);
        if (!tableElement.getTagName().toLowerCase().equals("table")) {
            try {
                tableElement = tableElement.findElement(By.xpath((String)".//table"));
            }
            catch (Exception ignored) {
                this.testCase.log(LogLevel.DEBUG, "The " + domElement.LogIdentification() + " is not of 'table' tag, and it does not seem to have any child element of type 'table' either.");
            }
        }
        if (tableElement == null) {
            if (logErrors) {
                this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Could not create TableData from " + domElement.LogIdentification() + ". Check debug for more info.");
            }
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return null;
        }
        try {
            rows = tableElement.findElements(By.xpath((String)"./tr"));
        }
        catch (Exception e) {
            if (logErrors) {
                this.testCase.log(LogLevel.DEBUG, "Cannot get hold of table rows directly under the TABLE element for HTML table " + domElement.LogIdentification() + ".");
            }
            rows = new ArrayList();
        }
        if (rows.size() == 0) {
            try {
                rows = tableElement.findElements(By.xpath((String)"./*/tr"));
            }
            catch (Exception e) {
                if (logErrors) {
                    this.testCase.log(LogLevel.DEBUG, "Cannot get hold of table rows one step below the TABLE element for HTML table " + domElement.LogIdentification() + ".");
                }
                rows = new ArrayList();
            }
        }
        if (rows.size() == 0) {
            try {
                rows = tableElement.findElements(By.xpath((String)".//tr"));
            }
            catch (Exception e) {
                if (logErrors) {
                    this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Cannot get hold of any table rows for HTML table " + domElement.LogIdentification() + ".");
                }
                this.saveScreenshot(tableElement);
                this.saveDesktopScreenshot();
                this.saveHtmlContentOfCurrentPage();
                this.writeRunningProcessListDeviationsSinceTestCaseStart();
                return null;
            }
        }
        for (WebElement row : rows) {
            List cells;
            block36: {
                block35: {
                    block34: {
                        cells = new ArrayList();
                        try {
                            cells = row.findElements(By.xpath((String)"(./td|./th)"));
                        }
                        catch (Exception e) {
                            if (!logErrors) break block34;
                            this.testCase.log(LogLevel.DEBUG, "Cannot find any table cells directly under the ROW element for table " + domElement.LogIdentification() + " for row '" + row.toString() + "'.");
                            cells = new ArrayList();
                        }
                    }
                    if (cells.size() == 0) {
                        try {
                            cells = row.findElements(By.xpath((String)"(./*/td|./*/th)"));
                        }
                        catch (Exception e) {
                            if (!logErrors) break block35;
                            this.testCase.log(LogLevel.DEBUG, "Cannot find any table cells one step below the ROW element for table " + domElement.LogIdentification() + " for row '" + row.toString() + "'.");
                            cells = new ArrayList();
                        }
                    }
                }
                if (cells.size() == 0) {
                    try {
                        cells = row.findElements(By.xpath((String)"(.//td|.//th)"));
                    }
                    catch (Exception e) {
                        if (!logErrors) break block36;
                        this.testCase.log(LogLevel.DEBUG, "Cannot find any table cells for row '" + row.toString() + "' in table " + domElement.LogIdentification() + ".");
                        this.saveScreenshot(tableElement);
                        this.saveDesktopScreenshot();
                        this.saveHtmlContentOfCurrentPage();
                        this.writeRunningProcessListDeviationsSinceTestCaseStart();
                    }
                }
            }
            if (cells.size() == 0) {
                tableContent.append(";");
                tableContent.append(SupportMethods.LF);
                continue;
            }
            for (WebElement cell : cells) {
                Integer colSpan;
                try {
                    colSpan = Integer.parseInt(cell.getAttribute("colspan"));
                }
                catch (Exception ignored) {
                    colSpan = 1;
                }
                if (colSpan == null) {
                    colSpan = 1;
                }
                for (int i = 0; i < colSpan; ++i) {
                    try {
                        tableContent.append(cell.getText().replace(";", " ").replace(System.lineSeparator(), " ")).append(";");
                        continue;
                    }
                    catch (Exception e) {
                        this.testCase.log(LogLevel.DEBUG, "Could not read text from table cell. Replacing with ''.");
                        tableContent.append(";");
                    }
                }
            }
            tableContent.append(SupportMethods.LF);
        }
        return new TableData(this.testCase, domElement.LogIdentification(), tableContent.toString());
    }

    public boolean tableRowExists(GuiElement tableElement, String headlineColonValueSemicolonSeparatedString, boolean regex) {
        if (regex) {
            return this.tableRowExists(tableElement, headlineColonValueSemicolonSeparatedString, CellMatchingType.REGEX_MATCH);
        }
        return this.tableRowExists(tableElement, headlineColonValueSemicolonSeparatedString, CellMatchingType.CONTAINS_MATCH);
    }

    public boolean tableRowExists(GuiElement tableElement, String headlineColonValueSemicolonSeparatedString, CellMatchingType cellMatchingType) {
        this.getRuntimeElementWithTimeout((DomElement)tableElement, this.standardTimeoutInSeconds);
        TableData tableData = this.tableDataFromGuiElement(tableElement, false);
        return tableData != null && tableData.rowExist(headlineColonValueSemicolonSeparatedString, cellMatchingType);
    }

    public boolean tableRowExistsWithTimeout(GuiElement tableElement, String headlineColonValueSemicolonSeparatedString, CellMatchingType cellMatchingType) {
        boolean doneOk = false;
        long startTime = System.currentTimeMillis();
        while (!doneOk && System.currentTimeMillis() - startTime <= (long)(this.standardTimeoutInSeconds * 1000)) {
            TableData tableData = this.tableDataFromGuiElement(tableElement, false);
            if (tableData == null) continue;
            doneOk = tableData.rowExist(headlineColonValueSemicolonSeparatedString, cellMatchingType);
        }
        return doneOk;
    }

    @Deprecated
    public void verifyTableHeadlines(GuiElement tableElement, List<String> expectedHeadlines) {
        DomElement table = (DomElement)tableElement;
        boolean found = this.waitForElementToAppear((GuiElement)tableElement).wasSuccess;
        if (!found) {
            this.log(LogLevel.VERIFICATION_PROBLEM, "Could not find " + table.LogIdentification() + " to verify headlines '" + String.join((CharSequence)"', '", expectedHeadlines) + "' in.");
            return;
        }
        TableData tableData = this.tableDataFromGuiElement(tableElement, false);
        if (tableData == null) {
            this.testCase.log(LogLevel.FRAMEWORK_ERROR, "Could not construct TableData for HTML table " + ((DomElement)tableElement).LogIdentification() + " when trying to verify headlines '" + String.join((CharSequence)"', '", expectedHeadlines) + "'.");
            this.saveScreenshot(this.getRuntimeElementWithoutLogging((DomElement)tableElement));
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return;
        }
        if (!tableData.verifyHeadingsExist(expectedHeadlines)) {
            this.saveScreenshot(this.getRuntimeElementWithoutLogging(table));
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
        }
    }

    public boolean tableIsEmpty(GuiElement tableElement) {
        this.getRuntimeElementWithTimeout((DomElement)tableElement, this.standardTimeoutInSeconds);
        TableData tableData = this.tableDataFromGuiElement(tableElement, true);
        return tableData != null && tableData.tableIsEmpty();
    }

    private ActionResult goToUrl(String url) throws NavigationError {
        try {
            this.driver.navigate().to(url);
            return new ActionResult(true, null, this);
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not go to url '" + url + "'. Error: " + e);
            return new ActionResult(false, null, this);
        }
    }

    private void enterText(WebElement element, String text, boolean clearElement) throws TextEnteringError {
        if (element != null) {
            try {
                if (clearElement) {
                    element.clear();
                    this.log(LogLevel.DEBUG, "Clearing existing text " + element.getText());
                }
                element.sendKeys(new CharSequence[]{text});
                this.log(LogLevel.DEBUG, "Sending keys '" + text + "'.");
            }
            catch (Exception e) {
                this.log(LogLevel.EXECUTION_PROBLEM, "Could not send keys '" + text + "'.");
                this.saveScreenshot(element);
                this.saveDesktopScreenshot();
                this.saveHtmlContentOfCurrentPage();
                this.writeRunningProcessListDeviationsSinceTestCaseStart();
                throw new TextEnteringError();
            }
        } else {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not send keys '" + text + "' since the webElement was null.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            throw new TextEnteringError();
        }
    }

    public ActionResult saveHtmlContentOfCurrentPage() {
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        String LF = SupportMethods.LF;
        String htmlStyle = "          pre              { font-family: Consolas, Menlo, Monaco, Lucida Console, Liberation Mono, DejaVu Sans Mono, Bitstream Vera Sans Mono, Courier New, monospace, serif;" + LF + "                             margin-bottom: 10px;" + LF + "                             overflow: auto;" + LF + "                             width: auto;" + LF + "                             padding: 5px;" + LF + "                             background-color: #eee;" + LF + "                             width: 100%;" + LF + "                             padding-bottom: 20px!ie7;" + LF + "                             max - height: 600px;" + LF + "          }" + LF;
        String html = "<!DOCTYPE html>" + LF + "<html lang=\"en\">" + LF + LF + "   <head>" + LF + "      <title>Source code of page</title>" + LF + "      <style>" + htmlStyle + "      </style>" + LF + "   </head>" + LF + "   <body>" + LF + "         " + StringManagement.htmlContentToDisplayableHtmlCode((String)this.driver.getPageSource()) + LF + LF + "   </body>" + LF + "</html>" + LF;
        String filePath = LogFolder.testRunLogFolder + this.testCase.testName + TestRun.getFileCounter() + ".html";
        TestRun.increaseFileCounter();
        SupportMethods.saveToFile((String)html, (String)filePath);
        this.logPageSourceSaving(filePath);
        return new ActionResult(true, null, this);
    }

    private void logPageSourceSaving(String filePath) {
        String htmlFilePath = filePath.replace("\\", "/");
        String[] parts = htmlFilePath.split("/");
        htmlFilePath = parts[parts.length - 1];
        this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.INFO, "Page source saved as '" + filePath + "'.", "Page source saved as <a href=\"" + htmlFilePath + "\" target=\"_blank\"><span class=\"htmlsourcefilepath\">" + filePath + "</span></a>");
    }

    public void haltFurtherExecution() {
        this.log(LogLevel.INFO, "Halting further execution due to perceived problems.");
        this.makeSureDriverIsClosed();
        this.testCase.report();
    }

    public WebElement getRuntimeElementWithoutLogging(DomElement element) {
        if (element == null) {
            return null;
        }
        List<WebElement> relevantWebElements = this.gatherRelevantElements(element, false);
        return this.mostRelevantElement(relevantWebElements, element, false);
    }

    public WebElement getRuntimeElementWithoutLogging(DomElement parent, DomElement descendantToReturn) {
        if (parent == null || descendantToReturn == null) {
            return null;
        }
        List<WebElement> relevantWebElements = this.gatherRelevantElements(parent, descendantToReturn, false);
        return this.mostRelevantElement(relevantWebElements, descendantToReturn, false);
    }

    private List<WebElement> gatherRelevantElements(DomElement element, boolean performLogging) {
        ArrayList<WebElement> webElements;
        block22: {
            Object returnElement;
            if (this.driver == null) {
                if (performLogging) {
                    this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
                }
                this.haltFurtherExecution();
            }
            webElements = new ArrayList<WebElement>();
            if (element == null) {
                if (performLogging) {
                    this.log(LogLevel.DEBUG, "Trying to get relevant WebElements for DomElement that is null.");
                }
                return webElements;
            }
            if (element.by != null && (returnElement = WebElementIdentifier.getWebElement(this.testCase, this.driver, element, true)) != null) {
                webElements.add((WebElement)returnElement);
                return webElements;
            }
            try {
                if (element.recognitionStrings == null) {
                    return webElements;
                }
                for (String recognitionString : element.recognitionStrings) {
                    if (element.identificationType == DomElement.IdentificationType.BY_LINK_TEXT) {
                        webElements.addAll(this.driver.findElements(By.linkText((String)recognitionString)));
                        continue;
                    }
                    if (element.identificationType == DomElement.IdentificationType.BY_ID) {
                        webElements.addAll(this.driver.findElements(By.id((String)recognitionString)));
                        continue;
                    }
                    if (element.identificationType == DomElement.IdentificationType.BY_X_PATH) {
                        webElements.addAll(this.driver.findElements(By.xpath((String)recognitionString)));
                        continue;
                    }
                    if (element.identificationType == DomElement.IdentificationType.BY_NAME) {
                        webElements.addAll(this.driver.findElements(By.name((String)recognitionString)));
                        continue;
                    }
                    if (element.identificationType == DomElement.IdentificationType.BY_CSS) {
                        webElements.addAll(this.driver.findElements(By.cssSelector((String)recognitionString)));
                        continue;
                    }
                    if (element.identificationType == DomElement.IdentificationType.BY_CLASS) {
                        webElements.addAll(this.driver.findElements(By.className((String)recognitionString)));
                        continue;
                    }
                    if (element.identificationType == DomElement.IdentificationType.BY_VISIBLE_TEXT) {
                        webElements.addAll(this.driver.findElements(By.xpath((String)("//*[.='" + recognitionString + "']"))));
                        if (webElements.size() != 0) continue;
                        webElements.addAll(this.driver.findElements(By.xpath((String)("//*[contains(text(), '" + recognitionString + "')]"))));
                        continue;
                    }
                    if (element.identificationType == DomElement.IdentificationType.BY_ATTRIBUTE_VALUE) {
                        if (!recognitionString.contains("=")) {
                            if (!performLogging) continue;
                            this.log(LogLevel.EXECUTION_PROBLEM, "Identifying elements by attribute value needs attribute value stated as 'attribute_name=attribute_value', for example 'href=http://myserver.com/mylink' or possibly 'href=\"http://myserver.com/mylink\"'." + System.lineSeparator() + "For element " + element.name + " the recognition string was '" + recognitionString + ".");
                            continue;
                        }
                        String attributeName = recognitionString.split("=")[0];
                        String attributeValue = recognitionString.substring(recognitionString.indexOf("=") + 1);
                        if (attributeValue.startsWith("\"") && attributeValue.endsWith("\"")) {
                            attributeValue = attributeValue.substring(1, attributeValue.length() - 1);
                        } else if (attributeValue.startsWith("'") && attributeValue.endsWith("'")) {
                            attributeValue = attributeValue.substring(1, attributeValue.length() - 1);
                        }
                        webElements.addAll(this.driver.findElements(By.xpath((String)("//*[@" + attributeName + "='" + attributeValue + "']"))));
                        continue;
                    }
                    if (performLogging) {
                        this.log(LogLevel.FRAMEWORK_ERROR, "Tried to identify " + element.LogIdentification() + ", but the IdentificationType '" + element.identificationType.toString() + "' was not supported in getRuntimeElementWithoutLogging() method.");
                    }
                    this.saveDesktopScreenshot();
                    this.saveHtmlContentOfCurrentPage();
                }
            }
            catch (Exception e) {
                if (!performLogging) break block22;
                this.log(LogLevel.DEBUG, "Tried to identify " + element.LogIdentification() + ", but something went wrong. " + e.getMessage());
            }
        }
        return webElements;
    }

    private List<WebElement> gatherRelevantElements(DomElement parentDomElement, DomElement descendantToFind, boolean performLogging) {
        ArrayList<WebElement> webElements;
        block23: {
            if (this.driver == null) {
                if (performLogging) {
                    this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
                }
                this.haltFurtherExecution();
            }
            if (parentDomElement == null) {
                return null;
            }
            WebElement parent = this.getRuntimeElementWithoutLogging(parentDomElement);
            if (parent == null) {
                if (performLogging) {
                    this.log(LogLevel.EXECUTION_PROBLEM, "Cannot find parent element " + parentDomElement.LogIdentification() + " so cannot find the DomElement " + descendantToFind.LogIdentification() + " among its descendants.");
                }
                return null;
            }
            webElements = new ArrayList<WebElement>();
            if (descendantToFind == null) {
                if (performLogging) {
                    this.log(LogLevel.DEBUG, "Trying to get relevant WebElements for DomElement that is null.");
                }
                return webElements;
            }
            try {
                for (String recognitionString : descendantToFind.recognitionStrings) {
                    if (descendantToFind.identificationType == DomElement.IdentificationType.BY_LINK_TEXT) {
                        webElements.addAll(parent.findElements(By.linkText((String)recognitionString)));
                        continue;
                    }
                    if (descendantToFind.identificationType == DomElement.IdentificationType.BY_ID) {
                        webElements.addAll(parent.findElements(By.id((String)recognitionString)));
                        continue;
                    }
                    if (descendantToFind.identificationType == DomElement.IdentificationType.BY_X_PATH) {
                        webElements.addAll(parent.findElements(By.xpath((String)recognitionString)));
                        continue;
                    }
                    if (descendantToFind.identificationType == DomElement.IdentificationType.BY_NAME) {
                        webElements.addAll(parent.findElements(By.name((String)recognitionString)));
                        continue;
                    }
                    if (descendantToFind.identificationType == DomElement.IdentificationType.BY_CSS) {
                        webElements.addAll(parent.findElements(By.cssSelector((String)recognitionString)));
                        continue;
                    }
                    if (descendantToFind.identificationType == DomElement.IdentificationType.BY_CLASS) {
                        webElements.addAll(parent.findElements(By.className((String)recognitionString)));
                        continue;
                    }
                    if (descendantToFind.identificationType == DomElement.IdentificationType.BY_VISIBLE_TEXT) {
                        webElements.addAll(parent.findElements(By.xpath((String)(".//*[text()='" + recognitionString + "']"))));
                        if (webElements.size() != 0) continue;
                        webElements.addAll(parent.findElements(By.xpath((String)(".//*[contains(text(), '" + recognitionString + "')]"))));
                        continue;
                    }
                    if (descendantToFind.identificationType == DomElement.IdentificationType.BY_ATTRIBUTE_VALUE) {
                        if (!recognitionString.contains("=")) {
                            if (!performLogging) continue;
                            this.log(LogLevel.EXECUTION_PROBLEM, "Identifying elements by attribute value needs attribute value stated as 'attribute_name=attribute_value', for example 'href=http://myserver.com/mylink' or possibly 'href=\"http://myserver.com/mylink\"'." + System.lineSeparator() + "For element " + descendantToFind.name + " the recognition string was '" + recognitionString + ".");
                            continue;
                        }
                        String attributeName = recognitionString.split("=")[0];
                        String attributeValue = recognitionString.substring(recognitionString.indexOf("=") + 1);
                        if (attributeValue.startsWith("\"") && attributeValue.endsWith("\"")) {
                            attributeValue = attributeValue.substring(1, attributeValue.length() - 1);
                        } else if (attributeValue.startsWith("'") && attributeValue.endsWith("'")) {
                            attributeValue = attributeValue.substring(1, attributeValue.length() - 1);
                        }
                        webElements.addAll(this.driver.findElements(By.xpath((String)("//*[@" + attributeName + "='" + attributeValue + "']"))));
                        continue;
                    }
                    if (performLogging) {
                        this.log(LogLevel.FRAMEWORK_ERROR, "Tried to identify " + descendantToFind.LogIdentification() + ", but the IdentificationType '" + descendantToFind.identificationType.toString() + "' was not supported in getRuntimeElementWithoutLogging() method.");
                    }
                    this.saveDesktopScreenshot();
                    this.saveHtmlContentOfCurrentPage();
                }
            }
            catch (Exception e) {
                if (!performLogging) break block23;
                this.log(LogLevel.DEBUG, "Tried to identify " + descendantToFind.LogIdentification() + ", but something went wrong. " + e.getMessage());
            }
        }
        return webElements;
    }

    private WebElement mostRelevantElement(List<WebElement> webElements, DomElement element, boolean performLogging) {
        if (webElements.size() == 0) {
            return null;
        }
        String debugString = "Found " + webElements.size() + " elements when trying to identify " + element.LogIdentification() + ". ";
        if (element.ordinalNumber != null) {
            if (webElements.size() <= element.ordinalNumber) {
                if (performLogging) {
                    this.log(LogLevel.DEBUG, debugString + "Using WebElement #" + element.ordinalNumber + ", given by the DomElement object. ");
                }
                return webElements.get(element.ordinalNumber + 1);
            }
            if (performLogging) {
                this.log(LogLevel.DEBUG, debugString + "The ordinal number given by the DomElement object was supposed to be " + element.ordinalNumber + ", so it could not be matched.");
            }
            return null;
        }
        if (webElements.size() == 1) {
            return webElements.get(0);
        }
        ArrayList<WebElement> visibleElementsList = new ArrayList<WebElement>();
        for (WebElement webElement : webElements) {
            if (!webElement.isDisplayed()) continue;
            visibleElementsList.add(webElement);
        }
        if (visibleElementsList.size() == 0) {
            this.log(LogLevel.DEBUG, debugString + "None of these elements were visible. Returning first match and holding thumbs this is the best match.");
            return webElements.get(0);
        }
        if (visibleElementsList.size() == 1) {
            this.log(LogLevel.DEBUG, debugString + "Only one of these was visible. Returning that element, assuming that was the element meant.");
            return (WebElement)visibleElementsList.get(0);
        }
        ArrayList<WebElement> enabledElements = new ArrayList<WebElement>();
        for (WebElement visibleElement : visibleElementsList) {
            if (!visibleElement.isEnabled()) continue;
            enabledElements.add(visibleElement);
        }
        debugString = debugString + visibleElementsList.size() + " of these elements were visible, and out of these " + enabledElements.size() + " were enabled. ";
        if (enabledElements.size() == 0) {
            this.log(LogLevel.DEBUG, debugString + "Using first visible match. No element was enabled, so no element seemed more likely than another.");
            return (WebElement)visibleElementsList.get(0);
        }
        if (enabledElements.size() == 1) {
            this.log(LogLevel.DEBUG, debugString + "Assuming the only enabled element is the element to interact with.");
            return (WebElement)enabledElements.get(0);
        }
        this.log(LogLevel.DEBUG, debugString + visibleElementsList.size() + " of these was visible. Returning the first match in hope of successful execution.");
        return (WebElement)visibleElementsList.get(0);
    }

    public WebElement getRuntimeElementWithTimeout(DomElement element, int timeoutInSeconds) {
        double startTickCount = System.currentTimeMillis();
        WebElement returnElement = this.getRuntimeElementWithoutLogging(element);
        long sleepTime = 50L;
        while (returnElement == null && (double)System.currentTimeMillis() - startTickCount < (double)(timeoutInSeconds * 1000)) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            returnElement = this.getRuntimeElementWithoutLogging(element);
        }
        if (returnElement == null) {
            this.log(LogLevel.DEBUG, "Could not identify element " + element.LogIdentification() + " within the " + timeoutInSeconds + " second timeout.");
        } else {
            this.log(LogLevel.DEBUG, "Identified element " + element.LogIdentification() + " after " + ((double)System.currentTimeMillis() - startTickCount) + " ms.");
        }
        return returnElement;
    }

    WebElement getRuntimeElementWithLogging(DomElement element) {
        if (element == null) {
            return null;
        }
        List<WebElement> relevantWebElements = this.gatherRelevantElements(element, true);
        return this.mostRelevantElement(relevantWebElements, element, true);
    }

    private void closeBrowserDriver() throws BrowserClosingError {
        try {
            this.driver.close();
            this.driver.quit();
        }
        catch (Exception e) {
            throw new BrowserClosingError();
        }
    }

    private void errorManagementProcedures(String errorMessage, WebElement webElement) {
        this.log(LogLevel.EXECUTION_PROBLEM, errorMessage);
        this.saveScreenshot(webElement);
        this.saveDesktopScreenshot();
        this.saveHtmlContentOfCurrentPage();
        this.writeRunningProcessListDeviationsSinceTestCaseStart();
        this.haltFurtherExecution();
    }

    public boolean pageTitleExistWithTimeout(String expectedPageTitle, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000) && !this.driver.getTitle().equals(expectedPageTitle)) {
            this.wait(100);
        }
        boolean success = this.driver.getTitle().equals(expectedPageTitle);
        long timeSpent = System.currentTimeMillis() - startTime;
        if (timeSpent > (long)(timeoutInSeconds * 1000)) {
            timeSpent = timeoutInSeconds * 1000;
        }
        if (success) {
            this.testCase.log(LogLevel.DEBUG, "Waited for page title to become '" + expectedPageTitle + "', and that was identified after " + timeSpent + " milliseconds. ");
        } else {
            this.testCase.log(LogLevel.DEBUG, "Waited for page title to become '" + expectedPageTitle + "', but that did not happen within the " + timeoutInSeconds + " second timeout. Page title is '" + this.driver.getTitle() + "'.");
        }
        return success;
    }

    public boolean pageTitleMatchRegexWithTimeout(String expectedPageTitleRegEx, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000) && !SupportMethods.isRegexMatch((String)this.driver.getTitle(), (String)expectedPageTitleRegEx)) {
            this.wait(100);
        }
        boolean success = SupportMethods.isRegexMatch((String)this.driver.getTitle(), (String)expectedPageTitleRegEx);
        long timeSpent = System.currentTimeMillis() - startTime;
        if (timeSpent > (long)(timeoutInSeconds * 1000)) {
            timeSpent = timeoutInSeconds * 1000;
        }
        if (success) {
            this.testCase.log(LogLevel.DEBUG, "Waited for page title to match regular expression pattern '" + expectedPageTitleRegEx + "', and that was identified after " + timeSpent + " milliseconds. ");
        } else {
            this.testCase.log(LogLevel.DEBUG, "Waited for page title to match regular expression pattern '" + expectedPageTitleRegEx + "', but that did not happen within the " + timeoutInSeconds + " second timeout. Page title is '" + this.driver.getTitle() + "'.");
        }
        return success;
    }

    @Deprecated
    public void verifyBrowserConsoleHasNoErrors_AlsoClearsBrowserConsole() {
        List<LogEntry> logEntries = this.getLogEntriesFromBrowser(Level.SEVERE);
        ArrayList<String> logEntriesAsStrings = new ArrayList<String>();
        for (LogEntry logEntry : logEntries) {
            logEntriesAsStrings.add(logEntry.toString());
        }
        if (logEntries.size() > 0) {
            this.log(LogLevel.VERIFICATION_FAILED, "Browser has the following log posts of at least log level 'severe' in console:" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), logEntriesAsStrings));
        } else {
            this.log(LogLevel.VERIFICATION_PASSED, "Browser had no severe log posts in console.");
        }
    }

    public void logOutputFromBrowserConsole_AlsoClearsBrowserConsole() {
        List<LogEntry> logEntries = this.getLogEntriesFromBrowser(null);
        ArrayList<String> logEntriesAsStrings = new ArrayList<String>();
        for (LogEntry logEntry : logEntries) {
            logEntriesAsStrings.add(logEntry.toString());
        }
        if (logEntriesAsStrings.size() > 0) {
            this.log(LogLevel.INFO, "Browser had the following log posts in console:" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), logEntriesAsStrings));
        } else {
            this.log(LogLevel.INFO, "Browser had an empty console output.");
        }
    }

    public List<LogEntry> getLogEntriesFromBrowser(Level lowestLogLevel) {
        ArrayList<LogEntry> logPosts = new ArrayList<LogEntry>();
        Set logTypes = this.driver.manage().logs().getAvailableLogTypes();
        for (String logType : logTypes) {
            LogEntries logEntries = this.driver.manage().logs().get(logType);
            List logEntryList = logEntries.getAll();
            for (LogEntry logEntry : logEntryList) {
                if (lowestLogLevel != null && logEntry.getLevel().intValue() < lowestLogLevel.intValue()) continue;
                logPosts.add(logEntry);
            }
        }
        return logPosts;
    }

    public boolean waitForElementToFinishAnimation(GuiElement guiElement) {
        DomElement domElement;
        try {
            domElement = (DomElement)guiElement;
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not convert GuiElement to DomElement.");
            return false;
        }
        return this.waitForElementToFinishAnimation(domElement, this.standardTimeoutInSeconds);
    }

    public boolean waitForElementToFinishAnimation(DomElement domElement, int timeoutInSeconds) {
        boolean animationDetected;
        long startTime = System.currentTimeMillis();
        this.waitForElementToAppear(domElement, timeoutInSeconds);
        BufferedImage bufferedImage1 = this.grabElementImage(domElement);
        this.wait(50);
        BufferedImage bufferedImage2 = this.grabElementImage(domElement);
        boolean bl = animationDetected = !this.bufferedImagesAreEqual(bufferedImage1, bufferedImage2);
        while (animationDetected && System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            bufferedImage1 = this.grabElementImage(domElement);
            this.wait(50);
            bufferedImage2 = this.grabElementImage(domElement);
            animationDetected = !this.bufferedImagesAreEqual(bufferedImage1, bufferedImage2);
        }
        if (animationDetected) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Waited " + timeoutInSeconds + " for element " + domElement.LogIdentification() + " to stop animation, but it didn't.");
        } else {
            this.log(LogLevel.DEBUG, "Waited " + (System.currentTimeMillis() - startTime) + " milliseconds until animation of element " + domElement.LogIdentification() + " had stopped.");
        }
        return !animationDetected;
    }

    @Deprecated
    public void verifyElementIsAnimated(DomElement domElement, int timeoutInSeconds) {
        boolean animationHasStarted;
        boolean elementHasFinishedRendering;
        long startTime = System.currentTimeMillis();
        this.waitForElementToAppear(domElement, timeoutInSeconds);
        BufferedImage bufferedImage1 = this.grabElementImage(domElement);
        BufferedImage bufferedImage2 = this.grabElementImage(domElement);
        boolean bl = elementHasFinishedRendering = !this.bufferedImagesAreEqual(bufferedImage1, bufferedImage2);
        while (!elementHasFinishedRendering && System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            this.wait(50);
            bufferedImage2 = this.grabElementImage(domElement);
            elementHasFinishedRendering = !this.bufferedImagesAreEqual(bufferedImage1, bufferedImage2);
        }
        this.wait(50);
        bufferedImage1 = this.grabElementImage(domElement);
        boolean bl2 = animationHasStarted = !this.bufferedImagesAreEqual(bufferedImage1, bufferedImage2);
        while (!animationHasStarted && System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            this.wait(50);
            bufferedImage1 = this.grabElementImage(domElement);
            animationHasStarted = !this.bufferedImagesAreEqual(bufferedImage1, bufferedImage2);
        }
        if (animationHasStarted) {
            this.log(LogLevel.VERIFICATION_PASSED, "Element " + domElement.LogIdentification() + " is detected to be animated.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "Element " + domElement.LogIdentification() + " could not be detected to be animated within the timeout of " + timeoutInSeconds + " seconds.");
            this.saveScreenshot(this.getRuntimeElementWithoutLogging(domElement));
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
        }
    }

    protected boolean bufferedImagesAreEqual(BufferedImage img1, BufferedImage img2) {
        if (img1.getWidth() == img2.getWidth() && img1.getHeight() == img2.getHeight()) {
            for (int x = 0; x < img1.getWidth(); ++x) {
                for (int y = 0; y < img1.getHeight(); ++y) {
                    if (img1.getRGB(x, y) == img2.getRGB(x, y)) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    protected BufferedImage grabElementImage(DomElement domElement) {
        WebElement webElement;
        if (this.driver == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Driver is null.");
            this.haltFurtherExecution();
        }
        if ((webElement = this.getRuntimeElementWithTimeout(domElement, this.standardTimeoutInSeconds)) == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not identify " + domElement.LogIdentification() + " when trying to capture an image of it.");
            this.saveScreenshot(null);
            this.saveDesktopScreenshot();
            this.saveHtmlContentOfCurrentPage();
            this.writeRunningProcessListDeviationsSinceTestCaseStart();
            return null;
        }
        File screen = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
        int ImageWidth = webElement.getSize().getWidth();
        int ImageHeight = webElement.getSize().getHeight();
        Point point = webElement.getLocation();
        int xCoordinate = point.getX();
        int yCoordinate = point.getY();
        BufferedImage img = null;
        try {
            img = ImageIO.read(screen);
        }
        catch (IOException e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not read screenshot of full screenshot when trying to capture an image of " + domElement.LogIdentification() + ".");
            return null;
        }
        return img.getSubimage(xCoordinate, yCoordinate, ImageWidth, ImageHeight);
    }

    public Integer getRuntimeElementMatchCount(DomElement domElement) {
        if (domElement == null) {
            return null;
        }
        List<WebElement> relevantWebElements = this.gatherRelevantElements(domElement, false);
        return relevantWebElements.size();
    }

    private class Waiter {
        private final TestCase testCase;
        private final LogLevel logLevel;
        private final long startTime;
        private int totalTimeInWaiting;

        public Waiter(TestCase testCase, LogLevel logLevel) {
            this.logLevel = logLevel;
            this.testCase = testCase;
            this.startTime = System.currentTimeMillis();
        }

        public void wait(int milliseconds) {
            try {
                Thread.sleep(milliseconds);
                this.totalTimeInWaiting += milliseconds;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void report() {
            this.testCase.log(this.logLevel, "Waited a total of " + (System.currentTimeMillis() - this.startTime) + " milliseconds, with " + this.totalTimeInWaiting + " of those in the waiting mechanism.");
        }

        public int totalTimeSpentSoFar() {
            return (int)(System.currentTimeMillis() - this.startTime);
        }
    }

    private class BrowserClosingError
    extends Exception {
        private BrowserClosingError() {
        }
    }

    private class TextEnteringError
    extends Exception {
        private TextEnteringError() {
        }
    }

    private class NavigationError
    extends Exception {
        private NavigationError() {
        }
    }
}

