/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.webdrivergluecode;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.support.SupportMethods;
import se.claremont.taf.websupport.webdrivergluecode.WebInteractionMethods;

public class WebPageCodeConstructorWithBy {
    private final WebInteractionMethods web;
    private final List<WebElement> unidentifiedElements = new ArrayList<WebElement>();
    private final StringBuilder sb = new StringBuilder();
    private final Map<String, WebElement> identifiedElementsByName = new HashMap<String, WebElement>();

    public WebPageCodeConstructorWithBy(WebInteractionMethods web) {
        this.web = web;
    }

    public String createPageObjectFromCurrentPage(String outPutFilePath, boolean quickAndSloppyMode) {
        long startTime = System.currentTimeMillis();
        String pageTitle = this.web.driver.getTitle() != null && this.web.driver.getTitle().length() > 0 ? this.web.driver.getTitle() : this.web.driver.getCurrentUrl().substring(this.web.driver.getCurrentUrl().lastIndexOf("/"));
        List elements = this.web.driver.findElements(By.xpath((String)"//body//*"));
        for (WebElement element : elements) {
            try {
                if (element.getTagName().equals("script") || element.getTagName().equals("style")) continue;
                this.unidentifiedElements.add(element);
            }
            catch (Exception exception) {}
        }
        this.web.getTestCase().log(LogLevel.DEBUG, "Took " + (System.currentTimeMillis() - startTime) + " milliseconds to gather all elements in HTML Body.");
        startTime = System.currentTimeMillis();
        this.sb.append("import se.claremont.autotest.websupport.DomElement;").append(System.lineSeparator());
        this.sb.append("import se.claremont.autotest.websupport.elementidentification.By;").append(System.lineSeparator());
        this.sb.append(System.lineSeparator());
        this.sb.append("//Automatically started generaton with TAF ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date())).append(System.lineSeparator());
        this.sb.append("public class ").append(WebPageCodeConstructorWithBy.upperCaseInitialLetterOfEachWord(WebPageCodeConstructorWithBy.programmaticallySafeName(pageTitle + "_Page"))).append(" {").append(System.lineSeparator());
        this.addElementsIdentifiableWithIds();
        this.web.getTestCase().log(LogLevel.DEBUG, "Identifying elements by id took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
        startTime = System.currentTimeMillis();
        this.addElementsIdentifiableWithNames();
        this.web.getTestCase().log(LogLevel.DEBUG, "Identifying elements by names took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
        startTime = System.currentTimeMillis();
        this.addElementsIdentifiableWithText();
        this.web.getTestCase().log(LogLevel.DEBUG, "Identifying elements by text took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
        startTime = System.currentTimeMillis();
        this.addElementsIdentifiableWithClasses();
        this.web.getTestCase().log(LogLevel.DEBUG, "Identifying elements by classes took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
        startTime = System.currentTimeMillis();
        this.addElementsIdentifiableWithTagNames();
        this.web.getTestCase().log(LogLevel.DEBUG, "Identifying elements by tag names took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
        startTime = System.currentTimeMillis();
        this.addElementsIdentifiableWithAttributes();
        this.web.getTestCase().log(LogLevel.DEBUG, "Identifying elements by attributes took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
        startTime = System.currentTimeMillis();
        if (!quickAndSloppyMode) {
            this.addUniqueElementsFromParent();
            this.web.getTestCase().log(LogLevel.DEBUG, "Identifying elements by parents took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
            startTime = System.currentTimeMillis();
        }
        this.sb.append("}").append(System.lineSeparator());
        if (this.unidentifiedElements.size() > 0) {
            this.sb.append("/*").append(System.lineSeparator());
            for (WebElement element : this.unidentifiedElements) {
                try {
                    this.sb.append("   Element not identified: [tag: '").append(element.getTagName()).append("', outerHtml: '").append(element.getAttribute("outerHTML")).append("']").append(System.lineSeparator()).append(System.lineSeparator());
                }
                catch (Exception e) {
                    System.out.println("Problems describing unidentified element. Error: " + e.getMessage());
                }
            }
            this.sb.append("*/").append(System.lineSeparator()).append(System.lineSeparator());
            this.sb.append("//Stopped page class generaton at ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date())).append(System.lineSeparator());
            this.web.getTestCase().log(LogLevel.DEBUG, "Describing unidentified elements by id took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
        }
        this.web.getTestCase().log(LogLevel.DEBUG, "Content of file created:" + System.lineSeparator() + this.sb.toString());
        if (outPutFilePath != null) {
            SupportMethods.saveToFile((String)this.sb.toString(), (String)outPutFilePath);
        }
        return this.sb.toString();
    }

    private String identifyName(WebElement element, int recursionLevel, String parentTagName) {
        String name = element.getAttribute("name");
        if (name != null && name.length() > 0) {
            return WebPageCodeConstructorWithBy.programmaticallySafeName(name) + "_" + WebPageCodeConstructorWithBy.tagName(element.getTagName());
        }
        name = element.getAttribute("title");
        if (name != null && name.length() > 0) {
            return WebPageCodeConstructorWithBy.programmaticallySafeName(name) + "_" + WebPageCodeConstructorWithBy.tagName(element.getTagName());
        }
        name = element.getAttribute("id");
        if (name != null && name.length() > 0) {
            return WebPageCodeConstructorWithBy.programmaticallySafeName(name) + "_" + WebPageCodeConstructorWithBy.tagName(element.getTagName());
        }
        name = element.getText();
        if (name != null && name.length() > 0) {
            if (name.length() > 40) {
                return WebPageCodeConstructorWithBy.programmaticallySafeName(name.substring(0, 40)) + "_" + WebPageCodeConstructorWithBy.tagName(element.getTagName());
            }
            return WebPageCodeConstructorWithBy.programmaticallySafeName(name) + "_" + WebPageCodeConstructorWithBy.tagName(element.getTagName());
        }
        name = element.getAttribute("alt");
        if (name != null && name.length() > 0) {
            return WebPageCodeConstructorWithBy.programmaticallySafeName(name) + "_" + WebPageCodeConstructorWithBy.tagName(element.getTagName());
        }
        name = element.getAttribute("value");
        if (name != null && name.length() > 0) {
            return WebPageCodeConstructorWithBy.programmaticallySafeName(name) + "_" + WebPageCodeConstructorWithBy.tagName(element.getTagName());
        }
        name = element.getAttribute("class");
        if (name != null && name.length() > 0) {
            return WebPageCodeConstructorWithBy.programmaticallySafeName(name) + "_" + WebPageCodeConstructorWithBy.tagName(element.getTagName());
        }
        JavascriptExecutor javascript = (JavascriptExecutor)this.web.driver;
        Map attributes = (Map)javascript.executeScript("var items = {}; for (index = 0; index < arguments[0].attributes.length; ++index) { items[arguments[0].attributes[index].name] = arguments[0].attributes[index].value }; return items;", new Object[]{element});
        if (attributes.size() > 0) {
            for (String attributeName : attributes.keySet()) {
                name = name + attributeName + " " + attributes.get(attributeName);
            }
            name = WebPageCodeConstructorWithBy.upperCaseInitialLetterOfEachWord(name);
        }
        if (name != null && name.length() > 0) {
            return WebPageCodeConstructorWithBy.programmaticallySafeName(name) + "_" + WebPageCodeConstructorWithBy.tagName(element.getTagName());
        }
        if (parentTagName == null) {
            parentTagName = element.getTagName();
        }
        if (recursionLevel < 2) {
            for (WebElement child : element.findElements(By.xpath((String)".//"))) {
                name = this.identifyName(child, recursionLevel + 1, parentTagName);
                if (name == null || name.length() <= 0 || name.startsWith("NoName_")) continue;
                return name + "_" + WebPageCodeConstructorWithBy.tagName(parentTagName);
            }
        }
        return "NoName_" + WebPageCodeConstructorWithBy.tagName(element.getTagName());
    }

    private String getUnusedName(String baseName) {
        String elementName = baseName;
        if (this.identifiedElementsByName.containsKey(elementName)) {
            int counter = 1;
            while (this.identifiedElementsByName.containsKey(elementName + String.valueOf(counter))) {
                ++counter;
            }
            elementName = elementName + String.valueOf(counter);
        }
        return elementName;
    }

    private void addUniqueElementsFromParent() {
        ArrayList<WebElement> elementsToRemove = new ArrayList<WebElement>();
        for (String parentName : this.identifiedElementsByName.keySet()) {
            try {
                WebElement parent = this.identifiedElementsByName.get(parentName);
                if (parent == null) continue;
                for (int i = 0; i < this.unidentifiedElements.size(); ++i) {
                    String id;
                    WebElement descendant = this.unidentifiedElements.get(i);
                    if (descendant == null || (id = descendant.getAttribute("id")) == null || id.length() == 0) continue;
                    if (parent.findElements(By.id((String)id)).size() == 1) {
                        String elementName = this.getUnusedName(parentName + "_" + this.identifyName(descendant, 0, null));
                        this.identifiedElementsByName.put(elementName, descendant);
                        this.sb.append("      public static DomElement ").append(elementName).append(" = new DomElement(By").append(System.lineSeparator());
                        this.sb.append("         .id(\"").append(id.replace("\"", "'")).append("\")").append(System.lineSeparator());
                        this.sb.append("         .andByBeingDescendantOf(").append(parentName).append(")").append(System.lineSeparator());
                        this.sb.append("         .andByTagName(\"").append(descendant.getTagName()).append("\"),").append(System.lineSeparator());
                        this.sb.append("         \"").append(elementName).append("\");").append(System.lineSeparator());
                        this.sb.append(System.lineSeparator());
                        elementsToRemove.add(descendant);
                        continue;
                    }
                    String name = descendant.getAttribute("name");
                    if (parent.findElements(By.name((String)name)).size() == 1) {
                        String elementNam = this.getUnusedName(parentName + "_" + this.identifyName(descendant, 0, null));
                        this.identifiedElementsByName.put(elementNam, descendant);
                        this.sb.append("      public static DomElement ").append(elementNam).append(" = new DomElement(By").append(System.lineSeparator()).append(System.lineSeparator());
                        this.sb.append("         .name(\"").append(name.replace("\"", "'")).append("\")").append(System.lineSeparator()).append(System.lineSeparator());
                        this.sb.append("         .andByBeingDescendantOf(").append(parentName).append(")").append(System.lineSeparator()).append(System.lineSeparator());
                        this.sb.append("         .andByTagName(\"").append(descendant.getTagName()).append("\"),").append(System.lineSeparator()).append(System.lineSeparator());
                        this.sb.append("         \"").append(elementNam).append("\");").append(System.lineSeparator());
                        this.sb.append(System.lineSeparator());
                        elementsToRemove.add(descendant);
                        continue;
                    }
                    String klass = descendant.getAttribute("class");
                    if (parent.findElements(By.className((String)klass)).size() != 1) continue;
                    String elementName2 = this.getUnusedName(parentName + "_" + this.identifyName(descendant, 0, null));
                    this.identifiedElementsByName.put(elementName2, descendant);
                    this.sb.append("      public static DomElement ").append(elementName2).append(" = new DomElement(By").append(System.lineSeparator()).append(System.lineSeparator());
                    this.sb.append("         .className(\"").append(klass.replace("\"", "'")).append("\")").append(System.lineSeparator()).append(System.lineSeparator());
                    this.sb.append("         .andByBeingDescendantOf(").append(parentName).append(")").append(System.lineSeparator()).append(System.lineSeparator());
                    this.sb.append("         .andByTagName(\"").append(descendant.getTagName()).append("\"),").append(System.lineSeparator()).append(System.lineSeparator());
                    this.sb.append("         \"").append(elementName2).append("\");").append(System.lineSeparator());
                    this.sb.append(System.lineSeparator());
                    elementsToRemove.add(descendant);
                }
            }
            catch (Exception e) {
                System.out.println("Problems with parent or descendant. Error: " + e.toString());
            }
        }
        for (WebElement element : elementsToRemove) {
            try {
                this.unidentifiedElements.remove(element);
            }
            catch (Exception e) {
                System.out.println("Could not remove element from unidentifiedList. Error: " + e.toString());
            }
        }
    }

    private void addElementsIdentifiableWithNames() {
        ArrayList<Integer> elementsToRemove = new ArrayList<Integer>();
        for (int i = 0; i < this.unidentifiedElements.size(); ++i) {
            try {
                WebElement element = this.unidentifiedElements.get(i);
                String name = element.getAttribute("name");
                if (name == null || name.length() <= 0 || this.web.driver.findElements(By.xpath((String)("//" + element.getTagName() + "[@name='" + name.replace("'", "\"") + "']"))).size() != 1) continue;
                String elementName = this.getUnusedName(this.identifyName(element, 0, null));
                this.identifiedElementsByName.put(elementName, element);
                this.sb.append("      public static DomElement ").append(elementName).append(" = new DomElement(By").append(System.lineSeparator());
                this.sb.append("         .name(\"").append(name.replace("\"", "'")).append("\")").append(System.lineSeparator());
                this.sb.append("         .andByTagName(\"").append(element.getTagName()).append("\"),").append(System.lineSeparator());
                this.sb.append("         \"").append(elementName).append("\");").append(System.lineSeparator());
                this.sb.append(System.lineSeparator());
                elementsToRemove.add(i);
                continue;
            }
            catch (Exception e) {
                System.out.println("Problem with element in names. Error: " + e.toString());
                elementsToRemove.add(i);
            }
        }
        Collections.reverse(elementsToRemove);
        Iterator iterator = elementsToRemove.iterator();
        while (iterator.hasNext()) {
            int elementNr = (Integer)iterator.next();
            try {
                this.unidentifiedElements.remove(elementNr);
            }
            catch (Exception e) {
                System.out.println("Could not remove element from unidentifiedList. Error: " + e.toString());
            }
        }
    }

    private void addElementsIdentifiableWithTagNames() {
        ArrayList<Integer> elementsToRemove = new ArrayList<Integer>();
        for (int i = 0; i < this.unidentifiedElements.size(); ++i) {
            try {
                WebElement element = this.unidentifiedElements.get(i);
                String tag = element.getTagName();
                if (tag == null || tag.length() <= 0 || this.web.driver.findElements(By.xpath((String)("//" + element.getTagName()))).size() != 1) continue;
                String elementName = this.getUnusedName(this.identifyName(element, 0, null));
                this.identifiedElementsByName.put(elementName, element);
                this.sb.append("      public static DomElement ").append(elementName).append(" = new DomElement(By").append(System.lineSeparator());
                this.sb.append("         .tagName(\"").append(tag).append("\"),").append(System.lineSeparator());
                this.sb.append("         \"").append(elementName).append("\");").append(System.lineSeparator());
                this.sb.append(System.lineSeparator());
                elementsToRemove.add(i);
                continue;
            }
            catch (Exception e) {
                System.out.println("Problems with element getter for tag name. Error: " + e.toString());
                elementsToRemove.add(i);
            }
        }
        Collections.reverse(elementsToRemove);
        Iterator iterator = elementsToRemove.iterator();
        while (iterator.hasNext()) {
            int elementNr = (Integer)iterator.next();
            try {
                this.unidentifiedElements.remove(elementNr);
            }
            catch (Exception e) {
                System.out.println("Could not remove element from unidentifiedList. Error: " + e.toString());
            }
        }
    }

    private void addElementsIdentifiableWithClasses() {
        ArrayList<Integer> elementsToRemove = new ArrayList<Integer>();
        for (int i = 0; i < this.unidentifiedElements.size(); ++i) {
            try {
                WebElement element = this.unidentifiedElements.get(i);
                String klass = element.getAttribute("class");
                if (klass == null || klass.length() <= 0 || this.web.driver.findElements(By.xpath((String)("//" + element.getTagName() + "[@class='" + klass.replace("'", "\"") + "']"))).size() != 1) continue;
                String elementName = this.getUnusedName(this.identifyName(element, 0, null));
                this.identifiedElementsByName.put(elementName, element);
                this.sb.append("      public static DomElement ").append(elementName).append(" = new DomElement(By").append(System.lineSeparator());
                this.sb.append("         .className(\"").append(klass.replace("\"", "'")).append("\")").append(System.lineSeparator());
                this.sb.append("         .andByTagName(\"").append(element.getTagName()).append("\"),").append(System.lineSeparator());
                this.sb.append("         \"").append(elementName).append("\");").append(System.lineSeparator());
                this.sb.append(System.lineSeparator());
                elementsToRemove.add(i);
                continue;
            }
            catch (Exception e) {
                System.out.println("Problems with element getters in classes. Error: " + e.toString());
                elementsToRemove.add(i);
            }
        }
        Collections.reverse(elementsToRemove);
        Iterator iterator = elementsToRemove.iterator();
        while (iterator.hasNext()) {
            int elementNr = (Integer)iterator.next();
            try {
                this.unidentifiedElements.remove(elementNr);
            }
            catch (Exception e) {
                System.out.println("Could not remove element from unidentifiedList. Error: " + e.toString());
            }
        }
    }

    private void addElementsIdentifiableWithAttributes() {
        ArrayList<Integer> elementsToRemove = new ArrayList<Integer>();
        JavascriptExecutor javascript = (JavascriptExecutor)this.web.driver;
        for (int i = 0; i < this.unidentifiedElements.size(); ++i) {
            try {
                WebElement element = this.unidentifiedElements.get(i);
                Map attributes = (Map)javascript.executeScript("var items = {}; for (index = 0; index < arguments[0].attributes.length; ++index) { items[arguments[0].attributes[index].name] = arguments[0].attributes[index].value }; return items;", new Object[]{element});
                String xpath = "//" + element.getTagName();
                ArrayList<String> attributeStrings = new ArrayList<String>();
                if (attributes.size() > 0) {
                    ArrayList<String> condition = new ArrayList<String>();
                    for (String attributeName : attributes.keySet()) {
                        String attributeValue = attributes.get(attributeName).toString();
                        condition.add("@" + attributeName + "='" + attributeValue.replace("'", "\"") + "'");
                        attributeStrings.add("\"" + attributeName + "\", \"" + attributes.get(attributeName).toString().replace("\"", "'") + "\"");
                    }
                    xpath = xpath + "[" + String.join((CharSequence)" and ", condition) + "]";
                }
                if (xpath == null || xpath.length() <= 0 || this.web.driver.findElements(By.xpath((String)xpath)).size() != 1) continue;
                String elementName = this.getUnusedName(this.identifyName(element, 0, null));
                this.identifiedElementsByName.put(elementName, element);
                this.sb.append("      public static DomElement ").append(elementName).append(" = new DomElement(By").append(System.lineSeparator()).append("         .tagName(\"").append(element.getTagName()).append("\")").append(System.lineSeparator()).append("         .andByAttributeValue(").append(String.join((CharSequence)(")" + System.lineSeparator() + "         .andByAttributeValue("), attributeStrings)).append("),").append(System.lineSeparator()).append("         \"").append(elementName).append("\");").append(System.lineSeparator());
                this.sb.append(System.lineSeparator());
                elementsToRemove.add(i);
                continue;
            }
            catch (Exception e) {
                System.out.println("Problem getting element for attributes. Error: " + e.toString());
                elementsToRemove.add(i);
            }
        }
        Collections.reverse(elementsToRemove);
        Iterator iterator = elementsToRemove.iterator();
        while (iterator.hasNext()) {
            int elementNr = (Integer)iterator.next();
            try {
                this.unidentifiedElements.remove(elementNr);
            }
            catch (Exception e) {
                System.out.println("Could not remove element from unidentifiedList. Error: " + e.toString());
            }
        }
    }

    private static String tagName(String tagName) {
        if (tagName.toLowerCase().equals("a")) {
            return "Link";
        }
        return WebPageCodeConstructorWithBy.upperCaseInitialLetterOfEachWord(tagName);
    }

    private void addElementsIdentifiableWithIds() {
        ArrayList<Integer> elementsToRemove = new ArrayList<Integer>();
        for (int i = 0; i < this.unidentifiedElements.size(); ++i) {
            try {
                WebElement element = this.unidentifiedElements.get(i);
                String id = element.getAttribute("id");
                if (id == null || id.length() <= 0 || this.web.driver.findElements(By.xpath((String)("//" + element.getTagName() + "[@id='" + id.replace("'", "\"") + "']"))).size() != 1) continue;
                String elementName = this.getUnusedName(this.identifyName(element, 0, null));
                this.identifiedElementsByName.put(elementName, element);
                this.sb.append("      public static DomElement ").append(elementName).append(" = new DomElement(By").append(System.lineSeparator());
                this.sb.append("         .id(\"").append(id.replace("\"", "'")).append("\")").append(System.lineSeparator());
                this.sb.append("         .andByTagName(\"").append(element.getTagName()).append("\"),").append(System.lineSeparator());
                this.sb.append("         \"").append(elementName).append("\");").append(System.lineSeparator());
                this.sb.append(System.lineSeparator());
                elementsToRemove.add(i);
                continue;
            }
            catch (Exception e) {
                System.out.println("Problem with element using ids. Error: " + e.toString());
                elementsToRemove.add(i);
            }
        }
        Collections.reverse(elementsToRemove);
        Iterator iterator = elementsToRemove.iterator();
        while (iterator.hasNext()) {
            int elementNr = (Integer)iterator.next();
            try {
                this.unidentifiedElements.remove(elementNr);
            }
            catch (Exception e) {
                System.out.println("Could not remove element from unidentifiedList. Error: " + e.toString());
            }
        }
    }

    private void addElementsIdentifiableWithText() {
        ArrayList<Integer> elementsToRemove = new ArrayList<Integer>();
        for (int i = 0; i < this.unidentifiedElements.size(); ++i) {
            try {
                WebElement element = this.unidentifiedElements.get(i);
                String text = element.getText();
                if (text == null || text.length() <= 0 || this.web.driver.findElements(By.xpath((String)("//*[text()='" + text.replace("'", "\"") + "']"))).size() != 1) continue;
                List<String> textLines = this.lineBreakedText(text);
                String exactTextString = textLines.size() == 1 ? "         .exactText(\"" + textLines.get(0) + "\")" + System.lineSeparator() : "         .exactText(" + System.lineSeparator() + "              \"" + String.join((CharSequence)("\"" + System.lineSeparator() + "            + \""), textLines) + "\"" + System.lineSeparator() + "            )" + System.lineSeparator();
                String elementName = this.getUnusedName(this.identifyName(element, 0, null));
                this.identifiedElementsByName.put(elementName, element);
                this.sb.append("      public static DomElement ").append(elementName).append(" = new DomElement(By").append(System.lineSeparator()).append(exactTextString).append("         .andByTagName(\"").append(element.getTagName()).append("\"),").append(System.lineSeparator()).append("         \"").append(elementName).append("\"); ").append(System.lineSeparator());
                this.sb.append(System.lineSeparator());
                elementsToRemove.add(i);
                continue;
            }
            catch (Exception e) {
                System.out.println("Problems with element in text getting. Error: " + e.toString());
                elementsToRemove.add(i);
            }
        }
        Collections.reverse(elementsToRemove);
        Iterator iterator = elementsToRemove.iterator();
        while (iterator.hasNext()) {
            int elementNr = (Integer)iterator.next();
            try {
                this.unidentifiedElements.remove(elementNr);
            }
            catch (Exception e) {
                System.out.println("Could not remove element from unidentifiedList. Error: " + e.toString());
            }
        }
    }

    private List<String> lineBreakedText(String text) {
        text = text.replace("\"", "'");
        ArrayList<String> parts = new ArrayList<String>();
        while (text.length() > 90) {
            parts.add(text.substring(0, 90));
            text = text.substring(90);
        }
        parts.add(text);
        return parts;
    }

    private static String upperCaseInitialLetterOfEachWord(String inString) {
        String[] words;
        StringBuilder sb = new StringBuilder();
        for (String word : words = inString.split(" ")) {
            if (word == null || word.trim().length() == 0) continue;
            if (word.length() > 1) {
                sb.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
                continue;
            }
            sb.append(word.toUpperCase());
        }
        return sb.toString();
    }

    public static String programmaticallySafeName(String inString) {
        if (inString == null) {
            inString = "";
        }
        if (inString.matches("^\\d")) {
            inString = "_" + inString;
        }
        if ((inString = WebPageCodeConstructorWithBy.upperCaseInitialLetterOfEachWord(inString)).length() > 0) {
            inString = inString.substring(0, 1).toLowerCase() + inString.substring(1);
        }
        inString = inString.replace(" ", "").replace("\\", "").replace("/", "").replace("\u00a9", "Copyright").replace(":", "_").replace("@", "At").replace(";", "_").replace("&", "And").replace("#", "_").replace("%", "Proc").replace("^", "_").replace("|", "_").replace("-", "_").replace("\u00a8", "").replace("~", "_").replace(System.lineSeparator(), "").replace("\n", "").replace("\t", "").replace("\"", "").replace("'", "").replace("<", "").replace("-", "_").replace("+", "Plus").replace(".", "_").replace(",", "_").replace("*", "").replace("$", "Dollar").replace("\u00a3", "Pound").replace("\u20ac", "Euro").replace("}", "").replace("[", "_").replace("]", "_").replace("?", "_").replace("!", "_").replace("{", "").replace("-", "_").replace("(", "").replace(")", "").replace(">", "").replace("=", "");
        while (inString.contains("__")) {
            inString = inString.replace("__", "_");
        }
        if (inString.length() > 50) {
            inString = inString.substring(0, 50);
        }
        if (inString.length() == 0) {
            inString = "NoName";
        }
        return inString;
    }
}

