/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import se.claremont.taf.core.guidriverpluginstructure.GuiElement;
import se.claremont.taf.core.support.StringManagement;
import se.claremont.taf.websupport.elementidentification.By;
import se.claremont.taf.websupport.elementidentification.WebElementIdentifier;
import se.claremont.taf.websupport.webdrivergluecode.WebInteractionMethods;
import se.claremont.taf.websupport.webdrivergluecode.positionbasedidentification.PositionBasedWebElement;

public class DomElement
implements GuiElement,
Serializable {
    public String name;
    public By by;
    public List<String> recognitionStrings;
    public IdentificationType identificationType;
    public Integer ordinalNumber = null;
    private String page = null;

    public DomElement(By by) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethodUsingConstructor = stackTraceElements[2];
        this.name = this.identifyElementName();
        this.page = callingMethodUsingConstructor.getClassName();
        this.by = by;
    }

    public DomElement(String json) {
        ObjectMapper om = new ObjectMapper();
        json = json.substring("webElement=".length());
        JsonNode jsonNode = null;
        try {
            jsonNode = om.readTree(json);
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        if (jsonNode == null) {
            this.name = "NullElement";
            return;
        }
        this.by = By.tagName(jsonNode.get("tagName").asText());
        if (jsonNode.get("id").asText() != null && jsonNode.get("id").asText().length() > 0) {
            this.by.andById(jsonNode.get("id").asText());
            this.name = jsonNode.get("id").asText();
        }
        if (jsonNode.get("text").asText() != null && jsonNode.get("text").asText().length() > 0) {
            this.by.andByExactText(jsonNode.get("text").asText());
            if (this.name == null || this.name.length() == 0) {
                this.name = StringManagement.stringToCapitalInitialCharacterForEachWordAndNoSpaces((String)jsonNode.get("text").asText());
            }
        }
        if (jsonNode.get("className").asText() != null && jsonNode.get("className").asText().length() > 0) {
            this.by.andByClass(jsonNode.get("className").asText());
            if (this.name == null || this.name.length() == 0) {
                this.name = StringManagement.stringToCapitalInitialCharacterForEachWordAndNoSpaces((String)jsonNode.get("className").asText());
            }
        }
        if (this.by.getConditionCount() == 0) {
            this.by.andByXPath(jsonNode.get("xpath").asText());
        }
        if (this.name.length() == 0) {
            this.name = "UnNamedElement";
        }
        if (this.name.length() > 30) {
            this.name = this.name.substring(0, 30);
        }
        this.name = StringManagement.safeVariableName((String)StringManagement.stringToCapitalInitialCharacterForEachWordAndNoSpaces((String)(this.name + jsonNode.get("tagName").asText())));
    }

    public DomElement(org.openqa.selenium.By seleniumBy) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethodUsingConstructor = stackTraceElements[2];
        this.name = this.identifyElementName();
        this.page = callingMethodUsingConstructor.getClassName();
        switch (seleniumBy.getClass().getSimpleName()) {
            case "ById": {
                this.by = By.id(this.removeSeleniumByTypeFromString(seleniumBy));
                break;
            }
            case "ByClassName": {
                this.by = By.className(this.removeSeleniumByTypeFromString(seleniumBy));
                break;
            }
            case "ByXPath": {
                this.by = By.xpath(this.removeSeleniumByTypeFromString(seleniumBy));
                break;
            }
            case "ByName": {
                this.by = By.name(this.removeSeleniumByTypeFromString(seleniumBy));
                break;
            }
            case "ByCssSelector": {
                this.by = By.cssSelector(this.removeSeleniumByTypeFromString(seleniumBy));
                break;
            }
            case "ByTagName": {
                this.by = By.tagName(this.removeSeleniumByTypeFromString(seleniumBy));
                break;
            }
            case "ByLinkText": {
                this.by = By.tagName("a").andByExactText(this.removeSeleniumByTypeFromString(seleniumBy));
                break;
            }
            case "ByPartialLinkText": {
                this.by = By.tagName("a").andByTextContainsString(this.removeSeleniumByTypeFromString(seleniumBy));
                break;
            }
            default: {
                System.out.println(seleniumBy.toString());
            }
        }
    }

    private String removeSeleniumByTypeFromString(org.openqa.selenium.By seleniumBy) {
        return seleniumBy.toString().substring(seleniumBy.toString().indexOf(": ") + 2);
    }

    public DomElement(By by, String name) {
        this.name = name;
        this.by = by;
    }

    public DomElement(WebElement webElement) {
        this.name = "Dynamically identified " + webElement.getTagName() + " element";
        this.recognitionStrings = new ArrayList<String>();
        this.recognitionStrings.add(this.getElementXPath(webElement));
        this.identificationType = IdentificationType.BY_X_PATH;
        this.page = this.getElementPageNameFromCurrentTitle(webElement);
    }

    public DomElement(WebElement webElement, String elementName, String elementPageName) {
        this.name = elementName == null ? "Dynamically identified " + webElement.getTagName() + " element" : elementName;
        this.recognitionStrings = new ArrayList<String>();
        this.by = By.xpath(this.getElementXPath(webElement));
        this.recognitionStrings.add(this.getElementXPath(webElement));
        this.identificationType = IdentificationType.BY_X_PATH;
        if (elementPageName == null) {
            elementPageName = this.getElementPageNameFromCurrentTitle(webElement);
        }
        this.page = elementPageName;
    }

    private String getElementPageNameFromCurrentTitle(WebElement webElement) {
        try {
            WebDriver driver = this.getDriver(webElement);
            return driver.getTitle();
        }
        catch (Exception e) {
            return "TempElementPage";
        }
    }

    public DomElement(String recognitionString, IdentificationType identificationType, String name) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethodUsingConstructor = stackTraceElements[2];
        this.recognitionStrings = new ArrayList<String>(Collections.singletonList(recognitionString));
        this.name = name;
        this.page = callingMethodUsingConstructor.getClassName();
        this.by = this.setByFromRecognitionStringAndIdentificationType(recognitionString, identificationType);
        this.identificationType = identificationType;
    }

    public DomElement(String recognitionString, IdentificationType identificationType) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethodUsingConstructor = stackTraceElements[2];
        this.recognitionStrings = new ArrayList<String>(Collections.singletonList(recognitionString));
        this.name = this.identifyElementName();
        this.page = callingMethodUsingConstructor.getClassName();
        this.by = this.setByFromRecognitionStringAndIdentificationType(recognitionString, identificationType);
        this.identificationType = identificationType;
    }

    public DomElement(String[] alternativeRecognitionStrings, IdentificationType identificationType, String name) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethodUsingConstructor = stackTraceElements[2];
        this.name = name;
        this.page = callingMethodUsingConstructor.getClassName();
        this.identificationType = identificationType;
        this.recognitionStrings = new ArrayList<String>(Arrays.asList(alternativeRecognitionStrings));
    }

    public DomElement(String[] alternativeRecognitionStrings, IdentificationType identificationType) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethodUsingConstructor = stackTraceElements[2];
        this.name = this.identifyElementName();
        this.page = callingMethodUsingConstructor.getClassName();
        this.identificationType = identificationType;
        this.recognitionStrings = new ArrayList<String>(Arrays.asList(alternativeRecognitionStrings));
    }

    public DomElement(String recognitionString, IdentificationType identificationType, Integer ordinalNumber, String name) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethodUsingConstructor = stackTraceElements[2];
        this.name = name;
        this.page = callingMethodUsingConstructor.getClassName();
        this.by = this.setByFromRecognitionStringAndIdentificationType(recognitionString, identificationType);
        if (this.by != null) {
            this.by = this.by.andByOrdinalNumber(ordinalNumber);
        }
        this.recognitionStrings = new ArrayList<String>(Collections.singletonList(recognitionString));
        this.ordinalNumber = ordinalNumber;
        this.identificationType = identificationType;
    }

    public DomElement(String recognitionString, IdentificationType identificationType, Integer ordinalNumber) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethodUsingConstructor = stackTraceElements[2];
        this.name = this.identifyElementName();
        this.page = callingMethodUsingConstructor.getClassName();
        this.by = this.setByFromRecognitionStringAndIdentificationType(recognitionString, identificationType);
        if (this.by != null) {
            this.by = this.by.andByOrdinalNumber(ordinalNumber);
        }
        this.recognitionStrings = new ArrayList<String>(Collections.singletonList(recognitionString));
        this.ordinalNumber = ordinalNumber;
        this.identificationType = identificationType;
    }

    public DomElement(String[] alternativeRecognitionStrings, IdentificationType identificationType, Integer ordinalNumber, String name) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethodUsingConstructor = stackTraceElements[2];
        this.name = name;
        this.ordinalNumber = ordinalNumber;
        this.page = callingMethodUsingConstructor.getClassName();
        this.recognitionStrings = new ArrayList<String>(Arrays.asList(alternativeRecognitionStrings));
        this.identificationType = identificationType;
    }

    public DomElement(String[] alternativeRecognitionStrings, IdentificationType identificationType, Integer ordinalNumber) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethodUsingConstructor = stackTraceElements[2];
        this.name = this.identifyElementName();
        this.ordinalNumber = ordinalNumber;
        this.page = callingMethodUsingConstructor.getClassName();
        this.recognitionStrings = new ArrayList<String>(Arrays.asList(alternativeRecognitionStrings));
        this.identificationType = identificationType;
    }

    public DomElement(PositionBasedWebElement positionBasedWebElement) {
        this.name = "Dynamically identified " + positionBasedWebElement.webElement.getTagName() + " element " + positionBasedWebElement.getText();
        this.recognitionStrings = new ArrayList<String>();
        this.recognitionStrings.add(this.getElementXPath(positionBasedWebElement.webElement));
        this.identificationType = IdentificationType.BY_X_PATH;
        this.page = "TempElementPage";
    }

    private By setByFromRecognitionStringAndIdentificationType(String recognitionString, IdentificationType identificationType) {
        switch (identificationType) {
            case BY_CSS: {
                return By.cssSelector(recognitionString);
            }
            case BY_CLASS: {
                return By.className(recognitionString);
            }
            case BY_ID: {
                return By.id(recognitionString);
            }
            case BY_X_PATH: {
                return By.xpath(recognitionString);
            }
            case BY_VISIBLE_TEXT: {
                return By.textContainsString(recognitionString);
            }
            case BY_NAME: {
                return By.name(recognitionString);
            }
            case BY_LINK_TEXT: {
                return By.exactText(recognitionString).andByTagName("a");
            }
        }
        return null;
    }

    private String identifyElementName() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethodUsingConstructor = stackTraceElements[3];
        String elementName = callingMethodUsingConstructor.getMethodName();
        Class<?> klass = null;
        try {
            klass = Thread.currentThread().getContextClassLoader().loadClass(callingMethodUsingConstructor.getClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (this.recognitionStrings != null && (this.elementNameMatchesNameOfAJunitTest(elementName, klass) || elementName.equals("<init>"))) {
            elementName = "'" + String.join((CharSequence)" and ", this.recognitionStrings) + "'";
        }
        return elementName;
    }

    private boolean elementNameMatchesNameOfAJunitTest(String elementName, Class klass) {
        for (Method m : klass.getMethods()) {
            if (!m.getName().equals(elementName)) continue;
            for (Annotation a : m.getDeclaredAnnotations()) {
                if (!a.annotationType().toString().equals("interface org.junit.Test")) continue;
                return true;
            }
        }
        return false;
    }

    public DomElement getDomElementFromDescendants(DomElement domElement, WebInteractionMethods web) {
        return new DomElement(web.getRuntimeElementWithoutLogging(this, domElement));
    }

    private WebDriver getDriver(WebElement webElement) {
        WebDriver driver = null;
        try {
            driver = ((WrapsDriver)webElement).getWrappedDriver();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return driver;
    }

    public PositionBasedWebElement asPositionBasedWebElement(WebInteractionMethods web) {
        return new PositionBasedWebElement(web.getRuntimeElementWithoutLogging(this));
    }

    public String getElementXPath(WebElement element) {
        if (element == null) {
            return null;
        }
        WebDriver driver = this.getDriver(element);
        if (driver == null) {
            return null;
        }
        String tag = element.getTagName();
        return (String)((JavascriptExecutor)driver).executeScript("gPt=function(c){   if(c===document.body){       return c.tagName   }   var a=0;   var e=c.parentNode.childNodes;   for(var b=0;b<e.length;b++){       var d=e[b];       if(d===c){           return gPt(c.parentNode)+'/'+c.tagName+'['+(a+1)+']'       }       if(d.nodeType===1&&d.tagName===c.tagName){           a++}       }   };   return '//' + gPt(arguments[0]).toLowerCase();", new Object[]{element});
    }

    public String LogIdentification() {
        String idMessage = this.name;
        if (this.page != null && this.page.length() > 0) {
            idMessage = idMessage + " (declared in page class " + this.page + ")";
        }
        return idMessage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[DomElement: ");
        sb.append("Name='").append(this.name).append("', ");
        sb.append("page='").append(this.page).append("', ");
        if (this.recognitionStrings != null) {
            for (String recognitionString : this.recognitionStrings) {
                sb.append(" recognitionString='").append(recognitionString).append("', ");
            }
        }
        if (this.by != null) {
            sb.append("by='").append(this.by.toString()).append("', ");
            sb.append("generatedXPath='").append(WebElementIdentifier.createXPathFromBy(this.by)).append("', ");
        }
        if (this.identificationType != null) {
            sb.append("identificationType='").append(this.identificationType.toString()).append("', ");
        }
        sb.append("ordinalNumber=").append(String.valueOf(this.ordinalNumber)).append("]");
        return sb.toString();
    }

    public static enum IdentificationType {
        BY_LINK_TEXT,
        BY_X_PATH,
        BY_ID,
        BY_CLASS,
        BY_CSS,
        BY_NAME,
        BY_VISIBLE_TEXT,
        BY_ATTRIBUTE_VALUE;

    }
}

