/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport;

import java.util.ArrayList;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.support.SupportMethods;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.json.JsonParser;
import se.claremont.taf.restsupport.RestSupport;

public class W3CHtmlValidatorService {
    private boolean failed = false;
    private final TestCase testCase;
    private final String pageSource;
    private final boolean verbose;
    private String responseJson;

    public W3CHtmlValidatorService(TestCase testCase, String pageSource, boolean verbose) {
        this.testCase = testCase;
        this.pageSource = pageSource;
        this.verbose = verbose;
    }

    public boolean verifyPageSourceWithW3validator() {
        this.reportProblemsIfExist();
        if (!this.isRunnable()) {
            return false;
        }
        RestSupport rest = new RestSupport(this.testCase);
        this.responseJson = rest.responseBodyFromPostRequest("https://validator.w3.org/nu/?out=json", "text/html; charset=utf-8", this.pageSource);
        if (this.responseJson == null) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not get any response from HTML validation service.");
            this.failed = true;
            return false;
        }
        if (JsonParser.childObjects((String)this.responseJson, (String)"messages").size() == 0) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Checking of page content against W3C validator passed with no messages.");
        }
        this.reportResults();
        return !this.failed;
    }

    public boolean failed() {
        return this.failed;
    }

    private void reportProblemsIfExist() {
        if (this.pageSource == null || this.pageSource.length() == 0) {
            this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Trying to check HTML with W3C, but the source seem to be empty.");
            this.failed = true;
        }
    }

    private boolean isRunnable() {
        return this.pageSource != null && this.pageSource.length() != 0;
    }

    private LogLevel getLogLevelDependingOnErrorLevel() {
        LogLevel logLevel = LogLevel.INFO;
        for (String child : JsonParser.childObjects((String)this.responseJson, (String)"messages")) {
            String text = JsonParser.get((String)child, (String)"type");
            if (text == null || !text.contains("error")) continue;
            logLevel = LogLevel.VERIFICATION_FAILED;
            break;
        }
        return logLevel;
    }

    private void reportResults() {
        LogLevel logLevel = this.getLogLevelDependingOnErrorLevel();
        StringBuilder textLogMessage = new StringBuilder();
        ArrayList<String> htmlLogMessage = new ArrayList<String>();
        for (String child : JsonParser.childObjects((String)this.responseJson, (String)"messages")) {
            String lineNumberString = this.getLineNumberString(child);
            String text = JsonParser.get((String)child, (String)"type");
            if (text == null) continue;
            if (this.verbose && text.contains("info")) {
                textLogMessage.append(SupportMethods.LF).append("W3C Validation ").append(JsonParser.get((String)child, (String)"subType")).append(": ").append(JsonParser.get((String)child, (String)"message"));
                htmlLogMessage.add("<p><font class=\"w3cvalidationinfo\">W3C Validation information info</font>" + lineNumberString + "<br>" + JsonParser.get((String)child, (String)"subType") + ":<br>" + JsonParser.get((String)child, (String)"message") + "<br>Extract:<pre>" + JsonParser.get((String)child, (String)"extract").replace("<", "&lt;").replace(">", "&gt;") + "</pre></p>");
            } else if (JsonParser.get((String)child, (String)"type").contains("error")) {
                textLogMessage.append(SupportMethods.LF).append("W3C Validation error: ").append(JsonParser.get((String)child, (String)"message")).append(" Extract: '").append(JsonParser.get((String)child, (String)"extract")).append("'.");
                htmlLogMessage.add("<p><font class=\"w3cvalidationerror\">W3C Validation information: Error</font>" + lineNumberString + "<br>'" + JsonParser.get((String)child, (String)"message") + "'<br>Extract:<pre>" + JsonParser.get((String)child, (String)"extract").replace("<", "&lt;").replace(">", "&gt;") + "</pre></p>");
            } else if (this.verbose) {
                textLogMessage.append(SupportMethods.LF).append("W3C Validation ").append(JsonParser.get((String)child, (String)"type")).append(": ").append(JsonParser.get((String)child, (String)"message"));
                htmlLogMessage.add("<p><font class=\"w3validationother\">W3C Validation information</font>" + lineNumberString + "<br>" + JsonParser.get((String)child, (String)"type") + ":<br>" + JsonParser.get((String)child, (String)"message") + "<br>Extract:<pre>" + JsonParser.get((String)child, (String)"extract").replace("<", "&lt;").replace(">", "&gt;") + "</pre></p>");
            }
            this.testCase.log(LogLevel.DEBUG, "W3C JSON response content: '" + child.replace("<", "&lt;").replace(">", "&gt;") + "'.");
        }
        this.reportResultsToTestCaseLog(logLevel, textLogMessage.toString(), htmlLogMessage);
    }

    private String getLineNumberString(String child) {
        String lineNumberString = "";
        try {
            lineNumberString = " - At line number " + JsonParser.getInt((String)child, (String)"lastline");
        }
        catch (Exception e) {
            try {
                lineNumberString = " - At line number " + JsonParser.getInt((String)child, (String)"lastLine");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lineNumberString;
    }

    private void reportResultsToTestCaseLog(LogLevel logLevel, String textLogMessage, ArrayList<String> htmlLogMessage) {
        if (logLevel == LogLevel.VERIFICATION_FAILED || logLevel == LogLevel.INFO && this.verbose) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(logLevel, textLogMessage, String.join((CharSequence)"<hr>", htmlLogMessage));
        } else {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "No indications of anything in the HTML to act on after validation of HTML with W3C validation service.");
        }
    }
}

