/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.brokenlinkcheck;

import java.util.ArrayList;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.restsupport.RestSupport;

public class LinkCheck
implements Runnable {
    private final String link;
    private final TestCase testCase;
    private final String testStepName;
    private final ArrayList<String[]> tableRows;

    public LinkCheck(TestCase testCase, String link) {
        this.link = link;
        this.testCase = testCase;
        this.testStepName = testCase.getCurrentTestStepName();
        System.out.println(this.testStepName);
        this.tableRows = null;
    }

    public LinkCheck(ArrayList<String[]> tableRows, String link) {
        this.link = link;
        this.testCase = null;
        this.testStepName = null;
        this.tableRows = tableRows;
    }

    private void log(LogLevel logLevel, String message) {
        this.testCase.testCaseResult.testCaseLog.log(logLevel, message, message, this.testCase.testName, this.testStepName, "WebInteractionMethods/" + this.testCase.testSetName);
    }

    @Override
    public void run() {
        try {
            String responseCode = null;
            String[] results = new String[4];
            results[0] = this.link;
            long startTime = System.currentTimeMillis();
            try {
                if (this.link.toLowerCase().startsWith("mailto:") && this.link.contains("@") && this.link.contains(".")) {
                    results[2] = String.valueOf(System.currentTimeMillis() - startTime);
                    results[3] = "Mail address. Skipped.";
                    return;
                }
                responseCode = new RestSupport(this.testCase).responseCodeFromGetRequestWithoutLogging(this.link);
            }
            catch (Exception e) {
                results[3] = "Error: " + e.getMessage();
            }
            results[1] = String.valueOf(responseCode);
            results[2] = String.valueOf(System.currentTimeMillis() - startTime);
            this.tableRows.add(results);
        }
        catch (Exception e) {
            System.out.println("Problems with link '" + this.link + "': " + e.toString());
        }
    }
}

