/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.elementidentification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;
import se.claremont.taf.websupport.elementidentification.SearchCondition;
import se.claremont.taf.websupport.elementidentification.SearchConditionType;

public class By
implements Serializable {
    final List<SearchCondition> conditions = new ArrayList<SearchCondition>();

    By() {
    }

    public int getConditionCount() {
        return this.conditions.size();
    }

    public static By classContains(String className) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.AttributeValue, "classcontains", className));
        return s;
    }

    public static By className(String className) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.AttributeValue, "class", className));
        return s;
    }

    public static By xpath(String xPath) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.XPath, xPath));
        return s;
    }

    public static By beingDescendantOf(WebElement webElement) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.ByAncestor, webElement));
        return s;
    }

    public static By exactText(String text) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.ExactText, text));
        return s;
    }

    public static By exactTextMatchOfAnyOfTheStrings(String ... textStrings) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.ExactText, textStrings));
        return s;
    }

    public static By textContainsAnyOfTheStrings(String ... textStrings) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.TextContains, textStrings));
        return s;
    }

    public static By id(String id) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.AttributeValue, "id", id));
        return s;
    }

    public static By name(String name) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.AttributeValue, name));
        return s;
    }

    public static By tagName(String tagName) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.ControlType, tagName));
        return s;
    }

    public static By ordinalNumber(int ordinalNumber) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.OrdinalNumber, ordinalNumber));
        return s;
    }

    public static By textIsRegexMatch(String regularExpressionPattern) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.TextRegex, regularExpressionPattern));
        return s;
    }

    public static By textContainsString(String text) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.TextContains, text));
        return s;
    }

    public static By attributeValue(String attributeName, String attributeValue) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.AttributeValue, attributeName, attributeValue));
        return s;
    }

    public static By cssSelector(String cssLocator) {
        By s = new By();
        s.conditions.add(new SearchCondition(SearchConditionType.CssLocator, cssLocator));
        return s;
    }

    public By andByClassContains(String className) {
        this.conditions.add(new SearchCondition(SearchConditionType.AttributeValue, "classcontains", className));
        return this;
    }

    public By andByClass(String className) {
        this.conditions.add(new SearchCondition(SearchConditionType.AttributeValue, "class", className));
        return this;
    }

    public By andByOrdinalNumber(int ordinalNumber) {
        this.conditions.add(new SearchCondition(SearchConditionType.OrdinalNumber, ordinalNumber));
        return this;
    }

    public By andByTagName(String tagName) {
        this.conditions.add(new SearchCondition(SearchConditionType.ControlType, tagName));
        return this;
    }

    public By andByExactText(String exactText) {
        this.conditions.add(new SearchCondition(SearchConditionType.ExactText, exactText));
        return this;
    }

    public By andByTextIsRegexMatch(String regexPattern) {
        this.conditions.add(new SearchCondition(SearchConditionType.TextRegex, regexPattern));
        return this;
    }

    public By andByTextContainsString(String textContained) {
        this.conditions.add(new SearchCondition(SearchConditionType.TextContains, textContained));
        return this;
    }

    public By andByElementName(String name) {
        this.conditions.add(new SearchCondition(SearchConditionType.AttributeValue, "name", name));
        return this;
    }

    public By andById(String id) {
        this.conditions.add(new SearchCondition(SearchConditionType.AttributeValue, "id", id));
        return this;
    }

    public By andByAttributeValue(String attributeName, String attributeValue) {
        this.conditions.add(new SearchCondition(SearchConditionType.AttributeValue, attributeName, attributeValue));
        return this;
    }

    public By andByBeingDescendantOf(WebElement ancestor) {
        this.conditions.add(new SearchCondition(SearchConditionType.ByAncestor, ancestor));
        return this;
    }

    public By andByTextBeingExactlyAnyOfTheStrings(String ... textStrings) {
        this.conditions.add(new SearchCondition(SearchConditionType.ExactText, textStrings));
        return this;
    }

    public By andByTextContainingAnyOfTheStrings(String ... textStrings) {
        this.conditions.add(new SearchCondition(SearchConditionType.TextContains, textStrings));
        return this;
    }

    public By andByXPath(String xPath) {
        this.conditions.add(new SearchCondition(SearchConditionType.XPath, xPath));
        return this;
    }

    public String toString() {
        String returnString = "[By:" + System.lineSeparator();
        for (SearchCondition sc : this.conditions) {
            returnString = returnString + "   " + sc.toString() + System.lineSeparator();
        }
        return returnString + "]";
    }
}

