/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.elementidentification;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.logging.LogPost;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.websupport.DomElement;
import se.claremont.taf.websupport.elementidentification.By;
import se.claremont.taf.websupport.elementidentification.SearchCondition;
import se.claremont.taf.websupport.elementidentification.SearchConditionType;

public class WebElementIdentifier {
    private final DomElement domElement;
    private final WebDriver driver;
    private final TestCase testCase;
    private final boolean performLogging;

    public static WebElement getWebElement(TestCase testCase, WebDriver driver, DomElement domElement, boolean performLogging) {
        WebElementIdentifier webElementIdentifier = new WebElementIdentifier(testCase, driver, domElement, performLogging);
        return webElementIdentifier.getRuntimeElement();
    }

    public WebElementIdentifier(TestCase testCase, WebDriver driver, DomElement domElement, boolean performLogging) {
        this.domElement = domElement;
        this.driver = driver;
        this.testCase = testCase;
        this.performLogging = performLogging;
    }

    public WebElement getWebElement() {
        return this.getRuntimeElement();
    }

    private WebElement getRuntimeElement() {
        String xpath = this.createXPathFromBy();
        if (xpath == null) {
            return this.getElementByCssSelector();
        }
        return this.getElementByXpath(xpath);
    }

    private WebElement getElementByXpath(String xpath) {
        WebElement returnElement;
        try {
            List elements = this.driver.findElements(org.openqa.selenium.By.xpath((String)xpath));
            if (elements.size() == 0) {
                this.log(new LogPost(LogLevel.DEBUG, "Could not identify any matches for '" + this.domElement.name + "' by using xpath:" + System.lineSeparator() + "'" + xpath + "'" + System.lineSeparator() + "Built from By statement:" + System.lineSeparator() + this.domElement.by.toString(), null, this.testCase.testName, this.testCase.getCurrentTestStepName(), this.getClass().getSimpleName()));
                return null;
            }
            int ordinalNumber = 1;
            for (SearchCondition sc : this.domElement.by.conditions) {
                if (sc.getType() != SearchConditionType.OrdinalNumber) continue;
                ordinalNumber = (Integer)sc.value();
            }
            if (elements.size() < ordinalNumber) {
                ArrayList<String> elementDescriptions = new ArrayList<String>();
                for (WebElement webElement : elements) {
                    elementDescriptions.add(webElement.toString());
                }
                this.log(new LogPost(LogLevel.DEBUG, "Element '" + this.domElement.name + "' was supposed to be the " + ordinalNumber + " match for its search criteria. However, only " + elements.size() + " metching elements were found when it is identified by its xPath:" + System.lineSeparator() + "'" + xpath + "'" + System.lineSeparator() + ", based on its By statement: + " + System.lineSeparator() + this.domElement.by.toString() + System.lineSeparator() + "Elements found:" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), elementDescriptions), null, this.testCase.testName, this.testCase.getCurrentTestStepName(), this.getClass().getSimpleName()));
                return (WebElement)elements.get(0);
            }
            if (ordinalNumber < 1) {
                this.log(new LogPost(LogLevel.DEBUG, "Ordinal number to identify element '" + this.domElement.name + "' is less than one. Must be a positive integer.", null, this.testCase.testName, this.testCase.getCurrentTestStepName(), this.getClass().getSimpleName()));
                return null;
            }
            returnElement = (WebElement)elements.get(ordinalNumber - 1);
        }
        catch (Exception poff) {
            this.log(new LogPost(LogLevel.DEBUG, "Something went wrong trying to identify element '" + this.domElement.name + "'. Error: " + poff.toString(), null, this.testCase.testName, this.testCase.getCurrentTestStepName(), this.getClass().getSimpleName()));
            return null;
        }
        if (returnElement != null) {
            this.log(new LogPost(LogLevel.DEBUG, "Found exactly one IWebElement match for element '" + this.domElement.name + "' using xpath:" + System.lineSeparator() + "'" + xpath + "'" + System.lineSeparator() + ", created from the By statement:" + System.lineSeparator() + this.domElement.by.toString(), null, this.testCase.testName, this.testCase.getCurrentTestStepName(), this.getClass().getSimpleName()));
        }
        return returnElement;
    }

    private WebElement getElementByCssSelector() {
        try {
            List potentialMatches = this.driver.findElements(org.openqa.selenium.By.cssSelector((String)this.cssLocatorDescription()));
            if (potentialMatches == null || potentialMatches.size() == 0) {
                this.log(new LogPost(LogLevel.DEBUG, "Could not identify any match for element '" + this.domElement.name + "'. Used CSS identification to try to find it.", null, this.testCase.testName, this.testCase.getCurrentTestStepName(), this.getClass().getSimpleName()));
                return null;
            }
            int ordinalNumber = 1;
            for (SearchCondition sc : this.domElement.by.conditions) {
                if (sc.getType() != SearchConditionType.OrdinalNumber) continue;
                ordinalNumber = (Integer)sc.value();
            }
            if (ordinalNumber > potentialMatches.size()) {
                this.log(new LogPost(LogLevel.DEBUG, "Was expected to return element number " + ordinalNumber + " among the elements matching search criteria for '" + this.domElement.name + "' but only " + potentialMatches.size() + " element(s) were found. Continuing using the first element, even if this could be the wrong one.", null, this.testCase.testName, this.testCase.getCurrentTestStepName(), this.getClass().getSimpleName()));
            }
            if (potentialMatches.size() == 1) {
                this.log(new LogPost(LogLevel.DEBUG, "Found exactly one match for element '" + this.domElement.name + "' identified by CSS identification.", null, this.testCase.testName, this.testCase.getCurrentTestStepName(), this.getClass().getSimpleName()));
                return (WebElement)potentialMatches.get(0);
            }
            this.log(new LogPost(LogLevel.DEBUG, "Found " + potentialMatches.size() + " elements given the search conditions when trying to identify the '" + this.domElement.name + "' element. Continuing using match number " + ordinalNumber + ", even if this could be the wrong element.", null, this.testCase.testName, this.testCase.getCurrentTestStepName(), this.getClass().getSimpleName()));
            if (ordinalNumber > 0) {
                return (WebElement)potentialMatches.get(ordinalNumber - 1);
            }
            return (WebElement)potentialMatches.get(0);
        }
        catch (Exception e) {
            this.log(new LogPost(LogLevel.DEBUG, "Could not identify element '" + this.domElement.name + "'. Error: " + e.toString(), null, this.testCase.testName, this.testCase.getCurrentTestStepName(), this.getClass().getSimpleName()));
            return null;
        }
    }

    public String createXPathFromBy() {
        List<String> textIdentification;
        if (this.cssLocatorDescription() != null) {
            return null;
        }
        String xpathString = this.getXPathIfCriteria();
        if (xpathString != null) {
            return this.addXPathForAcestorIfApplicable() + xpathString;
        }
        StringBuilder xpath = new StringBuilder();
        xpath.append("//").append(this.identifyExpectedTagNameFromSearchCriterias());
        ArrayList<String> parts = new ArrayList<String>();
        List<String> attributes = this.getPropertiesFromBy();
        if (attributes.size() > 0) {
            parts.addAll(attributes);
        }
        if ((textIdentification = this.textRecognitionPartsOfElementBy()).size() > 0) {
            parts.addAll(textIdentification);
        }
        if (parts.size() > 0) {
            xpath.append("[").append(String.join((CharSequence)" and ", parts)).append("]");
        }
        return this.addXPathForAcestorIfApplicable() + xpath.toString();
    }

    private String addXPathForAcestorIfApplicable() {
        String ancestorXPath = "";
        for (SearchCondition sc : this.domElement.by.conditions) {
            if (sc.getType() != SearchConditionType.ByAncestor) continue;
            WebElement ancestor = (WebElement)sc.value();
            ancestorXPath = ancestorXPath + this.getWebElementXPath(ancestor);
        }
        return ancestorXPath;
    }

    private void log(LogPost logPost) {
        if (!this.performLogging) {
            return;
        }
        if (this.testCase == null) {
            System.out.println(logPost.toString());
        } else {
            this.testCase.log(logPost.logLevel, logPost.message);
        }
    }

    private String cssLocatorDescription() {
        for (SearchCondition sc : this.domElement.by.conditions) {
            if (sc.getType() != SearchConditionType.CssLocator) continue;
            return sc.value().toString();
        }
        return null;
    }

    private List<String> textRecognitionPartsOfElementBy() {
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<String> textPattern = new ArrayList<String>();
        for (SearchCondition sc : this.domElement.by.conditions) {
            switch (sc.getType()) {
                case ExactText: {
                    for (Object text : sc.Values()) {
                        textPattern.add((String)text);
                    }
                    String xpathString = "text()='" + String.join((CharSequence)"' or text()='", textPattern) + "'";
                    if (textPattern.size() > 1) {
                        xpathString = "(" + xpathString + ")";
                    }
                    parts.add(xpathString);
                    break;
                }
                case TextContains: {
                    for (Object text : sc.Values()) {
                        textPattern.add((String)text);
                    }
                    String xpathString = "contains(text(),'" + String.join((CharSequence)"') or contains(text(),'", textPattern) + "')";
                    if (textPattern.size() > 1) {
                        xpathString = "(" + xpathString + ")";
                    }
                    parts.add(xpathString);
                    break;
                }
                case TextRegex: {
                    parts.add("matches(text(), '" + sc.value() + "')");
                    break;
                }
            }
        }
        return parts;
    }

    private List<String> getPropertiesFromBy() {
        ArrayList<String> attributes = new ArrayList<String>();
        for (SearchCondition sc : this.domElement.by.conditions) {
            if (sc.getType() != SearchConditionType.AttributeValue) continue;
            if (((String)sc.Values()[0]).toLowerCase().equals("classcontains")) {
                String[] classes;
                for (String klass : classes = ((String)sc.Values()[1]).split(" ")) {
                    if (klass.trim().length() == 0) continue;
                    attributes.add("contains(@class, '" + klass.trim() + "')");
                }
                continue;
            }
            attributes.add("@" + sc.Values()[0] + "='" + sc.Values()[1] + "'");
        }
        return attributes;
    }

    private String getXPathIfCriteria() {
        String xpath = null;
        for (SearchCondition sc : this.domElement.by.conditions) {
            if (sc.getType() != SearchConditionType.XPath) continue;
            xpath = (String)sc.value();
            break;
        }
        if (xpath == null) {
            return null;
        }
        for (SearchCondition sc : this.domElement.by.conditions) {
            if (sc.getType() != SearchConditionType.OrdinalNumber) continue;
            xpath = xpath + "[" + sc.value() + "]";
            break;
        }
        return xpath;
    }

    private String identifyExpectedTagNameFromSearchCriterias() {
        for (SearchCondition sc : this.domElement.by.conditions) {
            if (sc.getType() != SearchConditionType.ControlType) continue;
            return (String)sc.value();
        }
        return "*";
    }

    private WebDriver getDriver(WebElement webElement) {
        WebDriver driver = null;
        try {
            driver = ((WrapsDriver)webElement).getWrappedDriver();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return driver;
    }

    public String getWebElementXPath(WebElement element) {
        if (element == null) {
            return null;
        }
        WebDriver driver = this.getDriver(element);
        if (driver == null) {
            return null;
        }
        return (String)((JavascriptExecutor)driver).executeScript("gPt=function(c){   if(c===document.body){       return c.tagName   }   var a=0;   var e=c.parentNode.childNodes;   for(var b=0;b<e.length;b++){       var d=e[b];       if(d===c){           return gPt(c.parentNode)+'/'+c.tagName+'['+(a+1)+']'       }       if(d.nodeType===1&&d.tagName===c.tagName){           a++}       }   };   return '//' + gPt(arguments[0]).toLowerCase();", new Object[]{element});
    }

    public static String createXPathFromBy(By by) {
        WebElementIdentifier identifier = new WebElementIdentifier(null, null, new DomElement(by), false);
        return identifier.createXPathFromBy();
    }
}

