/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.gui.recorder;

import java.awt.Component;
import javax.swing.JFrame;
import se.claremont.taf.core.gui.guistyle.TafButton;
import se.claremont.taf.core.gui.guistyle.TafDialog;
import se.claremont.taf.core.gui.guistyle.TafFrame;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.websupport.gui.recorder.WebRecorder;
import se.claremont.taf.websupport.webdrivergluecode.WebInteractionMethods;

public class RecorderWindow {
    WebInteractionMethods web = new WebInteractionMethods(new TestCase());
    WebRecorder webRecorder;

    public RecorderWindow(TafFrame parentWindow) {
        try {
            this.webRecorder = new WebRecorder(this.web.driver);
            new Thread(new RecordingEnvironment(this.web, this.webRecorder)).start();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        RecordStopButtonWindow recordStopButtonWindow = new RecordStopButtonWindow(parentWindow, this.web, this.webRecorder);
        new Thread(recordStopButtonWindow).start();
    }

    class RecordingEnvironment
    implements Runnable {
        WebInteractionMethods web;
        WebRecorder recorder;

        public RecordingEnvironment(WebInteractionMethods web, WebRecorder recorder) {
            this.recorder = recorder;
            this.web = web;
        }

        @Override
        public void run() {
            try {
                RecorderWindow.this.webRecorder.start();
            }
            catch (WebRecorder.WebDriverIsNotJavaScriptExecutorException e) {
                e.printStackTrace();
            }
        }
    }

    class RecordStopButtonWindow
    extends TafDialog
    implements Runnable {
        TafButton stopRecordingButton = new TafButton("Stop recording");
        TafDialog recordingWindow;
        TafFrame parentWindow;
        WebInteractionMethods web;
        WebRecorder recorder;

        public RecordStopButtonWindow(TafFrame parentWindow, WebInteractionMethods web, WebRecorder recorder) {
            this.parentWindow = parentWindow;
            this.recorder = recorder;
            this.web = web;
        }

        public TafDialog getRecordingWindow() {
            return this.recordingWindow;
        }

        @Override
        public void run() {
            this.recordingWindow = new TafDialog((JFrame)this.parentWindow, "TAF - Web recorder", true);
            this.recordingWindow.setLocationRelativeTo((Component)this.parentWindow);
            this.stopRecordingButton.setEnabled(false);
            this.stopRecordingButton.addActionListener(e -> {
                if (this.web != null) {
                    this.web.makeSureDriverIsClosed();
                }
                if (RecorderWindow.this.webRecorder != null) {
                    RecorderWindow.this.webRecorder.stop();
                }
                this.recordingWindow.setVisible(false);
                this.recordingWindow.dispose();
            });
            this.stopRecordingButton.setText("Stop recording");
            this.stopRecordingButton.setEnabled(true);
            this.stopRecordingButton.revalidate();
            this.recordingWindow.getContentPane().add((Component)this.stopRecordingButton);
            this.recordingWindow.pack();
            this.recordingWindow.setVisible(true);
        }
    }
}

