/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.gui.recorder.captureinfrastructure.restserver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import se.claremont.taf.websupport.gui.recorder.captureinfrastructure.restserver.Settings;

public class HttpServer {
    private ResourceConfig config = new ResourceConfig();
    Server server;

    public void start() {
        System.out.println(System.lineSeparator() + "Starting TAF recording listener REST Server." + System.lineSeparator());
        this.config.packages(new String[]{"se.claremont.autotest.websupport.gui.recorder.captureinfrastructure.restserver"});
        ServletHolder servlet = new ServletHolder((Servlet)new ServletContainer(this.config));
        this.server = new Server(Settings.port);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this.server, "/*");
        context.addServlet(servlet, "/*");
        try {
            this.server.start();
        }
        catch (Exception e) {
            System.out.println(System.lineSeparator() + e.getMessage());
        }
        if (this.isStarted()) {
            System.out.println(System.lineSeparator() + "TAF Recording listener REST server started.");
        } else {
            System.out.println(System.lineSeparator() + "Could not start REST server." + System.lineSeparator());
        }
    }

    public boolean isStarted() {
        return this.server != null && !this.server.isFailed();
    }

    public void stop() {
        try {
            this.server.stop();
            this.server.destroy();
            System.out.println(System.lineSeparator() + "Server stopped." + System.lineSeparator());
        }
        catch (Exception e) {
            System.out.println("Error stopping HTTP server: " + e.toString());
        }
    }

    public static String getIPAddressesOfLocalMachine() {
        String ip = "Could not identify local IP address.";
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return ip;
    }
}

