/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.gui.recorder.captureinfrastructure.restserver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import se.claremont.taf.core.gui.Gui;
import se.claremont.taf.core.gui.teststructure.TestStep;
import se.claremont.taf.websupport.DomElement;
import se.claremont.taf.websupport.gui.recorder.captureinfrastructure.restserver.HttpServer;
import se.claremont.taf.websupport.gui.recorder.captureinfrastructure.restserver.Settings;
import se.claremont.taf.websupport.gui.teststeps.WebAttributeChangeTestStep;
import se.claremont.taf.websupport.gui.teststeps.WebClickTestStep;
import se.claremont.taf.websupport.gui.teststeps.WebInputTestStep;

@Path(value="tafwebrecorder")
public class Resource {
    @GET
    @Path(value="version")
    @Produces(value={"text/html"})
    public String versionHtml() {
        return "<html><body><p>TAF Recording REST server code version 1.0.</p></body></html>";
    }

    @GET
    @Path(value="instructions")
    @Produces(value={"text/html"})
    public String instructions() {
        return "<html>   <body>      <h1>TAF web recording</h1>      <p>         Use at own risk.      </p>    </body></html>";
    }

    @POST
    @Path(value="v1/click")
    public void clickPerformed(String data) {
        data = data.replace("%20", " ");
        String text = null;
        try {
            text = URLDecoder.decode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e);
        }
        System.out.println("Received POST request to http://" + HttpServer.getIPAddressesOfLocalMachine() + ":" + Settings.port + "/tafwebrecorder/v1/click with content: '" + text + "'.");
        Gui.addTestStepToListOfAvailableTestSteps((TestStep)new WebClickTestStep(new DomElement(text)));
    }

    @POST
    @Path(value="v1/checkbox")
    public void checkboxChangePerformed(String data) {
        data = data.replace("%20", " ");
        String text = null;
        try {
            text = URLDecoder.decode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e);
        }
        System.out.println("Received POST request to http://" + HttpServer.getIPAddressesOfLocalMachine() + ":" + Settings.port + "/tafwebrecorder/v1/checkbox with content: '" + text + "'.");
        Gui.addTestStepToListOfAvailableTestSteps((TestStep)new WebClickTestStep(new DomElement(text)));
    }

    @POST
    @Path(value="v1/input")
    public void inputPerformed(String data) {
        try {
            data = URLDecoder.decode(data.substring("webElement=".length()).replace("%20", " "), "UTF-8");
            System.out.println("Received POST request to http://" + HttpServer.getIPAddressesOfLocalMachine() + ":" + Settings.port + "/tafwebrecorder/v1/input with content: '" + data + "'.");
            DomElement domElement = new DomElement(data);
            ObjectMapper om = new ObjectMapper();
            JsonNode jsonNode = null;
            try {
                jsonNode = om.readTree(data);
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
            String text = "";
            if (jsonNode.get("text").asText() != null && jsonNode.get("text").asText().length() > 0) {
                text = jsonNode.get("text").asText();
            }
            Gui.addTestStepToListOfAvailableTestSteps((TestStep)new WebInputTestStep(domElement, text));
        }
        catch (Throwable ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    @POST
    @Path(value="v1/domchange")
    public void domChanged(String data) {
        try {
            data = URLDecoder.decode(data.substring("mutation=".length()).replace("%20", " "), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e);
        }
        System.out.println("Received POST request to http://" + HttpServer.getIPAddressesOfLocalMachine() + ":" + Settings.port + "/tafwebrecorder/v1/domchange with content: '" + data + "'.");
        ObjectMapper om = new ObjectMapper();
        JsonNode jsonNode = null;
        try {
            jsonNode = om.readTree(data);
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        if (jsonNode == null) {
            return;
        }
        if (!Resource.valueForAttributeInJson(jsonNode, "targetTagName").toLowerCase().equals("input")) {
            return;
        }
        String elementJSON = "webElement={\"tagName\": \"" + Resource.valueForAttributeInJson(jsonNode, "targetTagName") + "\", ";
        elementJSON = elementJSON + "\"className\": \"" + Resource.valueForAttributeInJson(jsonNode, "targetClassName") + "\", ";
        elementJSON = elementJSON + "\"xpath\": \"" + Resource.valueForAttributeInJson(jsonNode, "targetXpath") + "\",  ";
        elementJSON = elementJSON + "\"text\": \"\", ";
        elementJSON = elementJSON + "\"id\": \"" + Resource.valueForAttributeInJson(jsonNode, "tergetId") + "\"}";
        DomElement element = null;
        try {
            element = new DomElement(elementJSON);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        if (Resource.valueForAttributeInJson(jsonNode, "type").contains("attributes")) {
            WebAttributeChangeTestStep testStep = new WebAttributeChangeTestStep(element, Resource.valueForAttributeInJson(jsonNode, "attributeName"), Resource.valueForAttributeInJson(jsonNode, "oldValue"), Resource.valueForAttributeInJson(jsonNode, "newValue"));
            Gui.addTestStepToListOfAvailableTestSteps((TestStep)testStep);
        }
    }

    private static String valueForAttributeInJson(JsonNode jsonNode, String attributeName) {
        try {
            return jsonNode.get(attributeName).asText().replace("\"", "\\\"");
        }
        catch (Throwable throwable) {
            return "";
        }
    }
}

