/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.gui.teststeps;

import java.io.Serializable;
import se.claremont.taf.core.gui.teststructure.TestCaseManager;
import se.claremont.taf.core.gui.teststructure.TestStep;
import se.claremont.taf.core.gui.teststructure.TestStepResult;
import se.claremont.taf.core.testcase.TestCaseResult;
import se.claremont.taf.websupport.DomElement;
import se.claremont.taf.websupport.gui.teststeps.ReplayManager;

public class WebAttributeChangeTestStep
extends TestStep
implements Serializable {
    DomElement domElement;
    String attributeName;
    String oldAttributeValue;
    String newAttributeValue;

    public WebAttributeChangeTestStep() {
        this.setName("Attribute change on element");
        this.setDescription("Attribute change on element " + this.domElement.name + ".");
    }

    public WebAttributeChangeTestStep(String name, String description) {
        super(name, description);
    }

    public WebAttributeChangeTestStep(DomElement domElement, String attributeName, String oldAttributeValue, String newAttributeValue) {
        super("Attribute '" + attributeName + "' changed on " + domElement.name, "The attribute '" + attributeName + "' was changed from '" + oldAttributeValue + "' to '" + newAttributeValue + "' on the DomElement named '" + domElement.name + "'.");
        this.attributeName = attributeName;
        this.oldAttributeValue = oldAttributeValue;
        this.newAttributeValue = newAttributeValue;
        this.domElement = domElement;
        this.actionName = "Attribute change";
        this.setElementName(domElement.name);
    }

    public String asCode() {
        TestCaseManager.testSetCode.makeSureRequiredImportIsAdded("import se.claremont.autotest.websupport.webdrivergluecode.WebInteractionMethods;");
        TestCaseManager.testSetCode.makeSureBeginTestSectionDeclarationExist("web = new WebInteractionsMethod(currentTestCase());");
        TestCaseManager.testSetCode.makeSureClassVariableIsDeclared("WebInteractionMethods web;");
        return "web.click(new DomElement(By." + this.domElement.by.toString() + ");";
    }

    public TestStep clone() {
        WebAttributeChangeTestStep clonedStep = new WebAttributeChangeTestStep(this.getName(), this.getDescription());
        clonedStep.setActionName(this.actionName);
        clonedStep.setElementName(this.elementName);
        clonedStep.domElement = this.domElement;
        return clonedStep;
    }

    public String getTestStepTypeShortName() {
        return "Web";
    }

    public TestStepResult execute() {
        TestStepResult testStepResult = new TestStepResult((TestStep)this, TestStepResult.Result.NOT_RUN);
        try {
            ReplayManager.WebDriverSingleton.getInstance().click(this.domElement);
        }
        catch (Throwable e) {
            testStepResult.updateResultStatus(TestStepResult.Result.FAIL);
            return testStepResult;
        }
        if (TestCaseManager.getTestCase().testCaseResult.resultStatus == TestCaseResult.ResultStatus.PASSED) {
            testStepResult.updateResultStatus(TestStepResult.Result.PASS);
        } else {
            testStepResult.updateResultStatus(TestStepResult.Result.FAIL);
        }
        return testStepResult;
    }
}

