/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.gui.teststeps;

import java.io.Serializable;
import se.claremont.taf.core.gui.teststructure.TestCaseManager;
import se.claremont.taf.core.gui.teststructure.TestStep;
import se.claremont.taf.core.gui.teststructure.TestStepResult;
import se.claremont.taf.core.testcase.TestCaseResult;
import se.claremont.taf.websupport.gui.teststeps.ReplayManager;

public class WebNavigationTestStep
extends TestStep
implements Serializable {
    public WebNavigationTestStep() {
    }

    public WebNavigationTestStep(String name, String description) {
        super(name, description);
    }

    public WebNavigationTestStep(String newUrl) {
        super("Navigation to '" + newUrl + "'", "Navigation performed to new URL '" + newUrl + "'.");
        this.setActionName("Navigate");
        this.setElementName("browser");
        this.setAssociatedData(newUrl);
    }

    public String asCode() {
        TestCaseManager.testSetCode.makeSureRequiredImportIsAdded("import se.claremont.autotest.websupport.webdrivergluecode.WebInteractionMethods;");
        TestCaseManager.testSetCode.makeSureBeginTestSectionDeclarationExist("web = new WebInteractionsMethod(currentTestCase());");
        TestCaseManager.testSetCode.makeSureClassVariableIsDeclared("WebInteractionMethods web;");
        return "   web.navigate(\"" + this.getAssociatedData().toString() + "\");";
    }

    public TestStep clone() {
        WebNavigationTestStep clonedStep = new WebNavigationTestStep(this.getName(), this.getDescription());
        clonedStep.setActionName(this.actionName);
        clonedStep.setElementName(this.elementName);
        clonedStep.setAssociatedData(this.getAssociatedData());
        return clonedStep;
    }

    public String getTestStepTypeShortName() {
        return "Web";
    }

    public TestStepResult execute() {
        TestStepResult testStepResult = new TestStepResult((TestStep)this, TestStepResult.Result.NOT_RUN);
        try {
            ReplayManager.WebDriverSingleton.getInstance().navigate((String)this.getAssociatedData());
        }
        catch (Throwable e) {
            testStepResult.updateResultStatus(TestStepResult.Result.FAIL);
            return testStepResult;
        }
        if (TestCaseManager.getTestCase().testCaseResult.resultStatus == TestCaseResult.ResultStatus.PASSED) {
            testStepResult.updateResultStatus(TestStepResult.Result.PASS);
        } else {
            testStepResult.updateResultStatus(TestStepResult.Result.FAIL);
        }
        return testStepResult;
    }
}

