/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.webdrivergluecode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.claremont.taf.core.support.StringManagement;
import se.claremont.taf.core.support.SupportMethods;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.websupport.DomElement;
import se.claremont.taf.websupport.webdrivergluecode.WebInteractionMethods;

class WebPageCodeConstructor {
    private static final Logger logger = LoggerFactory.getLogger(WebPageCodeConstructor.class);
    private WebDriver driver;
    private final Constructors constructors = new Constructors();
    private final List<String> methodNames = new ArrayList<String>();
    private static WebInteractionMethods web;
    private static int numberOfUnMappedElements;
    private static JavascriptExecutor javascriptDriver;

    private WebPageCodeConstructor(WebDriver driver) {
        if (driver == null) {
            return;
        }
        this.driver = driver;
    }

    static String ConstructWebPageCode(WebDriver driver, String pathToOutputFile, boolean mapEvenBadlyIdentifiedElements) {
        javascriptDriver = (JavascriptExecutor)driver;
        web = new WebInteractionMethods(new TestCase(), driver);
        WebPageCodeConstructor webPageCodeConstructor = new WebPageCodeConstructor(driver);
        String descriptors = "//Auto-generated with mapCurrentPage() method of WebInteractionMethods." + System.lineSeparator() + System.lineSeparator() + webPageCodeConstructor.constructWebPageCodeElementByElement(mapEvenBadlyIdentifiedElements);
        if (numberOfUnMappedElements > 0) {
            descriptors = descriptors + System.lineSeparator() + "//If you run the ConstructWebPageCode() method with mapEvenBadlyIdentifiedElements = true the " + numberOfUnMappedElements + " elements now currently not mapped will get Xpath identifications.";
        }
        SupportMethods.saveToFile((String)descriptors, (String)pathToOutputFile);
        return descriptors;
    }

    static String ConstructWebPageCode(WebDriver driver, String pathToOutputFile) {
        javascriptDriver = (JavascriptExecutor)driver;
        web = new WebInteractionMethods(new TestCase(), driver);
        WebPageCodeConstructor webPageCodeConstructor = new WebPageCodeConstructor(driver);
        String descriptors = "//Auto-generated with mapCurrentPage() method of WebInteractionMethods." + System.lineSeparator() + System.lineSeparator() + webPageCodeConstructor.constructWebPageCodeElementByElement(false);
        if (numberOfUnMappedElements > 0) {
            descriptors = descriptors + System.lineSeparator() + "//If you run the ConstructWebPageCode() method with mapEvenBadlyIdentifiedElements = true the " + numberOfUnMappedElements + " elements now currently not mapped will get Xpath identifications.";
        }
        SupportMethods.saveToFile((String)(WebPageCodeConstructor.pageClassHeader(driver.getTitle()) + descriptors + WebPageCodeConstructor.pageClassFooter()), (String)pathToOutputFile);
        return descriptors;
    }

    public static String ConstructWebPageCodeThorough(WebDriver driver, String outputFilePath) {
        javascriptDriver = (JavascriptExecutor)driver;
        web = new WebInteractionMethods(new TestCase(), driver);
        WebPageCodeConstructor webPageCodeConstructor = new WebPageCodeConstructor(driver);
        String descriptors = "//Auto-generated with mapCurrentPage() method of WebInteractionMethods." + System.lineSeparator() + System.lineSeparator() + webPageCodeConstructor.constructWebPageCodeByTreeTraversing();
        if (numberOfUnMappedElements > 0) {
            descriptors = descriptors + System.lineSeparator() + "//If you run the ConstructWebPageCode() method with mapEvenBadlyIdentifiedElements = true the " + numberOfUnMappedElements + " elements now currently not mapped will get Xpath identifications.";
        }
        SupportMethods.saveToFile((String)descriptors, (String)outputFilePath);
        return descriptors;
    }

    private String unusedMethodName(String suggestedMethodName) {
        int elementCounter = 2;
        String methodNameToTry = suggestedMethodName;
        while (this.methodNameAlreadyUsed(methodNameToTry)) {
            methodNameToTry = suggestedMethodName + String.valueOf(elementCounter);
            ++elementCounter;
        }
        this.methodNames.add(methodNameToTry);
        return methodNameToTry;
    }

    private static String pageClassHeader(String pageTitle) {
        StringBuilder sb = new StringBuilder();
        sb.append("import se.claremont.autotest.websupport.DomElement;").append(System.lineSeparator());
        sb.append(System.lineSeparator());
        String className = StringManagement.methodNameWithOnlySafeCharacters((String)pageTitle);
        if (className.length() > 50) {
            className = className.substring(0, 50);
        }
        sb.append("public class ").append(className.substring(0, 1).toUpperCase()).append(className.substring(1)).append("Page {").append(System.lineSeparator());
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private static String pageClassFooter() {
        return System.lineSeparator() + "}" + System.lineSeparator();
    }

    private boolean methodNameAlreadyUsed(String nameToTry) {
        return this.methodNames.stream().anyMatch(m -> m.equals(nameToTry));
    }

    private String constructWebPageCodeElementByElement(boolean mapEvenBadlyIdentifiedElements) {
        List webElements = this.driver.findElements(By.xpath((String)"//body//*"));
        for (WebElement webElement : webElements) {
            Constructor constructor = this.attemptAddElementConstructor(webElement, mapEvenBadlyIdentifiedElements);
            if (constructor == null) continue;
            this.constructors.addConstructor(constructor);
        }
        return this.constructors.toString();
    }

    public String constructWebPageCodeByTreeTraversing() {
        this.addConstructorForSubElementsOf("//body");
        return this.constructors.toString();
    }

    private void addConstructorForSubElementsOf(String rootNodeXpath) {
        for (WebElement child : this.getChildren(rootNodeXpath)) {
            if (!this.hasBranschingChildren(WebPageCodeConstructor.generateXPATH(child, ""))) {
                Constructor constructor = this.attemptIdentifyElementConstructorRecursive(child);
                if (constructor == null) continue;
                String nameSuggestion = this.identifyBestName(child);
                if (nameSuggestion != null && nameSuggestion.length() > 0) {
                    constructor.setName(nameSuggestion);
                }
                this.constructors.addConstructor(constructor);
                continue;
            }
            this.addConstructorForSubElementsOf(WebPageCodeConstructor.generateXPATH(child, ""));
        }
    }

    private String identifyBestName(WebElement element) {
        String text = this.getAnyTextFromAnyChildren(element);
        if (text != null && text.length() > 0 && text.length() < 50) {
            return StringManagement.methodNameWithOnlySafeCharacters((String)this.unusedMethodName(text.replace("\"", "\\\"") + "_" + WebPageCodeConstructor.tagNameToElementSuffix(element.getTagName())));
        }
        text = this.getAnyAttributeFromAnyChildren(element);
        if (text != null && text.length() > 0) {
            return StringManagement.methodNameWithOnlySafeCharacters((String)this.unusedMethodName(text.replace("\"", "\\\"") + "_" + WebPageCodeConstructor.tagNameToElementSuffix(element.getTagName())));
        }
        return null;
    }

    private String getAnyAttributeFromAnyChildren(WebElement webElement) {
        if (webElement == null) {
            return null;
        }
        Map<String, String> attributes = this.getAttributes(webElement);
        if (attributes != null && attributes.size() > 0) {
            String attributeString = "";
            for (String attributeKey : attributes.keySet()) {
                attributeString = attributeString + attributeKey + "_" + attributes.get(attributeKey) + "_";
            }
            attributeString = attributeString + WebPageCodeConstructor.tagNameToElementSuffix(webElement.getTagName());
            return StringManagement.methodNameWithOnlySafeCharacters((String)this.unusedMethodName(attributeString));
        }
        List<WebElement> children = this.getChildren(webElement);
        for (WebElement child : children) {
            String attibutes = this.getAnyAttributeFromAnyChildren(child);
            if (attibutes == null) continue;
            return attibutes;
        }
        return null;
    }

    private WebElement getParent(WebElement child) {
        WebElement parent = null;
        try {
            parent = child.findElement(By.xpath((String)".."));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return parent;
    }

    private String getAnyTextFromAnyChildren(WebElement webElement) {
        if (webElement == null) {
            return null;
        }
        List<WebElement> children = this.getChildren(webElement);
        if (children.size() == 0) {
            String text = webElement.getText();
            if (text != null && text.length() > 0) {
                return text;
            }
            WebElement parent = webElement;
            while (parent != null) {
                parent = this.getParent(webElement);
                text = parent.getText();
                if (text != null && text.length() > 0) {
                    return text;
                }
                webElement = parent;
            }
        } else {
            return this.getAnyTextFromAnyChildren(children.get(0));
        }
        return null;
    }

    private Constructor attemptIdentifyElementConstructorRecursive(WebElement webElement) {
        Constructor constructor = this.attemptAddElementConstructor(webElement, false);
        if (constructor != null) {
            return constructor;
        }
        List<WebElement> children = this.getChildren(WebPageCodeConstructor.generateXPATH(webElement, ""));
        for (WebElement child : children) {
            constructor = this.attemptIdentifyElementConstructorRecursive(child);
            if (constructor == null) continue;
            return constructor;
        }
        return null;
    }

    private boolean hasBranschingChildren(String xpathOfParent) {
        List<WebElement> children = this.getChildren(xpathOfParent);
        if (children.size() < 1) {
            return false;
        }
        if (children.size() > 1) {
            return true;
        }
        return this.hasBranschingChildren(xpathOfParent + "/*[1]");
    }

    private List<WebElement> getChildren(WebElement rootElement) {
        String elementXpath = WebPageCodeConstructor.generateXPATH(rootElement, "");
        return this.driver.findElements(By.xpath((String)(elementXpath + "/*")));
    }

    private List<WebElement> getChildren(String rootElementXpath) {
        return this.driver.findElements(By.xpath((String)(rootElementXpath + "/*")));
    }

    private Map<String, String> getAttributes(WebElement element) {
        Map attributes = null;
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (element == null) {
            return returnMap;
        }
        try {
            attributes = (Map)javascriptDriver.executeScript("var items = {}; for (index = 0; index < arguments[0].attributes.length; ++index) { items[arguments[0].attributes[index].name] = arguments[0].attributes[index].value }; return items;", new Object[]{element});
        }
        catch (Exception e) {
            System.out.println("Could not get attributes for element. " + e.toString());
        }
        if (attributes == null) {
            return returnMap;
        }
        for (String key : attributes.keySet()) {
            returnMap.put(key, (String)attributes.get(key));
        }
        return returnMap;
    }

    private Constructor attemptAddElementConstructor(WebElement webElement, boolean mapEvenBadlyIdentifiedElements) {
        try {
            Map<String, String> attributes;
            String elementClass;
            String name;
            String recognitionString = null;
            String id = webElement.getAttribute("id");
            String tagName = webElement.getTagName();
            if (id != null && id.length() > 0) {
                String suggestedElementName = StringManagement.methodNameWithOnlySafeCharacters((String)id) + "_" + WebPageCodeConstructor.tagNameToElementSuffix(tagName);
                recognitionString = id;
                if ((suggestedElementName + recognitionString).length() < 200 && WebPageCodeConstructor.recognitionOnlyHasOneMatch(recognitionString, DomElement.IdentificationType.BY_ID)) {
                    recognitionString = recognitionString.replace("\"", "\\\"");
                    String suggestedElementConstructorString = "\"" + recognitionString + "\", DomElement.IdentificationType.BY_ID";
                    return new Constructor(this.unusedMethodName(suggestedElementName), suggestedElementConstructorString);
                }
            }
            if ((name = webElement.getAttribute("name")) != null && name.length() > 0) {
                String suggestedElementName = StringManagement.methodNameWithOnlySafeCharacters((String)name) + "_" + WebPageCodeConstructor.tagNameToElementSuffix(tagName);
                recognitionString = name;
                if ((suggestedElementName + recognitionString).length() < 200 && WebPageCodeConstructor.recognitionOnlyHasOneMatch(recognitionString, DomElement.IdentificationType.BY_NAME)) {
                    recognitionString = recognitionString.replace("\"", "\\\"");
                    String suggestedElementConstructorString = "\"" + recognitionString + "\", DomElement.IdentificationType.BY_NAME";
                    return new Constructor(this.unusedMethodName(suggestedElementName), suggestedElementConstructorString);
                }
            }
            String text = null;
            if (tagName.equals("a") && (text = webElement.getText()) != null && text.length() > 0) {
                String suggestedElementName = StringManagement.methodNameWithOnlySafeCharacters((String)text) + "_Link";
                recognitionString = text;
                if (!recognitionString.contains(System.lineSeparator()) && !recognitionString.contains("\n") && !recognitionString.contains("\r") && (suggestedElementName + recognitionString).length() < 200 && WebPageCodeConstructor.recognitionOnlyHasOneMatch(recognitionString, DomElement.IdentificationType.BY_LINK_TEXT)) {
                    recognitionString = recognitionString.replace("\"", "\\\"");
                    String suggestedElementConstructorString = "\"" + recognitionString + "\", DomElement.IdentificationType.BY_LINK_TEXT";
                    return new Constructor(this.unusedMethodName(suggestedElementName), suggestedElementConstructorString);
                }
            }
            if ((elementClass = webElement.getAttribute("class")) != null && elementClass.length() > 0) {
                String suggestedElementName = StringManagement.methodNameWithOnlySafeCharacters((String)elementClass) + "_" + WebPageCodeConstructor.tagNameToElementSuffix(tagName);
                recognitionString = elementClass;
                if ((suggestedElementName + recognitionString).length() < 200 && WebPageCodeConstructor.recognitionOnlyHasOneMatch(recognitionString, DomElement.IdentificationType.BY_CLASS)) {
                    recognitionString = recognitionString.replace("\"", "\\\"");
                    String suggestedElementConstructorString = "\"" + recognitionString + "\", DomElement.IdentificationType.BY_CLASS";
                    return new Constructor(this.unusedMethodName(suggestedElementName), suggestedElementConstructorString);
                }
            }
            if ((attributes = this.getAttributes(webElement)) != null) {
                boolean matchFound = false;
                for (String key : attributes.keySet()) {
                    if (key.toLowerCase().equals("class") || key.toLowerCase().equals("id") || (recognitionString = key + "=" + attributes.get(key)).length() >= 150 || !WebPageCodeConstructor.recognitionOnlyHasOneMatch(recognitionString, DomElement.IdentificationType.BY_ATTRIBUTE_VALUE)) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound) {
                    recognitionString = recognitionString.replace("\"", "\\\"");
                    String suggestedElementConstructorString = "\"" + recognitionString + "\", DomElement.IdentificationType.BY_ATTRIBUTE_VALUE";
                    String suggestedElementName = StringManagement.methodNameWithOnlySafeCharacters((String)recognitionString.replace("=", "_")) + "_" + WebPageCodeConstructor.tagNameToElementSuffix(tagName);
                    return new Constructor(this.unusedMethodName(suggestedElementName), suggestedElementConstructorString);
                }
                if (attributes.size() > 1) {
                    for (int i = 0; i < attributes.size() - 1; ++i) {
                        int j = i + 1;
                        while (i < attributes.size()) {
                            String key1 = (String)attributes.keySet().toArray()[i];
                            String key2 = (String)attributes.keySet().toArray()[j];
                            recognitionString = "//" + tagName + "[@" + key1 + "='" + attributes.get(key1) + "' and @" + key2 + "='" + attributes.get(key2) + "']";
                            if ((recognitionString = recognitionString.replace("\"", "\\\"")).length() < 200 && WebPageCodeConstructor.recognitionOnlyHasOneMatch(recognitionString, DomElement.IdentificationType.BY_X_PATH)) {
                                String suggestedElementConstructorString = "\"" + recognitionString + "\", DomElement.IdentificationType.BY_ATTRIBUTE_VALUE";
                                String suggestedElementName = StringManagement.methodNameWithOnlySafeCharacters((String)recognitionString.replace("=", "_")) + "_" + WebPageCodeConstructor.tagNameToElementSuffix(tagName);
                                return new Constructor(this.unusedMethodName(suggestedElementName), suggestedElementConstructorString);
                            }
                            ++i;
                        }
                    }
                }
            }
            if (text == null) {
                text = webElement.getText();
            }
            if (!(text == null || text.length() <= 0 || text.contains(System.lineSeparator()) || text.contains("\n") || text.contains("\r") || text.length() >= 200)) {
                List matchingElements = null;
                try {
                    matchingElements = this.driver.findElements(By.xpath((String)("//" + tagName + "[contains(text(),'" + webElement.getText() + "')]")));
                }
                catch (Exception e) {
                    System.out.println("Problems matching elements for page contruction: " + e.toString());
                }
                if (matchingElements != null && matchingElements.size() == 1) {
                    String suggestedElementName = StringManagement.methodNameWithOnlySafeCharacters((String)webElement.getText()) + "_" + WebPageCodeConstructor.tagNameToElementSuffix(tagName);
                    String suggestedElementConstructorString = "";
                    int numberOfElementsFound = this.driver.findElements(By.xpath((String)("//" + tagName + "[contains(text(),'" + text + "')]"))).size();
                    if (numberOfElementsFound == 1) {
                        suggestedElementConstructorString = suggestedElementConstructorString + "\"//" + tagName + "[contains(text(),'" + text.replace("\"", "\\\"").replace("'", "\"") + "')]\", DomElement.IdentificationType.BY_X_PATH";
                        return new Constructor(this.unusedMethodName(suggestedElementName), suggestedElementConstructorString);
                    }
                }
            }
            if (mapEvenBadlyIdentifiedElements) {
                return new Constructor(this.unusedMethodName("Badly_identified_element"), "\"" + WebPageCodeConstructor.generateXPATH(webElement, "") + "\", DomElement.IdentificationType.BY_XPATH");
            }
            ++numberOfUnMappedElements;
        }
        catch (Exception e) {
            System.out.println("Could not create costructor for element. " + e.toString());
        }
        return null;
    }

    private static String generateXPATH(WebElement childElement, String current) {
        String childTag = childElement.getTagName();
        if (childTag.equals("html")) {
            return "/html[1]" + current;
        }
        WebElement parentElement = childElement.findElement(By.xpath((String)".."));
        List childrenElements = parentElement.findElements(By.xpath((String)"*"));
        int count = 0;
        for (int i = 0; i < childrenElements.size(); ++i) {
            WebElement childrenElement = (WebElement)childrenElements.get(i);
            String childrenElementTag = childrenElement.getTagName();
            if (childTag.equals(childrenElementTag)) {
                ++count;
            }
            if (!childElement.equals(childrenElement)) continue;
            return WebPageCodeConstructor.generateXPATH(parentElement, "/" + childTag + "[" + count + "]" + current);
        }
        return null;
    }

    private static boolean recognitionOnlyHasOneMatch(String suggestedRecognitionString, DomElement.IdentificationType identificationType) {
        Integer numberOfMatches = web.getRuntimeElementMatchCount(new DomElement(suggestedRecognitionString, identificationType));
        return numberOfMatches == 1;
    }

    private static String tagNameToElementSuffix(String tagName) {
        if (tagName.toLowerCase().equals("a")) {
            return "Link";
        }
        if (tagName.toLowerCase().equals("li")) {
            return "ListItem";
        }
        if (tagName.toLowerCase().equals("ul")) {
            return "UnordereredList";
        }
        if (tagName.toLowerCase().equals("ol")) {
            return "NumberedList";
        }
        if (tagName.toLowerCase().equals("h1")) {
            return "MainHeading";
        }
        if (tagName.toLowerCase().equals("h2")) {
            return "Heading";
        }
        if (tagName.toLowerCase().equals("h3")) {
            return "SubHeading";
        }
        if (tagName.toLowerCase().equals("p")) {
            return "Paragraph";
        }
        if (tagName.toLowerCase().equals("div")) {
            return "Div";
        }
        return StringManagement.firstUpperLetterTrailingLowerLetter((String)tagName);
    }

    static {
        numberOfUnMappedElements = 0;
        javascriptDriver = null;
    }

    private class Constructor {
        String elementName;
        final String constructorString;

        Constructor(String elementName, String constructorString) {
            this.elementName = elementName;
            this.constructorString = constructorString;
            logger.debug("Creating: " + SupportMethods.LF + this.toString());
            System.out.println("Creating element: " + System.lineSeparator() + this.toString());
        }

        void setName(String name) {
            this.elementName = name;
        }

        public String toString() {
            return SupportMethods.LF + "public static DomElement " + this.elementName + "() {" + SupportMethods.LF + "    return new DomElement (" + this.constructorString + ");" + SupportMethods.LF + "}" + SupportMethods.LF;
        }
    }

    private class Constructors
    extends ArrayList<Constructor> {
        int elementCounter = 1;

        private Constructors() {
        }

        void addConstructor(Constructor constructor) {
            if (this.hasUniqueName(constructor)) {
                this.add(constructor);
            } else {
                constructor.elementName = constructor.elementName + Integer.toString(this.elementCounter);
                ++this.elementCounter;
                this.add(constructor);
            }
        }

        boolean hasUniqueName(Constructor constructor) {
            for (Constructor constr : this) {
                if (!constr.elementName.equals(constructor.elementName)) continue;
                return false;
            }
            return true;
        }

        public boolean hasUniqueDescriptor(Constructor constructor) {
            for (Constructor constr : this) {
                if (!constr.constructorString.equals(constructor.constructorString)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Constructor constructor : this) {
                stringBuilder.append(constructor.toString());
            }
            return stringBuilder.toString();
        }
    }
}

