/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.webdrivergluecode.positionbasedidentification;

import java.util.ArrayList;
import se.claremont.taf.core.guidriverpluginstructure.PositionBasedIdentification.ElementsList;
import se.claremont.taf.core.guidriverpluginstructure.PositionBasedIdentification.PositionBasedGuiElement;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.websupport.DomElement;
import se.claremont.taf.websupport.webdrivergluecode.WebInteractionMethods;
import se.claremont.taf.websupport.webdrivergluecode.positionbasedidentification.PositionBasedWebElement;

public class WebElementList
extends ElementsList {
    private WebInteractionMethods web = null;
    final ArrayList<String> identificationDescription = new ArrayList();

    WebElementList(ArrayList<PositionBasedWebElement> webElementList, WebInteractionMethods web, ArrayList<String> previousIdentificationDescription) {
        this.elements = webElementList;
        this.web = web;
        this.identificationDescription.addAll(previousIdentificationDescription);
    }

    public WebElementList keepOnlyElementsWithText() {
        long startTime = System.currentTimeMillis();
        ArrayList<PositionBasedWebElement> returnList = new ArrayList<PositionBasedWebElement>();
        for (PositionBasedGuiElement element : this.elements) {
            PositionBasedWebElement webElement = (PositionBasedWebElement)element;
            String text = webElement.getText();
            if (text == null || text.length() <= 0) continue;
            returnList.add(webElement);
        }
        this.identificationDescription.add("From the element set of " + this.elements.size() + " element(s) only the " + returnList.size() + " element(s) containing any text were kept. " + WebElementList.duration(startTime));
        return new WebElementList(returnList, this.web, this.identificationDescription);
    }

    private static String duration(long startTime) {
        return System.currentTimeMillis() - startTime + " milliseconds spent in this operation. ";
    }

    public WebElementList keepOnlyVisibleElements() {
        long startTime = System.currentTimeMillis();
        ArrayList<PositionBasedWebElement> returnList = new ArrayList<PositionBasedWebElement>();
        for (PositionBasedGuiElement element : this.elements) {
            PositionBasedWebElement webElement = (PositionBasedWebElement)element;
            if (!webElement.isDisplayed()) continue;
            returnList.add(webElement);
        }
        this.identificationDescription.add("From the element set of " + this.elements.size() + " element(s) only the " + returnList.size() + " visible element(s) were kept. " + WebElementList.duration(startTime));
        return new WebElementList(returnList, this.web, this.identificationDescription);
    }

    public WebElementList keepElementsOfType(String typeName) {
        long startTime = System.currentTimeMillis();
        WebElementList returnList = WebElementList.convertElementListToWebElementList(super.keepElementsOfType(typeName), this.web, this.identificationDescription);
        returnList.identificationDescription.add("From the element set of " + this.elements.size() + " element(s) only the " + returnList.elements.size() + " element(s) of type '" + typeName + "' were kept. " + WebElementList.duration(startTime));
        return returnList;
    }

    public WebElementList keepElementsToTheRightOf(DomElement domElement, WebInteractionMethods web) {
        long startTime = System.currentTimeMillis();
        if (domElement == null || web == null) {
            this.identificationDescription.add("Could not attempt to only keep elements to the right of reference element since WebInteractionMethods or the reference element was null. " + WebElementList.duration(startTime));
            return new WebElementList(new ArrayList<PositionBasedWebElement>(), web, this.identificationDescription);
        }
        WebElementList returnList = WebElementList.convertElementListToWebElementList(super.keepElementsToTheRightOf((PositionBasedGuiElement)domElement.asPositionBasedWebElement(web)), web, this.identificationDescription);
        returnList.identificationDescription.add("From the element set of " + this.elements.size() + " element(s) only the " + returnList.elements.size() + " element(s) to the right of element [" + domElement.LogIdentification() + "] were kept. ");
        return returnList;
    }

    public WebElementList keepElementsToTheLeftOf(DomElement domElement, WebInteractionMethods web) {
        long startTime = System.currentTimeMillis();
        if (domElement == null || web == null) {
            this.identificationDescription.add("Could not attempt to only keep elements to the left of reference element since WebInteractionMethods or the reference element was null. " + WebElementList.duration(startTime));
            return new WebElementList(new ArrayList<PositionBasedWebElement>(), web, this.identificationDescription);
        }
        WebElementList returnList = WebElementList.convertElementListToWebElementList(super.keepElementsToTheLeftOf((PositionBasedGuiElement)domElement.asPositionBasedWebElement(web)), web, this.identificationDescription);
        returnList.identificationDescription.add("From the element set of " + this.elements.size() + " element(s) only the " + returnList.elements.size() + " element(s) to the left of element [" + domElement.LogIdentification() + "] were kept. " + WebElementList.duration(startTime));
        return returnList;
    }

    public WebElementList keepElementsAbove(DomElement domElement, WebInteractionMethods web) {
        long startTime = System.currentTimeMillis();
        if (domElement == null || web == null) {
            this.identificationDescription.add("Could not attempt to only keep elements above the reference element since WebInteractionMethods or the reference element was null. " + WebElementList.duration(startTime));
            return new WebElementList(new ArrayList<PositionBasedWebElement>(), web, this.identificationDescription);
        }
        WebElementList returnList = WebElementList.convertElementListToWebElementList(super.keepElementsAbove((PositionBasedGuiElement)domElement.asPositionBasedWebElement(web)), web, this.identificationDescription);
        returnList.identificationDescription.add("From the element set of " + this.elements.size() + " element(s) only the " + returnList.elements.size() + " element(s) above the element [" + domElement.LogIdentification() + "] were kept. " + WebElementList.duration(startTime));
        return returnList;
    }

    public WebElementList keepElementsBelow(DomElement domElement, WebInteractionMethods web) {
        long startTime = System.currentTimeMillis();
        if (domElement == null || web == null) {
            this.identificationDescription.add("Could not attempt to only keep elements below the reference element since WebInteractionMethods or the reference element was null. " + WebElementList.duration(startTime));
            return new WebElementList(new ArrayList<PositionBasedWebElement>(), web, this.identificationDescription);
        }
        WebElementList returnList = WebElementList.convertElementListToWebElementList(super.keepElementsBelow((PositionBasedGuiElement)domElement.asPositionBasedWebElement(web)), web, this.identificationDescription);
        returnList.identificationDescription.add("From the element set of " + this.elements.size() + " element(s) only the " + returnList.elements.size() + " element(s) below the element [" + domElement.LogIdentification() + "] were kept. " + WebElementList.duration(startTime));
        return returnList;
    }

    public WebElementList keepElementsToTheRightOf(String elementText, WebInteractionMethods web) {
        return this.keepElementsToTheRightOf(this.identifyDomElementFromText(elementText), web);
    }

    public WebElementList keepElementsToTheLeftOf(String elementText, WebInteractionMethods web) {
        return this.keepElementsToTheLeftOf(this.identifyDomElementFromText(elementText), web);
    }

    public WebElementList keepElementsAbove(String elementText, WebInteractionMethods web) {
        return this.keepElementsAbove(this.identifyDomElementFromText(elementText), web);
    }

    public WebElementList keepElementsBelow(String elementText, WebInteractionMethods web) {
        return this.keepElementsBelow(this.identifyDomElementFromText(elementText), web);
    }

    public WebElementList atTheSameHightAs(DomElement domElement, WebInteractionMethods web) {
        long startTime = System.currentTimeMillis();
        if (domElement == null || web == null) {
            this.identificationDescription.add("Could not attempt to identify the elements at the same height as the reference element since either the reference element or the WebInteractionMethods object was null. " + WebElementList.duration(startTime));
            return new WebElementList(new ArrayList<PositionBasedWebElement>(), web, this.identificationDescription);
        }
        WebElementList returnList = WebElementList.convertElementListToWebElementList(super.atTheSameHeightAs((PositionBasedGuiElement)domElement.asPositionBasedWebElement(web)), web, this.identificationDescription);
        returnList.identificationDescription.add("From the element set of " + this.elements.size() + " element(s) only the " + returnList.elements.size() + " element(s) at the same hight as element [" + domElement.LogIdentification() + "] were kept. " + WebElementList.duration(startTime));
        return returnList;
    }

    public WebElementList atTheSameHeightAs(DomElement domElement, WebInteractionMethods web, int marginPixelsAbove, int marginPixelsBelow) {
        long startTime = System.currentTimeMillis();
        if (domElement == null || web == null) {
            this.identificationDescription.add("Could not attempt to identify the elements at the same height as the reference element since either the reference element or the WebInteractionMethods object was null. " + WebElementList.duration(startTime));
            return new WebElementList(new ArrayList<PositionBasedWebElement>(), web, this.identificationDescription);
        }
        WebElementList returnList = WebElementList.convertElementListToWebElementList(super.atTheSameHeightAs((PositionBasedGuiElement)domElement.asPositionBasedWebElement(web), marginPixelsAbove, marginPixelsBelow), web, this.identificationDescription);
        returnList.identificationDescription.add("From the element set of " + this.elements.size() + " element(s) only the " + returnList.elements.size() + " element(s) at the same hight as element [" + domElement.LogIdentification() + "] were kept (margin above " + marginPixelsAbove + "px and margin below " + marginPixelsBelow + "px.) " + WebElementList.duration(startTime));
        return returnList;
    }

    public WebElementList atTheSameHightAs(String elementText, WebInteractionMethods web) {
        long startTime = System.currentTimeMillis();
        if (web == null) {
            this.identificationDescription.add("Could not attempt to identify the elements at the same height as the reference element since the WebInteractionMethods object was null. " + WebElementList.duration(startTime));
            return new WebElementList(new ArrayList<PositionBasedWebElement>(), null, this.identificationDescription);
        }
        WebElementList returnList = WebElementList.convertElementListToWebElementList(super.atTheSameHeightAs((PositionBasedGuiElement)this.identifyDomElementFromText(elementText).asPositionBasedWebElement(web)), web, this.identificationDescription);
        returnList.identificationDescription.add("From the element set of " + this.elements.size() + " element(s) only the " + returnList.elements.size() + " element(s) at the same hight as element with test " + elementText + "' were kept. " + WebElementList.duration(startTime));
        return returnList;
    }

    public WebElementList atTheSameHeightAs(String elementText, WebInteractionMethods web, int marginPixelsAbove, int marginPixelsBelow) {
        long startTime = System.currentTimeMillis();
        if (elementText == null || web == null) {
            this.identificationDescription.add("Could not attempt to identify the elements at the same height as the reference element since either the reference element or the WebInteractionMethods object was null. " + WebElementList.duration(startTime));
            return new WebElementList(new ArrayList<PositionBasedWebElement>(), web, this.identificationDescription);
        }
        WebElementList returnList = WebElementList.convertElementListToWebElementList(super.atTheSameHeightAs((PositionBasedGuiElement)this.identifyDomElementFromText(elementText).asPositionBasedWebElement(web), marginPixelsAbove, marginPixelsBelow), web, this.identificationDescription);
        returnList.identificationDescription.add("From the element set of " + this.elements.size() + " element(s) only the " + returnList.elements.size() + " element(s) at the same hight as element with text '" + elementText + "' were kept (margin above " + marginPixelsAbove + "px and margin below " + marginPixelsBelow + "px.) " + WebElementList.duration(startTime));
        return returnList;
    }

    public PositionBasedGuiElement theObjectMostToTheRight() {
        long startTime = System.currentTimeMillis();
        PositionBasedGuiElement positionBasedGuiElement = super.theObjectMostToTheRight();
        if (positionBasedGuiElement == null) {
            this.identificationDescription.add("Tried returning a DomElement of the element most to the right, but could not identify any element. Returning null. " + WebElementList.duration(startTime));
            this.attemptLog();
            return null;
        }
        this.identificationDescription.add("Returning the element most to the right as a DomElement. " + WebElementList.duration(startTime));
        this.attemptLog();
        return positionBasedGuiElement;
    }

    public PositionBasedGuiElement theObjectMostToTheLeft() {
        long startTime = System.currentTimeMillis();
        PositionBasedGuiElement positionBasedGuiElement = super.theObjectMostToTheLeft();
        if (positionBasedGuiElement == null) {
            this.identificationDescription.add("Tried returning a DomElement of the element most to the left, but could not identify any element. Returning null. " + WebElementList.duration(startTime));
            this.attemptLog();
            return null;
        }
        this.identificationDescription.add("Returning the element most to the left as a DomElement. " + WebElementList.duration(startTime));
        this.attemptLog();
        return positionBasedGuiElement;
    }

    public PositionBasedGuiElement theObjectMostToTheTop() {
        long startTime = System.currentTimeMillis();
        PositionBasedGuiElement positionBasedGuiElement = super.theObjectMostToTheTop();
        if (positionBasedGuiElement == null) {
            this.identificationDescription.add("Tried returning a DomElement of the element most to the top, but could not identify any element. Returning null. " + WebElementList.duration(startTime));
            this.attemptLog();
            return null;
        }
        this.identificationDescription.add("Returning the element most to the top as a DomElement. " + WebElementList.duration(startTime));
        this.attemptLog();
        return positionBasedGuiElement;
    }

    public PositionBasedGuiElement theObjectMostToTheBottom() {
        long startTime = System.currentTimeMillis();
        PositionBasedGuiElement positionBasedGuiElement = super.theObjectMostToTheBottom();
        if (positionBasedGuiElement == null) {
            this.identificationDescription.add("Tried returning a DomElement of the element most to the bottom, but could not identify any element. Returning null. " + WebElementList.duration(startTime));
            this.attemptLog();
            return null;
        }
        this.identificationDescription.add("Returning the element most to the bottom as a DomElement. " + WebElementList.duration(startTime));
        this.attemptLog();
        return positionBasedGuiElement;
    }

    public PositionBasedGuiElement theOnlyElementThatShouldBeLeft() {
        long startTime = System.currentTimeMillis();
        PositionBasedGuiElement positionBasedGuiElement = super.theOnlyElementThatShouldBeLeft();
        if (positionBasedGuiElement == null) {
            this.identificationDescription.add("Tried returning a DomElement of the only element that should be left in the collection, but could not identify any element. Returning null. " + WebElementList.duration(startTime));
            this.attemptLog();
            return null;
        }
        this.identificationDescription.add("Returning the only element that should be left in the collection (actually returning the first element) as a DomElement. " + WebElementList.duration(startTime));
        this.attemptLog();
        return positionBasedGuiElement;
    }

    public DomElement elementImmediatelyToTheRightOf(DomElement domElement, WebInteractionMethods web) {
        long startTime = System.currentTimeMillis();
        if (domElement == null || web == null) {
            this.identificationDescription.add("Could not identify element immediately to the right of reference element since the reference element or the WebInteractionMethods object was null. Returning null. " + WebElementList.duration(startTime));
            this.attemptLog();
            return null;
        }
        PositionBasedGuiElement positionBasedGuiElement = super.elementImmediatelyToTheRightOf((PositionBasedGuiElement)domElement.asPositionBasedWebElement(web));
        if (positionBasedGuiElement == null) {
            this.identificationDescription.add("Could not identify element immediately to the right of reference element since no suitable element could be found. Returning null. " + WebElementList.duration(startTime));
            this.attemptLog();
            return null;
        }
        this.identificationDescription.add("Identified a suitable element being immediately to the right of DomElement [" + domElement.LogIdentification() + "]. Returning the following element: " + positionBasedGuiElement.toString() + ". " + WebElementList.duration(startTime));
        this.attemptLog();
        return ((PositionBasedWebElement)positionBasedGuiElement).asDomElement();
    }

    public DomElement elementImmediatelyToTheLeftOf(DomElement domElement, WebInteractionMethods web) {
        long startTime = System.currentTimeMillis();
        if (domElement == null || web == null) {
            this.identificationDescription.add("Could not identify element immediately to the left of reference element since the reference element or the WebInteractionMethods object was null. Returning null. " + WebElementList.duration(startTime));
            this.attemptLog();
            return null;
        }
        PositionBasedGuiElement positionBasedGuiElement = super.elementImmediatelyToTheLeftOf((PositionBasedGuiElement)domElement.asPositionBasedWebElement(web));
        if (positionBasedGuiElement == null) {
            this.identificationDescription.add("Could not identify element immediately to the left of reference element since no suitable element could be found. Returning null. " + WebElementList.duration(startTime));
            this.attemptLog();
            return null;
        }
        this.identificationDescription.add("Identified a suitable element being immediately to the left of DomElement [" + domElement.LogIdentification() + "]. Returning the following element: " + positionBasedGuiElement.toString() + ". " + WebElementList.duration(startTime));
        this.attemptLog();
        return ((PositionBasedWebElement)positionBasedGuiElement).asDomElement();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[WebElementList: ");
        for (PositionBasedGuiElement element : this.elements) {
            sb.append(element.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    private static WebElementList convertElementListToWebElementList(ElementsList elementsList, WebInteractionMethods web, ArrayList<String> previousIdentificationDescription) {
        long startTime = System.currentTimeMillis();
        ArrayList<PositionBasedWebElement> webElements = new ArrayList<PositionBasedWebElement>();
        for (PositionBasedGuiElement guiElement : elementsList.elements) {
            webElements.add((PositionBasedWebElement)guiElement);
        }
        return new WebElementList(webElements, web, previousIdentificationDescription);
    }

    private DomElement identifyDomElementFromText(String elementText) {
        long startTime = System.currentTimeMillis();
        DomElement domElement = null;
        ArrayList<PositionBasedWebElement> possibleElements = new ArrayList<PositionBasedWebElement>();
        for (PositionBasedGuiElement positionBasedGuiElement : this.elements) {
            PositionBasedWebElement positionBasedWebElement = (PositionBasedWebElement)positionBasedGuiElement;
            String text = positionBasedWebElement.getText();
            if (text == null || !text.contains(elementText)) continue;
            possibleElements.add(positionBasedWebElement);
        }
        if (possibleElements.size() == 1) {
            this.identificationDescription.add("Found one single element containing the text '" + elementText + ". Making a DomElement from it. " + WebElementList.duration(startTime));
            domElement = new DomElement((PositionBasedWebElement)possibleElements.get(0));
        } else if (possibleElements.size() > 1) {
            for (PositionBasedWebElement positionBasedWebElement : possibleElements) {
                if (!positionBasedWebElement.getText().equals(elementText)) continue;
                this.identificationDescription.add("Found " + possibleElements.size() + " element containing the text '" + elementText + "', but also found element with exact match for the text. Making a DomElement from it. " + WebElementList.duration(startTime));
                domElement = new DomElement(positionBasedWebElement);
                break;
            }
        }
        if (domElement == null) {
            this.identificationDescription.add("Could not find any element containing the text '" + elementText + "', but created a DomElement regardsless for chance of it to appear. " + WebElementList.duration(startTime));
            domElement = new DomElement(elementText, DomElement.IdentificationType.BY_VISIBLE_TEXT);
        }
        return domElement;
    }

    private void attemptLog() {
        StringBuilder sb = new StringBuilder();
        sb.append("Procedure for identifying element by position:").append(System.lineSeparator());
        for (int i = 1; i < this.identificationDescription.size() + 1; ++i) {
            sb.append("  ").append(i).append("). ").append(this.identificationDescription.get(i - 1)).append(System.lineSeparator());
        }
        if (this.web == null) {
            System.out.println(sb.toString());
        } else {
            this.web.log(LogLevel.DEBUG, sb.toString());
        }
    }
}

