/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.websupport.webdrivergluecode.positionbasedidentification;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import se.claremont.taf.core.guidriverpluginstructure.PositionBasedIdentification.PositionBasedGuiElement;
import se.claremont.taf.websupport.DomElement;
import se.claremont.taf.websupport.webdrivergluecode.WebInteractionMethods;

public class PositionBasedWebElement
implements PositionBasedGuiElement {
    private Integer left = null;
    private Integer right = null;
    private Integer top = null;
    private Integer bottom = null;
    private String typeName = null;
    private String text = null;
    private Boolean displayed = null;
    public final WebElement webElement;
    private WebDriver driver = null;

    public PositionBasedWebElement(DomElement domElement, WebInteractionMethods web) {
        this.webElement = web.getRuntimeElementWithoutLogging(domElement);
        this.driver = web.driver;
    }

    public PositionBasedWebElement(String elementText, WebInteractionMethods web) {
        this.driver = web.driver;
        this.text = elementText;
        this.webElement = web.getRuntimeElementWithoutLogging(new DomElement(this.text, DomElement.IdentificationType.BY_VISIBLE_TEXT));
    }

    public PositionBasedWebElement(WebElement webElement) {
        this.webElement = webElement;
    }

    private WebDriver getDriver() {
        if (this.driver == null) {
            try {
                this.driver = ((WrapsDriver)this.webElement).getWrappedDriver();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.driver;
    }

    public WebElement getWebElement() {
        return this.webElement;
    }

    public ArrayList<PositionBasedWebElement> childrenImmediate() {
        List subElements = this.webElement.findElements(By.xpath((String)"/*"));
        ArrayList<PositionBasedWebElement> positionBasedWebElements = new ArrayList<PositionBasedWebElement>();
        for (WebElement we : subElements) {
            positionBasedWebElements.add(new PositionBasedWebElement(we));
        }
        return positionBasedWebElements;
    }

    public WebElement asWebElement() {
        return this.getWebElement();
    }

    public DomElement asDomElement() {
        return new DomElement(this.webElement);
    }

    public DomElement asDomElement(String elementName, String elementPageName) {
        return new DomElement(this.webElement, elementName, elementPageName);
    }

    public ArrayList<PositionBasedWebElement> childrenRecursive() {
        List subElements = this.webElement.findElements(By.xpath((String)"//*"));
        ArrayList<PositionBasedWebElement> positionBasedWebElements = new ArrayList<PositionBasedWebElement>();
        for (WebElement we : subElements) {
            positionBasedWebElements.add(new PositionBasedWebElement(we));
        }
        return positionBasedWebElements;
    }

    public Integer getLeftPosition() {
        if (this.left == null) {
            try {
                this.left = this.webElement.getLocation().x;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.left;
    }

    public Integer getRightPosition() {
        if (this.right == null) {
            try {
                this.right = this.webElement.getLocation().x + this.webElement.getSize().width;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.right;
    }

    public Integer getTopPosition() {
        if (this.top == null) {
            try {
                this.top = this.webElement.getLocation().y;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.top;
    }

    public Integer getBottomPosition() {
        if (this.bottom == null) {
            try {
                this.bottom = this.webElement.getLocation().y + this.webElement.getSize().height;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.bottom;
    }

    public String getTypeName() {
        if (this.typeName == null) {
            this.typeName = this.webElement.getTagName();
        }
        return this.typeName;
    }

    public Object runtimeElement() {
        return this.webElement;
    }

    public String getText() {
        if (this.text == null) {
            try {
                this.text = this.webElement.getText();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.text;
    }

    public ArrayList<PositionBasedGuiElement> childElements() {
        ArrayList<PositionBasedGuiElement> list = new ArrayList<PositionBasedGuiElement>();
        for (PositionBasedWebElement element : this.childrenRecursive()) {
            list.add(element);
        }
        return list;
    }

    public PositionBasedWebElement parentElement() {
        WebElement parent = null;
        try {
            parent = this.webElement.findElement(By.xpath((String)".."));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PositionBasedWebElement(parent);
    }

    public boolean isDisplayed() {
        if (this.displayed == null) {
            try {
                this.displayed = this.webElement.isDisplayed();
            }
            catch (Exception e) {
                this.displayed = false;
            }
        }
        return this.displayed;
    }

    public String toString() {
        return "[PositionBasedWebElement: ElementType='" + this.getTypeName() + "', text='" + this.getText() + "', top=" + this.getTopPosition() + ", bottom=" + this.getBottomPosition() + ", left=" + this.getLeftPosition() + ", right=" + this.getRightPosition() + ", displayed=" + String.valueOf(this.isDisplayed()) + "]";
    }
}

