/*
 * Decompiled with CFR 0.152.
 */
package com.zingtongroup.loggingseleniumwebdriver;

import com.zingtongroup.loggingseleniumwebdriver.loggertypes.ConsoleLogger;
import com.zingtongroup.loggingseleniumwebdriver.logging.LogLevel;
import com.zingtongroup.loggingseleniumwebdriver.logging.Logger;
import com.zingtongroup.loggingseleniumwebdriver.logging.LoggerList;
import com.zingtongroup.loggingseleniumwebdriver.logging.LoggingSeleniumWebDriverException;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingNavigation;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingOptions;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingSeleniumComponent;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingTargetLocator;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingWebElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class LoggingSeleniumWebDriver
implements WebDriver,
LoggingSeleniumComponent {
    public LoggerList loggerList = new LoggerList();
    public WebDriver originalWebDriver;

    public LoggingSeleniumWebDriver(WebDriver webDriver) {
        this();
        this.loggerList.add(new ConsoleLogger());
        this.originalWebDriver = webDriver;
        this.log("Starting driver of type " + this.originalWebDriver.getClass().getName() + ".");
    }

    public LoggingSeleniumWebDriver() {
    }

    public LoggingSeleniumWebDriver attachWebDriverInstance(WebDriver driver) throws LoggingSeleniumWebDriverException {
        if (this.originalWebDriver != null) {
            throw new LoggingSeleniumWebDriverException("Attaching new driver instance when driver instance is already set require driver detach.");
        }
        this.originalWebDriver = driver;
        this.logInfo("Starting driver of type " + this.originalWebDriver.getClass().getName() + ".");
        return this;
    }

    public LoggingSeleniumWebDriver setMinimumLogLevel(LogLevel logLevel) {
        this.loggerList.minimumLogLevel = logLevel;
        return this;
    }

    public LoggingSeleniumWebDriver detachWebDriverInstance() {
        this.originalWebDriver = null;
        return this;
    }

    public LoggingSeleniumWebDriver addLogger(Logger logger) {
        this.loggerList.add(logger);
        return this;
    }

    @Override
    public void log(String message) {
        this.loggerList.logInfo(message);
    }

    public void logDebug(String message) {
        this.loggerList.logDebug(message);
    }

    public void logException(Exception e) {
        this.loggerList.logException(e);
    }

    public void logInfo(String message) {
        this.loggerList.logInfo(message);
    }

    public void logVerificationPassed(String message) {
        this.loggerList.logVerificationPassed(message);
    }

    public void logVerificationProblem(String message) {
        this.loggerList.logVerificationProblem(message);
    }

    public void logVerificationFailed(String message) {
        this.loggerList.logVerificationFailed(message);
    }

    public void logExecutionStep(String message) {
        this.loggerList.logExecutionStep(message);
    }

    @Override
    public void pauseLogging() {
        this.loggerList.pauseLogging();
    }

    @Override
    public void resumeLogging() {
        this.loggerList.resumeLogging();
    }

    public void get(String url) {
        this.logExecutionStep("Navigating to '" + url + "'.");
        this.originalWebDriver.get(url);
    }

    public String getCurrentUrl() {
        String url = this.originalWebDriver.getCurrentUrl();
        this.logDebug("Retrieving current URL (='" + url + "').");
        return url;
    }

    public String getTitle() {
        String title = this.originalWebDriver.getTitle();
        this.logDebug("Retrieving current page title (='" + title + "').");
        return title;
    }

    public List<WebElement> findElements(By by) {
        List elements = this.originalWebDriver.findElements(by);
        this.logDebug("Identifying " + elements.size() + " elements for By statement '" + by.toString() + "'.");
        ArrayList<WebElement> elements2 = new ArrayList<WebElement>();
        for (WebElement webElement : elements) {
            elements2.add(new LoggingWebElement(webElement, this.loggerList));
        }
        return elements2;
    }

    public WebElement findElement(By by) {
        WebElement element = this.originalWebDriver.findElement(by);
        if (element == null) {
            this.logDebug("Could not identify any element for By statement '" + by.toString() + "'.");
            return null;
        }
        this.logDebug("Identified element for By statement '" + by.toString() + "'.");
        return new LoggingWebElement(element, this.loggerList);
    }

    public String getPageSource() {
        this.logInfo("Retrieving current page source.");
        return this.originalWebDriver.getPageSource();
    }

    public void close() {
        this.logInfo("Closing web driver.");
        this.originalWebDriver.close();
    }

    public void quit() {
        this.logInfo("Quitting web driver instance.");
        this.originalWebDriver.quit();
    }

    public Set<String> getWindowHandles() {
        Set windowHandles = this.originalWebDriver.getWindowHandles();
        this.logDebug("Retrieved " + windowHandles.size() + " window handles.");
        return windowHandles;
    }

    public String getWindowHandle() {
        String handle = this.originalWebDriver.getWindowHandle();
        this.logDebug("Identified current window handle (='" + handle + "').");
        return handle;
    }

    public WebDriver.TargetLocator switchTo() {
        return new LoggingTargetLocator(this.originalWebDriver.switchTo(), this.loggerList);
    }

    public WebDriver.Navigation navigate() {
        return new LoggingNavigation(this.originalWebDriver.navigate(), this.loggerList);
    }

    public WebDriver.Options manage() {
        return new LoggingOptions(this.originalWebDriver.manage(), this.loggerList);
    }

    public static class Builder {
        private WebDriver driver = null;
        private final LoggerList loggerList = new LoggerList();
        private LogLevel minimumLogLevel = null;

        public Builder addLogger(Logger logger) {
            this.loggerList.add(logger);
            return this;
        }

        public Builder attachWebDriverInstance(WebDriver webDriver) {
            this.driver = webDriver;
            return this;
        }

        public Builder removeAllLoggers() {
            this.loggerList.removeAllLoggers();
            return this;
        }

        public Builder startWithLoggingPaused() {
            this.loggerList.pauseLogging();
            return this;
        }

        public LoggingSeleniumWebDriver build() {
            LoggingSeleniumWebDriver loggingSeleniumWebDriver = new LoggingSeleniumWebDriver(this.driver);
            loggingSeleniumWebDriver.loggerList = this.loggerList;
            if (this.minimumLogLevel != null) {
                loggingSeleniumWebDriver.setMinimumLogLevel(this.minimumLogLevel);
            }
            return loggingSeleniumWebDriver;
        }

        public Builder setMinimumLogLevel(LogLevel minimumLogLevel) {
            this.minimumLogLevel = minimumLogLevel;
            return this;
        }
    }
}

