/*
 * Decompiled with CFR 0.152.
 */
package com.zingtongroup.loggingseleniumwebdriver.loggertypes;

import com.zingtongroup.loggingseleniumwebdriver.logging.LogPost;
import com.zingtongroup.loggingseleniumwebdriver.logging.Logger;
import com.zingtongroup.loggingseleniumwebdriver.logging.TestFlowLogLevel;
import java.text.SimpleDateFormat;

public class ConsoleLogger
implements Logger {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int longestLogLevelNameLength = 0;

    public ConsoleLogger() {
        for (TestFlowLogLevel level : TestFlowLogLevel.values()) {
            if (level.toString().length() <= this.longestLogLevelNameLength) continue;
            this.longestLogLevelNameLength = level.toString().length();
        }
    }

    @Override
    public void addLogPost(LogPost logPost) {
        String evenLengthLogLevel = logPost.logLevel.toString() + " ".repeat(Math.max(0, this.longestLogLevelNameLength - logPost.logLevel.toString().length()));
        System.out.println(this.sdf.format(logPost.date) + " " + evenLengthLogLevel + ": " + logPost.logMessage);
    }
}

