/*
 * Decompiled with CFR 0.152.
 */
package com.zingtongroup.loggingseleniumwebdriver.logging;

import com.zingtongroup.loggingseleniumwebdriver.logging.LogLevel;
import com.zingtongroup.loggingseleniumwebdriver.logging.LogPost;
import com.zingtongroup.loggingseleniumwebdriver.logging.Logger;
import com.zingtongroup.loggingseleniumwebdriver.logging.TestFlowLogLevel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class LoggerList
extends ArrayList<Logger> {
    public boolean isPaused = false;
    public LogLevel minimumLogLevel = TestFlowLogLevel.INFO;

    public void setMinimumLogLevel(LogLevel minimumLogLevel) {
        this.minimumLogLevel = minimumLogLevel;
    }

    private void addLogPostToLoggers(LogPost logPost) {
        for (Logger logger : this) {
            try {
                logger.addLogPost(logPost);
            }
            catch (Exception e) {
                for (Logger l : this) {
                    if (l.equals(logger)) continue;
                    l.addLogPost(new LogPost(TestFlowLogLevel.EXCEPTION, e.toString()));
                }
                throw e;
            }
        }
    }

    public void logException(Exception e) {
        LogPost logPost = new LogPost(TestFlowLogLevel.EXCEPTION, e.getMessage());
        this.addLogPostToLoggers(logPost);
    }

    public void logDebug(String logMessage) {
        if (this.isPaused) {
            return;
        }
        LogPost logPost = new LogPost(TestFlowLogLevel.DEBUG, logMessage);
        if (logPost.logLevel.getValue() < this.minimumLogLevel.getValue()) {
            return;
        }
        this.addLogPostToLoggers(logPost);
    }

    public void logVerificationPassed(String logMessage) {
        if (this.isPaused) {
            return;
        }
        LogPost logPost = new LogPost(TestFlowLogLevel.PASSED_VERIFICATION, logMessage);
        if (logPost.logLevel.getValue() < this.minimumLogLevel.getValue()) {
            return;
        }
        this.addLogPostToLoggers(logPost);
    }

    public void logVerificationFailed(String logMessage) {
        if (this.isPaused) {
            return;
        }
        LogPost logPost = new LogPost(TestFlowLogLevel.FAILED_VERIFICATION, logMessage);
        if (logPost.logLevel.getValue() < this.minimumLogLevel.getValue()) {
            return;
        }
        this.addLogPostToLoggers(logPost);
    }

    public void logVerificationProblem(String logMessage) {
        if (this.isPaused) {
            return;
        }
        LogPost logPost = new LogPost(TestFlowLogLevel.VERIFICATION_PROBLEM, logMessage);
        if (logPost.logLevel.getValue() < this.minimumLogLevel.getValue()) {
            return;
        }
        this.addLogPostToLoggers(logPost);
    }

    public void logInfo(String logMessage) {
        if (this.isPaused) {
            return;
        }
        LogPost logPost = new LogPost(TestFlowLogLevel.INFO, logMessage);
        if (logPost.logLevel.getValue() < this.minimumLogLevel.getValue()) {
            return;
        }
        this.addLogPostToLoggers(logPost);
    }

    public void logExecutionStep(String logMessage) {
        if (this.isPaused) {
            return;
        }
        LogPost logPost = new LogPost(TestFlowLogLevel.EXECUTION_STEP, logMessage);
        if (logPost.logLevel.getValue() < this.minimumLogLevel.getValue()) {
            return;
        }
        this.addLogPostToLoggers(logPost);
    }

    public void log(String logMessage) {
        if (this.isPaused) {
            return;
        }
        LogPost logPost = new LogPost(TestFlowLogLevel.EXECUTION_STEP, logMessage);
        if (logPost.logLevel.getValue() < this.minimumLogLevel.getValue()) {
            return;
        }
        this.addLogPostToLoggers(logPost);
    }

    public Set<String> getLoggerTypes() {
        HashSet<String> loggerNames = new HashSet<String>();
        for (Logger logger : this) {
            if (loggerNames.contains(logger.getClass().getName())) continue;
            loggerNames.add(logger.getClass().getName());
        }
        return loggerNames;
    }

    public Logger getLoggerOfType(String typeName) {
        for (Logger logger : this) {
            if (!logger.getClass().getName().equals(typeName)) continue;
            return logger;
        }
        return null;
    }

    public void removeAllLoggers() {
        this.clear();
    }

    public Logger getLoggerOfType(Class<?> type) {
        for (Logger logger : this) {
            if (!logger.getClass().isAssignableFrom(type)) continue;
            return logger;
        }
        return null;
    }

    public void pauseLogging() {
        this.isPaused = true;
    }

    public void resumeLogging() {
        this.isPaused = false;
    }
}

