/*
 * Decompiled with CFR 0.152.
 */
package com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents;

import com.zingtongroup.loggingseleniumwebdriver.logging.LoggerList;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingSeleniumComponent;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingTimeouts;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingWindow;
import java.util.Set;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.Logs;

public class LoggingOptions
implements WebDriver.Options,
LoggingSeleniumComponent {
    public final LoggerList loggerList;
    public final WebDriver.Options options;

    public LoggingOptions(WebDriver.Options options, LoggerList loggerList) {
        this.loggerList = loggerList;
        this.options = options;
    }

    @Override
    public void pauseLogging() {
        this.loggerList.pauseLogging();
    }

    @Override
    public void resumeLogging() {
        this.loggerList.resumeLogging();
    }

    @Override
    public void log(String logMessage) {
        this.loggerList.log(logMessage);
    }

    public void addCookie(Cookie cookie) {
        this.loggerList.logExecutionStep("Adding cookie.");
        this.options.addCookie(cookie);
    }

    public void deleteCookieNamed(String name) {
        this.loggerList.logExecutionStep("Deleting cookie named '" + name + "'.");
        this.options.deleteCookieNamed(name);
    }

    public void deleteCookie(Cookie cookie) {
        this.loggerList.logExecutionStep("Deleting cookie.");
        this.options.deleteCookie(cookie);
    }

    public void deleteAllCookies() {
        this.loggerList.logExecutionStep("Deleting all cookies.");
        this.options.deleteAllCookies();
    }

    public Set<Cookie> getCookies() {
        Set cookies = this.options.getCookies();
        this.loggerList.logDebug("Retrieving " + cookies.size() + " cookies.");
        return cookies;
    }

    public Cookie getCookieNamed(String name) {
        Cookie cookie = this.options.getCookieNamed(name);
        this.loggerList.logDebug("Retrieving cookie named '" + name + "'.");
        return cookie;
    }

    public WebDriver.Timeouts timeouts() {
        return new LoggingTimeouts(this.options.timeouts(), this.loggerList);
    }

    public WebDriver.Window window() {
        return new LoggingWindow(this.options.window(), this.loggerList);
    }

    public Logs logs() {
        return this.options.logs();
    }
}

