/*
 * Decompiled with CFR 0.152.
 */
package com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents;

import com.zingtongroup.loggingseleniumwebdriver.logging.LoggerList;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingSeleniumComponent;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingWebElement;
import org.openqa.selenium.Alert;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;

public class LoggingTargetLocator
implements WebDriver.TargetLocator,
LoggingSeleniumComponent {
    public final LoggerList loggerList;
    public final WebDriver.TargetLocator targetLocator;

    public LoggingTargetLocator(WebDriver.TargetLocator targetLocator, LoggerList loggerList) {
        this.loggerList = loggerList;
        this.targetLocator = targetLocator;
    }

    @Override
    public void pauseLogging() {
        this.loggerList.pauseLogging();
    }

    @Override
    public void resumeLogging() {
        this.loggerList.resumeLogging();
    }

    @Override
    public void log(String logMessage) {
        this.loggerList.log(logMessage);
    }

    public WebDriver frame(int index) {
        this.loggerList.logInfo("Switching to Frame with index " + index + ".");
        return this.targetLocator.frame(index);
    }

    public WebDriver frame(String nameOrId) {
        this.loggerList.logInfo("Switching to Frame with name or id " + nameOrId + ".");
        return this.targetLocator.frame(nameOrId);
    }

    public WebDriver frame(WebElement frameElement) {
        this.loggerList.logInfo("Switching to Frame by frame WebElement.");
        return this.targetLocator.frame(frameElement);
    }

    public WebDriver parentFrame() {
        this.loggerList.logInfo("Switching to parent frame.");
        return this.targetLocator.parentFrame();
    }

    public WebDriver window(String nameOrHandle) {
        this.loggerList.logInfo("Switching to window by name or handle '" + nameOrHandle + "'.");
        return this.targetLocator.window(nameOrHandle);
    }

    public WebDriver newWindow(WindowType typeHint) {
        this.loggerList.logInfo("Creating new window of type '" + typeHint.getClass().getName() + "'.");
        return this.targetLocator.newWindow(typeHint);
    }

    public WebDriver defaultContent() {
        this.loggerList.logInfo("Switching to default content.");
        return this.targetLocator.defaultContent();
    }

    public WebElement activeElement() {
        this.loggerList.logInfo("Switching to active element.");
        return new LoggingWebElement(this.targetLocator.activeElement(), this.loggerList);
    }

    public Alert alert() {
        this.loggerList.logInfo("Switching to alert.");
        return this.targetLocator.alert();
    }
}

