/*
 * Decompiled with CFR 0.152.
 */
package com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents;

import com.zingtongroup.loggingseleniumwebdriver.logging.LoggerList;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingSeleniumComponent;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class LoggingWebElement
implements LoggingSeleniumComponent,
WebElement {
    public final WebElement webElement;
    public final LoggerList loggerList;
    public String elementString;

    public LoggingWebElement(WebElement webElement, LoggerList loggerList) {
        this.webElement = webElement;
        this.loggerList = loggerList;
        this.elementString = "nameless element";
        try {
            this.elementString = webElement.getTagName() + " element ";
            this.elementString = this.elementString + webElement.getAccessibleName();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void pauseLogging() {
        this.loggerList.pauseLogging();
    }

    @Override
    public void resumeLogging() {
        this.loggerList.resumeLogging();
    }

    @Override
    public void log(String logMessage) {
        this.loggerList.log(logMessage);
    }

    public void click() {
        this.loggerList.logExecutionStep("Clicking " + this.elementString + ".");
        this.webElement.click();
    }

    public void submit() {
        this.loggerList.logExecutionStep("Submitting");
        this.webElement.submit();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        if (keysToSend == null) {
            this.loggerList.logInfo("Attempting to send null to " + this.elementString + " with sendKeys(). Skipping it.");
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (CharSequence seq : keysToSend) {
            sb.append(seq);
        }
        this.loggerList.logExecutionStep("Sending keys '" + sb.toString() + "' to " + this.elementString + ".");
        this.webElement.sendKeys(keysToSend);
    }

    public void sendSecretKeys(CharSequence ... keysToSend) {
        if (keysToSend == null) {
            this.loggerList.logInfo("Attempting to send null to " + this.elementString + " with sendSecretKeys(). Skipping it.");
            return;
        }
        this.loggerList.logExecutionStep("Sending secret keys '" + "*".repeat(keysToSend.length) + "' to " + this.elementString + ".");
        this.webElement.sendKeys(keysToSend);
    }

    public void clear() {
        this.loggerList.logExecutionStep("Clearing element " + this.elementString + ".");
        this.webElement.clear();
    }

    public String getTagName() {
        this.loggerList.logDebug("Getting tag name for element " + this.elementString + ".");
        return this.webElement.getTagName();
    }

    public String getAttribute(String name) {
        String attributeValue = this.webElement.getAttribute(name);
        this.loggerList.logDebug("Reading attribute value '" + attributeValue + "' for attribute '" + name + "'.");
        return attributeValue;
    }

    public boolean isSelected() {
        boolean selected = this.webElement.isSelected();
        if (selected) {
            this.loggerList.logDebug("Checked if element was selected. It was.");
        } else {
            this.loggerList.logDebug("Checked if element was selected. It was not.");
        }
        return selected;
    }

    public boolean isEnabled() {
        boolean enabled = this.webElement.isEnabled();
        if (enabled) {
            this.loggerList.logDebug("Checked if element was enabled. It was.");
        } else {
            this.loggerList.logDebug("Checked if element was enabled. It was not.");
        }
        return enabled;
    }

    public String getText() {
        String text = this.webElement.getText();
        this.loggerList.logInfo("Read text '" + text + "' from element " + this.elementString + ".");
        return text;
    }

    public List<WebElement> findElements(By by) {
        List elements = this.webElement.findElements(by);
        this.log("Identifying " + elements.size() + " elements for By statement '" + by.toString() + "'.");
        ArrayList<WebElement> elements2 = new ArrayList<WebElement>();
        for (WebElement webElement : elements) {
            elements2.add(new LoggingWebElement(webElement, this.loggerList));
        }
        return elements2;
    }

    public WebElement findElement(By by) {
        WebElement element = this.webElement.findElement(by);
        if (element == null) {
            this.log("Could not identify any element for By statement '" + by.toString() + "'.");
            return null;
        }
        this.log("Identified element for By statement '" + by.toString() + "'.");
        return new LoggingWebElement(element, this.loggerList);
    }

    public boolean isDisplayed() {
        boolean displayed = this.webElement.isDisplayed();
        if (displayed) {
            this.loggerList.logDebug("Checked if element was displayed. It was.");
        } else {
            this.loggerList.logDebug("Checked if element was displayed. It was not.");
        }
        return displayed;
    }

    public Point getLocation() {
        Point location = this.webElement.getLocation();
        this.loggerList.logInfo("Read location (" + location.x + "x" + location.y + ") for element " + this.elementString + ".");
        return location;
    }

    public Dimension getSize() {
        Dimension size = this.webElement.getSize();
        this.loggerList.logInfo("Read size (" + size.width + "x" + size.height + ") for element " + this.elementString + ".");
        return size;
    }

    public Rectangle getRect() {
        Rectangle rect = this.webElement.getRect();
        this.loggerList.logInfo("Read rectangle (" + rect.width + "x" + rect.height + ") for element " + this.elementString + ".");
        return rect;
    }

    public String getCssValue(String propertyName) {
        String css = this.webElement.getCssValue(propertyName);
        this.loggerList.logInfo("Read CSS value for property '" + propertyName + "' from element " + this.elementString + ". It was '" + css + "'.");
        return css;
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        this.loggerList.logInfo("Snapping screenshot of element " + this.elementString + ".");
        return (X)this.webElement.getScreenshotAs(target);
    }
}

