/*
 * Decompiled with CFR 0.152.
 */
package com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents;

import com.zingtongroup.loggingseleniumwebdriver.logging.LoggerList;
import com.zingtongroup.loggingseleniumwebdriver.loggingseleniumcomponents.LoggingSeleniumComponent;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;

public class LoggingWindow
implements WebDriver.Window,
LoggingSeleniumComponent {
    public final LoggerList loggerList;
    public final WebDriver.Window window;

    public LoggingWindow(WebDriver.Window window, LoggerList loggerList) {
        this.loggerList = loggerList;
        this.window = window;
    }

    @Override
    public void pauseLogging() {
        this.loggerList.pauseLogging();
    }

    @Override
    public void resumeLogging() {
        this.loggerList.resumeLogging();
    }

    @Override
    public void log(String logMessage) {
        this.loggerList.log(logMessage);
    }

    public Dimension getSize() {
        Dimension size = this.window.getSize();
        this.loggerList.logDebug("Retrieving current window size (=" + size.width + "x" + size.height + ").");
        return size;
    }

    public void setSize(Dimension targetSize) {
        this.loggerList.logInfo("Setting window dimension to " + targetSize.width + "x" + targetSize.height + " pixels.");
        this.window.setSize(targetSize);
    }

    public Point getPosition() {
        Point position = this.window.getPosition();
        this.loggerList.logDebug("Retrieving current window position (=" + position.x + "," + position.y + ").");
        return position;
    }

    public void setPosition(Point targetPosition) {
        this.loggerList.logInfo("Setting window position to " + targetPosition.x + ", " + targetPosition.y + " pixels.");
        this.window.setPosition(targetPosition);
    }

    public void maximize() {
        this.loggerList.logInfo("Maximizing window.");
        this.window.maximize();
    }

    public void minimize() {
        this.loggerList.logInfo("Minimizing window.");
        this.window.minimize();
    }

    public void fullscreen() {
        this.loggerList.logInfo("Switching to browser full screen mode.");
        this.window.fullscreen();
    }
}

