/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeinghelper.auth;

import com.github.codeinghelper.auth.ActionRight;
import com.github.codeinghelper.auth.RightManager;
import com.github.codeinghelper.exception.http.ForbiddenException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ActionRightvalidator {
    @Autowired
    RightManager rightManager;

    @Pointcut(value="@annotation(com.github.codeinghelper.auth.ActionRight)")
    private void permission() {
    }

    @Before(value="permission()&&@annotation(actionRight)")
    public void doBefore(JoinPoint joinPoint, ActionRight actionRight) {
    }

    @After(value="permission()")
    public void doAfter() {
    }

    @Around(value="permission()")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String token = request.getHeader("token");
        if (StringUtils.isEmpty((Object)token)) {
            throw new ForbiddenException(4003);
        }
        Map<String, String> map = this.rightManager.ActionRights();
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        ActionRight visitPermission = method.getAnnotation(ActionRight.class);
        String value = visitPermission.actionCode();
        Boolean require = visitPermission.require();
        if (require.booleanValue() && !map.containsKey(value)) {
            throw new ForbiddenException(4003);
        }
        System.out.println(value);
        Object result = proceedingJoinPoint.proceed();
        long endTime = System.currentTimeMillis();
        return result;
    }
}

