/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface ResponseBody {
    public static final ResponseBody EMPTY_BODY = new ResponseBody(){

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public void writeTo(OutputStream out) {
        }
    };

    public long getLength();

    public void writeTo(OutputStream var1) throws IOException;

    public static ResponseBody newByteArrayBody(byte[] data) {
        return ResponseBody.newByteArrayBody(data, 0, data.length);
    }

    public static ResponseBody newByteArrayBody(final byte[] data, final int offset, final int length) {
        return new ResponseBody(){

            @Override
            public long getLength() {
                return data.length;
            }

            @Override
            public void writeTo(OutputStream out) throws IOException {
                out.write(data, offset, length);
                out.flush();
            }
        };
    }

    public static ResponseBody newInputStreamBody(final InputStream in, final long length) {
        return new ResponseBody(){

            @Override
            public long getLength() {
                return length;
            }

            @Override
            public void writeTo(OutputStream out) throws IOException {
                int read;
                long leftToWrite = length;
                byte[] data = new byte[8192];
                while ((read = in.read(data)) != -1) {
                    int toWrite = leftToWrite < (long)read ? (int)leftToWrite : read;
                    out.write(data, 0, toWrite);
                    if ((leftToWrite -= (long)toWrite) > 0L) continue;
                    break;
                }
                out.flush();
            }
        };
    }
}

