/*
 * Decompiled with CFR 0.152.
 */
package httpserver.handlers;

import httpserver.HttpHandler;
import httpserver.core.HttpServerExchange;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class ServerSentEvents
implements HttpHandler {
    private final Timer timer = new Timer();
    private final List<PrintWriter> connections = new ArrayList<PrintWriter>();

    public ServerSentEvents() {
        this(TimeUnit.MINUTES.toMillis(1L));
    }

    public ServerSentEvents(long keepAliveMillis) {
        if (keepAliveMillis < 1000L) {
            throw new IllegalArgumentException("Set a reasonable time between keep-alive messages; x >= 1000");
        }
        this.timer.scheduleAtFixedRate(ServerSentEvents.newKeepAliveTask(this.connections), keepAliveMillis, keepAliveMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.setStatusCode(200);
        exchange.setResponseHeader("Cache-Control", "no-cache");
        exchange.setResponseHeader("Connection", "keep-alive");
        exchange.setResponseHeader("Content-Type", "text/event-stream");
        exchange.setNoContentLength();
        exchange.sendResponse();
        List<PrintWriter> list = this.connections;
        synchronized (list) {
            this.connections.add(new PrintWriter(exchange.getOutputStream()));
        }
    }

    public void sendMessage(String message) {
        this.sendMessage(null, message);
    }

    public void sendMessage(String id, String message) {
        String event = ServerSentEvents.newSseEvent(id, null, message);
    }

    private static TimerTask newKeepAliveTask(final List<PrintWriter> connections) {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = connections;
                synchronized (list) {
                    Iterator it = connections.iterator();
                    while (it.hasNext()) {
                        PrintWriter connection = (PrintWriter)it.next();
                        String event = ServerSentEvents.newKeepAliveEvent();
                        try {
                            connection.print(event);
                        }
                        catch (Exception e) {
                            it.remove();
                        }
                    }
                }
            }
        };
    }

    private static String newKeepAliveEvent() {
        return "id: " + System.currentTimeMillis() + "\nevent: keep-alive\n\n";
    }

    private static String newSseEvent(String id, String type, String data) {
        StringBuilder message = new StringBuilder();
        message.append("id: ").append(id == null ? Long.valueOf(System.currentTimeMillis()) : id).append("\n");
        if (type != null) {
            message.append("event: ").append("\n");
        }
        if (data != null) {
            message.append("data: ").append(data).append("\n");
        }
        return message.append("\n").toString();
    }
}

