/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.HttpServerExchange;
import httpserver.error.InvalidInput;
import httpserver.util.Functions;
import java.util.Map;
import java.util.regex.Pattern;

public final class InputParser
extends Enum<InputParser> {
    private static final Pattern PATTERN_VALID_EMAIL;
    private static final /* synthetic */ InputParser[] $VALUES;

    public static InputParser[] values() {
        return (InputParser[])$VALUES.clone();
    }

    public static InputParser valueOf(String string) {
        return Enum.valueOf(InputParser.class, string);
    }

    public static String getMandatoryString(Map<String, String> map, String string) throws InvalidInput {
        String string2 = map.get(string);
        if (string2 == null) {
            throw new InvalidInput(String.format("Missing parameter '%s'", string));
        }
        return string2;
    }

    public static int getMandatoryInteger(Map<String, String> map, String string) throws InvalidInput {
        try {
            return Integer.parseInt(InputParser.getMandatoryString(map, string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain an integer", string));
        }
    }

    public static long getMandatoryLong(Map<String, String> map, String string) throws InvalidInput {
        try {
            return Long.parseLong(InputParser.getMandatoryString(map, string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain a long", string));
        }
    }

    public static double getMandatoryDouble(Map<String, String> map, String string) throws InvalidInput {
        try {
            return Double.parseDouble(InputParser.getMandatoryString(map, string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain a double", string));
        }
    }

    public static String getMandatoryEmailAddress(Map<String, String> map, String string) throws InvalidInput {
        String string2 = InputParser.getMandatoryString(map, string);
        if (!PATTERN_VALID_EMAIL.matcher(string2).matches()) {
            throw new InvalidInput("Parameter '" + string + "' does not contain a valid email address");
        }
        return string2;
    }

    public static String getOptionalString(Map<String, String> map, String string, String string2) throws InvalidInput {
        String string3 = map.get(string);
        return string3 == null ? string2 : string3;
    }

    public static Integer getOptionalInteger(Map<String, String> map, String string, Integer n) throws InvalidInput {
        String string2 = map.get(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain an integer", string));
        }
    }

    public static int getBoundedInteger(Map<String, String> map, String string, int n, int n2, int n3) throws InvalidInput {
        return Functions.rangeBound(n, n3, InputParser.getOptionalInteger(map, string, (Integer)n2));
    }

    public static Long getOptionalLong(Map<String, String> map, String string, Long l) throws InvalidInput {
        String string2 = map.get(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain an integer", string));
        }
    }

    public static long getBoundedLong(Map<String, String> map, String string, long l, long l2, long l3) throws InvalidInput {
        return Functions.rangeBound(l, l3, InputParser.getOptionalLong(map, string, (Long)l2));
    }

    public static Double getOptionalDouble(Map<String, String> map, String string, Double d) throws InvalidInput {
        String string2 = map.get(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain an integer", string));
        }
    }

    public static boolean getOptionalBoolean(Map<String, String> map, String string, boolean bl) throws InvalidInput {
        String string2 = map.get(string);
        if (string2 == null) {
            return bl;
        }
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        throw new InvalidInput("Parameter '" + string + "' must contain a boolean");
    }

    public static String getMandatoryString(HttpServerExchange httpServerExchange, String string) throws InvalidInput {
        String string2 = httpServerExchange.getQueryParameter(string);
        if (string2 == null || string2.isEmpty()) {
            throw new InvalidInput(String.format("Missing parameter '%s'", string));
        }
        return string2;
    }

    public static int getMandatoryInteger(HttpServerExchange httpServerExchange, String string) throws InvalidInput {
        try {
            return Integer.parseInt(InputParser.getMandatoryString(httpServerExchange, string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain an integer", string));
        }
    }

    public static long getMandatoryLong(HttpServerExchange httpServerExchange, String string) throws InvalidInput {
        try {
            return Long.parseLong(InputParser.getMandatoryString(httpServerExchange, string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain a long", string));
        }
    }

    public static double getMandatoryDouble(HttpServerExchange httpServerExchange, String string) throws InvalidInput {
        try {
            return Double.parseDouble(InputParser.getMandatoryString(httpServerExchange, string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain a double", string));
        }
    }

    public static String getMandatoryEmailAddress(HttpServerExchange httpServerExchange, String string) throws InvalidInput {
        String string2 = InputParser.getMandatoryString(httpServerExchange, string);
        if (!PATTERN_VALID_EMAIL.matcher(string2).matches()) {
            throw new InvalidInput("Parameter '" + string + "' does not contain a valid email address");
        }
        return string2;
    }

    public static String getOptionalString(HttpServerExchange httpServerExchange, String string, String string2) throws InvalidInput {
        String string3 = httpServerExchange.getQueryParameter(string);
        return string3 == null ? string2 : string3;
    }

    public static Integer getOptionalInteger(HttpServerExchange httpServerExchange, String string, Integer n) throws InvalidInput {
        String string2 = httpServerExchange.getQueryParameter(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain an integer", string));
        }
    }

    public static int getBoundedInteger(HttpServerExchange httpServerExchange, String string, int n, int n2, int n3) throws InvalidInput {
        return Functions.rangeBound(n, n3, InputParser.getOptionalInteger(httpServerExchange, string, (Integer)n2));
    }

    public static Long getOptionalLong(HttpServerExchange httpServerExchange, String string, Long l) throws InvalidInput {
        String string2 = httpServerExchange.getQueryParameter(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain an integer", string));
        }
    }

    public static long getBoundedLong(HttpServerExchange httpServerExchange, String string, long l, long l2, long l3) throws InvalidInput {
        return Functions.rangeBound(l, l3, InputParser.getOptionalLong(httpServerExchange, string, (Long)l2));
    }

    public static Double getOptionalDouble(HttpServerExchange httpServerExchange, String string, Double d) throws InvalidInput {
        String string2 = httpServerExchange.getQueryParameter(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInput(String.format("Parameter '%s' must contain an integer", string));
        }
    }

    public static boolean getOptionalBoolean(HttpServerExchange httpServerExchange, String string, boolean bl) throws InvalidInput {
        String string2 = httpServerExchange.getQueryParameter(string);
        if (string2 == null) {
            return bl;
        }
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        throw new InvalidInput("Parameter '" + string + "' must contain a boolean");
    }

    private static /* synthetic */ InputParser[] $values() {
        return new InputParser[0];
    }

    static {
        $VALUES = InputParser.$values();
        PATTERN_VALID_EMAIL = Pattern.compile("[a-z0-9\\-_+\\.]+@[a-z0-9-\\.]+");
    }
}

