/*
 * Decompiled with CFR 0.152.
 */
package httpserver.caching;

import httpserver.core.HttpServerExchange;
import java.util.function.Consumer;

public enum CacheControlStrategy {
    SET_NOTHING(httpServerExchange -> {}),
    NEVER_CACHE(httpServerExchange -> {
        httpServerExchange.setResponseHeader("Cache-Control", "no-cache, no-store, must-revalidate, pre-check=0, post-check=0, max-age=0, s-maxage=0");
        httpServerExchange.setResponseHeader("Expires", "0");
        httpServerExchange.setResponseHeader("Pragma", "no-cache");
    }),
    STORE_BUT_CHECK_SERVER(httpServerExchange -> httpServerExchange.setResponseHeader("Cache-Control", "public, no-cache, max-age=0, must-revalidate")),
    IMMUTABLE(httpServerExchange -> {
        httpServerExchange.setResponseHeader("Cache-Control", "public, max-age=315569260, immutable");
        httpServerExchange.setResponseHeader("Expires", "Fri, 1 Jan 2100 00:00:00 GMT");
    });

    private final Consumer<HttpServerExchange> impl;

    private CacheControlStrategy(Consumer<HttpServerExchange> consumer) {
        this.impl = consumer;
    }

    public void apply(HttpServerExchange httpServerExchange) {
        this.impl.accept(httpServerExchange);
    }
}

