/*
 * Decompiled with CFR 0.152.
 */
package httpserver.handlers;

import httpserver.HttpHandler;
import httpserver.core.CacheControlStrategy;
import httpserver.core.ContentType;
import httpserver.core.HttpServerExchange;
import httpserver.core.ResponseBuilder;
import httpserver.error.HttpError;
import httpserver.util.Encoding;
import httpserver.util.Functions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Consumer;

public final class Common
extends Enum<Common> {
    private static final /* synthetic */ Common[] $VALUES;

    public static Common[] values() {
        return (Common[])$VALUES.clone();
    }

    public static Common valueOf(String string) {
        return Enum.valueOf(Common.class, string);
    }

    public static HttpHandler logError(Consumer<Exception> consumer, Consumer<Error> consumer2, HttpHandler httpHandler) {
        return httpServerExchange -> {
            try {
                httpHandler.handleRequest(httpServerExchange);
            }
            catch (Exception exception) {
                if (exception instanceof HttpError) {
                    HttpError httpError = (HttpError)((Object)exception);
                    httpError.processExchange(httpServerExchange);
                } else {
                    consumer.accept(exception);
                    HttpError.respondInternalError(httpServerExchange);
                }
            }
            catch (Error error) {
                consumer2.accept(error);
                throw error;
            }
        };
    }

    public static HttpHandler pathPrefix(String string, HttpHandler httpHandler, HttpHandler httpHandler2) {
        return httpServerExchange -> (httpServerExchange.getRequestPath().startsWith(string) ? httpHandler : httpHandler2).handleRequest(httpServerExchange);
    }

    public static HttpHandler staticHtml(String string) {
        String string2 = String.format("\"%s\"", Encoding.encodeHex(Encoding.sha256(string, StandardCharsets.UTF_8)));
        return httpServerExchange -> {
            String string3 = httpServerExchange.getRequestHeader("If-None-Match");
            if (string2.equals(string3)) {
                ResponseBuilder.respond(httpServerExchange).status(304).contentType(ContentType.text_html).send();
            } else {
                ResponseBuilder.respond(httpServerExchange).status(200).contentType(ContentType.text_html).cache(CacheControlStrategy.STORE_BUT_CHECK_SERVER).header("ETag", string2).send(string);
            }
        };
    }

    public static boolean matchesEtag(HttpServerExchange httpServerExchange, String string) {
        return string.equals(httpServerExchange.getRequestHeader("If-None-Match"));
    }

    public static void checkEtag(String string, HttpServerExchange httpServerExchange, HttpHandler httpHandler) throws Exception {
        if (Common.matchesEtag(httpServerExchange, string)) {
            ResponseBuilder.respond(httpServerExchange).status(304).send();
            return;
        }
        httpHandler.handleRequest(httpServerExchange);
    }

    public static HttpHandler html404(String string) {
        return httpServerExchange -> ResponseBuilder.respond(httpServerExchange).status(404).cache(CacheControlStrategy.NEVER_CACHE).contentType(ContentType.text_html).send(string);
    }

    public static HttpHandler statusCode(int n) {
        return httpServerExchange -> httpServerExchange.setStatusCode(n);
    }

    public static HttpHandler redirect(String string) {
        return httpServerExchange -> ResponseBuilder.respond(httpServerExchange).status(302).header("Location", string).send();
    }

    public static HttpHandler noSuchApiEndpoint() {
        return httpServerExchange -> HttpError.respondError(httpServerExchange, 400, 400, "No such API endpoint");
    }

    public static HttpHandler securityHeaders(boolean bl, HttpHandler httpHandler) {
        return httpServerExchange -> {
            if (bl) {
                httpServerExchange.setResponseHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains");
                httpServerExchange.setResponseHeader("Cross-Origin-Opener-Policy", "same-origin");
            }
            httpServerExchange.setResponseHeader("X-Frame-Options", "sameorigin");
            httpServerExchange.setResponseHeader("X-XSS-Protection", "1; mode=block");
            httpServerExchange.setResponseHeader("X-Content-Type-Options", "nosniff");
            httpServerExchange.setResponseHeader("Referrer-Policy", "no-referrer");
            httpHandler.handleRequest(httpServerExchange);
        };
    }

    public static HttpHandler singlePageApp(String string, Set<String> set) {
        HttpHandler httpHandler = Common.html404(string);
        HttpHandler httpHandler2 = Common.staticHtml(string);
        return httpServerExchange -> (set.contains(httpServerExchange.getRequestPath()) ? httpHandler2 : httpHandler).handleRequest(httpServerExchange);
    }

    public static HttpHandler resourceHandler(String string, HttpHandler httpHandler) {
        HashMap hashMap = new HashMap();
        return httpServerExchange -> {
            String string3 = httpServerExchange.getRequestURI();
            byte[] byArray = Common.loadResource(string, string3, null);
            if (byArray == null) {
                httpHandler.handleRequest(httpServerExchange);
            } else {
                String string4;
                String string5 = ContentType.toContentType(string3);
                String string6 = String.format("\"%s\"", hashMap.computeIfAbsent(string3, string -> Encoding.encodeHex(Encoding.sha256(byArray))));
                if (string6.equals(string4 = httpServerExchange.getRequestHeader("If-None-Match"))) {
                    ResponseBuilder.respond(httpServerExchange).status(304).cache(CacheControlStrategy.STORE_BUT_CHECK_SERVER).contentType(string5).send();
                } else {
                    ResponseBuilder.respond(httpServerExchange).status(200).cache(CacheControlStrategy.STORE_BUT_CHECK_SERVER).contentType(string5).header("ETag", string6).send(byArray);
                }
            }
        };
    }

    private static byte[] loadResource(String string, String string2, byte[] byArray) throws IOException {
        if (string2.isBlank() || string2.endsWith("/") || string2.endsWith("\\")) {
            return byArray;
        }
        String string3 = Path.of(string, string2).normalize().toString().replace('\\', '/');
        if (!string3.startsWith(string)) {
            return byArray;
        }
        try (InputStream inputStream = Functions.class.getResourceAsStream(string3);){
            if (inputStream == null) {
                byte[] byArray2 = byArray;
                return byArray2;
            }
            byte[] byArray3 = inputStream.readAllBytes();
            return byArray3;
        }
    }

    private static /* synthetic */ Common[] $values() {
        return new Common[0];
    }

    static {
        $VALUES = Common.$values();
    }
}

