/*
 * Decompiled with CFR 0.152.
 */
package simplexml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import simplexml.XmlReader;
import simplexml.XmlStream;
import simplexml.XmlWriter;
import simplexml.model.Element;
import simplexml.model.ObjectDeserializer;
import simplexml.model.ObjectSerializer;
import simplexml.utils.Interfaces;
import simplexml.utils.Reflection;

public final class SimpleXml {
    private final XmlReader reader;
    private final XmlWriter writer;
    private final XmlStream stream;
    private final Charset charset;

    public SimpleXml() {
        this(false, true, StandardCharsets.UTF_8, ObjectSerializer.defaultSerializer(), new HashMap(), ObjectDeserializer.defaultDeserializers());
    }

    private SimpleXml(final boolean shouldEncodeUTF8, final boolean shouldPrettyPrint, Charset charset, final ObjectSerializer defaultSerializer, final Map<Class<?>, ObjectSerializer> serializers, Map<Class<?>, ObjectDeserializer> deserializers) {
        this.charset = charset;
        this.reader = deserializers::get;
        this.writer = new XmlWriter(){

            @Override
            public boolean hasSerializer(Class<?> type) {
                return serializers.containsKey(type);
            }

            @Override
            public ObjectSerializer getSerializer(Class<?> type) {
                return serializers.getOrDefault(type, defaultSerializer);
            }

            @Override
            public boolean shouldEncodeUTF8() {
                return shouldEncodeUTF8;
            }

            @Override
            public boolean shouldPrettyPrint() {
                return shouldPrettyPrint;
            }
        };
        this.stream = new XmlStream(){};
    }

    public <T> T fromXml(String xml, Class<T> clazz) throws IOException {
        return this.fromXml(this.fromXml(xml), clazz);
    }

    public <T> T fromXml(InputStream xmlStream, Class<T> clazz) throws IOException {
        return this.fromXml(this.fromXml(xmlStream), clazz);
    }

    public <T> T fromXml(Element element, Class<T> clazz) throws IOException {
        try {
            return this.reader.domToObject(element, clazz);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    public Element fromXml(String input) throws IOException {
        return this.fromXml(new ByteArrayInputStream(input.getBytes(this.charset)));
    }

    public Element fromXml(InputStream stream) throws IOException {
        return XmlReader.parseXML(new InputStreamReader(stream, this.charset));
    }

    public String toXml(Object o) {
        return this.writer.toXml(o, Reflection.toName(o.getClass()));
    }

    public String toXml(Object o, String name) {
        return this.writer.toXml(o, name);
    }

    public void toXml(Object o, Writer out) throws IOException {
        this.writer.toXml(o, Reflection.toName(o.getClass()), out);
    }

    public void toXml(Object o, String name, Writer out) throws IOException {
        this.writer.toXml(o, name, out);
    }

    public String domToXml(Element node) {
        return this.writer.domToXml(node);
    }

    public void domToXml(Element node, Writer out) throws IOException {
        this.writer.domToXml(node, out);
    }

    public Interfaces.CheckedIterator<String> iterateXml(InputStream in) {
        return this.stream.iterateXml(new InputStreamReader(in, this.charset));
    }

    public Interfaces.CheckedIterator<Element> iterateDom(InputStream in) {
        return this.stream.iterateDom(new InputStreamReader(in, this.charset), this.charset);
    }

    public <T> Interfaces.CheckedIterator<T> iterateObject(InputStream in, Class<T> clazz) {
        return this.stream.iterateObject(new InputStreamReader(in, this.charset), this.charset, this.reader, clazz);
    }

    public static Builder newSimpleXml() {
        return new Builder();
    }

    public static class Builder {
        private boolean shouldEncodeUTF8 = false;
        private boolean shouldPrettyPrint = true;
        private Charset charset = StandardCharsets.UTF_8;
        private ObjectSerializer defaultSerializer = ObjectSerializer.defaultSerializer();
        private Map<Class<?>, ObjectSerializer> serializers = new HashMap();
        private Map<Class<?>, ObjectDeserializer> deserializers = ObjectDeserializer.defaultDeserializers();

        public Builder defaultSerializer(ObjectSerializer serializer) {
            this.defaultSerializer = serializer;
            return this;
        }

        public Builder addSerializer(Class<?> c, ObjectSerializer serializer) {
            this.serializers.put(c, serializer);
            return this;
        }

        public Builder addDeserializer(Class<?> c, ObjectDeserializer deserializer) {
            this.deserializers.put(c, deserializer);
            return this;
        }

        public Builder shouldPrettyPrint() {
            this.shouldPrettyPrint = true;
            return this;
        }

        public Builder shouldPrettyPrint(boolean shouldPrettyPrint) {
            this.shouldPrettyPrint = shouldPrettyPrint;
            return this;
        }

        public Builder shouldEncodeUTF8() {
            this.shouldEncodeUTF8 = true;
            return this;
        }

        public Builder shouldEncodeUTF8(boolean shouldEncodeUTF8) {
            this.shouldEncodeUTF8 = shouldEncodeUTF8;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public SimpleXml build() {
            return new SimpleXml(this.shouldEncodeUTF8, this.shouldPrettyPrint, this.charset, this.defaultSerializer, this.serializers, this.deserializers);
        }
    }
}

